/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.processor.manager.commons.transport.server;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.event.processor.manager.commons.transport.common.EventServerUtils;
import org.wso2.carbon.event.processor.manager.commons.transport.common.StreamRuntimeInfo;
import org.wso2.carbon.event.processor.manager.commons.transport.server.ConnectionCallback;
import org.wso2.carbon.event.processor.manager.commons.transport.server.StreamCallback;
import org.wso2.carbon.event.processor.manager.commons.transport.server.TCPEventServerConfig;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.definition.StreamDefinition;

public class TCPEventServer {
    private static Log log = LogFactory.getLog(TCPEventServer.class);
    private TCPEventServerConfig tcpEventServerConfig = new TCPEventServerConfig("0.0.0.0", 7211);
    private ExecutorService executorService;
    private StreamCallback streamCallback;
    private ConnectionCallback connectionCallback;
    private ServerWorker serverWorker;
    private Map<String, StreamRuntimeInfo> streamRuntimeInfoMap = new ConcurrentHashMap<String, StreamRuntimeInfo>();

    public TCPEventServer(TCPEventServerConfig tcpeventserverconfig, StreamCallback streamCallback, ConnectionCallback connectionCallback) {
        this.tcpEventServerConfig = tcpeventserverconfig;
        this.streamCallback = streamCallback;
        this.connectionCallback = connectionCallback;
        this.serverWorker = new ServerWorker();
        this.executorService = Executors.newCachedThreadPool();
    }

    public void addStreamDefinition(StreamDefinition streamDefinition) {
        String streamId = streamDefinition.getId();
        this.streamRuntimeInfoMap.put(streamId, EventServerUtils.createStreamRuntimeInfo(streamDefinition));
    }

    public void removeStreamDefinition(String streamId) {
        this.streamRuntimeInfoMap.remove(streamId);
    }

    public synchronized void start() throws IOException {
        if (!this.serverWorker.isRunning()) {
            this.serverWorker.startServerWorker();
            new Thread(this.serverWorker).start();
        }
    }

    public synchronized void shutdown() {
        this.serverWorker.shutdownServerWorker();
    }

    private class ServerWorker
    implements Runnable {
        private ServerSocket receiverSocket;
        private boolean isRunning = false;

        private ServerWorker() {
        }

        public boolean isRunning() {
            return this.isRunning;
        }

        public void startServerWorker() throws IOException {
            InetAddress inetAddress = InetAddress.getByName(TCPEventServer.this.tcpEventServerConfig.getHostName());
            log.info((Object)("EventServer starting event listener on " + inetAddress.getHostAddress() + ":" + TCPEventServer.this.tcpEventServerConfig.getPort()));
            this.receiverSocket = new ServerSocket(TCPEventServer.this.tcpEventServerConfig.getPort(), 50, inetAddress);
            this.isRunning = true;
            this.receiverSocket.setReuseAddress(true);
        }

        public void shutdownServerWorker() {
            this.isRunning = false;
            try {
                if (this.receiverSocket != null) {
                    this.receiverSocket.close();
                }
            }
            catch (IOException e) {
                log.error((Object)("Error occurred while trying to shutdown socket: " + e.getMessage()), (Throwable)e);
            }
        }

        @Override
        public void run() {
            try {
                while (this.isRunning) {
                    Socket connectionSocket = this.receiverSocket.accept();
                    connectionSocket.setKeepAlive(true);
                    TCPEventServer.this.executorService.execute(new ListenerProcessor(connectionSocket));
                }
            }
            catch (Throwable e) {
                if (this.isRunning) {
                    log.error((Object)("Error while the server was listening for events: " + e.getMessage()), e);
                } else {
                    log.info((Object)("EventServer stopped listening for socket connections, " + e.getMessage()));
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"EventServer stopped listening for socket connections", e);
                    }
                }
            }
            finally {
                this.isRunning = false;
            }
        }

        private class ListenerProcessor
        implements Runnable {
            private final Socket connectionSocket;

            public ListenerProcessor(Socket connectionSocket) {
                this.connectionSocket = connectionSocket;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            @Override
            public void run() {
                try {
                    if (TCPEventServer.this.connectionCallback != null) {
                        TCPEventServer.this.connectionCallback.onPublisherBoltConnect();
                    }
                    BufferedInputStream in = new BufferedInputStream(this.connectionSocket.getInputStream());
                    while (true) {
                        byte[] streamNameByteSize;
                        ByteBuffer sizeBuf;
                        int streamNameSize;
                        if ((streamNameSize = (sizeBuf = ByteBuffer.wrap(streamNameByteSize = this.loadData(in, new byte[4]))).getInt()) == -99) {
                            continue;
                        }
                        byte[] streamNameData = this.loadData(in, new byte[streamNameSize]);
                        String streamId = new String(streamNameData, 0, streamNameData.length);
                        StreamRuntimeInfo streamRuntimeInfo = (StreamRuntimeInfo)TCPEventServer.this.streamRuntimeInfoMap.get(streamId);
                        while (streamRuntimeInfo == null) {
                            Thread.sleep(1000L);
                            log.warn((Object)("TCP server on port :'" + TCPEventServer.this.tcpEventServerConfig.getPort() + "' waiting for streamId:'" + streamId + "' to process incoming events"));
                            streamRuntimeInfo = (StreamRuntimeInfo)TCPEventServer.this.streamRuntimeInfoMap.get(streamId);
                        }
                        Object[] eventData = new Object[streamRuntimeInfo.getNoOfAttributes()];
                        byte[] fixedMessageData = this.loadData(in, new byte[12 + streamRuntimeInfo.getFixedMessageSize()]);
                        ByteBuffer bbuf = ByteBuffer.wrap(fixedMessageData, 0, fixedMessageData.length);
                        long timestamp = bbuf.getLong();
                        int arbitraryMapSize = bbuf.getInt();
                        ArrayList<Integer> stringValueSizes = new ArrayList<Integer>();
                        Attribute.Type[] attributeTypes = streamRuntimeInfo.getAttributeTypes();
                        block19: for (int i = 0; i < attributeTypes.length; ++i) {
                            Attribute.Type type = attributeTypes[i];
                            switch (type) {
                                case INT: {
                                    eventData[i] = bbuf.getInt();
                                    continue block19;
                                }
                                case LONG: {
                                    eventData[i] = bbuf.getLong();
                                    continue block19;
                                }
                                case BOOL: {
                                    eventData[i] = bbuf.get() == 1;
                                    continue block19;
                                }
                                case FLOAT: {
                                    eventData[i] = Float.valueOf(bbuf.getFloat());
                                    continue block19;
                                }
                                case DOUBLE: {
                                    eventData[i] = bbuf.getDouble();
                                    continue block19;
                                }
                                case STRING: {
                                    int size = bbuf.getInt();
                                    stringValueSizes.add(size);
                                }
                            }
                        }
                        int stringSizePosition = 0;
                        for (int i = 0; i < attributeTypes.length; ++i) {
                            Attribute.Type type = attributeTypes[i];
                            if (Attribute.Type.STRING != type) continue;
                            int size = (Integer)stringValueSizes.get(stringSizePosition);
                            if (size == -1) {
                                eventData[i] = null;
                            } else {
                                byte[] stringData = this.loadData(in, new byte[size]);
                                eventData[i] = new String(stringData, 0, stringData.length);
                            }
                            ++stringSizePosition;
                        }
                        HashMap<String, String> arbitraryMap = null;
                        if (arbitraryMapSize > 0) {
                            int valueStringSize;
                            arbitraryMap = new HashMap<String, String>();
                            for (int arbitraryMapBytesRead = 0; arbitraryMapBytesRead < arbitraryMapSize; arbitraryMapBytesRead += 4 + valueStringSize) {
                                byte[] arbitraryMapAttributeSizeData = this.loadData(in, new byte[4]);
                                ByteBuffer arbitraryMapAttributeSizeByteBuf = ByteBuffer.wrap(arbitraryMapAttributeSizeData);
                                int keyStringSize = arbitraryMapAttributeSizeByteBuf.getInt();
                                byte[] keyStringData = this.loadData(in, new byte[keyStringSize]);
                                arbitraryMapBytesRead += 4 + keyStringSize;
                                arbitraryMapAttributeSizeData = this.loadData(in, new byte[4]);
                                arbitraryMapAttributeSizeByteBuf = ByteBuffer.wrap(arbitraryMapAttributeSizeData);
                                valueStringSize = arbitraryMapAttributeSizeByteBuf.getInt();
                                byte[] valueStringData = this.loadData(in, new byte[valueStringSize]);
                                arbitraryMap.put(new String(keyStringData), new String(valueStringData));
                            }
                        }
                        TCPEventServer.this.streamCallback.receive(streamId, timestamp, eventData, arbitraryMap);
                    }
                }
                catch (EOFException e) {
                    log.info((Object)("Closing listener socket. " + e.getMessage()));
                    if (TCPEventServer.this.connectionCallback != null) {
                        TCPEventServer.this.connectionCallback.onPublisherBoltDisconnect();
                    }
                }
                catch (IOException e) {
                    log.error((Object)("Error reading data from receiver socket:" + e.getMessage()), (Throwable)e);
                }
                catch (Throwable t) {
                    log.error((Object)("Error :" + t.getMessage()), t);
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    if (TCPEventServer.this.connectionCallback != null) {
                        TCPEventServer.this.connectionCallback.onPublisherBoltDisconnect();
                    }
                }
                {
                    finally {
                        if (TCPEventServer.this.connectionCallback != null) {
                            TCPEventServer.this.connectionCallback.onPublisherBoltDisconnect();
                        }
                    }
                }
            }

            private int loadData(BufferedInputStream in) throws IOException {
                int byteData = in.read();
                if (byteData != -1) {
                    return byteData;
                }
                throw new EOFException("Connection closed from remote end.");
            }

            private byte[] loadData(BufferedInputStream in, byte[] dataArray) throws IOException {
                int readCount;
                int start = 0;
                while ((readCount = in.read(dataArray, start, dataArray.length - start)) != -1) {
                    if ((start += readCount) != dataArray.length) continue;
                    return dataArray;
                }
                throw new EOFException("Connection closed from remote end.");
            }
        }
    }
}

