/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.processor.manager.commons.transport.common;

import java.util.List;
import org.wso2.carbon.event.processor.manager.commons.transport.common.StreamRuntimeInfo;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.definition.StreamDefinition;

public class EventServerUtils {
    public static StreamRuntimeInfo createStreamRuntimeInfo(StreamDefinition streamDefinition) {
        StreamRuntimeInfo streamRuntimeInfo = new StreamRuntimeInfo(streamDefinition.getId());
        int messageSize = 0;
        int stringAttributes = 0;
        Attribute.Type[] attributeTypes = new Attribute.Type[streamDefinition.getAttributeList().size()];
        List attributeList = streamDefinition.getAttributeList();
        block8: for (int i = 0; i < attributeList.size(); ++i) {
            Attribute attribute = (Attribute)attributeList.get(i);
            switch (attribute.getType()) {
                case INT: {
                    messageSize += 4;
                    attributeTypes[i] = Attribute.Type.INT;
                    continue block8;
                }
                case LONG: {
                    messageSize += 8;
                    attributeTypes[i] = Attribute.Type.LONG;
                    continue block8;
                }
                case BOOL: {
                    ++messageSize;
                    attributeTypes[i] = Attribute.Type.BOOL;
                    continue block8;
                }
                case FLOAT: {
                    messageSize += 4;
                    attributeTypes[i] = Attribute.Type.FLOAT;
                    continue block8;
                }
                case DOUBLE: {
                    messageSize += 8;
                    attributeTypes[i] = Attribute.Type.DOUBLE;
                    continue block8;
                }
                case STRING: {
                    messageSize += 4;
                    ++stringAttributes;
                    attributeTypes[i] = Attribute.Type.STRING;
                }
            }
        }
        streamRuntimeInfo.setFixedMessageSize(messageSize);
        streamRuntimeInfo.setNoOfStringAttributes(stringAttributes);
        streamRuntimeInfo.setNoOfAttributes(streamDefinition.getAttributeList().size());
        streamRuntimeInfo.setAttributeTypes(attributeTypes);
        return streamRuntimeInfo;
    }
}

