/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.processor.manager.commons.transport.client;

import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.TimeoutBlockingWaitStrategy;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.ProducerType;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.event.processor.manager.commons.transport.client.ConnectionFailureHandler;
import org.wso2.carbon.event.processor.manager.commons.transport.client.TCPEventPublisherConfig;
import org.wso2.carbon.event.processor.manager.commons.transport.common.EventServerUtils;
import org.wso2.carbon.event.processor.manager.commons.transport.common.StreamRuntimeInfo;
import org.wso2.carbon.event.processor.manager.commons.transport.server.ConnectionCallback;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.definition.StreamDefinition;

public class TCPEventPublisher {
    public static final int PING_HEADER_VALUE = -99;
    private static Log log = LogFactory.getLog(TCPEventPublisher.class);
    private final String hostUrl;
    private Disruptor<ByteArrayHolder> disruptor;
    private RingBuffer<ByteArrayHolder> ringBuffer;
    private Map<String, StreamRuntimeInfo> streamRuntimeInfoMap;
    private OutputStream outputStream;
    private Socket clientSocket;
    private TCPEventPublisherConfig publisherConfig;
    public String defaultCharset;
    private Timer connectionStatusCheckTimer;
    private ExecutorService socketIoExecutorService;
    private long socketIoTimeout = Integer.MAX_VALUE;
    private boolean isSynchronous;
    private ConnectionCallback connectionCallback;
    private ConnectionFailureHandler failureHandler = null;

    public TCPEventPublisher(String hostUrl, TCPEventPublisherConfig publisherConfig, boolean isSynchronous, ConnectionCallback connectionCallback) throws IOException {
        this.hostUrl = hostUrl;
        this.publisherConfig = publisherConfig;
        this.defaultCharset = publisherConfig.getCharset();
        this.streamRuntimeInfoMap = new ConcurrentHashMap<String, StreamRuntimeInfo>();
        this.isSynchronous = isSynchronous;
        this.connectionCallback = connectionCallback;
        this.socketIoExecutorService = Executors.newCachedThreadPool();
        this.socketIoTimeout = publisherConfig.getConnectionStatusCheckInterval() / 4L;
        if (!isSynchronous) {
            try {
                this.connect(hostUrl);
            }
            catch (IOException e) {
                log.error((Object)("Error connection to " + hostUrl), (Throwable)e);
            }
            this.initializeDisruptor(publisherConfig);
        } else {
            this.connect(hostUrl);
        }
    }

    private synchronized void connect(String hostUrl) throws IOException {
        String[] hp = hostUrl.split(":");
        String host = hp[0];
        int port = Integer.parseInt(hp[1]);
        this.clientSocket = new Socket(host, port);
        this.clientSocket.setKeepAlive(true);
        this.clientSocket.setTcpNoDelay(true);
        this.clientSocket.setSendBufferSize(this.publisherConfig.getTcpSendBufferSize());
        this.outputStream = new BufferedOutputStream(this.clientSocket.getOutputStream());
        log.info((Object)("Connecting to " + hostUrl));
        if (this.connectionCallback != null) {
            this.connectionCallback.onCepReceiverConnect();
        }
        this.connectionStatusCheckTimer = new Timer();
        this.connectionStatusCheckTimer.schedule((TimerTask)new ConnectionStatusCheckTask(), this.publisherConfig.getConnectionStatusCheckInterval(), this.publisherConfig.getConnectionStatusCheckInterval());
    }

    public TCPEventPublisher(String hostUrl, boolean isSynchronous, ConnectionCallback connectionCallback) throws IOException {
        this(hostUrl, new TCPEventPublisherConfig(), isSynchronous, connectionCallback);
    }

    public void addStreamDefinition(StreamDefinition streamDefinition) {
        this.streamRuntimeInfoMap.put(streamDefinition.getId(), EventServerUtils.createStreamRuntimeInfo(streamDefinition));
    }

    public void removeStreamDefinition(StreamDefinition streamDefinition) {
        this.streamRuntimeInfoMap.remove(streamDefinition.getId());
    }

    public void registerConnectionFailureHandler(ConnectionFailureHandler failureHandler) {
        this.failureHandler = failureHandler;
    }

    public void sendEvent(String streamId, long timestamp, Object[] eventData, boolean flush) throws IOException {
        this.sendEvent(streamId, timestamp, eventData, null, flush);
    }

    public void sendEvent(String streamId, long timestamp, Object[] eventData, Map<String, String> arbitraryMap, boolean flush) throws IOException {
        StreamRuntimeInfo streamRuntimeInfo = this.streamRuntimeInfoMap.get(streamId);
        ByteArrayOutputStream arrayOutputStream = new ByteArrayOutputStream();
        boolean hasArbitraryAttributes = arbitraryMap != null;
        int streamIdSize = streamRuntimeInfo.getStreamId().getBytes(this.defaultCharset).length;
        int arbitraryMapSize = 0;
        if (hasArbitraryAttributes) {
            for (Map.Entry<String, String> entry : arbitraryMap.entrySet()) {
                arbitraryMapSize += 4 + entry.getKey().getBytes(this.defaultCharset).length;
                arbitraryMapSize += 4 + entry.getValue().getBytes(this.defaultCharset).length;
            }
        }
        ByteBuffer buf = ByteBuffer.allocate(streamRuntimeInfo.getFixedMessageSize() + streamIdSize + 16);
        buf.putInt(streamIdSize);
        buf.put(streamRuntimeInfo.getStreamId().getBytes(this.defaultCharset));
        buf.putLong(timestamp);
        buf.putInt(arbitraryMapSize);
        int[] stringDataIndex = new int[streamRuntimeInfo.getNoOfStringAttributes()];
        int stringIndex = 0;
        int stringSize = 0;
        Attribute.Type[] types = streamRuntimeInfo.getAttributeTypes();
        int typesLength = types.length;
        block9: for (int i = 0; i < typesLength; ++i) {
            Attribute.Type type = types[i];
            switch (type) {
                case INT: {
                    buf.putInt((Integer)eventData[i]);
                    continue block9;
                }
                case LONG: {
                    buf.putLong((Long)eventData[i]);
                    continue block9;
                }
                case BOOL: {
                    buf.put((byte)((Boolean)eventData[i] != false ? 1 : 0));
                    continue block9;
                }
                case FLOAT: {
                    buf.putFloat(((Float)eventData[i]).floatValue());
                    continue block9;
                }
                case DOUBLE: {
                    buf.putDouble((Double)eventData[i]);
                    continue block9;
                }
                case STRING: {
                    if (eventData[i] == null) {
                        buf.putInt(-1);
                    } else {
                        int length = ((String)eventData[i]).getBytes(this.defaultCharset).length;
                        buf.putInt(length);
                        stringSize += length;
                    }
                    stringDataIndex[stringIndex] = i;
                    ++stringIndex;
                }
            }
        }
        arrayOutputStream.write(buf.array());
        buf = ByteBuffer.allocate(stringSize);
        for (int aStringIndex : stringDataIndex) {
            Object data = eventData[aStringIndex];
            if (data == null) continue;
            buf.put(((String)eventData[aStringIndex]).getBytes(this.defaultCharset));
        }
        arrayOutputStream.write(buf.array());
        if (arbitraryMapSize > 0) {
            buf = ByteBuffer.allocate(arbitraryMapSize);
            Object object = arbitraryMap.entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry entry = (Map.Entry)object.next();
                buf.putInt(((String)entry.getKey()).length());
                buf.put(((String)entry.getKey()).getBytes(this.defaultCharset));
                buf.putInt(((String)entry.getValue()).length());
                buf.put(((String)entry.getValue()).getBytes(this.defaultCharset));
            }
            arrayOutputStream.write(buf.array());
        }
        if (!this.isSynchronous) {
            this.publishToDisruptor(arrayOutputStream.toByteArray());
        } else {
            this.publishEvent(arrayOutputStream.toByteArray(), flush);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publishToDisruptor(byte[] byteArray) {
        long sequenceNo = this.ringBuffer.next();
        try {
            ByteArrayHolder existingHolder = (ByteArrayHolder)this.ringBuffer.get(sequenceNo);
            existingHolder.bytes = byteArray;
        }
        finally {
            this.ringBuffer.publish(sequenceNo);
        }
    }

    private synchronized void publishEvent(byte[] data, boolean flush) throws IOException {
        this.doPublishEvent(data, flush);
    }

    private void doPublishEvent(final byte[] data, final boolean flush) throws IOException {
        Future<Boolean> callableFuture = this.socketIoExecutorService.submit(new Callable<Boolean>(){

            @Override
            public Boolean call() throws IOException {
                TCPEventPublisher.this.outputStream.write(data);
                if (flush) {
                    TCPEventPublisher.this.outputStream.flush();
                }
                return true;
            }
        });
        try {
            callableFuture.get(this.socketIoTimeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IOException("Could not write the data to " + this.hostUrl);
        }
        catch (TimeoutException e) {
            throw new IOException("Timed out writing the data to " + this.hostUrl + " in milliseconds " + this.socketIoTimeout);
        }
    }

    private synchronized void publishEventAsync(byte[] data, boolean flush) throws IOException {
        if (this.outputStream != null) {
            try {
                this.doPublishEvent(data, flush);
            }
            catch (IOException e) {
                try {
                    log.error((Object)("Error on sending to " + this.hostUrl), (Throwable)e);
                    log.info((Object)("Reconnecting to " + this.hostUrl));
                    this.disconnect();
                    this.connect(this.hostUrl);
                    this.doPublishEvent(data, flush);
                }
                catch (IOException ex) {
                    log.error((Object)("Error on reconnection to " + this.hostUrl), (Throwable)ex);
                }
            }
        } else {
            try {
                log.info((Object)("Reconnecting to " + this.hostUrl));
                this.disconnect();
                this.connect(this.hostUrl);
                this.doPublishEvent(data, flush);
            }
            catch (IOException ex) {
                log.error((Object)("Error on reconnection to " + this.hostUrl), (Throwable)ex);
            }
        }
    }

    private void initializeDisruptor(TCPEventPublisherConfig publisherConfig) {
        this.disruptor = new Disruptor((EventFactory)new EventFactory<ByteArrayHolder>(){

            public ByteArrayHolder newInstance() {
                return new ByteArrayHolder();
            }
        }, publisherConfig.getBufferSize(), (Executor)Executors.newCachedThreadPool(), ProducerType.MULTI, (WaitStrategy)new TimeoutBlockingWaitStrategy(1L, TimeUnit.SECONDS));
        this.ringBuffer = this.disruptor.getRingBuffer();
        this.disruptor.handleEventsWith(new EventHandler[]{new EventHandler<ByteArrayHolder>(){

            public void onEvent(ByteArrayHolder byteArrayHolder, long sequence, boolean endOfBatch) throws IOException {
                TCPEventPublisher.this.publishEventAsync(byteArrayHolder.bytes, endOfBatch);
            }
        }});
        this.disruptor.start();
    }

    public void shutdown() {
        try {
            this.outputStream.flush();
        }
        catch (IOException e) {
            log.warn((Object)("Error while flushing output stream to " + this.hostUrl + " : " + e.getMessage()), (Throwable)e);
        }
        finally {
            this.terminate();
        }
    }

    public void terminate() {
        this.connectionStatusCheckTimer.cancel();
        if (!this.isSynchronous) {
            this.disruptor.shutdown();
        }
        this.disconnect();
        try {
            this.socketIoExecutorService.awaitTermination(this.socketIoTimeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            log.debug((Object)"Error while terminating the executor service", (Throwable)e);
        }
    }

    private void disconnect() {
        if (this.connectionStatusCheckTimer != null) {
            this.connectionStatusCheckTimer.cancel();
        }
        Future<?> outputStreamClosing = this.socketIoExecutorService.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    if (TCPEventPublisher.this.outputStream != null) {
                        TCPEventPublisher.this.outputStream.close();
                        TCPEventPublisher.this.outputStream = null;
                    }
                }
                catch (IOException e) {
                    log.debug((Object)("Error while disconnecting to " + TCPEventPublisher.this.hostUrl + " : " + e.getMessage()), (Throwable)e);
                }
            }
        });
        try {
            outputStreamClosing.get(this.socketIoTimeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            log.error((Object)"Could not close the output stream properly ", (Throwable)e);
        }
        Future<?> clientSocketClosing = this.socketIoExecutorService.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    if (TCPEventPublisher.this.clientSocket != null) {
                        TCPEventPublisher.this.clientSocket.close();
                        TCPEventPublisher.this.clientSocket = null;
                    }
                }
                catch (IOException e) {
                    log.debug((Object)("Error while closing socket to " + TCPEventPublisher.this.hostUrl + " : " + e.getMessage()), (Throwable)e);
                }
            }
        });
        try {
            clientSocketClosing.get(this.socketIoTimeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            log.error((Object)"Could not close the socket properly ", (Throwable)e);
        }
        if (this.connectionCallback != null) {
            this.connectionCallback.onCepReceiverDisconnect();
        }
    }

    public String getHostUrl() {
        return this.hostUrl;
    }

    class ConnectionStatusCheckTask
    extends TimerTask {
        ConnectionStatusCheckTask() {
        }

        private byte[] createPing() throws IOException {
            ByteBuffer buffer = ByteBuffer.allocate(4);
            buffer.putInt(-99);
            ByteArrayOutputStream arrayOutputStream = new ByteArrayOutputStream();
            arrayOutputStream.write(buffer.array());
            return arrayOutputStream.toByteArray();
        }

        @Override
        public void run() {
            block2: {
                try {
                    TCPEventPublisher.this.publishEvent(this.createPing(), true);
                }
                catch (IOException e) {
                    log.warn((Object)("Ping failed to " + TCPEventPublisher.this.getHostUrl() + " with error: " + e.getMessage()));
                    TCPEventPublisher.this.connectionStatusCheckTimer.cancel();
                    if (TCPEventPublisher.this.failureHandler == null) break block2;
                    TCPEventPublisher.this.failureHandler.onConnectionFail(e);
                }
            }
        }
    }

    class ByteArrayHolder {
        byte[] bytes;

        ByteArrayHolder() {
        }
    }
}

