/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.template.manager.admin.internal.util;

import java.util.List;
import org.wso2.carbon.event.template.manager.admin.dto.domain.DomainInfoDTO;
import org.wso2.carbon.event.template.manager.admin.dto.domain.DomainParameterDTO;
import org.wso2.carbon.event.template.manager.admin.dto.domain.ScenarioInfoDTO;
import org.wso2.carbon.event.template.manager.core.structure.domain.Domain;
import org.wso2.carbon.event.template.manager.core.structure.domain.Parameter;
import org.wso2.carbon.event.template.manager.core.structure.domain.Scenario;

public class DomainMapper {
    private DomainMapper() {
    }

    public static DomainInfoDTO mapTemplateManagerTemplate(Domain domain) {
        DomainInfoDTO domainInfoDTO = null;
        if (domain != null) {
            domainInfoDTO = new DomainInfoDTO();
            domainInfoDTO.setName(domain.getName());
            domainInfoDTO.setDescription(domain.getDescription());
            domainInfoDTO.setScenarioInfoDTOs(DomainMapper.mapScenarios(domain.getScenarios().getScenario()));
        }
        return domainInfoDTO;
    }

    public static DomainInfoDTO[] mapTemplateManagerTemplates(List<Domain> domains) {
        DomainInfoDTO[] domainInfoDTO = null;
        if (domains != null) {
            domainInfoDTO = new DomainInfoDTO[domains.size()];
            for (int i = 0; i < domainInfoDTO.length; ++i) {
                domainInfoDTO[i] = DomainMapper.mapTemplateManagerTemplate(domains.get(i));
            }
        }
        return domainInfoDTO;
    }

    private static ScenarioInfoDTO[] mapScenarios(List<Scenario> scenarios) {
        ScenarioInfoDTO[] scenarioInfoDTOs = new ScenarioInfoDTO[scenarios.size()];
        int i = 0;
        for (Scenario scenario : scenarios) {
            ScenarioInfoDTO scenarioInfoDTO = new ScenarioInfoDTO();
            scenarioInfoDTO.setType(scenario.getType());
            scenarioInfoDTO.setDescription(scenario.getDescription());
            scenarioInfoDTO.setDomainParameterDTOs(DomainMapper.mapParameters(scenario.getParameters().getParameter()));
            scenarioInfoDTOs[i] = scenarioInfoDTO;
            ++i;
        }
        return scenarioInfoDTOs;
    }

    private static DomainParameterDTO[] mapParameters(List<Parameter> parameters) {
        DomainParameterDTO[] domainParameterDTOs = new DomainParameterDTO[parameters.size()];
        int i = 0;
        for (Parameter parameter : parameters) {
            DomainParameterDTO domainParameterDTO = new DomainParameterDTO();
            domainParameterDTO.setName(parameter.getName());
            domainParameterDTO.setType(parameter.getType());
            domainParameterDTO.setDefaultValue(parameter.getDefaultValue());
            domainParameterDTO.setDescription(parameter.getDescription());
            domainParameterDTO.setDisplayName(parameter.getDisplayName());
            domainParameterDTO.setOptions(parameter.getOptions());
            domainParameterDTOs[i] = domainParameterDTO;
            ++i;
        }
        return domainParameterDTOs;
    }
}

