/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.template.manager.admin.internal.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.wso2.carbon.event.template.manager.admin.dto.configuration.AttributeMappingDTO;
import org.wso2.carbon.event.template.manager.admin.dto.configuration.ConfigurationParameterDTO;
import org.wso2.carbon.event.template.manager.admin.dto.configuration.ScenarioConfigurationDTO;
import org.wso2.carbon.event.template.manager.admin.dto.configuration.ScenarioConfigurationInfoDTO;
import org.wso2.carbon.event.template.manager.admin.dto.configuration.StreamMappingDTO;
import org.wso2.carbon.event.template.manager.core.structure.configuration.AttributeMapping;
import org.wso2.carbon.event.template.manager.core.structure.configuration.AttributeMappings;
import org.wso2.carbon.event.template.manager.core.structure.configuration.ScenarioConfiguration;
import org.wso2.carbon.event.template.manager.core.structure.configuration.StreamMapping;
import org.wso2.carbon.event.template.manager.core.structure.configuration.StreamMappings;

public class ConfigurationMapper {
    private ConfigurationMapper() {
    }

    public static ScenarioConfigurationInfoDTO[] mapConfigurationsInfo(List<ScenarioConfiguration> scenarioConfigurations) {
        ScenarioConfigurationInfoDTO[] scenarioConfigurationInfoDTO = null;
        if (scenarioConfigurations != null) {
            scenarioConfigurationInfoDTO = new ScenarioConfigurationInfoDTO[scenarioConfigurations.size()];
            for (int i = 0; i < scenarioConfigurationInfoDTO.length; ++i) {
                scenarioConfigurationInfoDTO[i] = ConfigurationMapper.mapConfigurationInfo(scenarioConfigurations.get(i));
            }
        }
        return scenarioConfigurationInfoDTO;
    }

    public static ScenarioConfigurationInfoDTO mapConfigurationInfo(ScenarioConfiguration scenarioConfig) {
        ScenarioConfigurationInfoDTO scenarioConfigurationInfoDTO = null;
        if (scenarioConfig != null) {
            scenarioConfigurationInfoDTO = new ScenarioConfigurationInfoDTO();
            scenarioConfigurationInfoDTO.setName(scenarioConfig.getName());
            scenarioConfigurationInfoDTO.setType(scenarioConfig.getScenario());
            scenarioConfigurationInfoDTO.setDescription(scenarioConfig.getDescription());
            scenarioConfigurationInfoDTO.setDomain(scenarioConfig.getDomain());
        }
        return scenarioConfigurationInfoDTO;
    }

    public static ScenarioConfigurationDTO[] mapConfigurations(List<ScenarioConfiguration> scenarioConfigurations) {
        ScenarioConfigurationDTO[] scenarioConfigurationDTOs = null;
        if (scenarioConfigurations != null) {
            scenarioConfigurationDTOs = new ScenarioConfigurationDTO[scenarioConfigurations.size()];
            for (int i = 0; i < scenarioConfigurationDTOs.length; ++i) {
                scenarioConfigurationDTOs[i] = ConfigurationMapper.mapConfiguration(scenarioConfigurations.get(i));
            }
        }
        return scenarioConfigurationDTOs;
    }

    public static ScenarioConfigurationDTO mapConfiguration(ScenarioConfiguration scenarioConfig) {
        ScenarioConfigurationDTO scenarioConfigurationDTO = null;
        if (scenarioConfig != null) {
            scenarioConfigurationDTO = new ScenarioConfigurationDTO();
            scenarioConfigurationDTO.setName(scenarioConfig.getName());
            scenarioConfigurationDTO.setType(scenarioConfig.getScenario());
            scenarioConfigurationDTO.setDescription(scenarioConfig.getDescription());
            scenarioConfigurationDTO.setDomain(scenarioConfig.getDomain());
            scenarioConfigurationDTO.setConfigurationParameterDTOs(ConfigurationMapper.mapParameters(scenarioConfig.getParameterMap()));
            scenarioConfigurationDTO.setStreamMappingDTOs(ConfigurationMapper.mapStreamMappings(scenarioConfig.getStreamMappings()));
        }
        return scenarioConfigurationDTO;
    }

    private static StreamMappingDTO[] mapStreamMappings(StreamMappings streamMappings) {
        if (streamMappings == null) {
            return null;
        }
        List streamMappingList = streamMappings.getStreamMapping();
        StreamMappingDTO[] mappingDTOArray = new StreamMappingDTO[streamMappingList.size()];
        int i = 0;
        for (StreamMapping streamMapping : streamMappingList) {
            StreamMappingDTO mappingDTO = new StreamMappingDTO();
            mappingDTO.setFromStream(streamMapping.getFrom());
            mappingDTO.setToStream(streamMapping.getTo());
            AttributeMappingDTO[] attributeDTOArray = new AttributeMappingDTO[streamMapping.getAttributeMappings().getAttributeMapping().size()];
            int j = 0;
            for (AttributeMapping attributeMapping : streamMapping.getAttributeMappings().getAttributeMapping()) {
                AttributeMappingDTO attributeDTO = new AttributeMappingDTO();
                attributeDTO.setFromAttribute(attributeMapping.getFrom());
                attributeDTO.setToAttribute(attributeMapping.getTo());
                attributeDTO.setAttributeType(attributeMapping.getType());
                attributeDTOArray[j] = attributeDTO;
                ++j;
            }
            mappingDTO.setAttributeMappingDTOs(attributeDTOArray);
            mappingDTOArray[i] = mappingDTO;
            ++i;
        }
        return mappingDTOArray;
    }

    public static ScenarioConfiguration mapConfiguration(ScenarioConfigurationDTO configDTO) {
        ScenarioConfiguration scenarioConfig = null;
        if (configDTO != null) {
            scenarioConfig = new ScenarioConfiguration();
            scenarioConfig.setName(configDTO.getName());
            scenarioConfig.setScenario(configDTO.getType());
            scenarioConfig.setDescription(configDTO.getDescription());
            scenarioConfig.setDomain(configDTO.getDomain());
            scenarioConfig.setParameterMap(ConfigurationMapper.mapParameters(configDTO.getConfigurationParameterDTOs()));
        }
        return scenarioConfig;
    }

    private static Map<String, String> mapParameters(ConfigurationParameterDTO[] configurationParameterDTOs) {
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        if (configurationParameterDTOs != null) {
            for (int i = 0; i < configurationParameterDTOs.length; ++i) {
                parameterMap.put(configurationParameterDTOs[i].getName(), configurationParameterDTOs[i].getValue());
            }
        }
        return parameterMap;
    }

    private static ConfigurationParameterDTO[] mapParameters(Map<String, String> parameterMap) {
        ConfigurationParameterDTO[] configurationParameterDTOs = null;
        if (parameterMap != null) {
            configurationParameterDTOs = new ConfigurationParameterDTO[parameterMap.size()];
            int i = 0;
            for (Map.Entry<String, String> entry : parameterMap.entrySet()) {
                ConfigurationParameterDTO dto = new ConfigurationParameterDTO();
                dto.setName(entry.getKey());
                dto.setValue(entry.getValue());
                configurationParameterDTOs[i] = dto;
                ++i;
            }
        }
        return configurationParameterDTOs;
    }

    public static List<StreamMapping> mapStreamMapping(StreamMappingDTO[] streamMappingDTO) {
        ArrayList<StreamMapping> streamMappings = new ArrayList<StreamMapping>();
        for (int i = 0; i < streamMappingDTO.length; ++i) {
            StreamMapping streamMapping = new StreamMapping();
            streamMapping.setFrom(streamMappingDTO[i].getFromStream());
            streamMapping.setTo(streamMappingDTO[i].getToStream());
            ArrayList<AttributeMapping> attributeMappingList = new ArrayList<AttributeMapping>();
            for (int j = 0; j < streamMappingDTO[i].getAttributeMappingDTOs().length; ++j) {
                AttributeMapping attributeMapping = new AttributeMapping();
                attributeMapping.setFrom(streamMappingDTO[i].getAttributeMappingDTOs()[j].getFromAttribute());
                attributeMapping.setTo(streamMappingDTO[i].getAttributeMappingDTOs()[j].getToAttribute());
                attributeMapping.setType(streamMappingDTO[i].getAttributeMappingDTOs()[j].getAttributeType());
                attributeMappingList.add(attributeMapping);
            }
            AttributeMappings attributeMappings = new AttributeMappings();
            attributeMappings.setAttributeMapping(attributeMappingList);
            streamMapping.setAttributeMappings(attributeMappings);
            streamMappings.add(streamMapping);
        }
        return streamMappings;
    }
}

