/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.template.manager.admin;

import java.util.ArrayList;
import java.util.List;
import org.apache.axis2.AxisFault;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.event.template.manager.admin.dto.configuration.ScenarioConfigurationDTO;
import org.wso2.carbon.event.template.manager.admin.dto.configuration.ScenarioConfigurationInfoDTO;
import org.wso2.carbon.event.template.manager.admin.dto.configuration.StreamMappingDTO;
import org.wso2.carbon.event.template.manager.admin.dto.domain.DomainInfoDTO;
import org.wso2.carbon.event.template.manager.admin.internal.ds.TemplateManagerAdminServiceValueHolder;
import org.wso2.carbon.event.template.manager.admin.internal.util.ConfigurationMapper;
import org.wso2.carbon.event.template.manager.admin.internal.util.DomainMapper;
import org.wso2.carbon.event.template.manager.core.exception.TemplateManagerException;
import org.wso2.carbon.event.template.manager.core.structure.configuration.ScenarioConfiguration;
import org.wso2.carbon.event.template.manager.core.structure.domain.Domain;

public class TemplateManagerAdminService
extends AbstractAdmin {
    private static final Log log = LogFactory.getLog(TemplateManagerAdminService.class);

    public DomainInfoDTO getDomainInfo(String domainName) throws AxisFault {
        try {
            return DomainMapper.mapTemplateManagerTemplate(TemplateManagerAdminServiceValueHolder.getCarbonTemplateManagerService().getDomain(domainName));
        }
        catch (Throwable e) {
            log.error((Object)("Error occurred when getting domain " + domainName), e);
            throw new AxisFault(e.getMessage());
        }
    }

    public DomainInfoDTO[] getAllDomainInfos() throws AxisFault {
        try {
            return DomainMapper.mapTemplateManagerTemplates(new ArrayList<Domain>(TemplateManagerAdminServiceValueHolder.getCarbonTemplateManagerService().getAllDomains()));
        }
        catch (Throwable e) {
            log.error((Object)"Error occurred when getting all domains ", e);
            throw new AxisFault(e.getMessage(), e);
        }
    }

    public ScenarioConfigurationDTO getConfiguration(String domainName, String configName) throws AxisFault {
        try {
            return ConfigurationMapper.mapConfiguration(TemplateManagerAdminServiceValueHolder.getCarbonTemplateManagerService().getConfiguration(domainName, configName));
        }
        catch (TemplateManagerException e) {
            log.error((Object)("Error occurred when getting template configuration " + configName), (Throwable)e);
            throw new AxisFault(e.getMessage());
        }
    }

    public ScenarioConfigurationInfoDTO[] getConfigurationInfos(String domainName) throws AxisFault {
        try {
            return ConfigurationMapper.mapConfigurationsInfo(new ArrayList<ScenarioConfiguration>(TemplateManagerAdminServiceValueHolder.getCarbonTemplateManagerService().getConfigurations(domainName)));
        }
        catch (TemplateManagerException e) {
            log.error((Object)("Error occurred when getting configurations for domain " + domainName), (Throwable)e);
            throw new AxisFault(e.getMessage());
        }
    }

    public boolean deleteConfiguration(String domainName, String configName) throws AxisFault {
        try {
            TemplateManagerAdminServiceValueHolder.getCarbonTemplateManagerService().deleteConfiguration(domainName, configName);
            return true;
        }
        catch (TemplateManagerException e) {
            log.error((Object)("Error occurred when deleting configuration " + configName), (Throwable)e);
            throw new AxisFault(e.getMessage(), (Throwable)e);
        }
    }

    public String[] saveConfiguration(ScenarioConfigurationDTO configuration) throws AxisFault {
        try {
            List streamIdList = TemplateManagerAdminServiceValueHolder.getCarbonTemplateManagerService().saveConfiguration(ConfigurationMapper.mapConfiguration(configuration));
            if (streamIdList != null) {
                return streamIdList.toArray(new String[0]);
            }
            return null;
        }
        catch (TemplateManagerException e) {
            log.error((Object)("Error occurred when saving configuration " + configuration.getName()), (Throwable)e);
            throw new AxisFault(e.getMessage(), (Throwable)e);
        }
    }

    public String[] editConfiguration(ScenarioConfigurationDTO configuration) throws AxisFault {
        try {
            List streamIdList = TemplateManagerAdminServiceValueHolder.getCarbonTemplateManagerService().editConfiguration(ConfigurationMapper.mapConfiguration(configuration));
            if (streamIdList != null) {
                return streamIdList.toArray(new String[0]);
            }
            return null;
        }
        catch (TemplateManagerException e) {
            log.error((Object)("Error occurred when editing configuration " + configuration.getName()), (Throwable)e);
            throw new AxisFault(e.getMessage(), (Throwable)e);
        }
    }

    public boolean saveStreamMapping(StreamMappingDTO[] streamMappingDTOs, String configName, String domainName) throws AxisFault {
        try {
            TemplateManagerAdminServiceValueHolder.getCarbonTemplateManagerService().saveStreamMapping(ConfigurationMapper.mapStreamMapping(streamMappingDTOs), configName, domainName);
            return true;
        }
        catch (TemplateManagerException e) {
            log.error((Object)("Error occurred when saving configuration " + configName + " in domain " + domainName + " with stream mappings"), (Throwable)e);
            throw new AxisFault(e.getMessage(), (Throwable)e);
        }
    }
}

