/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.idp.mgt.ui.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.axiom.om.util.Base64;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.RequestContext;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.servlet.ServletRequestContext;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.identity.application.common.IdentityApplicationManagementException;
import org.wso2.carbon.identity.application.common.model.idp.xsd.Claim;
import org.wso2.carbon.identity.application.common.model.idp.xsd.ClaimConfig;
import org.wso2.carbon.identity.application.common.model.idp.xsd.ClaimMapping;
import org.wso2.carbon.identity.application.common.model.idp.xsd.FederatedAuthenticatorConfig;
import org.wso2.carbon.identity.application.common.model.idp.xsd.IdentityProvider;
import org.wso2.carbon.identity.application.common.model.idp.xsd.IdentityProviderProperty;
import org.wso2.carbon.identity.application.common.model.idp.xsd.JustInTimeProvisioningConfig;
import org.wso2.carbon.identity.application.common.model.idp.xsd.LocalRole;
import org.wso2.carbon.identity.application.common.model.idp.xsd.PermissionsAndRoleConfig;
import org.wso2.carbon.identity.application.common.model.idp.xsd.Property;
import org.wso2.carbon.identity.application.common.model.idp.xsd.ProvisioningConnectorConfig;
import org.wso2.carbon.identity.application.common.model.idp.xsd.RoleMapping;
import org.wso2.carbon.identity.application.common.util.IdentityApplicationManagementUtil;

public class IdPManagementUIUtil {
    private static final Log log = LogFactory.getLog(IdPManagementUIUtil.class);
    public static final String JWKS_URI = "jwksUri";
    private static final String META_DATA_SAML = "meta_data_saml";
    public static final String DEFAULT_AUTH_SEQ = "default_sequence";
    public static final String FILTER_STRING = "org.wso2.carbon.idp.mgt.filter";
    public static final String IDP_FILTER = "idpFilter";
    public static final String IDP_LIST = "identityProviderList";
    public static final String PAGE_NUMBER = "pageNumber";
    public static final String IDP_LIST_UNIQUE_ID = "idpUniqueIdMap";

    public static boolean validateURI(String uriString) {
        if (uriString != null) {
            try {
                URL uRL = new URL(uriString);
            }
            catch (MalformedURLException e) {
                log.debug((Object)e.getMessage(), (Throwable)e);
                return false;
            }
        } else {
            String errorMsg = "Invalid URL: 'NULL'";
            log.debug((Object)errorMsg);
            return false;
        }
        return true;
    }

    public static IdentityProvider buildFederatedIdentityProvider(HttpServletRequest request, StringBuilder oldIdpName) throws Exception {
        HashMap<String, List<Property>> customProProperties;
        ArrayList<String> proConnectorNames;
        HashMap<String, String> paramMap;
        IdentityProvider fedIdp = new IdentityProvider();
        if (ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            ServletRequestContext servletContext = new ServletRequestContext(request);
            DiskFileItemFactory factory = new DiskFileItemFactory();
            ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
            List items = upload.parseRequest((RequestContext)servletContext);
            paramMap = new HashMap<String, String>();
            ArrayList<String> idpClaims = new ArrayList<String>();
            ArrayList<String> idpRoles = new ArrayList<String>();
            ArrayList<String> customAuthenticatorNames = new ArrayList<String>();
            proConnectorNames = new ArrayList<String>();
            HashMap<String, List<Property>> customAuthenticatorProperties = new HashMap<String, List<Property>>();
            customProProperties = new HashMap<String, List<Property>>();
            String idpUUID = "";
            StringBuilder deletedCertificateValue = new StringBuilder();
            for (Object item : items) {
                String string;
                List propList;
                Property prop;
                String propVal;
                String propName;
                DiskFileItem diskFileItem = (DiskFileItem)item;
                if (diskFileItem == null) continue;
                byte[] value = diskFileItem.get();
                String key = diskFileItem.getFieldName();
                if (StringUtils.equals((String)key, (String)"idpUUID")) {
                    idpUUID = diskFileItem.getString();
                }
                if (META_DATA_SAML.equals(key)) {
                    if (StringUtils.isNotEmpty((String)diskFileItem.getName()) && !diskFileItem.getName().trim().endsWith(".xml")) {
                        throw new CarbonException("File not supported!");
                    }
                    paramMap.put(key, Base64.encode((byte[])value));
                }
                if ("certFile".equals(key)) {
                    paramMap.put(key, Base64.encode((byte[])value));
                } else if (key.startsWith("certificateVal")) {
                    deletedCertificateValue.append(new String(value, StandardCharsets.UTF_8));
                } else if ("google_prov_private_key".equals(key)) {
                    paramMap.put(key, Base64.encode((byte[])value));
                } else if (key.startsWith("claimrowname_")) {
                    String string2 = new String(value, StandardCharsets.UTF_8);
                    idpClaims.add(string2);
                    paramMap.put(key, string2);
                } else if (key.startsWith("rolerowname_")) {
                    String string3 = new String(value, StandardCharsets.UTF_8);
                    idpRoles.add(string3);
                    paramMap.put(key, string3);
                } else if (key.startsWith("custom_auth_name")) {
                    customAuthenticatorNames.add(new String(value, StandardCharsets.UTF_8));
                } else if (key.startsWith("custom_pro_name")) {
                    proConnectorNames.add(new String(value, StandardCharsets.UTF_8));
                } else if (key.startsWith("cust_auth_prop_")) {
                    int n = "cust_auth_prop_".length();
                    String authPropString = new String(key).substring(n);
                    if (authPropString.indexOf("#") > 0) {
                        String authName = authPropString.substring(0, authPropString.indexOf("#"));
                        propName = authPropString.substring(authPropString.indexOf("#") + 1);
                        propVal = new String(value, StandardCharsets.UTF_8);
                        prop = new Property();
                        prop.setName(propName);
                        prop.setValue(propVal);
                        propList = null;
                        if (customAuthenticatorProperties.get(authName) == null) {
                            customAuthenticatorProperties.put(authName, new ArrayList());
                        }
                        propList = (List)customAuthenticatorProperties.get(authName);
                        propList.add(prop);
                        customAuthenticatorProperties.put(authName, propList);
                    }
                } else if (key.startsWith("cust_pro_prop_")) {
                    int n = "cust_pro_prop_".length();
                    String provPropString = new String(key).substring(n);
                    if (provPropString.indexOf("#") > 0) {
                        String proConName = provPropString.substring(0, provPropString.indexOf("#"));
                        propName = provPropString.substring(provPropString.indexOf("#") + 1);
                        propVal = new String(value, StandardCharsets.UTF_8);
                        prop = new Property();
                        prop.setName(propName);
                        prop.setValue(propVal);
                        propList = null;
                        if (customProProperties.get(proConName) == null) {
                            customProProperties.put(proConName, new ArrayList());
                        }
                        propList = (List)customProProperties.get(proConName);
                        propList.add(prop);
                        customProProperties.put(proConName, propList);
                    }
                } else {
                    paramMap.put(key, new String(value, StandardCharsets.UTF_8));
                }
                if ((string = (String)paramMap.get(key)) == null || string.trim().length() != 0) continue;
                paramMap.put(key, null);
            }
            paramMap.put("certificateVal", deletedCertificateValue.toString());
            IdentityProvider oldIdentityProvider = (IdentityProvider)request.getSession().getAttribute(idpUUID);
            if (oldIdentityProvider != null) {
                if (oldIdpName == null) {
                    oldIdpName = new StringBuilder();
                }
                oldIdpName.append(oldIdentityProvider.getIdentityProviderName());
            }
            if (oldIdentityProvider != null && oldIdentityProvider.getCertificate() != null) {
                if (oldIdentityProvider.getCertificateInfoArray() != null && oldIdentityProvider.getCertificateInfoArray().length > 1) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Number of old certificate for the identity provider " + oldIdentityProvider.getDisplayName() + " is " + oldIdentityProvider.getCertificateInfoArray().length));
                    }
                    StringBuilder multipleCertificate = new StringBuilder();
                    for (ProvisioningConnectorConfig provisioningConnectorConfig : oldIdentityProvider.getCertificateInfoArray()) {
                        multipleCertificate.append(new String(Base64.decode((String)provisioningConnectorConfig.getCertValue()), StandardCharsets.UTF_8));
                    }
                    paramMap.put("oldCertFile", Base64.encode((byte[])multipleCertificate.toString().getBytes(StandardCharsets.UTF_8)));
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Only one certificate has been found as old certificate.");
                    }
                    paramMap.put("oldCertFile", oldIdentityProvider.getCertificate());
                }
            }
            if (oldIdentityProvider != null && oldIdentityProvider.getProvisioningConnectorConfigs() != null) {
                ProvisioningConnectorConfig[] provisioningConnectorConfig;
                for (ProvisioningConnectorConfig provisioningConnectorConfig2 : provisioningConnectorConfig = oldIdentityProvider.getProvisioningConnectorConfigs()) {
                    Property[] googleProperties;
                    if (!"googleapps".equals(provisioningConnectorConfig2.getName())) continue;
                    for (Property property : googleProperties = provisioningConnectorConfig2.getProvisioningProperties()) {
                        if (!property.getName().equals("google_prov_private_key")) continue;
                        paramMap.put("old_google_prov_private_key", property.getValue());
                    }
                }
            }
            IdPManagementUIUtil.buildBasicInformation(fedIdp, paramMap);
            IdPManagementUIUtil.buildOutboundAuthenticationConfiguration(fedIdp, paramMap);
            IdPManagementUIUtil.buildCustomAuthenticationConfiguration(fedIdp, customAuthenticatorNames, customAuthenticatorProperties, paramMap);
            if (oldIdentityProvider != null && oldIdentityProvider.getClaimConfig().getClaimMappings() != null) {
                IdPManagementUIUtil.buildClaimConfiguration(fedIdp, paramMap, idpClaims, oldIdentityProvider.getClaimConfig().getClaimMappings());
            } else {
                IdPManagementUIUtil.buildClaimConfiguration(fedIdp, paramMap, idpClaims, null);
            }
            if (oldIdentityProvider != null && oldIdentityProvider.getPermissionAndRoleConfig() != null && oldIdentityProvider.getPermissionAndRoleConfig().getRoleMappings() != null) {
                IdPManagementUIUtil.buildRoleConfiguration(fedIdp, paramMap, idpRoles, oldIdentityProvider.getPermissionAndRoleConfig().getRoleMappings());
            } else {
                IdPManagementUIUtil.buildRoleConfiguration(fedIdp, paramMap, idpRoles, null);
            }
        } else {
            throw new Exception("Invalid Content Type: Not multipart/form-data");
        }
        IdPManagementUIUtil.buildInboundProvisioningConfiguration(fedIdp, paramMap);
        IdPManagementUIUtil.buildOutboundProvisioningConfiguration(fedIdp, paramMap);
        IdPManagementUIUtil.buildCustomProvisioningConfiguration(fedIdp, proConnectorNames, customProProperties, paramMap);
        return fedIdp;
    }

    private static void buildOutboundProvisioningConfiguration(IdentityProvider fedIdp, Map<String, String> paramMap) throws IdentityApplicationManagementException {
        IdPManagementUIUtil.buildGoogleProvisioningConfiguration(fedIdp, paramMap);
        IdPManagementUIUtil.buildSCIMProvisioningConfiguration(fedIdp, paramMap);
        IdPManagementUIUtil.buildSalesforceProvisioningConfiguration(fedIdp, paramMap);
    }

    private static void buildGoogleProvisioningConfiguration(IdentityProvider fedIdp, Map<String, String> paramMap) throws IdentityApplicationManagementException {
        ProvisioningConnectorConfig proConnector = new ProvisioningConnectorConfig();
        proConnector.setName("googleapps");
        Property domainName = null;
        Property emailClaim = null;
        Property givenNameClaim = null;
        Property givenNameDefaultVal = null;
        Property familyNameClaim = null;
        Property familyNameDefault = null;
        Property serviceAccEmail = null;
        Property privateKey = null;
        Property adminEmail = null;
        Property appName = null;
        Property googleProvPatten = null;
        Property googleProvSeparator = null;
        Property uniqueID = null;
        String oldGooglePvtKey = null;
        String newGooglePvtKey = null;
        if (paramMap.get("googleProvEnabled") != null && "on".equals(paramMap.get("googleProvEnabled"))) {
            proConnector.setEnabled(true);
        } else {
            proConnector.setEnabled(false);
        }
        if (paramMap.get("googleProvDefault") != null && "on".equals(paramMap.get("googleProvDefault"))) {
            fedIdp.setDefaultProvisioningConnectorConfig(proConnector);
        }
        if (paramMap.get("google_prov_domain_name") != null) {
            domainName = new Property();
            domainName.setName("google_prov_domain_name");
            domainName.setValue(paramMap.get("google_prov_domain_name"));
        }
        if (paramMap.get("google_prov_email_claim_dropdown") != null) {
            emailClaim = new Property();
            emailClaim.setName("google_prov_email_claim_dropdown");
            emailClaim.setValue(paramMap.get("google_prov_email_claim_dropdown"));
        }
        if (paramMap.get("google_prov_givenname_claim_dropdown") != null) {
            givenNameClaim = new Property();
            givenNameClaim.setName("google_prov_givenname_claim_dropdown");
            givenNameClaim.setValue(paramMap.get("google_prov_givenname_claim_dropdown"));
        }
        if (paramMap.get("google_prov_givenname") != null) {
            givenNameDefaultVal = new Property();
            givenNameDefaultVal.setName("google_prov_givenname");
            givenNameDefaultVal.setValue(paramMap.get("google_prov_givenname"));
        }
        if (paramMap.get("google_prov_familyname_claim_dropdown") != null) {
            familyNameClaim = new Property();
            familyNameClaim.setName("google_prov_familyname_claim_dropdown");
            familyNameClaim.setValue(paramMap.get("google_prov_familyname_claim_dropdown"));
        }
        if (paramMap.get("google_prov_familyname") != null) {
            familyNameDefault = new Property();
            familyNameDefault.setName("google_prov_familyname");
            familyNameDefault.setValue(paramMap.get("google_prov_familyname"));
        }
        if (paramMap.get("google_prov_service_acc_email") != null) {
            serviceAccEmail = new Property();
            serviceAccEmail.setName("google_prov_service_acc_email");
            serviceAccEmail.setValue(paramMap.get("google_prov_service_acc_email"));
        }
        if (paramMap.get("old_google_prov_private_key") != null) {
            oldGooglePvtKey = paramMap.get("old_google_prov_private_key");
        }
        if (paramMap.get("google_prov_private_key") != null) {
            newGooglePvtKey = paramMap.get("google_prov_private_key");
        }
        if (newGooglePvtKey == null && oldGooglePvtKey != null) {
            newGooglePvtKey = oldGooglePvtKey;
        }
        if (newGooglePvtKey != null) {
            privateKey = new Property();
            privateKey.setName("google_prov_private_key");
            privateKey.setValue(newGooglePvtKey);
            privateKey.setType("BLOB");
        }
        if (paramMap.get("google_prov_admin_email") != null) {
            adminEmail = new Property();
            adminEmail.setName("google_prov_admin_email");
            adminEmail.setValue(paramMap.get("google_prov_admin_email"));
        }
        if (paramMap.get("google_prov_application_name") != null) {
            appName = new Property();
            appName.setName("google_prov_application_name");
            appName.setValue(paramMap.get("google_prov_application_name"));
        }
        if (paramMap.get("google_prov_pattern") != null) {
            googleProvPatten = new Property();
            googleProvPatten.setName("google_prov_pattern");
            googleProvPatten.setValue(paramMap.get("google_prov_pattern"));
        }
        if (paramMap.get("google_prov_separator") != null) {
            googleProvSeparator = new Property();
            googleProvSeparator.setName("google_prov_separator");
            googleProvSeparator.setValue(paramMap.get("google_prov_separator"));
        }
        if (paramMap.get("google-unique-id") != null) {
            uniqueID = new Property();
            uniqueID.setName("UniqueID");
            uniqueID.setValue(paramMap.get("google-unique-id"));
        }
        Property[] proProperties = new Property[]{appName, adminEmail, privateKey, serviceAccEmail, familyNameDefault, familyNameClaim, givenNameDefaultVal, givenNameClaim, emailClaim, domainName, googleProvPatten, googleProvSeparator, uniqueID};
        proConnector.setProvisioningProperties(proProperties);
        ProvisioningConnectorConfig[] proConnectors = fedIdp.getProvisioningConnectorConfigs();
        if (proConnector.getName() != null) {
            if (proConnectors == null || proConnectors.length == 0) {
                fedIdp.setProvisioningConnectorConfigs(new ProvisioningConnectorConfig[]{proConnector});
            } else {
                fedIdp.setProvisioningConnectorConfigs(IdPManagementUIUtil.concatArrays(new ProvisioningConnectorConfig[]{proConnector}, proConnectors));
            }
        }
    }

    private static void buildSCIMProvisioningConfiguration(IdentityProvider fedIdp, Map<String, String> paramMap) throws IdentityApplicationManagementException {
        ProvisioningConnectorConfig proConnector = new ProvisioningConnectorConfig();
        proConnector.setName("scim");
        Property userNameProp = null;
        Property passwordProp = null;
        Property userEpProp = null;
        Property groupEpProp = null;
        Property scimUserStoreDomain = null;
        Property scimEnablePwdProvisioning = null;
        Property defaultPwdProp = null;
        Property uniqueID = null;
        if (paramMap.get("scimProvEnabled") != null && "on".equals(paramMap.get("scimProvEnabled"))) {
            proConnector.setEnabled(true);
        } else {
            proConnector.setEnabled(false);
        }
        if (paramMap.get("scimProvDefault") != null && "on".equals(paramMap.get("scimProvDefault"))) {
            fedIdp.setDefaultProvisioningConnectorConfig(proConnector);
        }
        if (paramMap.get("scim-username") != null) {
            userNameProp = new Property();
            userNameProp.setName("scim-username");
            userNameProp.setValue(paramMap.get("scim-username"));
        }
        if (paramMap.get("scim-password") != null) {
            passwordProp = new Property();
            passwordProp.setConfidential(true);
            passwordProp.setName("scim-password");
            passwordProp.setValue(paramMap.get("scim-password"));
        }
        if (paramMap.get("scim-user-ep") != null) {
            userEpProp = new Property();
            userEpProp.setName("scim-user-ep");
            userEpProp.setValue(paramMap.get("scim-user-ep"));
        }
        if (paramMap.get("scim-group-ep") != null) {
            groupEpProp = new Property();
            groupEpProp.setName("scim-group-ep");
            groupEpProp.setValue(paramMap.get("scim-group-ep"));
        }
        if (paramMap.get("scim-user-store-domain") != null) {
            scimUserStoreDomain = new Property();
            scimUserStoreDomain.setName("scim-user-store-domain");
            scimUserStoreDomain.setValue(paramMap.get("scim-user-store-domain"));
        }
        if (paramMap.get("scimPwdProvEnabled") != null && "on".equals(paramMap.get("scimPwdProvEnabled"))) {
            scimEnablePwdProvisioning = new Property();
            scimEnablePwdProvisioning.setName("scim-enable-pwd-provisioning");
            scimEnablePwdProvisioning.setDefaultValue("false");
            scimEnablePwdProvisioning.setValue("true");
        }
        if (paramMap.get("scim-default-pwd") != null) {
            defaultPwdProp = new Property();
            defaultPwdProp.setName("scim-default-pwd");
            defaultPwdProp.setValue(paramMap.get("scim-default-pwd"));
        }
        if (paramMap.get("scim-unique-id") != null) {
            uniqueID = new Property();
            uniqueID.setName("UniqueID");
            uniqueID.setValue(paramMap.get("scim-unique-id"));
        }
        Property[] proProperties = new Property[]{userNameProp, passwordProp, userEpProp, groupEpProp, scimUserStoreDomain, scimEnablePwdProvisioning, defaultPwdProp, uniqueID};
        proConnector.setProvisioningProperties(proProperties);
        ProvisioningConnectorConfig[] proConnectors = fedIdp.getProvisioningConnectorConfigs();
        if (proConnector.getName() != null) {
            if (proConnectors == null || proConnectors.length == 0) {
                fedIdp.setProvisioningConnectorConfigs(new ProvisioningConnectorConfig[]{proConnector});
            } else {
                fedIdp.setProvisioningConnectorConfigs(IdPManagementUIUtil.concatArrays(new ProvisioningConnectorConfig[]{proConnector}, proConnectors));
            }
        }
    }

    private static void buildSalesforceProvisioningConfiguration(IdentityProvider fedIdp, Map<String, String> paramMap) throws IdentityApplicationManagementException {
        ProvisioningConnectorConfig proConnector = new ProvisioningConnectorConfig();
        proConnector.setName("salesforce");
        Property userNameProp = null;
        Property passwordProp = null;
        Property clentIdProp = null;
        Property clientSecretProp = null;
        Property apiVersionProp = null;
        Property domainNameProp = null;
        Property tokenEndpointProp = null;
        Property provisioningPattern = null;
        Property provisioningSeparator = null;
        Property provisioningDomain = null;
        Property uniqueID = null;
        if (paramMap.get("sfProvEnabled") != null && "on".equals(paramMap.get("sfProvEnabled"))) {
            proConnector.setEnabled(true);
        } else {
            proConnector.setEnabled(false);
        }
        if (paramMap.get("sfProvDefault") != null && "on".equals(paramMap.get("sfProvDefault"))) {
            fedIdp.setDefaultProvisioningConnectorConfig(proConnector);
        }
        if (paramMap.get("sf-username") != null) {
            userNameProp = new Property();
            userNameProp.setName("sf-username");
            userNameProp.setValue(paramMap.get("sf-username"));
        }
        if (paramMap.get("sf-password") != null) {
            passwordProp = new Property();
            passwordProp.setConfidential(true);
            passwordProp.setName("sf-password");
            passwordProp.setValue(paramMap.get("sf-password"));
        }
        if (paramMap.get("sf-clientid") != null) {
            clentIdProp = new Property();
            clentIdProp.setName("sf-clientid");
            clentIdProp.setValue(paramMap.get("sf-clientid"));
        }
        if (paramMap.get("sf-client-secret") != null) {
            clientSecretProp = new Property();
            clientSecretProp.setConfidential(true);
            clientSecretProp.setName("sf-client-secret");
            clientSecretProp.setValue(paramMap.get("sf-client-secret"));
        }
        if (paramMap.get("sf-clientid") != null) {
            clentIdProp = new Property();
            clentIdProp.setName("sf-clientid");
            clentIdProp.setValue(paramMap.get("sf-clientid"));
        }
        if (paramMap.get("sf-api-version") != null) {
            apiVersionProp = new Property();
            apiVersionProp.setName("sf-api-version");
            apiVersionProp.setValue(paramMap.get("sf-api-version"));
        }
        if (paramMap.get("sf-domain-name") != null) {
            domainNameProp = new Property();
            domainNameProp.setName("sf-domain-name");
            domainNameProp.setValue(paramMap.get("sf-domain-name"));
        }
        if (paramMap.get("sf-token-endpoint") != null) {
            tokenEndpointProp = new Property();
            tokenEndpointProp.setName("sf-token-endpoint");
            tokenEndpointProp.setValue(paramMap.get("sf-token-endpoint"));
        }
        if (paramMap.get("sf-prov-pattern") != null) {
            provisioningPattern = new Property();
            provisioningPattern.setName("sf-prov-pattern");
            provisioningPattern.setValue(paramMap.get("sf-prov-pattern"));
        }
        if (paramMap.get("sf-prov-separator") != null) {
            provisioningSeparator = new Property();
            provisioningSeparator.setName("sf-prov-separator");
            provisioningSeparator.setValue(paramMap.get("sf-prov-separator"));
        }
        if (paramMap.get("sf-prov-domainName") != null) {
            provisioningDomain = new Property();
            provisioningDomain.setName("sf-prov-domainName");
            provisioningDomain.setValue(paramMap.get("sf-prov-domainName"));
        }
        if (paramMap.get("sf-unique-id") != null) {
            uniqueID = new Property();
            uniqueID.setName("UniqueID");
            uniqueID.setValue(paramMap.get("sf-unique-id"));
        }
        Property[] proProperties = new Property[]{userNameProp, passwordProp, clentIdProp, clientSecretProp, apiVersionProp, domainNameProp, tokenEndpointProp, provisioningPattern, provisioningSeparator, provisioningDomain, uniqueID};
        proConnector.setProvisioningProperties(proProperties);
        ProvisioningConnectorConfig[] proConnectors = fedIdp.getProvisioningConnectorConfigs();
        if (proConnector.getName() != null) {
            if (proConnectors == null || proConnectors.length == 0) {
                fedIdp.setProvisioningConnectorConfigs(new ProvisioningConnectorConfig[]{proConnector});
            } else {
                fedIdp.setProvisioningConnectorConfigs(IdPManagementUIUtil.concatArrays(new ProvisioningConnectorConfig[]{proConnector}, proConnectors));
            }
        }
    }

    private static void buildClaimConfiguration(IdentityProvider fedIdp, Map<String, String> paramMap, List<String> idpClaims, ClaimMapping[] currentClaimMapping) throws IdentityApplicationManagementException {
        ClaimConfig claimConfiguration = new ClaimConfig();
        if (idpClaims != null && idpClaims.size() > 0) {
            ArrayList<Claim> idPClaimList = new ArrayList<Claim>();
            for (String claimUri : idpClaims) {
                Claim idpClaim = new Claim();
                idpClaim.setClaimUri(claimUri);
                idPClaimList.add(idpClaim);
            }
            claimConfiguration.setIdpClaims(idPClaimList.toArray(new Claim[idPClaimList.size()]));
        }
        claimConfiguration.setUserClaimURI(paramMap.get("user_id_claim_dropdown"));
        claimConfiguration.setRoleClaimURI(paramMap.get("role_claim_dropdown"));
        ClaimConfig claimConfigurationUpdated = IdPManagementUIUtil.claimMappingFromUI(claimConfiguration, paramMap);
        fedIdp.setClaimConfig(claimConfigurationUpdated);
    }

    private static ClaimConfig claimMappingFromUI(ClaimConfig claimConfiguration, Map<String, String> paramMap) {
        int i;
        HashSet<ClaimMapping> claimMappingList = new HashSet<ClaimMapping>();
        HashMap<String, String> advancedMapping = new HashMap<String, String>();
        int mappedClaimCount = 0;
        int advancedClaimCount = 0;
        if (paramMap.get("advanced_claim_id_count") != null) {
            advancedClaimCount = Integer.parseInt(paramMap.get("advanced_claim_id_count"));
        }
        for (i = 0; i < advancedClaimCount; ++i) {
            if (paramMap.get("advancnedIdpClaim_" + i) == null) continue;
            if (paramMap.get("advancedDefault_" + i) != null) {
                advancedMapping.put(paramMap.get("advancnedIdpClaim_" + i), paramMap.get("advancedDefault_" + i));
                continue;
            }
            advancedMapping.put(paramMap.get("advancnedIdpClaim_" + i), "");
        }
        if (paramMap.get("claimrow_name_count") != null) {
            mappedClaimCount = Integer.parseInt(paramMap.get("claimrow_name_count"));
        }
        if ("choose_dialet_type1".equals(paramMap.get("choose_dialet_type_group"))) {
            claimConfiguration.setLocalClaimDialect(true);
            for (i = 0; i < advancedClaimCount; ++i) {
                String idPClaimURI = paramMap.get("advancnedIdpClaim_" + i);
                String defaultValue = paramMap.get("advancedDefault_" + i);
                ClaimMapping mapping = new ClaimMapping();
                Claim providerClaim = new Claim();
                providerClaim.setClaimUri(idPClaimURI);
                Claim localClaim = new Claim();
                localClaim.setClaimUri(idPClaimURI);
                mapping.setLocalClaim(localClaim);
                if (defaultValue != null) {
                    mapping.setDefaultValue(defaultValue);
                } else {
                    mapping.setDefaultValue("");
                }
                mapping.setRequested(true);
                claimMappingList.add(mapping);
            }
        } else if ("choose_dialet_type2".equals(paramMap.get("choose_dialet_type_group"))) {
            claimConfiguration.setLocalClaimDialect(false);
            for (i = 0; i < mappedClaimCount; ++i) {
                String idPClaimURI = paramMap.get("claimrowname_" + i);
                if (idPClaimURI == null) continue;
                String localClaimURI = paramMap.get("claimrow_name_wso2_" + i);
                ClaimMapping mapping = new ClaimMapping();
                Claim providerClaim = new Claim();
                providerClaim.setClaimUri(idPClaimURI);
                Claim localClaim = new Claim();
                localClaim.setClaimUri(localClaimURI);
                mapping.setRemoteClaim(providerClaim);
                mapping.setLocalClaim(localClaim);
                if (advancedMapping.get(idPClaimURI) != null) {
                    if (StringUtils.isNotEmpty((String)((String)advancedMapping.get(idPClaimURI)))) {
                        mapping.setDefaultValue((String)advancedMapping.get(idPClaimURI));
                    }
                    mapping.setRequested(true);
                }
                claimMappingList.add(mapping);
            }
        }
        claimConfiguration.setClaimMappings(claimMappingList.toArray(new ClaimMapping[claimMappingList.size()]));
        return claimConfiguration;
    }

    private static void claimMappingFromFile(ClaimConfig claimConfiguration, String claimMappingFromFile) {
        String[] claimMappings = claimMappingFromFile.replaceAll("\\s", "").split(",");
        if (claimMappings != null && claimMappings.length > 0) {
            HashSet<ClaimMapping> claimMappingList = new HashSet<ClaimMapping>();
            for (int i = 0; i < claimMappings.length; ++i) {
                String[] splitClaimMapping;
                String claimMappingString = claimMappings[i];
                if (claimMappingString == null || (splitClaimMapping = claimMappingString.split("-")) == null || splitClaimMapping.length != 2) continue;
                String idPClaimURI = splitClaimMapping[0];
                String localClaimURI = splitClaimMapping[1];
                ClaimMapping mapping = new ClaimMapping();
                Claim providerClaim = new Claim();
                providerClaim.setClaimUri(idPClaimURI);
                Claim localClaim = new Claim();
                localClaim.setClaimUri(localClaimURI);
                mapping.setRemoteClaim(providerClaim);
                mapping.setLocalClaim(localClaim);
                claimMappingList.add(mapping);
            }
            claimConfiguration.setClaimMappings(claimMappingList.toArray(new ClaimMapping[claimMappingList.size()]));
        }
    }

    private static void buildBasicInformation(IdentityProvider fedIdp, Map<String, String> paramMap) {
        String idpIssuerName;
        String deletedCertificateValue;
        String oldCertFile = null;
        String certFile = null;
        String deletePublicCert = null;
        fedIdp.setIdentityProviderName(paramMap.get("idPName"));
        fedIdp.setDisplayName(paramMap.get("idpDisplayName"));
        if (paramMap.get("enable") != null && "1".equals(paramMap.get("enable"))) {
            fedIdp.setEnable(true);
        } else {
            fedIdp.setEnable(false);
        }
        fedIdp.setIdentityProviderDescription(paramMap.get("idPDescription"));
        if ("on".equals(paramMap.get("federation_hub_idp"))) {
            fedIdp.setFederationHub(true);
        } else {
            fedIdp.setFederationHub(false);
        }
        fedIdp.setHomeRealmId(paramMap.get("realmId"));
        fedIdp.setAlias(paramMap.get("tokenEndpointAlias"));
        if (paramMap.get("oldCertFile") != null) {
            oldCertFile = paramMap.get("oldCertFile");
        }
        if (paramMap.get("certFile") != null) {
            certFile = paramMap.get("certFile");
        }
        if (paramMap.get("deletePublicCert") != null) {
            deletePublicCert = paramMap.get("deletePublicCert");
        }
        if (oldCertFile != null && certFile == null && !Boolean.parseBoolean(deletePublicCert)) {
            certFile = oldCertFile;
        } else if (StringUtils.isNotBlank((String)oldCertFile) && StringUtils.isNotBlank((String)certFile) && !Boolean.parseBoolean(deletePublicCert)) {
            certFile = IdPManagementUIUtil.handleCertificateAddition(oldCertFile, certFile);
        } else if (oldCertFile != null && certFile == null && Boolean.parseBoolean(deletePublicCert)) {
            deletedCertificateValue = paramMap.get("certificateVal");
            certFile = IdPManagementUIUtil.handleCertificateDeletion(oldCertFile, deletedCertificateValue);
        } else if (oldCertFile != null && certFile != null && Boolean.parseBoolean(deletePublicCert)) {
            deletedCertificateValue = paramMap.get("certificateVal");
            oldCertFile = IdPManagementUIUtil.handleCertificateDeletion(oldCertFile, deletedCertificateValue);
            certFile = IdPManagementUIUtil.handleCertificateAddition(oldCertFile, certFile);
        }
        fedIdp.setCertificate(certFile);
        String jwksUri = paramMap.get(JWKS_URI);
        if (StringUtils.isNotBlank((String)jwksUri)) {
            IdentityProviderProperty jwksProperty = new IdentityProviderProperty();
            jwksProperty.setName(JWKS_URI);
            jwksProperty.setValue(jwksUri);
            jwksProperty.setDisplayName("Identity Provider's JWKS Endpoint");
            fedIdp.addIdpProperties(jwksProperty);
        }
        if (StringUtils.isNotBlank((String)(idpIssuerName = paramMap.get("idpIssuerName")))) {
            IdentityProviderProperty idpIssuerNameProperty = new IdentityProviderProperty();
            idpIssuerNameProperty.setName("idpIssuerName");
            idpIssuerNameProperty.setValue(idpIssuerName);
            fedIdp.addIdpProperties(idpIssuerNameProperty);
        }
    }

    private static String handleCertificateDeletion(String oldCertificateValues, String deletedCertificateValues) {
        String decodedOldCertificate = new String(Base64.decode((String)oldCertificateValues), StandardCharsets.UTF_8);
        String decodedDeletedCertificate = new String(Base64.decode((String)deletedCertificateValues), StandardCharsets.UTF_8);
        LinkedHashSet<String> updatedCertificateSet = new LinkedHashSet<String>(IdPManagementUIUtil.getExtractedCertificateValues(decodedOldCertificate));
        updatedCertificateSet.removeAll(IdPManagementUIUtil.getExtractedCertificateValues(decodedDeletedCertificate));
        return Base64.encode((byte[])String.join((CharSequence)"", updatedCertificateSet).getBytes(StandardCharsets.UTF_8));
    }

    private static String handleCertificateAddition(String oldCertValues, String newCertValues) {
        String decodedOldCertificate = new String(Base64.decode((String)oldCertValues), StandardCharsets.UTF_8);
        String decodedNewCertificate = new String(Base64.decode((String)newCertValues), StandardCharsets.UTF_8);
        LinkedHashSet<String> updatedCertificateSet = new LinkedHashSet<String>(IdPManagementUIUtil.getExtractedCertificateValues(decodedOldCertificate));
        updatedCertificateSet.addAll(IdPManagementUIUtil.getExtractedCertificateValues(decodedNewCertificate));
        return Base64.encode((byte[])String.join((CharSequence)"", updatedCertificateSet).getBytes(StandardCharsets.UTF_8));
    }

    private static List<String> getExtractedCertificateValues(String decodedCertificate) {
        int numOfCertificates = StringUtils.countMatches((String)decodedCertificate, (String)"-----BEGIN CERTIFICATE-----");
        ArrayList<String> extractedCertificateValues = new ArrayList<String>();
        for (int i = 1; i <= numOfCertificates; ++i) {
            extractedCertificateValues.add(IdentityApplicationManagementUtil.extractCertificate((String)decodedCertificate, (int)i));
        }
        return extractedCertificateValues;
    }

    private static void buildOutboundAuthenticationConfiguration(IdentityProvider fedIdp, Map<String, String> paramMap) throws IdentityApplicationManagementException {
        IdPManagementUIUtil.buildOpenIDAuthenticationConfiguration(fedIdp, paramMap);
        IdPManagementUIUtil.buildFacebookAuthenticationConfiguration(fedIdp, paramMap);
        IdPManagementUIUtil.buildOpenIDConnectAuthenticationConfiguration(fedIdp, paramMap);
        IdPManagementUIUtil.buildSAMLAuthenticationConfiguration(fedIdp, paramMap);
        IdPManagementUIUtil.buildPassiveSTSAuthenticationConfiguration(fedIdp, paramMap);
    }

    private static void buildOpenIDAuthenticationConfiguration(IdentityProvider fedIdp, Map<String, String> paramMap) throws IdentityApplicationManagementException {
        FederatedAuthenticatorConfig openIdAuthnConfig = new FederatedAuthenticatorConfig();
        openIdAuthnConfig.setName("OpenIDAuthenticator");
        openIdAuthnConfig.setDisplayName("openid");
        if ("on".equals(paramMap.get("openIdEnabled"))) {
            openIdAuthnConfig.setEnabled(true);
        }
        if ("on".equals(paramMap.get("openIdDefault"))) {
            fedIdp.setDefaultAuthenticatorConfig(openIdAuthnConfig);
        }
        Property[] properties = new Property[4];
        Property property = new Property();
        property.setName("OpenIdUrl");
        property.setValue(paramMap.get("openIdUrl"));
        properties[0] = property;
        property = new Property();
        property.setName("RealmId");
        property.setValue(paramMap.get("realmId"));
        properties[1] = property;
        property = new Property();
        property.setName("IsUserIdInClaims");
        if ("1".equals(paramMap.get("open_id_user_id_location"))) {
            property.setValue("true");
        } else {
            property.setValue("false");
        }
        properties[2] = property;
        property = new Property();
        property.setName("commonAuthQueryParams");
        if (paramMap.get("openidQueryParam") != null && paramMap.get("openidQueryParam").trim().length() > 0) {
            property.setValue(paramMap.get("openidQueryParam"));
        }
        properties[3] = property;
        openIdAuthnConfig.setProperties(properties);
        FederatedAuthenticatorConfig[] authenticators = fedIdp.getFederatedAuthenticatorConfigs();
        if (paramMap.get("openIdUrl") != null && !"".equals(paramMap.get("openIdUrl"))) {
            if (authenticators == null || authenticators.length == 0) {
                fedIdp.setFederatedAuthenticatorConfigs(new FederatedAuthenticatorConfig[]{openIdAuthnConfig});
            } else {
                fedIdp.setFederatedAuthenticatorConfigs(IdPManagementUIUtil.concatArrays(new FederatedAuthenticatorConfig[]{openIdAuthnConfig}, authenticators));
            }
        }
    }

    private static void buildFacebookAuthenticationConfiguration(IdentityProvider fedIdp, Map<String, String> paramMap) throws IdentityApplicationManagementException {
        FederatedAuthenticatorConfig facebookAuthnConfig = new FederatedAuthenticatorConfig();
        facebookAuthnConfig.setName("FacebookAuthenticator");
        facebookAuthnConfig.setDisplayName("facebook");
        if ("on".equals(paramMap.get("fbAuthEnabled"))) {
            facebookAuthnConfig.setEnabled(true);
        }
        if ("on".equals(paramMap.get("fbAuthDefault"))) {
            fedIdp.setDefaultAuthenticatorConfig(facebookAuthnConfig);
        }
        Property[] properties = new Property[8];
        Property property = new Property();
        property.setName("ClientId");
        property.setValue(paramMap.get("fbClientId"));
        properties[0] = property;
        property = new Property();
        property.setName("ClientSecret");
        property.setValue(paramMap.get("fbClientSecret"));
        property.setConfidential(true);
        properties[1] = property;
        property = new Property();
        property.setName("Scope");
        property.setValue(paramMap.get("fbScope"));
        properties[2] = property;
        property = new Property();
        property.setName("UserInfoFields");
        String fbUserInfoFields = paramMap.get("fbUserInfoFields");
        if (fbUserInfoFields != null && fbUserInfoFields.endsWith(",")) {
            fbUserInfoFields = fbUserInfoFields.substring(0, fbUserInfoFields.length() - 1);
        }
        property.setValue(fbUserInfoFields);
        properties[3] = property;
        property = new Property();
        property.setName("AuthnEndpoint");
        property.setValue(paramMap.get("fbAuthnEndpoint"));
        properties[4] = property;
        property = new Property();
        property.setName("AuthTokenEndpoint");
        property.setValue(paramMap.get("fbOauth2TokenEndpoint"));
        properties[5] = property;
        property = new Property();
        property.setName("UserInfoEndpoint");
        property.setValue(paramMap.get("fbUserInfoEndpoint"));
        properties[6] = property;
        property = new Property();
        property.setName("callBackUrl");
        property.setValue(paramMap.get("fbCallBackUrl"));
        properties[7] = property;
        facebookAuthnConfig.setProperties(properties);
        FederatedAuthenticatorConfig[] authenticators = fedIdp.getFederatedAuthenticatorConfigs();
        if (paramMap.get("fbClientId") != null && !"".equals(paramMap.get("fbClientId")) && paramMap.get("fbClientSecret") != null && !"".equals(paramMap.get("fbClientSecret"))) {
            if (authenticators == null || authenticators.length == 0) {
                fedIdp.setFederatedAuthenticatorConfigs(new FederatedAuthenticatorConfig[]{facebookAuthnConfig});
            } else {
                fedIdp.setFederatedAuthenticatorConfigs(IdPManagementUIUtil.concatArrays(new FederatedAuthenticatorConfig[]{facebookAuthnConfig}, authenticators));
            }
        }
    }

    private static void buildOpenIDConnectAuthenticationConfiguration(IdentityProvider fedIdp, Map<String, String> paramMap) throws IdentityApplicationManagementException {
        FederatedAuthenticatorConfig oidcAuthnConfig = new FederatedAuthenticatorConfig();
        oidcAuthnConfig.setName("OpenIDConnectAuthenticator");
        oidcAuthnConfig.setDisplayName("openidconnect");
        if ("on".equals(paramMap.get("oidcEnabled"))) {
            oidcAuthnConfig.setEnabled(true);
        }
        if ("on".equals(paramMap.get("oidcDefault"))) {
            fedIdp.setDefaultAuthenticatorConfig(oidcAuthnConfig);
        }
        Property[] properties = new Property[10];
        Property property = new Property();
        property.setName("ClientId");
        property.setValue(paramMap.get("clientId"));
        properties[0] = property;
        property = new Property();
        property.setName("OAuth2AuthzEPUrl");
        property.setValue(paramMap.get("authzUrl"));
        properties[1] = property;
        property = new Property();
        property.setName("OAuth2TokenEPUrl");
        property.setValue(paramMap.get("tokenUrl"));
        properties[2] = property;
        property = new Property();
        property.setName("ClientSecret");
        property.setValue(paramMap.get("clientSecret"));
        property.setConfidential(true);
        properties[3] = property;
        property = new Property();
        property.setName("IsUserIdInClaims");
        properties[4] = property;
        if ("1".equals(paramMap.get("oidc_user_id_location"))) {
            property.setValue("true");
        } else {
            property.setValue("false");
        }
        property = new Property();
        property.setName("commonAuthQueryParams");
        if (paramMap.get("oidcQueryParam") != null && paramMap.get("oidcQueryParam").trim().length() > 0) {
            property.setValue(paramMap.get("oidcQueryParam"));
        }
        properties[5] = property;
        property = new Property();
        property.setName("callbackUrl");
        property.setValue(paramMap.get("callbackUrl"));
        properties[6] = property;
        property = new Property();
        property.setName("UserInfoUrl");
        property.setValue(paramMap.get("userInfoEndpoint"));
        properties[7] = property;
        property = new Property();
        property.setName("OIDCLogoutEPUrl");
        property.setValue(paramMap.get("logoutUrlOIDC"));
        properties[8] = property;
        property = new Property();
        property.setName("IsBasicAuthEnabled");
        if (paramMap.get("oidcBasicAuthEnabled") != null && "on".equals(paramMap.get("oidcBasicAuthEnabled"))) {
            property.setValue("true");
        } else {
            property.setValue("false");
        }
        properties[9] = property;
        oidcAuthnConfig.setProperties(properties);
        FederatedAuthenticatorConfig[] authenticators = fedIdp.getFederatedAuthenticatorConfigs();
        if (!(paramMap.get("authzUrl") == null || "".equals(paramMap.get("authzUrl")) || paramMap.get("tokenUrl") == null || "".equals(paramMap.get("tokenUrl")) || paramMap.get("clientId") == null || "".equals(paramMap.get("clientId")) || paramMap.get("clientSecret") == null || "".equals(paramMap.get("clientSecret")))) {
            if (authenticators == null || authenticators.length == 0) {
                fedIdp.setFederatedAuthenticatorConfigs(new FederatedAuthenticatorConfig[]{oidcAuthnConfig});
            } else {
                fedIdp.setFederatedAuthenticatorConfigs(IdPManagementUIUtil.concatArrays(new FederatedAuthenticatorConfig[]{oidcAuthnConfig}, authenticators));
            }
        }
    }

    private static void buildPassiveSTSAuthenticationConfiguration(IdentityProvider fedIdp, Map<String, String> paramMap) throws IdentityApplicationManagementException {
        FederatedAuthenticatorConfig passiveSTSAuthnConfig = new FederatedAuthenticatorConfig();
        passiveSTSAuthnConfig.setName("PassiveSTSAuthenticator");
        passiveSTSAuthnConfig.setDisplayName("passivests");
        if ("on".equals(paramMap.get("passiveSTSEnabled"))) {
            passiveSTSAuthnConfig.setEnabled(true);
        }
        if ("on".equals(paramMap.get("passiveSTSDefault"))) {
            fedIdp.setDefaultAuthenticatorConfig(passiveSTSAuthnConfig);
        }
        Property[] properties = new Property[6];
        Property property = new Property();
        property.setName("RealmId");
        property.setValue(paramMap.get("passiveSTSRealm"));
        properties[0] = property;
        property = new Property();
        property.setName("IdentityProviderUrl");
        property.setValue(paramMap.get("passiveSTSUrl"));
        properties[1] = property;
        property = new Property();
        property.setName("IsUserIdInClaims");
        properties[2] = property;
        if ("1".equals(paramMap.get("passive_sts_user_id_location"))) {
            property.setValue("true");
        } else {
            property.setValue("false");
        }
        property = new Property();
        property.setName("IsEnablePassiveSTSAssertionSignatureValidation");
        properties[3] = property;
        if ("on".equals(paramMap.get("isEnablePassiveSTSAssertionSignatureValidation"))) {
            property.setValue("true");
        } else {
            property.setValue("false");
        }
        property = new Property();
        property.setName("IsEnablePassiveSTSAssertionAudienceValidation");
        properties[4] = property;
        if ("on".equals(paramMap.get("isEnablePassiveSTSAssertionAudienceValidation"))) {
            property.setValue("true");
        } else {
            property.setValue("false");
        }
        property = new Property();
        property.setName("commonAuthQueryParams");
        if (paramMap.get("passiveSTSQueryParam") != null && paramMap.get("passiveSTSQueryParam").trim().length() > 0) {
            property.setValue(paramMap.get("passiveSTSQueryParam"));
        }
        properties[5] = property;
        passiveSTSAuthnConfig.setProperties(properties);
        FederatedAuthenticatorConfig[] authenticators = fedIdp.getFederatedAuthenticatorConfigs();
        if (paramMap.get("passiveSTSUrl") != null && !"".equals(paramMap.get("passiveSTSUrl"))) {
            if (authenticators == null || authenticators.length == 0) {
                fedIdp.setFederatedAuthenticatorConfigs(new FederatedAuthenticatorConfig[]{passiveSTSAuthnConfig});
            } else {
                fedIdp.setFederatedAuthenticatorConfigs(IdPManagementUIUtil.concatArrays(new FederatedAuthenticatorConfig[]{passiveSTSAuthnConfig}, authenticators));
            }
        }
    }

    private static void buildCustomProvisioningConfiguration(IdentityProvider fedIdp, List<String> proConnectorNames, Map<String, List<Property>> customProProperties, Map<String, String> paramMap) throws IdentityApplicationManagementException {
        if (CollectionUtils.isNotEmpty(proConnectorNames)) {
            ProvisioningConnectorConfig[] proConfigConnList = new ProvisioningConnectorConfig[proConnectorNames.size()];
            int j = 0;
            for (String conName : proConnectorNames) {
                List<Property> customProps;
                ProvisioningConnectorConfig customConfig = new ProvisioningConnectorConfig();
                customConfig.setName(conName);
                if ("on".equals(paramMap.get(conName + "_PEnabled"))) {
                    customConfig.setEnabled(true);
                }
                if ("on".equals(paramMap.get(conName + "_Default"))) {
                    fedIdp.setDefaultProvisioningConnectorConfig(customConfig);
                }
                if (CollectionUtils.isNotEmpty(customProps = customProProperties.get(conName))) {
                    customConfig.setProvisioningProperties(customProps.toArray(new Property[customProps.size()]));
                }
                proConfigConnList[j++] = customConfig;
            }
            ProvisioningConnectorConfig[] provConnectors = fedIdp.getProvisioningConnectorConfigs();
            if (provConnectors == null || provConnectors.length == 0) {
                fedIdp.setProvisioningConnectorConfigs(proConfigConnList);
            } else {
                fedIdp.setProvisioningConnectorConfigs(IdPManagementUIUtil.concatArrays(proConfigConnList, provConnectors));
            }
        }
    }

    private static void buildCustomAuthenticationConfiguration(IdentityProvider fedIdp, List<String> authenticatorNames, Map<String, List<Property>> customAuthenticatorProperties, Map<String, String> paramMap) throws IdentityApplicationManagementException {
        if (CollectionUtils.isNotEmpty(authenticatorNames)) {
            FederatedAuthenticatorConfig[] fedAuthConfigList = new FederatedAuthenticatorConfig[authenticatorNames.size()];
            int j = 0;
            for (String authName : authenticatorNames) {
                FederatedAuthenticatorConfig customConfig = new FederatedAuthenticatorConfig();
                customConfig.setName(authName);
                if ("on".equals(paramMap.get(authName + "_Enabled"))) {
                    customConfig.setEnabled(true);
                }
                if ("on".equals(paramMap.get(authName + "_Default"))) {
                    fedIdp.setDefaultAuthenticatorConfig(customConfig);
                }
                customConfig.setDisplayName(paramMap.get(authName + "_DisplayName"));
                List<Property> customProps = customAuthenticatorProperties.get(authName);
                if (CollectionUtils.isNotEmpty(customProps)) {
                    customConfig.setProperties(customProps.toArray(new Property[customProps.size()]));
                }
                fedAuthConfigList[j++] = customConfig;
            }
            FederatedAuthenticatorConfig[] authenticators = fedIdp.getFederatedAuthenticatorConfigs();
            if (authenticators == null || authenticators.length == 0) {
                fedIdp.setFederatedAuthenticatorConfigs(fedAuthConfigList);
            } else {
                fedIdp.setFederatedAuthenticatorConfigs(IdPManagementUIUtil.concatArrays(fedAuthConfigList, authenticators));
            }
        }
    }

    private static void buildSAMLAuthenticationConfiguration(IdentityProvider fedIdp, Map<String, String> paramMap) throws IdentityApplicationManagementException {
        FederatedAuthenticatorConfig saml2SSOAuthnConfig = new FederatedAuthenticatorConfig();
        saml2SSOAuthnConfig.setName("SAMLSSOAuthenticator");
        saml2SSOAuthnConfig.setDisplayName("samlsso");
        if ("on".equals(paramMap.get("saml2SSOEnabled"))) {
            saml2SSOAuthnConfig.setEnabled(true);
        }
        if ("on".equals(paramMap.get("saml2SSODefault"))) {
            fedIdp.setDefaultAuthenticatorConfig(saml2SSOAuthnConfig);
        }
        ArrayList<Property> properties = new ArrayList<Property>();
        if ("on".equals(paramMap.get("saml2SSOEnabled"))) {
            saml2SSOAuthnConfig.setEnabled(true);
        }
        if ("on".equals(paramMap.get("saml2SSODefault"))) {
            fedIdp.setDefaultAuthenticatorConfig(saml2SSOAuthnConfig);
        }
        Property property = new Property();
        property.setName("IdPEntityId");
        property.setValue(paramMap.get("idPEntityId"));
        properties.add(property);
        property = new Property();
        property.setName("SPEntityId");
        property.setValue(paramMap.get("spEntityId"));
        properties.add(property);
        property = new Property();
        property.setName("SSOUrl");
        property.setValue(paramMap.get("ssoUrl"));
        properties.add(property);
        property = new Property();
        property.setName("ACSUrl");
        property.setValue(paramMap.get("acsUrl"));
        properties.add(property);
        property = new Property();
        property.setName("ISAuthnReqSigned");
        if ("on".equals(paramMap.get("authnRequestSigned"))) {
            property.setValue("true");
        } else {
            property.setValue("false");
        }
        properties.add(property);
        property = new Property();
        property.setName("IsLogoutEnabled");
        if ("on".equals(paramMap.get("sloEnabled"))) {
            property.setValue("true");
        } else {
            property.setValue("false");
        }
        properties.add(property);
        property = new Property();
        property.setName("LogoutReqUrl");
        property.setValue(paramMap.get("logoutUrl"));
        properties.add(property);
        property = new Property();
        property.setName("IsSLORequestAccepted");
        if ("on".equals(paramMap.get("sloRequestAccepted"))) {
            property.setValue("true");
        } else {
            property.setValue("false");
        }
        properties.add(property);
        property = new Property();
        property.setName("IsLogoutReqSigned");
        if ("on".equals(paramMap.get("logoutRequestSigned"))) {
            property.setValue("true");
        } else {
            property.setValue("false");
        }
        properties.add(property);
        property = new Property();
        property.setName("IsAuthnRespSigned");
        if ("on".equals(paramMap.get("authnResponseSigned"))) {
            property.setValue("true");
        } else {
            property.setValue("false");
        }
        properties.add(property);
        property = new Property();
        property.setName("IsUserIdInClaims");
        if ("1".equals(paramMap.get("saml2_sso_user_id_location"))) {
            property.setValue("true");
        } else {
            property.setValue("false");
        }
        properties.add(property);
        property = new Property();
        property.setName("IsAssertionEncrypted");
        if ("on".equals(paramMap.get("IsEnableAssetionEncription"))) {
            property.setValue("true");
        } else {
            property.setValue("false");
        }
        properties.add(property);
        property = new Property();
        property.setName("isAssertionSigned");
        if ("on".equals(paramMap.get("isEnableAssertionSigning"))) {
            property.setValue("true");
        } else {
            property.setValue("false");
        }
        properties.add(property);
        property = new Property();
        property.setName("commonAuthQueryParams");
        if (paramMap.get("samlQueryParam") != null && paramMap.get("samlQueryParam").trim().length() > 0) {
            property.setValue(paramMap.get("samlQueryParam"));
        }
        properties.add(property);
        property = new Property();
        property.setName("RequestMethod");
        property.setValue(paramMap.get("RequestMethod"));
        properties.add(property);
        property = new Property();
        property.setName("SignatureAlgorithm");
        property.setValue(paramMap.get("SignatureAlgorithm"));
        properties.add(property);
        property = new Property();
        property.setName("DigestAlgorithm");
        property.setValue(paramMap.get("DigestAlgorithm"));
        properties.add(property);
        property = new Property();
        property.setName("AuthnContextComparisonLevel");
        property.setValue(paramMap.get("AuthnContextComparisonLevel"));
        properties.add(property);
        property = new Property();
        property.setName("IncludeNameIDPolicy");
        if ("on".equals(paramMap.get("IncludeNameIDPolicy"))) {
            property.setValue("true");
        } else {
            property.setValue("false");
        }
        properties.add(property);
        property = new Property();
        property.setName("ForceAuthentication");
        property.setValue(paramMap.get("ForceAuthentication"));
        properties.add(property);
        property = new Property();
        property.setName("SignatureAlgorithmPost");
        property.setValue(paramMap.get("SignatureAlgorithmPost"));
        properties.add(property);
        String authenticationContextClass = paramMap.get("AuthnContextClassRef");
        if ("Custom Authentication Context Class".equals(authenticationContextClass)) {
            authenticationContextClass = paramMap.get("CustomAuthnContextClassRef");
        }
        property = new Property();
        property.setName("AuthnContextClassRef");
        property.setValue(authenticationContextClass);
        properties.add(property);
        property = new Property();
        property.setName("AttributeConsumingServiceIndex");
        property.setValue(paramMap.get("AttributeConsumingServiceIndex"));
        properties.add(property);
        property = new Property();
        property.setName("IncludeCert");
        if ("on".equals(paramMap.get("IncludeCert"))) {
            property.setValue("true");
        } else {
            property.setValue("false");
        }
        properties.add(property);
        property = new Property();
        property.setName("IncludeAuthnContext");
        property.setValue(paramMap.get("IncludeAuthnContext"));
        properties.add(property);
        property = new Property();
        property.setName("IncludeProtocolBinding");
        if ("on".equals(paramMap.get("IncludeProtocolBinding"))) {
            property.setValue("true");
        } else {
            property.setValue("false");
        }
        properties.add(property);
        property = new Property();
        property.setName("ISArtifactBindingEnabled");
        if ("on".equals(paramMap.get("ISArtifactBindingEnabled"))) {
            property.setValue("true");
        } else {
            property.setValue("false");
        }
        properties.add(property);
        property = new Property();
        property.setName("ArtifactResolveUrl");
        property.setValue(paramMap.get("ArtifactResolveUrl"));
        properties.add(property);
        property = new Property();
        property.setName("ISArtifactResolveReqSigned");
        if ("on".equals(paramMap.get("ISArtifactResolveReqSigned"))) {
            property.setValue("true");
        } else {
            property.setValue("false");
        }
        properties.add(property);
        property = new Property();
        property.setName("ISArtifactResponseSigned");
        if ("on".equals(paramMap.get("ISArtifactResponseSigned"))) {
            property.setValue("true");
        } else {
            property.setValue("false");
        }
        properties.add(property);
        property = new Property();
        property.setName(META_DATA_SAML);
        if (paramMap.get(META_DATA_SAML) != null && paramMap.get(META_DATA_SAML).length() > 0) {
            property.setValue(paramMap.get(META_DATA_SAML));
        } else {
            property.setValue(null);
        }
        properties.add(property);
        property = new Property();
        property.setName("NameIDType");
        property.setValue(paramMap.get("NameIDType"));
        properties.add(property);
        property = new Property();
        property.setName("ResponseAuthnContextClassRef");
        property.setValue(paramMap.get("ResponseAuthnContextClassRef"));
        properties.add(property);
        saml2SSOAuthnConfig.setProperties(properties.toArray(new Property[properties.size()]));
        FederatedAuthenticatorConfig[] authenticators = fedIdp.getFederatedAuthenticatorConfigs();
        if (paramMap.get(META_DATA_SAML) != null && paramMap.get(META_DATA_SAML).length() > 0) {
            if (authenticators == null || authenticators.length == 0) {
                fedIdp.setFederatedAuthenticatorConfigs(new FederatedAuthenticatorConfig[]{saml2SSOAuthnConfig});
            } else {
                fedIdp.setFederatedAuthenticatorConfigs(IdPManagementUIUtil.concatArrays(new FederatedAuthenticatorConfig[]{saml2SSOAuthnConfig}, authenticators));
            }
        } else if (paramMap.get("ssoUrl") != null && !"".equals(paramMap.get("ssoUrl")) && paramMap.get("idPEntityId") != null && !"".equals(paramMap.get("idPEntityId"))) {
            if (authenticators == null || authenticators.length == 0) {
                fedIdp.setFederatedAuthenticatorConfigs(new FederatedAuthenticatorConfig[]{saml2SSOAuthnConfig});
            } else {
                fedIdp.setFederatedAuthenticatorConfigs(IdPManagementUIUtil.concatArrays(new FederatedAuthenticatorConfig[]{saml2SSOAuthnConfig}, authenticators));
            }
        }
    }

    private static void buildRoleConfiguration(IdentityProvider fedIdp, Map<String, String> paramMap, List<String> idpRoles, RoleMapping[] currentRoleMapping) throws IdentityApplicationManagementException {
        PermissionsAndRoleConfig roleConfiguration = new PermissionsAndRoleConfig();
        roleConfiguration.setIdpRoles(idpRoles.toArray(new String[idpRoles.size()]));
        HashSet<RoleMapping> roleMappingList = new HashSet<RoleMapping>();
        String idpProvisioningRole = paramMap.get("idpProvisioningRole");
        fedIdp.setProvisioningRole(idpProvisioningRole);
        int attributesCount = 0;
        if (paramMap.get("rolemappingrow_name_count") != null) {
            attributesCount = Integer.parseInt(paramMap.get("rolemappingrow_name_count"));
        }
        for (int i = 0; i < attributesCount; ++i) {
            String idPRoleName = paramMap.get("rolerowname_" + i);
            String localRoleString = paramMap.get("localrowname_" + i);
            if (idPRoleName == null || localRoleString == null) continue;
            String[] splitLocalRole = localRoleString.split("/");
            String userStoreId = null;
            String localRoleName = null;
            LocalRole localRole = null;
            if (splitLocalRole != null && splitLocalRole.length == 2) {
                userStoreId = splitLocalRole[0];
                localRoleName = splitLocalRole[1];
                localRole = new LocalRole();
                localRole.setUserStoreId(userStoreId);
                localRole.setLocalRoleName(localRoleName);
            } else {
                localRoleName = localRoleString;
                localRole = new LocalRole();
                localRole.setLocalRoleName(localRoleName);
            }
            RoleMapping roleMapping = new RoleMapping();
            roleMapping.setLocalRole(localRole);
            roleMapping.setRemoteRole(idPRoleName);
            roleMappingList.add(roleMapping);
        }
        roleConfiguration.setRoleMappings(roleMappingList.toArray(new RoleMapping[roleMappingList.size()]));
        fedIdp.setPermissionAndRoleConfig(roleConfiguration);
    }

    private static void buildInboundProvisioningConfiguration(IdentityProvider fedIdp, Map<String, String> paramMap) throws IdentityApplicationManagementException {
        String modifyUserNamePassword = "prompt_username_password_consent";
        String modifyPassword = "prompt_password_consent";
        String doNotPrompt = "do_not_prompt";
        String jitTypeGroup = "choose_jit_type_group";
        String provisioning = paramMap.get("provisioning");
        JustInTimeProvisioningConfig jitProvisioningConfiguration = new JustInTimeProvisioningConfig();
        if ("provision_disabled".equals(provisioning)) {
            jitProvisioningConfiguration.setProvisioningEnabled(false);
            jitProvisioningConfiguration.setPasswordProvisioningEnabled(false);
            jitProvisioningConfiguration.setModifyUserNameAllowed(false);
            jitProvisioningConfiguration.setPromptConsent(false);
        } else if ("provision_static".equals(provisioning) || "provision_dynamic".equals(provisioning)) {
            jitProvisioningConfiguration.setProvisioningEnabled(true);
            if (modifyUserNamePassword.equals(paramMap.get(jitTypeGroup))) {
                jitProvisioningConfiguration.setPasswordProvisioningEnabled(true);
                jitProvisioningConfiguration.setModifyUserNameAllowed(true);
                jitProvisioningConfiguration.setPromptConsent(true);
            } else if (modifyPassword.equals(paramMap.get(jitTypeGroup))) {
                jitProvisioningConfiguration.setPasswordProvisioningEnabled(true);
                jitProvisioningConfiguration.setModifyUserNameAllowed(false);
                jitProvisioningConfiguration.setPromptConsent(true);
            } else {
                jitProvisioningConfiguration.setPasswordProvisioningEnabled(false);
                jitProvisioningConfiguration.setModifyUserNameAllowed(false);
                if (doNotPrompt.equals(paramMap.get(jitTypeGroup))) {
                    jitProvisioningConfiguration.setPromptConsent(false);
                } else {
                    jitProvisioningConfiguration.setPromptConsent(true);
                }
            }
        }
        jitProvisioningConfiguration.setProvisioningUserStore(paramMap.get("provision_static_dropdown"));
        if (paramMap.get("provision_dynamic_dropdown") != null && !"--- Select Claim URI ---".equals(paramMap.get("provision_dynamic_dropdown"))) {
            jitProvisioningConfiguration.setProvisioningUserStore(paramMap.get("provision_dynamic_dropdown"));
        }
        fedIdp.setJustInTimeProvisioningConfig(jitProvisioningConfiguration);
    }

    private static ProvisioningConnectorConfig[] concatArrays(ProvisioningConnectorConfig[] o1, ProvisioningConnectorConfig[] o2) {
        ProvisioningConnectorConfig[] ret = new ProvisioningConnectorConfig[o1.length + o2.length];
        System.arraycopy(o1, 0, ret, 0, o1.length);
        System.arraycopy(o2, 0, ret, o1.length, o2.length);
        return ret;
    }

    private static FederatedAuthenticatorConfig[] concatArrays(FederatedAuthenticatorConfig[] o1, FederatedAuthenticatorConfig[] o2) {
        FederatedAuthenticatorConfig[] ret = new FederatedAuthenticatorConfig[o1.length + o2.length];
        System.arraycopy(o1, 0, ret, 0, o1.length);
        System.arraycopy(o2, 0, ret, o1.length, o2.length);
        return ret;
    }

    public static FederatedAuthenticatorConfig getFederatedAuthenticator(FederatedAuthenticatorConfig[] federatedAuthenticators, String authenticatorName) {
        for (FederatedAuthenticatorConfig authenticator : federatedAuthenticators) {
            if (!authenticator.getName().equals(authenticatorName)) continue;
            return authenticator;
        }
        return null;
    }

    public static Property getProperty(Property[] properties, String propertyName) {
        for (Property property : properties) {
            if (!property.getName().equals(propertyName)) continue;
            return property;
        }
        return null;
    }

    public static List<Property> getPropertySetStartsWith(Property[] properties, String startWith) {
        ArrayList<Property> propertySet = new ArrayList<Property>();
        for (Property property : properties) {
            if (!property.getName().startsWith(startWith)) continue;
            propertySet.add(property);
        }
        return propertySet;
    }
}

