/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.idp.mgt.ui.client;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.common.model.idp.xsd.FederatedAuthenticatorConfig;
import org.wso2.carbon.identity.application.common.model.idp.xsd.IdentityProvider;
import org.wso2.carbon.identity.application.common.model.idp.xsd.ProvisioningConnectorConfig;
import org.wso2.carbon.idp.mgt.stub.IdentityProviderMgtServiceIdentityProviderManagementExceptionException;
import org.wso2.carbon.idp.mgt.stub.IdentityProviderMgtServiceStub;
import org.wso2.carbon.idp.mgt.ui.util.IdentityException;
import org.wso2.carbon.user.mgt.stub.UserAdminStub;
import org.wso2.carbon.user.mgt.stub.types.carbon.UserStoreInfo;

public class IdentityProviderMgtServiceClient {
    private static final Log log = LogFactory.getLog(IdentityProviderMgtServiceClient.class);
    private IdentityProviderMgtServiceStub idPMgtStub;
    private UserAdminStub userAdminStub;

    public IdentityProviderMgtServiceClient(String cookie, String backendServerURL, ConfigurationContext configCtx) {
        String idPMgtServiceURL = backendServerURL + "IdentityProviderMgtService";
        String userAdminServiceURL = backendServerURL + "UserAdmin";
        try {
            this.idPMgtStub = new IdentityProviderMgtServiceStub(configCtx, idPMgtServiceURL);
        }
        catch (AxisFault axisFault) {
            log.error((Object)"Error while instantiating IdentityProviderMgtServiceStub", (Throwable)axisFault);
        }
        try {
            this.userAdminStub = new UserAdminStub(configCtx, userAdminServiceURL);
        }
        catch (AxisFault axisFault) {
            log.error((Object)"Error while instantiating UserAdminServiceStub", (Throwable)axisFault);
        }
        ServiceClient idPMgtClient = this.idPMgtStub._getServiceClient();
        ServiceClient userAdminClient = this.userAdminStub._getServiceClient();
        Options idPMgtOptions = idPMgtClient.getOptions();
        idPMgtOptions.setManageSession(true);
        idPMgtOptions.setProperty("Cookie", (Object)cookie);
        Options userAdminOptions = userAdminClient.getOptions();
        userAdminOptions.setManageSession(true);
        userAdminOptions.setProperty("Cookie", (Object)cookie);
    }

    public IdentityProvider getResidentIdP() throws Exception {
        try {
            return this.idPMgtStub.getResidentIdP();
        }
        catch (Exception e) {
            log.error((Object)"Error in retrieving list of Identity Providers ", (Throwable)e);
            throw new Exception("Error occurred while retrieving list of Identity Providers");
        }
    }

    public void updateResidentIdP(IdentityProvider identityProvider) throws Exception {
        try {
            this.idPMgtStub.updateResidentIdP(identityProvider);
        }
        catch (Exception e) {
            log.error((Object)"Error in retrieving the list of Resident Identity Providers", (Throwable)e);
            throw new Exception("Error occurred while retrieving list of Identity Providers");
        }
    }

    public IdentityProvider[] getIdPs() throws IdentityException {
        try {
            return this.idPMgtStub.getAllIdPs();
        }
        catch (RemoteException | IdentityProviderMgtServiceIdentityProviderManagementExceptionException e) {
            String message = "Error in retrieving the list of Identity Providers for a given tenant ";
            log.error((Object)message, e);
            throw new IdentityException(message, e);
        }
    }

    public IdentityProvider[] getAllPaginatedIdpInfo(int pageNumber) throws IdentityException {
        try {
            return this.idPMgtStub.getAllPaginatedIdpInfo(pageNumber);
        }
        catch (RemoteException | IdentityProviderMgtServiceIdentityProviderManagementExceptionException e) {
            String message = "Error in retrieving the list of Identity Providers for a given tenant ";
            log.error((Object)message, e);
            throw new IdentityException(message, e);
        }
    }

    public IdentityProvider[] getPaginatedIdpInfo(int pageNumber, String filter) throws IdentityException {
        try {
            return this.idPMgtStub.getPaginatedIdpInfo(filter, pageNumber);
        }
        catch (RemoteException | IdentityProviderMgtServiceIdentityProviderManagementExceptionException e) {
            String message = "Error in retrieving the list of filtered Identity Providers for a given tenant ";
            log.error((Object)message, e);
            throw new IdentityException(message, e);
        }
    }

    public int getIdpCount() throws IdentityException {
        try {
            return this.idPMgtStub.getAllIdpCount();
        }
        catch (RemoteException | IdentityProviderMgtServiceIdentityProviderManagementExceptionException e) {
            String message = "Error in retrieving the count of Identity Providers for a given tenant ";
            log.error((Object)message, e);
            throw new IdentityException(message, e);
        }
    }

    public int getFilteredIdpCount(String filter) throws IdentityException {
        try {
            return this.idPMgtStub.getFilteredIdpCount(filter);
        }
        catch (RemoteException | IdentityProviderMgtServiceIdentityProviderManagementExceptionException e) {
            String message = "Error in retrieving the count of registered Identity Providers for a given tenant ";
            log.error((Object)message, e);
            throw new IdentityException(message, e);
        }
    }

    public List<IdentityProvider> getIdPsSearch(String filter) throws Exception {
        try {
            IdentityProvider[] identityProviders = this.idPMgtStub.getAllIdPsSearch(filter);
            if (identityProviders != null && identityProviders.length > 0) {
                return Arrays.asList(identityProviders);
            }
            return new ArrayList<IdentityProvider>();
        }
        catch (Exception e) {
            log.error((Object)"Error in retrieving the Identity Provider", (Throwable)e);
            throw new Exception("Error occurred while retrieving Identity Providers", e);
        }
    }

    public List<IdentityProvider> getEnabledIdPs() throws Exception {
        try {
            IdentityProvider[] identityProviders = this.idPMgtStub.getEnabledAllIdPs();
            if (identityProviders != null && identityProviders.length > 0) {
                return Arrays.asList(identityProviders);
            }
            return new ArrayList<IdentityProvider>();
        }
        catch (Exception e) {
            log.error((Object)"Error in retrieving the list of enabled registered Identity Providers for a given tenant", (Throwable)e);
            throw new Exception("Error occurred while retrieving list of Enabled Identity Providers", e);
        }
    }

    public IdentityProvider getIdPByName(String idPName) throws Exception {
        try {
            return this.idPMgtStub.getIdPByName(idPName);
        }
        catch (Exception e) {
            log.error((Object)"Error in retrieving the information about Identity provider for a given tenant", (Throwable)e);
            throw new Exception("Error occurred while retrieving information about " + idPName, e);
        }
    }

    public void addIdP(IdentityProvider identityProvider) throws Exception {
        try {
            this.idPMgtStub.addIdP(identityProvider);
        }
        catch (Exception e) {
            log.error((Object)"Error in adding a Identity Provider for a given tenant", (Throwable)e);
            throw new Exception(e.getMessage(), e);
        }
    }

    public void deleteIdP(String idPName) throws Exception {
        try {
            this.idPMgtStub.deleteIdP(idPName);
        }
        catch (Exception e) {
            log.error((Object)"Error in deleting the Identity Provider for a given tenant", (Throwable)e);
            throw new Exception("Error in deleting the Identity Provider", e);
        }
    }

    public void updateIdP(String oldIdPName, IdentityProvider identityProvider) throws Exception {
        try {
            this.idPMgtStub.updateIdP(oldIdPName, identityProvider);
        }
        catch (Exception e) {
            log.error((Object)"Error in updating the Identity Provider for a given tenant", (Throwable)e);
            throw new Exception(e.getMessage(), e);
        }
    }

    public Map<String, FederatedAuthenticatorConfig> getAllFederatedAuthenticators() throws Exception {
        HashMap<String, FederatedAuthenticatorConfig> configMap = new HashMap<String, FederatedAuthenticatorConfig>();
        try {
            FederatedAuthenticatorConfig[] fedAuthConfigs = this.idPMgtStub.getAllFederatedAuthenticators();
            if (fedAuthConfigs != null && fedAuthConfigs.length > 0) {
                for (FederatedAuthenticatorConfig config : fedAuthConfigs) {
                    configMap.put(config.getName(), config);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Error in retrieving Federated Authenticators", (Throwable)e);
            throw new Exception("Error occurred while retrieving all Federated Authenticators", e);
        }
        return configMap;
    }

    public Map<String, ProvisioningConnectorConfig> getCustomProvisioningConnectors() throws Exception {
        HashMap<String, ProvisioningConnectorConfig> provisioningConnectors = new HashMap<String, ProvisioningConnectorConfig>();
        try {
            ProvisioningConnectorConfig[] provisioningConnectorConfigs = this.idPMgtStub.getAllProvisioningConnectors();
            if (provisioningConnectorConfigs != null && provisioningConnectorConfigs.length > 0 && provisioningConnectorConfigs[0] != null) {
                for (ProvisioningConnectorConfig config : provisioningConnectorConfigs) {
                    if (StringUtils.equals((String)"scim", (String)config.getName()) || StringUtils.equals((String)"salesforce", (String)config.getName()) || StringUtils.equals((String)"googleapps", (String)config.getName())) continue;
                    provisioningConnectors.put(config.getName(), config);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Error in retrieving Provisioning Connector", (Throwable)e);
            throw new Exception("Error occurred while retrieving all Provisioning Connectors", e);
        }
        return provisioningConnectors;
    }

    public String[] getAllLocalClaimUris() throws Exception {
        try {
            return this.idPMgtStub.getAllLocalClaimUris();
        }
        catch (Exception e) {
            log.error((Object)"Error in retrieving localClaim Uris", (Throwable)e);
            throw new Exception("Error occurred while retrieving all local claim URIs", e);
        }
    }

    public String[] getUserStoreDomains() throws Exception {
        try {
            UserStoreInfo[] storesInfo;
            ArrayList<String> readWriteDomainNames = new ArrayList<String>();
            for (UserStoreInfo storeInfo : storesInfo = this.userAdminStub.getUserRealmInfo().getUserStoresInfo()) {
                if (storeInfo.getReadOnly()) continue;
                readWriteDomainNames.add(storeInfo.getDomainName());
            }
            return readWriteDomainNames.toArray(new String[readWriteDomainNames.size()]);
        }
        catch (Exception e) {
            log.error((Object)"Error in retrieving User Store Domain IDs", (Throwable)e);
            throw new Exception("Error occurred while retrieving Read-Write User Store Domain IDs for logged-in user's tenant realm", e);
        }
    }

    public String getResidentIDPMetadata() throws RemoteException, IdentityProviderMgtServiceIdentityProviderManagementExceptionException {
        return this.idPMgtStub.getResidentIDPMetadata();
    }
}

