/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.idp.mgt.ui.client;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.governance.stub.IdentityGovernanceAdminServiceIdentityGovernanceExceptionException;
import org.wso2.carbon.identity.governance.stub.IdentityGovernanceAdminServiceStub;
import org.wso2.carbon.identity.governance.stub.bean.ConnectorConfig;
import org.wso2.carbon.identity.governance.stub.bean.Property;

public class IdentityGovernanceAdminClient {
    protected IdentityGovernanceAdminServiceStub stub = null;
    public static final String IDENTITY_MGT_ADMIN_SERVICE_URL = "IdentityGovernanceAdminService";
    public static final String DEFAULT = "DEFAULT";
    protected static Log log = LogFactory.getLog(IdentityGovernanceAdminClient.class);

    public IdentityGovernanceAdminClient(String cookie, String backendServerURL, ConfigurationContext configContext) throws Exception {
        try {
            this.stub = new IdentityGovernanceAdminServiceStub(configContext, backendServerURL + IDENTITY_MGT_ADMIN_SERVICE_URL);
            ServiceClient client = this.stub._getServiceClient();
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)cookie);
        }
        catch (Exception e) {
            throw new Exception("Error occurred while creating TenantIdentityMgtClient Object", e);
        }
    }

    public Map<String, Map<String, List<ConnectorConfig>>> getConnectorList() throws RemoteException, IdentityGovernanceAdminServiceIdentityGovernanceExceptionException {
        ConnectorConfig[] configs = this.stub.getConnectorList();
        HashMap<String, Map<String, List<ConnectorConfig>>> catMap = new HashMap<String, Map<String, List<ConnectorConfig>>>();
        if (configs != null) {
            for (ConnectorConfig conf : configs) {
                List<ConnectorConfig> confList;
                Map subCatMap;
                String subCategoryName;
                String categoryName = StringUtils.isBlank((String)conf.getCategory()) ? DEFAULT : conf.getCategory();
                String string = subCategoryName = StringUtils.isBlank((String)conf.getSubCategory()) ? DEFAULT : conf.getSubCategory();
                if (catMap.containsKey(categoryName)) {
                    subCatMap = (Map)catMap.get(categoryName);
                    if (subCatMap.containsKey(subCategoryName)) {
                        confList = (List)subCatMap.get(subCategoryName);
                        confList.add(conf);
                        continue;
                    }
                    confList = new ArrayList();
                    confList.add(conf);
                    subCatMap.put(subCategoryName, confList);
                    continue;
                }
                subCatMap = new HashMap();
                catMap.put(categoryName, subCatMap);
                confList = new ArrayList();
                confList.add(conf);
                subCatMap.put(subCategoryName, confList);
            }
        }
        return catMap;
    }

    public void updateConfigurations(Property[] properties) throws RemoteException, IdentityGovernanceAdminServiceIdentityGovernanceExceptionException {
        this.stub.updateConfigurations(properties);
    }
}

