/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.idp.mgt.ui.client;

import java.rmi.RemoteException;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.common.model.xsd.DefaultAuthenticationSequence;
import org.wso2.carbon.identity.application.mgt.defaultsequence.stub.IdentityDefaultSeqManagementServiceDefaultAuthSeqMgtException;
import org.wso2.carbon.identity.application.mgt.defaultsequence.stub.IdentityDefaultSeqManagementServiceStub;

public class DefaultAuthenticationSeqMgtServiceClient {
    private IdentityDefaultSeqManagementServiceStub stub;
    private static final Log log = LogFactory.getLog(DefaultAuthenticationSeqMgtServiceClient.class);

    public DefaultAuthenticationSeqMgtServiceClient(String cookie, String backendServerURL, ConfigurationContext configCtx) throws Exception {
        String serviceURL = backendServerURL + "IdentityDefaultSeqManagementService";
        this.stub = new IdentityDefaultSeqManagementServiceStub(configCtx, serviceURL);
        ServiceClient client = this.stub._getServiceClient();
        Options option = client.getOptions();
        option.setManageSession(true);
        option.setProperty("Cookie", (Object)cookie);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Invoking service " + serviceURL));
        }
    }

    public void createDefaultAuthenticationSeq(DefaultAuthenticationSequence authenticationSequence) throws IdentityDefaultSeqManagementServiceDefaultAuthSeqMgtException {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Creating default authentication sequence.");
            }
            this.stub.createDefaultAuthenticationSeq(authenticationSequence);
        }
        catch (RemoteException e) {
            log.error((Object)"Error occurred when creating default authentication sequence.", (Throwable)e);
            throw new IdentityDefaultSeqManagementServiceDefaultAuthSeqMgtException("Server error occurred.");
        }
    }

    public DefaultAuthenticationSequence getDefaultAuthenticationSeq() throws IdentityDefaultSeqManagementServiceDefaultAuthSeqMgtException {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Retrieving default authentication sequence.");
            }
            return this.stub.getDefaultAuthenticationSeqInXML("default_sequence");
        }
        catch (RemoteException e) {
            log.error((Object)"Error occurred when retrieving default authentication sequence.", (Throwable)e);
            throw new IdentityDefaultSeqManagementServiceDefaultAuthSeqMgtException("Server error occurred.");
        }
    }

    public DefaultAuthenticationSequence getDefaultAuthenticationSeqInfo() throws IdentityDefaultSeqManagementServiceDefaultAuthSeqMgtException {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Retrieving default authentication sequence info.");
            }
            return this.stub.getDefaultAuthenticationSeqInfo("default_sequence");
        }
        catch (RemoteException e) {
            log.error((Object)"Error occurred when retrieving default authentication sequence info.", (Throwable)e);
            throw new IdentityDefaultSeqManagementServiceDefaultAuthSeqMgtException("Server error occurred.");
        }
    }

    public void deleteDefaultAuthenticationSeq() throws IdentityDefaultSeqManagementServiceDefaultAuthSeqMgtException {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Deleting default authentication sequence.");
            }
            this.stub.deleteDefaultAuthenticationSeq("default_sequence");
        }
        catch (RemoteException e) {
            log.error((Object)"Error occurred when deleting default authentication sequence.", (Throwable)e);
            throw new IdentityDefaultSeqManagementServiceDefaultAuthSeqMgtException("Server error occurred.");
        }
    }

    public void updateDefaultAuthenticationSeq(DefaultAuthenticationSequence sequence) throws IdentityDefaultSeqManagementServiceDefaultAuthSeqMgtException {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Updating default authentication sequence.");
            }
            this.stub.updateDefaultAuthenticationSeq("default_sequence", sequence);
        }
        catch (RemoteException e) {
            log.error((Object)"Error occurred when updating default authentication sequence.", (Throwable)e);
            throw new IdentityDefaultSeqManagementServiceDefaultAuthSeqMgtException("Server error occurred.");
        }
    }
}

