/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.privacy.forgetme.analytics.streams.instructions;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.privacy.forgetme.analytics.streams.beans.Streams;
import org.wso2.carbon.privacy.forgetme.analytics.streams.exceptions.AnalyticsStreamsProcessorException;
import org.wso2.carbon.privacy.forgetme.analytics.streams.instructions.AnalyticsStreamsInstruction;
import org.wso2.carbon.privacy.forgetme.api.runtime.Environment;
import org.wso2.carbon.privacy.forgetme.api.runtime.ForgetMeInstruction;
import org.wso2.carbon.privacy.forgetme.api.runtime.InstructionReader;
import org.wso2.carbon.privacy.forgetme.api.runtime.ModuleException;

public class AnalyticsStreamsInstructionReader
implements InstructionReader {
    private static final Logger log = LoggerFactory.getLogger(AnalyticsStreamsInstructionReader.class);

    private static boolean isJsonFile(File file) {
        int index = file.getName().lastIndexOf(46);
        return index > 0 && file.getName().substring(index + 1).equalsIgnoreCase("json");
    }

    public String getType() {
        return "analytics-streams";
    }

    public List<ForgetMeInstruction> read(Path contentDirectory, Properties properties, Environment environment) throws ModuleException {
        ArrayList<ForgetMeInstruction> instructions = new ArrayList<ForgetMeInstruction>();
        File dir = contentDirectory.toFile();
        File[] files = dir.listFiles(file -> file.isFile() && AnalyticsStreamsInstructionReader.isJsonFile(file));
        if (files == null) {
            throw new AnalyticsStreamsProcessorException("No stream definition files found.");
        }
        List<Streams.Stream> streams = this.loadStreamDefinitions(files);
        instructions.add(new AnalyticsStreamsInstruction(environment, streams));
        return instructions;
    }

    private List<Streams.Stream> loadStreamDefinitions(File[] streamFiles) {
        ArrayList<Streams.Stream> streams = new ArrayList<Streams.Stream>();
        for (File streamFile : streamFiles) {
            try {
                Streams streamCollection = this.readStreamDefinitionFile(streamFile);
                streams.addAll(streamCollection.getStreams());
            }
            catch (AnalyticsStreamsProcessorException e) {
                log.error("Error in parsing the stream definition. Ignoring and passing to next file...", (Throwable)((Object)e));
            }
        }
        return streams;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Streams readStreamDefinitionFile(File streamFile) throws AnalyticsStreamsProcessorException {
        try (FileReader fileReader = new FileReader(streamFile);){
            Streams streams = (Streams)new Gson().fromJson((Reader)fileReader, Streams.class);
            return streams;
        }
        catch (IOException e) {
            throw new AnalyticsStreamsProcessorException("Error in reading stream definition: " + streamFile.getName(), e);
        }
        catch (JsonParseException e) {
            throw new AnalyticsStreamsProcessorException("Invalid stream definition:" + streamFile.getName(), e);
        }
    }
}

