/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.privacy.forgetme.analytics.streams.instructions;

import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.analytics.dataservice.commons.AnalyticsDataResponse;
import org.wso2.carbon.analytics.dataservice.core.AnalyticsDataService;
import org.wso2.carbon.analytics.dataservice.core.AnalyticsServiceHolder;
import org.wso2.carbon.analytics.dataservice.core.clustering.AnalyticsClusterManager;
import org.wso2.carbon.analytics.dataservice.core.clustering.AnalyticsClusterManagerImpl;
import org.wso2.carbon.analytics.datasource.commons.AnalyticsIterator;
import org.wso2.carbon.analytics.datasource.commons.Record;
import org.wso2.carbon.analytics.datasource.commons.exception.AnalyticsException;
import org.wso2.carbon.privacy.forgetme.analytics.streams.beans.Streams;
import org.wso2.carbon.privacy.forgetme.analytics.streams.exceptions.AnalyticsStreamsProcessorException;
import org.wso2.carbon.privacy.forgetme.api.report.ReportAppender;
import org.wso2.carbon.privacy.forgetme.api.runtime.Environment;
import org.wso2.carbon.privacy.forgetme.api.runtime.ForgetMeInstruction;
import org.wso2.carbon.privacy.forgetme.api.runtime.ForgetMeResult;
import org.wso2.carbon.privacy.forgetme.api.runtime.InstructionExecutionException;
import org.wso2.carbon.privacy.forgetme.api.runtime.ProcessorConfig;
import org.wso2.carbon.privacy.forgetme.api.user.UserIdentifier;

public class AnalyticsStreamsInstruction
implements ForgetMeInstruction {
    private static final Logger log = LoggerFactory.getLogger(AnalyticsStreamsInstruction.class);
    private static final String CARBON_HOME = "CARBON_HOME";
    private static final String CUSTOM_CONF_DIR_NAME = "wso2_custom_conf_dir";
    private static final String CUSTOM_CONF_DIR_PATH_SEGMENT = "/repository/conf";
    private static final int RECORD_BATCH_SIZE = -1;
    private List<Record> anonymizedRecords;
    private List<Streams.Stream> streams;
    private Environment environment;

    public AnalyticsStreamsInstruction(Environment environment, List<Streams.Stream> streams) {
        this.environment = environment;
        this.streams = streams;
        this.anonymizedRecords = new ArrayList<Record>();
    }

    private static String getTableName(String streamName) {
        return streamName.replace(".", "_").toUpperCase();
    }

    private static Object hashRecordValue(Object value) {
        return Objects.hash(value);
    }

    public ForgetMeResult execute(UserIdentifier userIdentifier, ProcessorConfig processorConfig, Environment environment, ReportAppender reportAppender) throws InstructionExecutionException {
        AnalyticsDataService analyticsDataService = this.getAnalyticsDataService();
        for (Streams.Stream stream : this.streams) {
            this.filterRecords(analyticsDataService, userIdentifier, stream);
        }
        try {
            this.updateQueuedRecords(analyticsDataService);
        }
        catch (AnalyticsException e) {
            throw new AnalyticsStreamsProcessorException("Error in updating data records.", e);
        }
        return new ForgetMeResult();
    }

    private AnalyticsDataService getAnalyticsDataService() {
        String carbonHome = this.environment.getProperty(CARBON_HOME);
        System.setProperty(CUSTOM_CONF_DIR_NAME, Paths.get(carbonHome, CUSTOM_CONF_DIR_PATH_SEGMENT).toString());
        AnalyticsServiceHolder.setAnalyticsClusterManager((AnalyticsClusterManager)new AnalyticsClusterManagerImpl());
        return AnalyticsServiceHolder.getAnalyticsDataService();
    }

    private void filterRecords(AnalyticsDataService analyticsDataService, UserIdentifier userIdentifier, Streams.Stream stream) {
        if (stream == null) {
            return;
        }
        try {
            AnalyticsDataResponse analyticsDataResponse = analyticsDataService.get(userIdentifier.getTenantId(), AnalyticsStreamsInstruction.getTableName(stream.getStreamName()), 1, null, Long.MIN_VALUE, Long.MAX_VALUE, 0, -1);
            List entries = analyticsDataResponse.getEntries();
            for (AnalyticsDataResponse.Entry entry : entries) {
                AnalyticsIterator recordAnalyticsIterator = analyticsDataService.readRecords(entry.getRecordStoreName(), entry.getRecordGroup());
                while (recordAnalyticsIterator.hasNext()) {
                    Record record = (Record)recordAnalyticsIterator.next();
                    if (!record.getValue(stream.getId()).equals(userIdentifier.getUsername())) continue;
                    this.anonymizedRecords.add(this.anonymizeRecord(record, stream, userIdentifier.getPseudonym()));
                }
            }
        }
        catch (AnalyticsException e) {
            log.error("Error occurred while filtering record set.", (Throwable)e);
        }
    }

    private void updateQueuedRecords(AnalyticsDataService analyticsDataService) throws AnalyticsException {
        analyticsDataService.put(this.anonymizedRecords);
    }

    private Record anonymizeRecord(Record record, Streams.Stream stream, String pseudonym) {
        for (String attribute : stream.getAttributes()) {
            if (stream.isIdAttribute(attribute)) {
                record.getValues().put(attribute, pseudonym);
                continue;
            }
            Object value = record.getValue(attribute);
            if (value == null) continue;
            record.getValues().put(attribute, AnalyticsStreamsInstruction.hashRecordValue(value));
        }
        return record;
    }
}

