/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth.ciba.handlers;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticatedUser;
import org.wso2.carbon.identity.oauth.ciba.common.AuthReqStatus;
import org.wso2.carbon.identity.oauth.ciba.dao.CibaDAOFactory;
import org.wso2.carbon.identity.oauth.ciba.exceptions.CibaCoreException;
import org.wso2.carbon.identity.oauth.dto.OAuthErrorDTO;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.authz.OAuthAuthzReqMessageContext;
import org.wso2.carbon.identity.oauth2.authz.handlers.AbstractResponseTypeHandler;
import org.wso2.carbon.identity.oauth2.dto.OAuth2AuthorizeReqDTO;
import org.wso2.carbon.identity.oauth2.dto.OAuth2AuthorizeRespDTO;
import org.wso2.carbon.identity.oauth2.model.OAuth2Parameters;

public class CibaResponseTypeHandler
extends AbstractResponseTypeHandler {
    private static Log log = LogFactory.getLog(CibaResponseTypeHandler.class);

    public OAuth2AuthorizeRespDTO issue(OAuthAuthzReqMessageContext oauthAuthzMsgCtx) throws IdentityOAuth2Exception {
        OAuth2AuthorizeRespDTO respDTO = new OAuth2AuthorizeRespDTO();
        OAuth2AuthorizeReqDTO authorizationReqDTO = oauthAuthzMsgCtx.getAuthorizationReqDTO();
        try {
            AuthenticatedUser cibaAuthenticatedUser = authorizationReqDTO.getUser();
            AuthReqStatus authenticationStatus = AuthReqStatus.AUTHENTICATED;
            String authCodeKey = CibaDAOFactory.getInstance().getCibaAuthMgtDAO().getCibaAuthCodeKey(authorizationReqDTO.getNonce());
            CibaDAOFactory.getInstance().getCibaAuthMgtDAO().persistAuthenticationSuccess(authCodeKey, cibaAuthenticatedUser);
            String callbackURL = authorizationReqDTO.getCallbackUrl() + "?authenticationStatus=" + (Object)((Object)authenticationStatus);
            respDTO.setCallbackURI(callbackURL);
            return respDTO;
        }
        catch (CibaCoreException e) {
            throw new IdentityOAuth2Exception("Error occurred in persisting authenticated user and authentication status for the request made by client: " + authorizationReqDTO.getConsumerKey(), (Throwable)((Object)e));
        }
    }

    public OAuthErrorDTO handleUserConsentDenial(OAuth2Parameters oAuth2Parameters) {
        OAuthErrorDTO oAuthErrorDTO = new OAuthErrorDTO();
        String authReqID = oAuth2Parameters.getNonce();
        String authCodeKey = null;
        try {
            authCodeKey = CibaDAOFactory.getInstance().getCibaAuthMgtDAO().getCibaAuthCodeKey(authReqID);
            CibaDAOFactory.getInstance().getCibaAuthMgtDAO().updateStatus(authCodeKey, AuthReqStatus.CONSENT_DENIED);
            oAuthErrorDTO.setErrorDescription("User denied the consent.");
            return oAuthErrorDTO;
        }
        catch (CibaCoreException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Error occurred in updating the authentication_status for the auth_req_id : " + authReqID + "with responseType as (ciba). "));
            }
            return null;
        }
    }

    public OAuthErrorDTO handleAuthenticationFailure(OAuth2Parameters oAuth2Parameters) {
        OAuthErrorDTO oAuthErrorDTO = new OAuthErrorDTO();
        String authReqID = oAuth2Parameters.getNonce();
        String authCodeKey = null;
        try {
            authCodeKey = CibaDAOFactory.getInstance().getCibaAuthMgtDAO().getCibaAuthCodeKey(authReqID);
            CibaDAOFactory.getInstance().getCibaAuthMgtDAO().updateStatus(authCodeKey, AuthReqStatus.FAILED);
            oAuthErrorDTO.setErrorDescription("Authentication failed.");
            return oAuthErrorDTO;
        }
        catch (CibaCoreException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Error occurred in updating the authentication_status for the ID : " + authReqID + "with responseType as (ciba). "));
            }
            return null;
        }
    }
}

