/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth.ciba.grant;

import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticatedUser;
import org.wso2.carbon.identity.oauth.ciba.common.AuthReqStatus;
import org.wso2.carbon.identity.oauth.ciba.dao.CibaDAOFactory;
import org.wso2.carbon.identity.oauth.ciba.exceptions.CibaCoreException;
import org.wso2.carbon.identity.oauth.ciba.model.CibaAuthCodeDO;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.dto.OAuth2AccessTokenRespDTO;
import org.wso2.carbon.identity.oauth2.model.RequestParameter;
import org.wso2.carbon.identity.oauth2.token.OAuthTokenReqMessageContext;
import org.wso2.carbon.identity.oauth2.token.handlers.grant.AbstractAuthorizationGrantHandler;
import org.wso2.carbon.identity.oauth2.util.OAuth2Util;

public class CibaGrantHandler
extends AbstractAuthorizationGrantHandler {
    private static final String INVALID_GRANT = "invalid_grant";
    private static final String MISSING_AUTH_REQ_ID = "auth_req_id_missing";
    private static final String INVALID_AUTH_REQ_ID = "invalid auth_req_id";
    private static final String INVALID_PARAMETERS = "invalid_request_parameters";
    private static Log log = LogFactory.getLog(CibaGrantHandler.class);

    public OAuth2AccessTokenRespDTO issue(OAuthTokenReqMessageContext tokReqMsgCtx) throws IdentityOAuth2Exception {
        OAuth2AccessTokenRespDTO responseDTO = super.issue(tokReqMsgCtx);
        String authReqId = this.getAuthReqId(tokReqMsgCtx);
        CibaAuthCodeDO cibaAuthCodeDO = this.retrieveCibaAuthCode(authReqId);
        try {
            CibaDAOFactory.getInstance().getCibaAuthMgtDAO().updateStatus(cibaAuthCodeDO.getCibaAuthCodeKey(), AuthReqStatus.TOKEN_ISSUED);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Successfully updated the status of authentication request made by client:" + tokReqMsgCtx.getOauth2AccessTokenReqDTO().getClientId()));
            }
        }
        catch (CibaCoreException e) {
            throw new IdentityOAuth2Exception("Error occurred in persisting status for the request made with auth_req_id: " + authReqId, (Throwable)((Object)e));
        }
        return responseDTO;
    }

    public boolean validateGrant(OAuthTokenReqMessageContext tokReqMsgCtx) throws IdentityOAuth2Exception {
        if (!super.validateGrant(tokReqMsgCtx)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Successful in validating grant.Validation failed for the token request made by client: " + tokReqMsgCtx.getOauth2AccessTokenReqDTO().getClientId()));
            }
            return false;
        }
        String authReqId = this.getAuthReqId(tokReqMsgCtx);
        try {
            CibaAuthCodeDO cibaAuthCodeDO = this.retrieveCibaAuthCode(authReqId);
            this.validateAuthReqId(cibaAuthCodeDO);
            if (this.isTokenAlreadyIssued(cibaAuthCodeDO)) {
                throw new IdentityOAuth2Exception("invalid_request");
            }
            if (!this.isConsentGiven(cibaAuthCodeDO).booleanValue()) {
                throw new IdentityOAuth2Exception("consent_denied");
            }
            this.validatePollingFrequency(cibaAuthCodeDO);
            if (this.isAuthorizationPending(cibaAuthCodeDO)) {
                this.updateLastPolledTime(cibaAuthCodeDO);
                throw new IdentityOAuth2Exception("authorization_pending");
            }
            this.setPropertiesForTokenGeneration(tokReqMsgCtx, cibaAuthCodeDO);
            return true;
        }
        catch (CibaCoreException e) {
            throw new IdentityOAuth2Exception(INVALID_PARAMETERS, (Throwable)((Object)e));
        }
    }

    private String getAuthReqId(OAuthTokenReqMessageContext tokReqMsgCtx) throws IdentityOAuth2Exception {
        RequestParameter[] parameters;
        String authReqId = null;
        for (RequestParameter parameter : parameters = tokReqMsgCtx.getOauth2AccessTokenReqDTO().getRequestParameters()) {
            if (!"auth_req_id".equals(parameter.getKey()) || parameter.getValue() == null || parameter.getValue().length <= 0) continue;
            authReqId = parameter.getValue()[0];
        }
        if (authReqId == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"token request misses mandated parameter (auth_req_id).");
            }
            throw new IdentityOAuth2Exception(MISSING_AUTH_REQ_ID);
        }
        return authReqId;
    }

    private Boolean isConsentGiven(CibaAuthCodeDO cibaAuthCodeDO) {
        return !AuthReqStatus.CONSENT_DENIED.equals(cibaAuthCodeDO.getAuthReqStatus());
    }

    private void validateAuthReqId(CibaAuthCodeDO cibaAuthCodeDO) throws IdentityOAuth2Exception, CibaCoreException {
        long scheduledExpiryTime;
        long expiresIn = cibaAuthCodeDO.getExpiresIn() * 1000L;
        long currentTimeInMillis = Calendar.getInstance(TimeZone.getTimeZone("UTC")).getTimeInMillis();
        if (currentTimeInMillis > (scheduledExpiryTime = cibaAuthCodeDO.getIssuedTime().getTime() + expiresIn)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"CIBA auth_req_id is in expired state.Token Request Denied.");
            }
            CibaDAOFactory.getInstance().getCibaAuthMgtDAO().updateStatus(cibaAuthCodeDO.getCibaAuthCodeKey(), AuthReqStatus.EXPIRED);
            throw new IdentityOAuth2Exception("expired_token");
        }
    }

    private void validatePollingFrequency(CibaAuthCodeDO cibaAuthCodeDO) throws IdentityOAuth2Exception, CibaCoreException {
        long currentTimeInMillis = Calendar.getInstance(TimeZone.getTimeZone("UTC")).getTimeInMillis();
        long lastPollTimeInMillis = cibaAuthCodeDO.getLastPolledTime().getTime();
        long intervalInSec = cibaAuthCodeDO.getInterval();
        String cibaAuthCodeID = cibaAuthCodeDO.getCibaAuthCodeKey();
        if (currentTimeInMillis < lastPollTimeInMillis + intervalInSec * 1000L) {
            long newInterval = intervalInSec + 3L;
            if (log.isDebugEnabled()) {
                log.debug((Object)(" Rigorous polling for the token  made by client for request identified by cibaAuthCodeDOKey : " + cibaAuthCodeDO.getCibaAuthCodeKey() + ". Updated the Polling frequency on the table."));
            }
            CibaDAOFactory.getInstance().getCibaAuthMgtDAO().updatePollingInterval(cibaAuthCodeID, newInterval);
            throw new IdentityOAuth2Exception("slow_down");
        }
    }

    private void updateLastPolledTime(CibaAuthCodeDO cibaAuthCodeDO) throws CibaCoreException {
        long currentTimeInMillis = Calendar.getInstance(TimeZone.getTimeZone("UTC")).getTimeInMillis();
        Timestamp latestPollingTime = new Timestamp(currentTimeInMillis);
        CibaDAOFactory.getInstance().getCibaAuthMgtDAO().updateLastPollingTime(cibaAuthCodeDO.getCibaAuthCodeKey(), latestPollingTime);
    }

    private boolean isAuthorizationPending(CibaAuthCodeDO cibaAuthCodeDO) throws CibaCoreException {
        Enum authenticationStatus = cibaAuthCodeDO.getAuthReqStatus();
        String cibaAuthCodeKey = cibaAuthCodeDO.getCibaAuthCodeKey();
        if (!authenticationStatus.equals((Object)AuthReqStatus.AUTHENTICATED)) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.info((Object)("User still not authenticated for the request made by client for request uniquely identified by cibaAuthCodeKey : " + cibaAuthCodeKey));
        }
        return false;
    }

    private boolean isTokenAlreadyIssued(CibaAuthCodeDO cibaAuthCodeDO) throws CibaCoreException {
        Enum authenticationStatus = cibaAuthCodeDO.getAuthReqStatus();
        String cibaAuthCodeDOKey = cibaAuthCodeDO.getCibaAuthCodeKey();
        if (authenticationStatus.equals((Object)AuthReqStatus.TOKEN_ISSUED)) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.info((Object)("Token is not delivered for the request made for cibaAuthCodeDOKey : " + cibaAuthCodeDOKey));
        }
        return false;
    }

    private void setPropertiesForTokenGeneration(OAuthTokenReqMessageContext tokReqMsgCtx, CibaAuthCodeDO cibaAuthCodeDO) {
        tokReqMsgCtx.setAuthorizedUser(OAuth2Util.getUserFromUserName((String)cibaAuthCodeDO.getAuthenticatedUser().getUserName()));
        tokReqMsgCtx.setScope(cibaAuthCodeDO.getScopes());
    }

    private CibaAuthCodeDO retrieveCibaAuthCode(String authReqId) throws IdentityOAuth2Exception {
        try {
            String authCodeKey = CibaDAOFactory.getInstance().getCibaAuthMgtDAO().getCibaAuthCodeKey(authReqId);
            if (StringUtils.isBlank((String)authCodeKey)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Provided auth_req_id : " + authReqId + " with the token request is not valid.Or not issued by Identity server."));
                }
                throw new IdentityOAuth2Exception(INVALID_AUTH_REQ_ID);
            }
            CibaAuthCodeDO cibaAuthCodeDO = CibaDAOFactory.getInstance().getCibaAuthMgtDAO().getCibaAuthCode(authCodeKey);
            if (cibaAuthCodeDO.getAuthReqStatus().equals((Object)AuthReqStatus.AUTHENTICATED)) {
                List<String> scope = CibaDAOFactory.getInstance().getCibaAuthMgtDAO().getScopes(cibaAuthCodeDO.getCibaAuthCodeKey());
                cibaAuthCodeDO.setScopes(scope.toArray(new String[scope.size()]));
                AuthenticatedUser authenticatedUser = CibaDAOFactory.getInstance().getCibaAuthMgtDAO().getAuthenticatedUser(cibaAuthCodeDO.getCibaAuthCodeKey());
                cibaAuthCodeDO.setAuthenticatedUser(authenticatedUser);
            }
            return cibaAuthCodeDO;
        }
        catch (CibaCoreException e) {
            throw new IdentityOAuth2Exception(INVALID_AUTH_REQ_ID, (Throwable)((Object)e));
        }
    }
}

