/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth.ciba.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticatedUser;
import org.wso2.carbon.identity.core.util.IdentityDatabaseUtil;
import org.wso2.carbon.identity.oauth.ciba.common.AuthReqStatus;
import org.wso2.carbon.identity.oauth.ciba.dao.CibaMgtDAO;
import org.wso2.carbon.identity.oauth.ciba.exceptions.CibaCoreException;
import org.wso2.carbon.identity.oauth.ciba.model.CibaAuthCodeDO;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.util.OAuth2Util;

public class CibaMgtDAOImpl
implements CibaMgtDAO {
    private static final Log log = LogFactory.getLog(CibaMgtDAOImpl.class);

    @Override
    public void updateStatus(String authCodeKey, Enum authenticationStatus) throws CibaCoreException {
        try (Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)true);){
            try (PreparedStatement prepStmt = connection.prepareStatement("UPDATE IDN_OAUTH2_CIBA_AUTH_CODE SET AUTH_REQ_STATUS = ? WHERE AUTH_CODE_KEY = ? ");){
                prepStmt.setString(1, authenticationStatus.toString());
                prepStmt.setString(2, authCodeKey);
                prepStmt.execute();
                IdentityDatabaseUtil.commitTransaction((Connection)connection);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Successfully persisted the authentication status: " + authenticationStatus + " identified by authCodeKey: " + authCodeKey));
                }
            }
            catch (SQLException e) {
                IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                throw new CibaCoreException("Error occurred in persisting authentication status for the authCodeKey: " + authCodeKey, e);
            }
        }
        catch (SQLException e) {
            throw new CibaCoreException("Error occurred in persisting authentication status for the authCodeKey: " + authCodeKey, e);
        }
    }

    @Override
    public void persistAuthenticationSuccess(String authCodeKey, AuthenticatedUser authenticatedUser) throws CibaCoreException {
        String authenticatedIDP = OAuth2Util.getAuthenticatedIDP((AuthenticatedUser)authenticatedUser);
        try (Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)true);){
            try (PreparedStatement prepStmt = connection.prepareStatement("UPDATE IDN_OAUTH2_CIBA_AUTH_CODE SET AUTHENTICATED_USER_NAME = ? ,USER_STORE_DOMAIN = ? ,TENANT_ID = ?, IDP_ID = (SELECT IDP.ID FROM IDP WHERE IDP.NAME = ? AND IDP.TENANT_ID = ?) ,AUTH_REQ_STATUS = ? WHERE AUTH_CODE_KEY = ? ");){
                int authenticatedTenant = OAuth2Util.getTenantId((String)authenticatedUser.getTenantDomain());
                prepStmt.setString(1, authenticatedUser.getUserName());
                prepStmt.setString(2, authenticatedUser.getUserStoreDomain());
                prepStmt.setInt(3, authenticatedTenant);
                prepStmt.setString(4, authenticatedIDP);
                prepStmt.setInt(5, authenticatedTenant);
                prepStmt.setString(6, AuthReqStatus.AUTHENTICATED.toString());
                prepStmt.setString(7, authCodeKey);
                prepStmt.execute();
                IdentityDatabaseUtil.commitTransaction((Connection)connection);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Successfully updated the authentication request status to 'AUTHENTICATED' for the request identified by authCodeKey: " + authCodeKey));
                }
            }
            catch (SQLException | IdentityOAuth2Exception e) {
                IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                throw new CibaCoreException("Error occurred in persisting the successful authentication identified by authCodeKey: " + authCodeKey, e);
            }
        }
        catch (SQLException e) {
            throw new CibaCoreException("Error occurred in persisting the successful authentication identified by authCodeKey: " + authCodeKey, e);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public String getCibaAuthCodeKey(String authReqId) throws CibaCoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void updateLastPollingTime(String authCodeKey, Timestamp lastPolledTime) throws CibaCoreException {
        try (Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)true);){
            try (PreparedStatement prepStmt = connection.prepareStatement("UPDATE IDN_OAUTH2_CIBA_AUTH_CODE SET LAST_POLLED_TIME = ? WHERE  AUTH_CODE_KEY = ? ");){
                prepStmt.setTimestamp(1, lastPolledTime, Calendar.getInstance(TimeZone.getTimeZone("UTC")));
                prepStmt.setString(2, authCodeKey);
                prepStmt.execute();
                IdentityDatabaseUtil.commitTransaction((Connection)connection);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Successfully updated lastPollingTime of TokenRequest  with authCodeKey : " + authCodeKey));
                }
            }
            catch (SQLException e) {
                IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                throw new CibaCoreException("Error occurred in updating lastPollingTime of TokenRequest identified by authCodeKey: " + authCodeKey, e);
            }
        }
        catch (SQLException e) {
            throw new CibaCoreException("Error occurred in updating lastPollingTime of TokenRequest identified by authCodeKey: " + authCodeKey, e);
        }
    }

    @Override
    public void updatePollingInterval(String authCodeKey, long newInterval) throws CibaCoreException {
        try (Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)true);){
            try (PreparedStatement prepStmt = connection.prepareStatement("UPDATE IDN_OAUTH2_CIBA_AUTH_CODE SET POLLING_INTERVAL = ? WHERE  AUTH_CODE_KEY = ? ");){
                prepStmt.setLong(1, newInterval);
                prepStmt.setString(2, authCodeKey);
                prepStmt.execute();
                IdentityDatabaseUtil.commitTransaction((Connection)connection);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Successfully updated pollingInterval of TokenRequest  with authCodeKey : " + authCodeKey));
                }
            }
            catch (SQLException e) {
                IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                throw new CibaCoreException("Error occurred in updating pollingInterval of TokenRequest identified by authCodeKey: " + authCodeKey, e);
            }
        }
        catch (SQLException e) {
            throw new CibaCoreException("Error occurred in updating pollingInterval of TokenRequest identified by authCodeKey: " + authCodeKey, e);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public AuthenticatedUser getAuthenticatedUser(String authCodeKey) throws CibaCoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void persistCibaAuthCode(CibaAuthCodeDO cibaAuthCodeDO) throws CibaCoreException {
        try (Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)true);){
            Throwable throwable;
            try {
                throwable = null;
                try (PreparedStatement prepStmt = connection.prepareStatement("INSERT INTO IDN_OAUTH2_CIBA_AUTH_CODE (AUTH_CODE_KEY, AUTH_REQ_ID, CONSUMER_KEY, ISSUED_TIME, LAST_POLLED_TIME, POLLING_INTERVAL, EXPIRES_IN, AUTH_REQ_STATUS) VALUES (?,?,?,?,?,?,?,?)");){
                    prepStmt.setString(1, cibaAuthCodeDO.getCibaAuthCodeKey());
                    prepStmt.setString(2, cibaAuthCodeDO.getAuthReqId());
                    prepStmt.setString(3, cibaAuthCodeDO.getConsumerKey());
                    prepStmt.setTimestamp(4, cibaAuthCodeDO.getIssuedTime(), Calendar.getInstance(TimeZone.getTimeZone("UTC")));
                    prepStmt.setTimestamp(5, cibaAuthCodeDO.getLastPolledTime(), Calendar.getInstance(TimeZone.getTimeZone("UTC")));
                    prepStmt.setLong(6, cibaAuthCodeDO.getInterval());
                    prepStmt.setLong(7, cibaAuthCodeDO.getExpiresIn());
                    prepStmt.setString(8, cibaAuthCodeDO.getAuthReqStatus().toString());
                    prepStmt.execute();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Successfully persisted cibaAuthCodeDO for unique CibaAuthCodeKey : " + cibaAuthCodeDO.getCibaAuthCodeKey()));
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (SQLException e) {
                IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                throw new CibaCoreException("Error occurred while persisting cibaAuthCode for the application with consumer key: " + cibaAuthCodeDO.getConsumerKey() + " and with authCodeKey: " + cibaAuthCodeDO.getCibaAuthCodeKey(), e);
            }
            try {
                throwable = null;
                try (PreparedStatement prepStmtForScope = connection.prepareStatement("INSERT INTO IDN_OAUTH2_CIBA_REQUEST_SCOPES (AUTH_CODE_KEY,SCOPE) VALUES (?,?)");){
                    for (String singleScopeValue : cibaAuthCodeDO.getScopes()) {
                        prepStmtForScope.setString(1, cibaAuthCodeDO.getCibaAuthCodeKey());
                        prepStmtForScope.setString(2, singleScopeValue);
                        prepStmtForScope.addBatch();
                    }
                    prepStmtForScope.executeBatch();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Successfully persisted scopes for unique authCodeKey : " + cibaAuthCodeDO.getCibaAuthCodeKey()));
                    }
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            catch (SQLException e) {
                IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                throw new CibaCoreException("Error occurred while persisting scopes for the application with consumer key: " + cibaAuthCodeDO.getConsumerKey() + " and with authCodeKey: " + cibaAuthCodeDO.getCibaAuthCodeKey(), e);
            }
            IdentityDatabaseUtil.commitTransaction((Connection)connection);
        }
        catch (SQLException e) {
            throw new CibaCoreException("Error occurred while persisting cibaAuthCode for the application with consumer key: " + cibaAuthCodeDO.getConsumerKey() + " and with authCodeKey: " + cibaAuthCodeDO.getCibaAuthCodeKey(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public CibaAuthCodeDO getCibaAuthCode(String authCodeKey) throws CibaCoreException {
        CibaAuthCodeDO cibaAuthCodeDO = new CibaAuthCodeDO();
        try (Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
             PreparedStatement prepStmt = connection.prepareStatement("SELECT AUTH_CODE_KEY,  AUTH_REQ_ID, CONSUMER_KEY, LAST_POLLED_TIME, POLLING_INTERVAL, EXPIRES_IN, AUTH_REQ_STATUS,  ISSUED_TIME FROM IDN_OAUTH2_CIBA_AUTH_CODE WHERE AUTH_CODE_KEY = ?");){
            prepStmt.setString(1, authCodeKey);
            try (ResultSet resultSet = prepStmt.executeQuery();){
                if (resultSet.next()) {
                    cibaAuthCodeDO.setCibaAuthCodeKey(resultSet.getString(1));
                    cibaAuthCodeDO.setAuthReqId(resultSet.getString(2));
                    cibaAuthCodeDO.setConsumerKey(resultSet.getString(3));
                    cibaAuthCodeDO.setLastPolledTime(resultSet.getTimestamp(4, Calendar.getInstance(TimeZone.getTimeZone("UTC"))));
                    cibaAuthCodeDO.setInterval(resultSet.getLong(5));
                    cibaAuthCodeDO.setExpiresIn(resultSet.getLong(6));
                    cibaAuthCodeDO.setAuthReqStatus(AuthReqStatus.valueOf(resultSet.getString(7)));
                    cibaAuthCodeDO.setIssuedTime(resultSet.getTimestamp(8, Calendar.getInstance(TimeZone.getTimeZone("UTC"))));
                    if (!log.isDebugEnabled()) return cibaAuthCodeDO;
                    log.debug((Object)("Successfully obtained cibaAuthCode for unique authCodeKey : " + authCodeKey));
                    return cibaAuthCodeDO;
                }
                CibaAuthCodeDO cibaAuthCodeDO2 = null;
                return cibaAuthCodeDO2;
            }
        }
        catch (SQLException e) {
            throw new CibaCoreException("Error in obtaining cibaAuthCode for unique authCodeKey : " + authCodeKey, e);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<String> getScopes(String authCodeKey) throws CibaCoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

