/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth.ciba.api;

import java.sql.Timestamp;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.oauth.ciba.api.CibaAuthService;
import org.wso2.carbon.identity.oauth.ciba.common.AuthReqStatus;
import org.wso2.carbon.identity.oauth.ciba.dao.CibaDAOFactory;
import org.wso2.carbon.identity.oauth.ciba.exceptions.CibaClientException;
import org.wso2.carbon.identity.oauth.ciba.exceptions.CibaCoreException;
import org.wso2.carbon.identity.oauth.ciba.model.CibaAuthCodeDO;
import org.wso2.carbon.identity.oauth.ciba.model.CibaAuthCodeRequest;
import org.wso2.carbon.identity.oauth.ciba.model.CibaAuthCodeResponse;
import org.wso2.carbon.identity.oauth.common.exception.InvalidOAuthClientException;
import org.wso2.carbon.identity.oauth.dao.OAuthAppDO;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.util.OAuth2Util;

public class CibaAuthServiceImpl
implements CibaAuthService {
    private static Log log = LogFactory.getLog(CibaAuthServiceImpl.class);

    @Override
    public CibaAuthCodeResponse generateAuthCodeResponse(CibaAuthCodeRequest cibaAuthCodeRequest) throws CibaCoreException, CibaClientException {
        CibaAuthCodeDO cibaAuthCodeDO = this.generateCibaAuthCodeDO(cibaAuthCodeRequest);
        CibaDAOFactory.getInstance().getCibaAuthMgtDAO().persistCibaAuthCode(cibaAuthCodeDO);
        return this.buildAuthCodeResponse(cibaAuthCodeRequest, cibaAuthCodeDO);
    }

    private String generateAuthCodeKey() {
        return UUID.randomUUID().toString();
    }

    private String generateAuthRequestId() {
        return UUID.randomUUID().toString();
    }

    private long getExpiresIn(CibaAuthCodeRequest cibaAuthCodeRequest) {
        long requestedExpiry = cibaAuthCodeRequest.getRequestedExpiry();
        if (requestedExpiry == 0L) {
            return 3600L;
        }
        if (requestedExpiry < 3600L) {
            return requestedExpiry;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("The requested_expiry: " + requestedExpiry + " exceeds default maximum value: " + 3600L + " for the CIBA authentication request made by: " + cibaAuthCodeRequest.getIssuer()));
        }
        return 3600L;
    }

    private CibaAuthCodeDO generateCibaAuthCodeDO(CibaAuthCodeRequest cibaAuthCodeRequest) {
        CibaAuthCodeDO cibaAuthCodeDO = new CibaAuthCodeDO();
        long issuedTimeInMillis = Calendar.getInstance(TimeZone.getTimeZone("UTC")).getTimeInMillis();
        Timestamp issuedTime = new Timestamp(issuedTimeInMillis);
        long expiryTime = this.getExpiresIn(cibaAuthCodeRequest);
        String[] scopes = cibaAuthCodeRequest.getScopes();
        cibaAuthCodeDO.setCibaAuthCodeKey(this.generateAuthCodeKey());
        cibaAuthCodeDO.setAuthReqId(this.generateAuthRequestId());
        cibaAuthCodeDO.setConsumerKey(cibaAuthCodeRequest.getIssuer());
        cibaAuthCodeDO.setIssuedTime(issuedTime);
        cibaAuthCodeDO.setLastPolledTime(issuedTime);
        cibaAuthCodeDO.setAuthReqStatus(AuthReqStatus.REQUESTED);
        cibaAuthCodeDO.setInterval(2L);
        cibaAuthCodeDO.setExpiresIn(expiryTime);
        cibaAuthCodeDO.setScopes(scopes);
        return cibaAuthCodeDO;
    }

    private CibaAuthCodeResponse buildAuthCodeResponse(CibaAuthCodeRequest cibaAuthCodeRequest, CibaAuthCodeDO cibaAuthCodeDO) throws CibaCoreException, CibaClientException {
        String clientID = cibaAuthCodeRequest.getIssuer();
        try {
            CibaAuthCodeResponse cibaAuthCodeResponse = new CibaAuthCodeResponse();
            String user = cibaAuthCodeRequest.getUserHint();
            OAuthAppDO appDO = OAuth2Util.getAppInformationByClientId((String)clientID);
            String callbackUri = appDO.getCallbackUrl();
            cibaAuthCodeResponse.setAuthReqId(cibaAuthCodeDO.getAuthReqId());
            cibaAuthCodeResponse.setCallBackUrl(callbackUri);
            cibaAuthCodeResponse.setUserHint(user);
            cibaAuthCodeResponse.setClientId(clientID);
            cibaAuthCodeResponse.setScopes(cibaAuthCodeRequest.getScopes());
            cibaAuthCodeResponse.setExpiresIn(cibaAuthCodeDO.getExpiresIn());
            if (StringUtils.isNotBlank((String)cibaAuthCodeRequest.getBindingMessage())) {
                cibaAuthCodeResponse.setBindingMessage(cibaAuthCodeRequest.getBindingMessage());
            }
            if (StringUtils.isNotBlank((String)cibaAuthCodeRequest.getTransactionContext())) {
                cibaAuthCodeResponse.setTransactionDetails(cibaAuthCodeRequest.getTransactionContext());
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Successful in creating AuthCodeResponse for the client: " + clientID));
            }
            return cibaAuthCodeResponse;
        }
        catch (IdentityOAuth2Exception e) {
            throw new CibaCoreException("Error in creating AuthCodeResponse for the client: " + clientID, e);
        }
        catch (InvalidOAuthClientException e) {
            throw new CibaClientException("Error in creating AuthCodeResponse for the client: " + clientID, e);
        }
    }
}

