/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.core.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.pagination.PaginationContext;
import org.wso2.carbon.registry.core.pagination.PaginationUtils;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.utils.CarbonUtils;

public class MediaTypesUtils {
    private static final Log log = LogFactory.getLog(MediaTypesUtils.class);
    private static final String RESOURCE_MEDIA_TYPE_MAPPINGS_FILE = "mime.types";
    private static final String MIME_TYPE_COLLECTION = "/repository/components/org.wso2.carbon.governance/media-types";
    private static final String RESOURCE_MIME_TYPE_INDEX = "index";
    private static final String COLLECTION_MIME_TYPE_INDEX = "collection";
    private static final String CUSTOM_UI_MIME_TYPE_INDEX = "custom.ui";
    private static Map<String, String> humanReadableMediaTypeMap;
    private static final String HUMAN_READABLE_MEDIA_TYPE_MAPPINGS_FILE = "mime.mappings";
    private static final String FAILED_TO_READ_THE_THE_HUMAN_READABLE_MEDIA_TYPE_MIME_TYPE_MAPPINGS_FILE_MSG = "Failed to read the the human readable media type mime type mappings file.";

    public static String getCollectionMediaTypeMappings(RegistryContext registryContext) throws RegistryException {
        if (registryContext == null) {
            return RegistryContext.getBaseInstance().getCollectionMediaTypes();
        }
        return registryContext.getCollectionMediaTypes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getResultPaths(Registry registry, String mediaType) throws RegistryException {
        String[] result;
        block10: {
            String[] stringArray;
            HashMap<String, String> parameter = new HashMap<String, String>();
            parameter.put("1", mediaType);
            parameter.put("query", "SELECT DISTINCT REG_PATH_ID, REG_NAME FROM REG_RESOURCE WHERE REG_MEDIA_TYPE=?");
            result = (String[])registry.executeQuery(null, parameter).getContent();
            if (result == null || result.length == 0) {
                return new String[0];
            }
            result = MediaTypesUtils.removeMountPaths(result, registry);
            MessageContext messageContext = MessageContext.getCurrentMessageContext();
            if (!PaginationUtils.isPaginationAnnotationFound("getPaginatedGovernanceArtifacts") || (messageContext == null || !PaginationUtils.isPaginationHeadersExist(messageContext)) && PaginationContext.getInstance() == null) break block10;
            int rowCount = result.length;
            try {
                String[] paginatedResult;
                PaginationContext paginationContext;
                if (messageContext != null) {
                    PaginationUtils.setRowCount(messageContext, Integer.toString(rowCount));
                    paginationContext = PaginationUtils.initPaginationContext(messageContext);
                } else {
                    paginationContext = PaginationContext.getInstance();
                }
                int start = paginationContext.getStart();
                int count = paginationContext.getCount();
                int startIndex = start == 1 ? 0 : start;
                if (rowCount < start + count) {
                    paginatedResult = new String[rowCount - startIndex];
                    System.arraycopy(result, startIndex, paginatedResult, 0, rowCount - startIndex);
                } else {
                    paginatedResult = new String[count];
                    System.arraycopy(result, startIndex, paginatedResult, 0, count);
                }
                stringArray = paginatedResult;
            }
            catch (Throwable throwable) {
                try {
                    PaginationContext.destroy();
                    throw throwable;
                }
                catch (RegistryException e) {
                    String msg = "Error in getting the result for media type: " + mediaType + ".";
                    log.error((Object)msg, (Throwable)((Object)e));
                    throw new RegistryException(msg, (Throwable)((Object)e));
                }
            }
            PaginationContext.destroy();
            return stringArray;
        }
        return result;
    }

    private static String[] removeMountPaths(String[] paths, Registry registry) {
        if (paths == null) {
            return new String[0];
        }
        LinkedList<String> fixedPaths = new LinkedList<String>();
        for (String path : paths) {
            if (path.contains("/repository/components/org.wso2.carbon.registry/mount")) continue;
            fixedPaths.add(path);
        }
        return fixedPaths.toArray(new String[fixedPaths.size()]);
    }

    public static String getCollectionMediaTypeMappings(Registry configSystemRegistry) throws RegistryException {
        Resource resource;
        RegistryContext registryContext = configSystemRegistry.getRegistryContext();
        if (MediaTypesUtils.getCollectionMediaTypeMappings(registryContext) != null) {
            return MediaTypesUtils.getCollectionMediaTypeMappings(registryContext);
        }
        String mediaTypeString = null;
        String resourcePath = "/repository/components/org.wso2.carbon.governance/media-types/index";
        if (!configSystemRegistry.resourceExists(resourcePath)) {
            MediaTypesUtils.getResourceMediaTypeMappings(configSystemRegistry);
        }
        if (!configSystemRegistry.resourceExists(resourcePath + "/" + COLLECTION_MIME_TYPE_INDEX)) {
            resource = configSystemRegistry.newResource();
            resource.setDescription("This resource contains the media Types associated with collections on the Registry. Add, Edit or Delete properties to Manage Media Types.");
            configSystemRegistry.put(resourcePath + "/" + COLLECTION_MIME_TYPE_INDEX, resource);
        } else {
            resource = configSystemRegistry.get(resourcePath + "/" + COLLECTION_MIME_TYPE_INDEX);
        }
        Properties properties = resource.getProperties();
        if (properties.size() > 0) {
            Set<Object> keySet = properties.keySet();
            for (Object key : keySet) {
                String ext;
                if (!(key instanceof String) || RegistryUtils.isHiddenProperty(ext = (String)key)) continue;
                String value = resource.getProperty(ext);
                String mediaTypeMapping = ext + ":" + value;
                if (mediaTypeString == null) {
                    mediaTypeString = mediaTypeMapping;
                    continue;
                }
                mediaTypeString = mediaTypeString + "," + mediaTypeMapping;
            }
        }
        registryContext.setCollectionMediaTypes(mediaTypeString);
        return mediaTypeString;
    }

    public static String getCustomUIMediaTypeMappings(RegistryContext registryContext) throws RegistryException {
        if (registryContext == null) {
            return RegistryContext.getBaseInstance().getCustomUIMediaTypes();
        }
        return registryContext.getCustomUIMediaTypes();
    }

    public static String getCustomUIMediaTypeMappings(Registry configSystemRegistry) throws RegistryException {
        Resource resource;
        RegistryContext registryContext = configSystemRegistry.getRegistryContext();
        if (MediaTypesUtils.getCustomUIMediaTypeMappings(registryContext) != null) {
            return MediaTypesUtils.getCustomUIMediaTypeMappings(registryContext);
        }
        String mediaTypeString = null;
        String resourcePath = "/repository/components/org.wso2.carbon.governance/media-types/index";
        if (!configSystemRegistry.resourceExists(resourcePath)) {
            MediaTypesUtils.getResourceMediaTypeMappings(configSystemRegistry);
        }
        if (!configSystemRegistry.resourceExists(resourcePath + "/" + CUSTOM_UI_MIME_TYPE_INDEX)) {
            resource = configSystemRegistry.newResource();
            resource.setProperty("profiles", "application/vnd.wso2-profiles+xml");
            resource.setDescription("This resource contains the media Types associated with custom user interfaces on the Registry. Add, Edit or Delete properties to Manage Media Types.");
            configSystemRegistry.put(resourcePath + "/" + CUSTOM_UI_MIME_TYPE_INDEX, resource);
        } else {
            resource = configSystemRegistry.get(resourcePath + "/" + CUSTOM_UI_MIME_TYPE_INDEX);
        }
        Properties properties = resource.getProperties();
        if (properties.size() > 0) {
            Set<Object> keySet = properties.keySet();
            for (Object key : keySet) {
                String ext;
                if (!(key instanceof String) || RegistryUtils.isHiddenProperty(ext = (String)key)) continue;
                String value = resource.getProperty(ext);
                String mediaTypeMapping = ext + ":" + value;
                if (mediaTypeString == null) {
                    mediaTypeString = mediaTypeMapping;
                    continue;
                }
                mediaTypeString = mediaTypeString + "," + mediaTypeMapping;
            }
        }
        registryContext.setCustomUIMediaTypes(mediaTypeString);
        return mediaTypeString;
    }

    public static String getResourceMediaTypeMappings(RegistryContext registryContext) throws RegistryException {
        if (registryContext == null) {
            return RegistryContext.getBaseInstance().getResourceMediaTypes();
        }
        return registryContext.getResourceMediaTypes();
    }

    public static String getResourceMediaTypeMappings(Registry configSystemRegistry) throws RegistryException {
        BufferedReader reader;
        RegistryContext registryContext = configSystemRegistry.getRegistryContext();
        if (MediaTypesUtils.getResourceMediaTypeMappings(registryContext) != null) {
            return MediaTypesUtils.getResourceMediaTypeMappings(registryContext);
        }
        String mediaTypeString = null;
        String resourcePath = "/repository/components/org.wso2.carbon.governance/media-types/index";
        if (configSystemRegistry.resourceExists(resourcePath)) {
            Resource resource = configSystemRegistry.get(resourcePath);
            Properties properties = resource.getProperties();
            if (properties.size() > 0) {
                Set<Object> keySet = properties.keySet();
                for (Object key : keySet) {
                    String ext;
                    if (!(key instanceof String) || RegistryUtils.isHiddenProperty(ext = (String)key)) continue;
                    String value = resource.getProperty(ext);
                    String mediaTypeMapping = ext + ":" + value;
                    if (mediaTypeString == null) {
                        mediaTypeString = mediaTypeMapping;
                        continue;
                    }
                    mediaTypeString = mediaTypeString + "," + mediaTypeMapping;
                }
            }
            registryContext.setResourceMediaTypes(mediaTypeString);
            return mediaTypeString;
        }
        Collection resource = configSystemRegistry.newCollection();
        try {
            File mimeFile = MediaTypesUtils.getMediaTypesFile();
            reader = new BufferedReader(new InputStreamReader(new FileInputStream(mimeFile)));
        }
        catch (Exception e) {
            String msg = "Failed to read the the media type definitions file. Only a limited set of media type definitions will be populated. ";
            log.error((Object)msg, (Throwable)e);
            mediaTypeString = "txt:text/plain,jpg:image/jpeg,gif:image/gif";
            registryContext.setResourceMediaTypes(mediaTypeString);
            return mediaTypeString;
        }
        try {
            while (reader.ready()) {
                String[] extensions;
                String[] parts;
                String mediaTypeData = reader.readLine().trim();
                if (mediaTypeData.startsWith("#") || mediaTypeData.length() == 0 || mediaTypeData.indexOf(9) <= 0 || (parts = mediaTypeData.split("\t+")).length != 2 || parts[0].length() <= 0 || parts[1].length() <= 0) continue;
                for (String extension : extensions = parts[1].trim().split(" ")) {
                    if (extension.length() <= 0) continue;
                    String mediaTypeMapping = extension + ":" + parts[0];
                    resource.setProperty(extension, parts[0]);
                    mediaTypeString = mediaTypeString == null ? mediaTypeMapping : mediaTypeString + "," + mediaTypeMapping;
                }
            }
            resource.setDescription("This collection contains the media Types available for resources on the Registry. Add, Edit or Delete properties to Manage Media Types.");
            Collection collection = configSystemRegistry.newCollection();
            collection.setDescription("This collection lists the media types available on the Registry Server. Before changing an existing media type, please make sure to alter existing resources/collections and related configuration details.");
            configSystemRegistry.put(MIME_TYPE_COLLECTION, collection);
            configSystemRegistry.put(resourcePath, resource);
        }
        catch (IOException e) {
            String msg = "Could not read the media type mappings file from the location: ";
            throw new RegistryException(msg, e);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
        registryContext.setResourceMediaTypes(mediaTypeString);
        return mediaTypeString;
    }

    public static String getMediaType(String resourceName) throws RegistryException {
        if (resourceName == null || resourceName.indexOf(46) == -1 || resourceName.indexOf(46) + 1 >= resourceName.length()) {
            return null;
        }
        String extension = resourceName.substring(resourceName.lastIndexOf(46) + 1).toLowerCase();
        String mediaTypes = MediaTypesUtils.getResourceMediaTypeMappings(RegistryContext.getBaseInstance());
        if (mediaTypes == null) {
            return null;
        }
        if (mediaTypes.contains(extension = extension + ":")) {
            String temp = mediaTypes.substring(mediaTypes.indexOf(extension) + extension.length());
            if (temp.indexOf(44) == -1) {
                return temp;
            }
            return temp.substring(0, temp.indexOf(44));
        }
        return null;
    }

    private static File getMediaTypesFile() throws RegistryException {
        String carbonHome = System.getProperty("carbon.home");
        if (carbonHome == null) {
            carbonHome = System.getenv("CARBON_HOME");
        }
        if (carbonHome != null) {
            File mediaTypesFile = new File(CarbonUtils.getEtcCarbonConfigDirPath(), RESOURCE_MEDIA_TYPE_MAPPINGS_FILE);
            if (!mediaTypesFile.exists()) {
                String msg = "Resource media type definitions file (mime.types) file does not exist in the path " + CarbonUtils.getEtcCarbonConfigDirPath();
                log.error((Object)msg);
                throw new RegistryException(msg);
            }
            return mediaTypesFile;
        }
        String msg = "carbon.home system property is not set. It is required to to derive the path of the media type definitions file (mime.types).";
        log.error((Object)msg);
        throw new RegistryException(msg);
    }

    private static File getHumanMediaTypeMappingsFile() throws RegistryException {
        String carbonHome = System.getProperty("carbon.home");
        if (carbonHome == null) {
            carbonHome = System.getenv("CARBON_HOME");
        }
        if (carbonHome != null) {
            File mediaTypesFile = new File(CarbonUtils.getEtcCarbonConfigDirPath(), HUMAN_READABLE_MEDIA_TYPE_MAPPINGS_FILE);
            if (!mediaTypesFile.exists()) {
                String msg = "Resource human readable media type mappings file (mime.mappings) file does not exist in the path " + CarbonUtils.getEtcCarbonConfigDirPath();
                log.error((Object)msg);
                throw new RegistryException(msg);
            }
            return mediaTypesFile;
        }
        String msg = "carbon.home system property is not set. It is required to to derive the path of the media type definitions file (mime.types).";
        log.error((Object)msg);
        throw new RegistryException(msg);
    }

    private static void populateMediaTypeMappings() throws RegistryException {
        BufferedReader reader;
        humanReadableMediaTypeMap = new HashMap<String, String>();
        try {
            File mimeFile = MediaTypesUtils.getHumanMediaTypeMappingsFile();
            reader = new BufferedReader(new InputStreamReader(new FileInputStream(mimeFile)));
        }
        catch (Exception e) {
            String msg = FAILED_TO_READ_THE_THE_HUMAN_READABLE_MEDIA_TYPE_MIME_TYPE_MAPPINGS_FILE_MSG;
            log.warn((Object)msg, (Throwable)e);
            return;
        }
        try {
            while (reader.ready()) {
                String[] parts;
                String mediaTypeData = reader.readLine().trim();
                if (mediaTypeData.startsWith("#") || mediaTypeData.length() == 0 || mediaTypeData.indexOf(9) <= 0 || (parts = mediaTypeData.split("\t+")).length != 2 || parts[0].length() <= 0 || parts[1].length() <= 0) continue;
                humanReadableMediaTypeMap.put(parts[1], parts[0]);
            }
        }
        catch (IOException e) {
            String msg = FAILED_TO_READ_THE_THE_HUMAN_READABLE_MEDIA_TYPE_MIME_TYPE_MAPPINGS_FILE_MSG;
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg);
        }
        finally {
            try {
                reader.close();
                if (humanReadableMediaTypeMap == null) {
                    humanReadableMediaTypeMap = Collections.emptyMap();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static String getMimeTypeFromHumanReadableMediaType(String mediaType) {
        try {
            if (humanReadableMediaTypeMap == null) {
                MediaTypesUtils.populateMediaTypeMappings();
            }
            if (humanReadableMediaTypeMap.containsKey(mediaType)) {
                return humanReadableMediaTypeMap.get(mediaType);
            }
            return mediaType;
        }
        catch (RegistryException e) {
            String msg = FAILED_TO_READ_THE_THE_HUMAN_READABLE_MEDIA_TYPE_MIME_TYPE_MAPPINGS_FILE_MSG;
            log.error((Object)msg);
            return null;
        }
    }

    public static String getHumanReadableMediaTypeFromMimeType(String mediaType) {
        try {
            if (humanReadableMediaTypeMap == null) {
                MediaTypesUtils.populateMediaTypeMappings();
            }
            if (humanReadableMediaTypeMap.containsValue(mediaType)) {
                for (Map.Entry<String, String> entry : humanReadableMediaTypeMap.entrySet()) {
                    if (!entry.getValue().equals(mediaType)) continue;
                    return entry.getKey();
                }
            }
            return mediaType;
        }
        catch (RegistryException e) {
            String msg = FAILED_TO_READ_THE_THE_HUMAN_READABLE_MEDIA_TYPE_MIME_TYPE_MAPPINGS_FILE_MSG;
            log.error((Object)msg);
            return null;
        }
    }

    public static String getAllHumanTypes() {
        StringBuilder returnStringBuilder = new StringBuilder();
        String returnString = "";
        try {
            if (humanReadableMediaTypeMap == null) {
                MediaTypesUtils.populateMediaTypeMappings();
            }
            for (Map.Entry<String, String> entry : humanReadableMediaTypeMap.entrySet()) {
                returnStringBuilder.append(entry.getValue()).append(":").append(entry.getKey()).append(",");
            }
            returnString = returnStringBuilder.toString();
            if (returnString.endsWith(",")) {
                returnString = returnString.substring(0, returnString.lastIndexOf(44));
            }
        }
        catch (RegistryException e) {
            String msg = FAILED_TO_READ_THE_THE_HUMAN_READABLE_MEDIA_TYPE_MIME_TYPE_MAPPINGS_FILE_MSG;
            log.error((Object)msg);
        }
        return returnString;
    }
}

