/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.core.session;

import java.io.Reader;
import java.io.Writer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.api.RegistryException;
import org.wso2.carbon.registry.core.Aspect;
import org.wso2.carbon.registry.core.Association;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.CollectionImpl;
import org.wso2.carbon.registry.core.CollectionVersionImpl;
import org.wso2.carbon.registry.core.Comment;
import org.wso2.carbon.registry.core.LogEntry;
import org.wso2.carbon.registry.core.LogEntryCollection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourceImpl;
import org.wso2.carbon.registry.core.Tag;
import org.wso2.carbon.registry.core.TaggedResourcePath;
import org.wso2.carbon.registry.core.caching.CacheBackedRegistry;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.dao.ResourceDAO;
import org.wso2.carbon.registry.core.internal.RegistryDataHolder;
import org.wso2.carbon.registry.core.jdbc.EmbeddedRegistry;
import org.wso2.carbon.registry.core.jdbc.realm.RegistryRealm;
import org.wso2.carbon.registry.core.secure.AuthorizationFailedException;
import org.wso2.carbon.registry.core.session.ChrootWrapper;
import org.wso2.carbon.registry.core.session.CurrentSession;
import org.wso2.carbon.registry.core.utils.AuthorizationUtils;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class UserRegistry
implements Registry {
    private static final Log log = LogFactory.getLog(UserRegistry.class);
    private String userName;
    private int tenantId;
    private int callerTenantId;
    private RealmService realmService;
    private UserRealm userRealm;
    private Registry coreRegistry;
    private ChrootWrapper chrootWrapper;
    private boolean isRemoteRegistry;

    public UserRegistry(final String userName, final String password, final int tenantId, final Registry coreRegistry, final RealmService realmService, final String chroot) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    UserRegistry.this.init(userName, password, tenantId, coreRegistry, realmService, chroot);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (org.wso2.carbon.registry.core.exceptions.RegistryException)((Object)e.getException());
        }
    }

    private void init(String userName, String password, int tenantId, Registry coreRegistry, RealmService realmService, String chroot) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        String tenantUserName = userName;
        if (realmService == null) {
            String msg = "Unable to create an instance of a UserRegistry. The realm service wasnot specified.";
            log.error((Object)msg);
            throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg);
        }
        try {
            UserStoreManager authenticator;
            UserRealm tempUserRealm;
            if (!realmService.getTenantManager().isTenantActive(tenantId)) {
                String msg = "The tenant is not active. tenant id: " + tenantId + ".";
                log.error((Object)msg);
                throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg);
            }
            try {
                tempUserRealm = (UserRealm)realmService.getTenantUserRealm(tenantId);
            }
            catch (Exception e) {
                String msg = "Failed in getting the user realm for the tenant id: " + tenantId;
                log.error((Object)msg);
                throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg, e);
            }
            try {
                authenticator = tempUserRealm.getUserStoreManager();
            }
            catch (Exception e) {
                String msg = "Failed in getting the user realm for the tenant id: " + tenantId;
                log.error((Object)msg);
                throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg, e);
            }
            int tempTenantId = authenticator.getTenantId();
            if (tempTenantId != -1 && tempTenantId != -1234) {
                tenantUserName = MultitenantUtils.getTenantAwareUsername((String)userName);
            }
            if (!authenticator.authenticate(tenantUserName, (Object)password)) {
                String msg = "Attempted to authenticate invalid user.";
                log.warn((Object)msg);
                throw new AuthorizationFailedException(msg);
            }
        }
        catch (UserStoreException e) {
            String msg = "Could not obtain the authenticator for authenticating the user " + tenantUserName + ". \nCaused by " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg, e);
        }
        this.init(tenantUserName, tenantId, coreRegistry, realmService, chroot, false);
    }

    public UserRegistry getChrootedRegistry(String chroot) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        String newChroot = RegistryUtils.concatenateChroot(this.chrootWrapper.getBasePrefix(), chroot);
        return new UserRegistry(this.userName, this.tenantId, this.coreRegistry, this.realmService, newChroot);
    }

    public UserRegistry(String userName, int tenantId, Registry coreRegistry, RealmService realmService, String chroot) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        this(userName, tenantId, coreRegistry, realmService, chroot, false);
    }

    public UserRegistry(final String userName, final int tenantId, final Registry coreRegistry, final RealmService realmService, final String chroot, final boolean disableCaching) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    UserRegistry.this.init(userName, tenantId, coreRegistry, realmService, chroot, disableCaching);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (org.wso2.carbon.registry.core.exceptions.RegistryException)((Object)e.getException());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(String userName, int tenantId, Registry registry, RealmService realmService, String chroot, boolean disableCaching) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        RegistryContext registryContext = registry.getRegistryContext();
        this.coreRegistry = !disableCaching && registryContext.isCacheEnabled() && registry instanceof EmbeddedRegistry ? new CacheBackedRegistry(registry, tenantId) : registry;
        this.isRemoteRegistry = !(registry instanceof EmbeddedRegistry);
        this.chrootWrapper = new ChrootWrapper(chroot);
        this.callerTenantId = tenantId;
        this.tenantId = tenantId;
        this.realmService = realmService;
        this.userName = "wso2.system.user";
        if (realmService != null) {
            try {
                this.userRealm = new RegistryRealm(realmService.getBootstrapRealm());
            }
            catch (Exception e) {
                String msg = "Failed in getting the bootstrap realm for the tenantId: " + tenantId + ".";
                log.error((Object)msg);
                throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg, e);
            }
        }
        if (tenantId != -1234) {
            try {
                UserRealm realm = null;
                if (realmService != null) {
                    realm = (UserRealm)realmService.getTenantUserRealm(tenantId);
                } else {
                    realmService = RegistryDataHolder.getInstance().getRealmService();
                    realm = (UserRealm)realmService.getTenantUserRealm(tenantId);
                }
                if (realm == null) {
                    String msg = "Failed to obtain the user realm for tenant: " + tenantId + ".";
                    throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg);
                }
                this.userRealm = new RegistryRealm(realm);
            }
            catch (UserStoreException e) {
                String msg = "An error occurred while obtaining the user realm for the tenant: " + tenantId + ".";
                log.error((Object)msg);
                throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg, e);
            }
        }
        try {
            this.setSessionInformation();
            if (registryContext.isClone()) {
                try {
                    this.addRootCollection();
                }
                catch (Exception exception) {}
            } else {
                this.addRootCollection();
            }
            if (!registryContext.isClone()) {
                this.addSystemCollections();
            }
        }
        finally {
            this.clearSessionInformation();
        }
        this.userName = userName;
    }

    private void addSystemCollections() throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        if (this.userRealm == null) {
            log.debug((Object)"The UserRealm is not available. The system collection will not be added.");
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"adding system collections.");
        }
        try {
            this.setSessionInformation();
            RegistryUtils.addBaseCollectionStructure(this.coreRegistry, this.userRealm);
        }
        finally {
            this.clearSessionInformation();
        }
    }

    private void addRootCollection() throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        boolean isTransactionStarted = false;
        try {
            if (this.isRemoteRegistry || this.coreRegistry.getRegistryContext() == null || this.coreRegistry.getRegistryContext().getDataAccessManager() == null) {
                isTransactionStarted = this.startTransaction(isTransactionStarted);
                if (this.userRealm != null) {
                    AuthorizationUtils.setRootAuthorizations("/", this.userRealm);
                }
            } else {
                String chroot;
                boolean addAuthorizations;
                ResourceDAO resourceDAO = this.coreRegistry.getRegistryContext().getDataAccessManager().getDAOManager().getResourceDAO();
                if (log.isTraceEnabled()) {
                    log.trace((Object)"Checking the existence of the root collection of the Registry.");
                }
                boolean bl = addAuthorizations = !RegistryContext.getBaseInstance().isSystemResourcePathRegistered("/");
                if (!RegistryContext.getBaseInstance().isSystemResourcePathRegistered("/")) {
                    isTransactionStarted = this.startTransaction(isTransactionStarted);
                }
                if (RegistryUtils.systemResourceShouldBeAdded(resourceDAO, "/")) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)"Creating the root collection of the Registry.");
                    }
                    isTransactionStarted = this.startTransaction(isTransactionStarted);
                    CollectionImpl root = new CollectionImpl();
                    root.setUUID(UUID.randomUUID().toString());
                    resourceDAO.addRoot(root);
                }
                if (addAuthorizations && this.userRealm != null) {
                    isTransactionStarted = this.startTransaction(isTransactionStarted);
                    AuthorizationUtils.setRootAuthorizations("/", this.userRealm);
                }
                if ((chroot = this.chrootWrapper.getBasePrefix()) != null && !chroot.equals("/")) {
                    if (!RegistryContext.getBaseInstance().isSystemResourcePathRegistered(chroot)) {
                        isTransactionStarted = this.startTransaction(isTransactionStarted);
                    }
                    if (RegistryUtils.systemResourceShouldBeAdded(resourceDAO, chroot)) {
                        isTransactionStarted = this.startTransaction(isTransactionStarted);
                        CollectionImpl chrootColl = new CollectionImpl();
                        this.put("/", chrootColl);
                    }
                }
            }
            if (isTransactionStarted) {
                this.coreRegistry.commitTransaction();
            }
        }
        catch (Exception e) {
            String msg = "Failed to add the root collection to the coreRegistry.";
            log.fatal((Object)msg, (Throwable)e);
            if (isTransactionStarted) {
                this.coreRegistry.rollbackTransaction();
            }
            throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg, e);
        }
    }

    private boolean startTransaction(boolean status) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        if (!status) {
            this.coreRegistry.beginTransaction();
            status = true;
        }
        return status;
    }

    @Override
    public Resource newResource() throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Resource>(){

                @Override
                public Resource run() throws Exception {
                    return UserRegistry.this.newResourceInternal();
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (org.wso2.carbon.registry.core.exceptions.RegistryException)((Object)e.getException());
        }
    }

    private Resource newResourceInternal() throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Preparing operation new resource.");
        }
        try {
            this.setSessionInformation();
            Resource resource = this.coreRegistry.newResource();
            return resource;
        }
        finally {
            this.clearSessionInformation();
        }
    }

    @Override
    public Collection newCollection() throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Collection>(){

                @Override
                public Collection run() throws Exception {
                    return UserRegistry.this.newCollectionInternal();
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (org.wso2.carbon.registry.core.exceptions.RegistryException)((Object)e.getException());
        }
    }

    private Collection newCollectionInternal() throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Preparing operation new collection.");
        }
        try {
            this.setSessionInformation();
            Collection collection = this.coreRegistry.newCollection();
            return collection;
        }
        finally {
            this.clearSessionInformation();
        }
    }

    @Override
    public void beginTransaction() throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Preparing operation begin transaction.");
        }
        try {
            this.setSessionInformation();
            this.coreRegistry.beginTransaction();
        }
        finally {
            this.clearSessionInformation();
        }
    }

    @Override
    public void rollbackTransaction() throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Preparing operation rollback transaction.");
        }
        try {
            this.setSessionInformation();
            this.coreRegistry.rollbackTransaction();
        }
        finally {
            this.clearSessionInformation();
        }
    }

    @Override
    public void commitTransaction() throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Preparing operation commit transaction.");
        }
        try {
            this.setSessionInformation();
            this.coreRegistry.commitTransaction();
        }
        finally {
            this.clearSessionInformation();
        }
    }

    @Override
    public RegistryContext getRegistryContext() {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Preparing operation get registryContext.");
        }
        try {
            this.setSessionInformation();
            RegistryContext registryContext = this.coreRegistry.getRegistryContext();
            return registryContext;
        }
        finally {
            this.clearSessionInformation();
        }
    }

    public String getUserName() {
        return this.userName;
    }

    public int getTenantId() {
        return this.tenantId;
    }

    public int getCallerTenantId() {
        return this.callerTenantId;
    }

    public UserRealm getUserRealm() {
        return this.userRealm;
    }

    @Override
    public Resource get(final String path) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Resource>(){

                @Override
                public Resource run() throws Exception {
                    return UserRegistry.this.getInternal(path);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (org.wso2.carbon.registry.core.exceptions.RegistryException)((Object)e.getException());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Resource getInternal(String path) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        if (path == null) {
            throw new org.wso2.carbon.registry.core.exceptions.RegistryException("Resource path is null");
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Preparing operation get, path: " + path + "."));
        }
        try {
            this.setSessionInformation();
            ResourceImpl resource = (ResourceImpl)this.coreRegistry.get(this.chrootWrapper.getInPath(path));
            if (resource != null) {
                if (this.coreRegistry instanceof CacheBackedRegistry) {
                    resource = resource instanceof CollectionVersionImpl ? new CollectionVersionImpl((CollectionVersionImpl)resource) : (resource instanceof CollectionImpl ? new CollectionImpl((CollectionImpl)resource) : (resource instanceof Comment ? new Comment((Comment)resource) : new ResourceImpl(resource)));
                }
                resource.setUserName(this.userName);
                resource.setTenantId(this.tenantId);
                resource.setUserRealm(this.userRealm);
                resource = (ResourceImpl)this.chrootWrapper.getOutResource(resource);
            }
            ResourceImpl resourceImpl = resource;
            return resourceImpl;
        }
        finally {
            this.clearSessionInformation();
        }
    }

    @Override
    public Resource getMetaData(final String path) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Resource>(){

                @Override
                public Resource run() throws Exception {
                    return UserRegistry.this.getMetaDataInternal(path);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (org.wso2.carbon.registry.core.exceptions.RegistryException)((Object)e.getException());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Resource getMetaDataInternal(String path) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Preparing operation get meta data, path: " + path + "."));
        }
        try {
            this.setSessionInformation();
            ResourceImpl resource = (ResourceImpl)this.coreRegistry.getMetaData(this.chrootWrapper.getInPath(path));
            if (resource != null) {
                resource.setUserName(this.userName);
                resource.setTenantId(this.tenantId);
                resource.setUserRealm(this.userRealm);
                resource = (ResourceImpl)this.chrootWrapper.getOutResource(resource);
            }
            ResourceImpl resourceImpl = resource;
            return resourceImpl;
        }
        finally {
            this.clearSessionInformation();
        }
    }

    public String importResource(final String suggestedPath, final String sourceURL, final org.wso2.carbon.registry.api.Resource resource) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws Exception {
                    return UserRegistry.this.importResourceInternal(suggestedPath, sourceURL, resource);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (org.wso2.carbon.registry.core.exceptions.RegistryException)((Object)e.getException());
        }
    }

    private String importResourceInternal(String suggestedPath, String sourceURL, org.wso2.carbon.registry.api.Resource resource) throws RegistryException {
        return this.importResourceInternal(suggestedPath, sourceURL, (Resource)resource);
    }

    @Override
    public Collection get(final String path, final int start, final int pageSize) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Collection>(){

                @Override
                public Collection run() throws Exception {
                    return UserRegistry.this.getInternal(path, start, pageSize);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (org.wso2.carbon.registry.core.exceptions.RegistryException)((Object)e.getException());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection getInternal(String path, int start, int pageSize) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Preparing operation get with pagination, path: " + path + ", start: " + start + ", page size: " + pageSize + "."));
        }
        try {
            this.setSessionInformation();
            Collection collection = this.coreRegistry.get(this.chrootWrapper.getInPath(path), start, pageSize);
            if (collection != null) {
                if (this.coreRegistry instanceof CacheBackedRegistry) {
                    collection = collection instanceof CollectionVersionImpl ? new CollectionVersionImpl((CollectionVersionImpl)collection) : new CollectionImpl((CollectionImpl)collection);
                }
                ResourceImpl resourceImpl = (ResourceImpl)((Object)collection);
                resourceImpl.setUserName(this.userName);
                resourceImpl.setTenantId(this.tenantId);
                resourceImpl.setUserRealm(this.userRealm);
                collection = this.chrootWrapper.getOutCollection(collection);
            }
            Collection collection2 = collection;
            return collection2;
        }
        finally {
            this.clearSessionInformation();
        }
    }

    @Override
    public boolean resourceExists(final String path) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){

                @Override
                public Boolean run() throws Exception {
                    return UserRegistry.this.resourceExistsInternal(path);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (org.wso2.carbon.registry.core.exceptions.RegistryException)((Object)e.getException());
        }
    }

    private boolean resourceExistsInternal(String path) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Preparing operation resource exists, path: " + path + "."));
        }
        try {
            this.setSessionInformation();
            boolean bl = this.coreRegistry.resourceExists(this.chrootWrapper.getInPath(path));
            return bl;
        }
        finally {
            this.clearSessionInformation();
        }
    }

    public String put(final String suggestedPath, final org.wso2.carbon.registry.api.Resource resource) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws Exception {
                    return UserRegistry.this.putInternal(suggestedPath, resource);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (org.wso2.carbon.registry.core.exceptions.RegistryException)((Object)e.getException());
        }
    }

    private String putInternal(String suggestedPath, org.wso2.carbon.registry.api.Resource resource) throws RegistryException {
        return this.putInternal(suggestedPath, (Resource)resource);
    }

    @Override
    public String put(final String suggestedPath, final Resource resource) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws Exception {
                    return UserRegistry.this.putInternal(suggestedPath, resource);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (org.wso2.carbon.registry.core.exceptions.RegistryException)((Object)e.getException());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String putInternal(String suggestedPath, Resource resource) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Preparing operation put, path: " + suggestedPath + "."));
        }
        if (RegistryUtils.isRegistryReadOnly(this.coreRegistry.getRegistryContext())) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Cannot continue the operation put, the coreRegistry is read-only");
            }
            return suggestedPath;
        }
        try {
            this.setSessionInformation();
            String returningPath = this.coreRegistry.put(this.chrootWrapper.getInPath(suggestedPath), resource);
            String string = returningPath = this.chrootWrapper.getOutPath(returningPath);
            return string;
        }
        finally {
            this.clearSessionInformation();
        }
    }

    @Override
    public void delete(final String path) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws Exception {
                    UserRegistry.this.deleteInternal(path);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (org.wso2.carbon.registry.core.exceptions.RegistryException)((Object)e.getException());
        }
    }

    private void deleteInternal(String path) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Preparing operation delete, path: " + path + "."));
        }
        if (RegistryUtils.isRegistryReadOnly(this.coreRegistry.getRegistryContext())) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Cannot continue the operation delete, the coreRegistry is read-only");
            }
            return;
        }
        try {
            this.setSessionInformation();
            this.coreRegistry.delete(this.chrootWrapper.getInPath(path));
        }
        finally {
            this.clearSessionInformation();
        }
    }

    @Override
    public String importResource(final String suggestedPath, final String sourceURL, final Resource resource) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws Exception {
                    return UserRegistry.this.importResourceInternal(suggestedPath, sourceURL, resource);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (org.wso2.carbon.registry.core.exceptions.RegistryException)((Object)e.getException());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String importResourceInternal(String suggestedPath, String sourceURL, Resource resource) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Preparing operation import resource. path: " + suggestedPath + "."));
        }
        if (RegistryUtils.isRegistryReadOnly(this.coreRegistry.getRegistryContext())) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Cannot continue the operation import resource, the coreRegistry is read-only");
            }
            return suggestedPath;
        }
        try {
            this.setSessionInformation();
            String returnedPath = this.coreRegistry.importResource(this.chrootWrapper.getInPath(suggestedPath), sourceURL, resource);
            String string = returnedPath = this.chrootWrapper.getOutPath(returnedPath);
            return string;
        }
        finally {
            this.clearSessionInformation();
        }
    }

    @Override
    public String rename(final String currentPath, final String newName) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws Exception {
                    return UserRegistry.this.renameInternal(currentPath, newName);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (org.wso2.carbon.registry.core.exceptions.RegistryException)((Object)e.getException());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String renameInternal(String currentPath, String newPath) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Preparing operation rename. source: " + currentPath + ", target: " + newPath + "."));
        }
        if (RegistryUtils.isRegistryReadOnly(this.coreRegistry.getRegistryContext())) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Cannot continue the operation rename, the coreRegistry is read-only");
            }
            return currentPath;
        }
        try {
            String updatedNewPath = newPath;
            this.setSessionInformation();
            if (updatedNewPath.startsWith("/")) {
                updatedNewPath = this.chrootWrapper.getInPath(newPath);
            }
            String renamedPath = this.coreRegistry.rename(this.chrootWrapper.getInPath(currentPath), updatedNewPath);
            String string = renamedPath = this.chrootWrapper.getOutPath(renamedPath);
            return string;
        }
        finally {
            this.clearSessionInformation();
        }
    }

    @Override
    public String move(final String currentPath, final String newPath) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws Exception {
                    return UserRegistry.this.moveInternal(currentPath, newPath);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (org.wso2.carbon.registry.core.exceptions.RegistryException)((Object)e.getException());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String moveInternal(String currentPath, String newPath) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Preparing operation move. source: " + currentPath + ", target: " + newPath + "."));
        }
        if (RegistryUtils.isRegistryReadOnly(this.coreRegistry.getRegistryContext())) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Cannot continue the operation move, the coreRegistry is read-only");
            }
            return currentPath;
        }
        try {
            this.setSessionInformation();
            String movedPath = this.coreRegistry.move(this.chrootWrapper.getInPath(currentPath), this.chrootWrapper.getInPath(newPath));
            String string = movedPath = this.chrootWrapper.getOutPath(movedPath);
            return string;
        }
        finally {
            this.clearSessionInformation();
        }
    }

    @Override
    public String copy(final String sourcePath, final String targetPath) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws Exception {
                    return UserRegistry.this.copyInternal(sourcePath, targetPath);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (org.wso2.carbon.registry.core.exceptions.RegistryException)((Object)e.getException());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String copyInternal(String sourcePath, String targetPath) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Preparing operation copy. source: " + sourcePath + ", target: " + targetPath + "."));
        }
        if (RegistryUtils.isRegistryReadOnly(this.coreRegistry.getRegistryContext())) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Cannot continue the operation copy, the coreRegistry is read-only");
            }
            return sourcePath;
        }
        try {
            this.setSessionInformation();
            String copiedPath = this.coreRegistry.copy(this.chrootWrapper.getInPath(sourcePath), this.chrootWrapper.getInPath(targetPath));
            String string = copiedPath = this.chrootWrapper.getOutPath(copiedPath);
            return string;
        }
        finally {
            this.clearSessionInformation();
        }
    }

    @Override
    public void createVersion(final String path) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws Exception {
                    UserRegistry.this.createVersionInternal(path);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (org.wso2.carbon.registry.core.exceptions.RegistryException)((Object)e.getException());
        }
    }

    private void createVersionInternal(String path) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Preparing operation create version, path: " + path + "."));
        }
        if (RegistryUtils.isRegistryReadOnly(this.coreRegistry.getRegistryContext())) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Cannot continue the operation create version, the coreRegistry is read-only");
            }
            return;
        }
        try {
            this.setSessionInformation();
            this.coreRegistry.createVersion(this.chrootWrapper.getInPath(path));
        }
        finally {
            this.clearSessionInformation();
        }
    }

    @Override
    public String[] getVersions(final String path) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<String[]>(){

                @Override
                public String[] run() throws Exception {
                    return UserRegistry.this.getVersionsInternal(path);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (org.wso2.carbon.registry.core.exceptions.RegistryException)((Object)e.getException());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getVersionsInternal(String path) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Preparing operation get versions, path: " + path + "."));
        }
        try {
            this.setSessionInformation();
            String[] versionPaths = this.coreRegistry.getVersions(this.chrootWrapper.getInPath(path));
            String[] stringArray = versionPaths = this.chrootWrapper.getOutPaths(versionPaths);
            return stringArray;
        }
        finally {
            this.clearSessionInformation();
        }
    }

    @Override
    public void restoreVersion(final String versionPath) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws Exception {
                    UserRegistry.this.restoreVersionInternal(versionPath);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (org.wso2.carbon.registry.core.exceptions.RegistryException)((Object)e.getException());
        }
    }

    private void restoreVersionInternal(String versionPath) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Preparing operation restore version, version path: " + versionPath + "."));
        }
        if (RegistryUtils.isRegistryReadOnly(this.coreRegistry.getRegistryContext())) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Cannot continue the operation restore version, the coreRegistry is read-only");
            }
            return;
        }
        try {
            this.setSessionInformation();
            this.coreRegistry.restoreVersion(this.chrootWrapper.getInPath(versionPath));
        }
        finally {
            this.clearSessionInformation();
        }
    }

    @Override
    public void addAssociation(final String sourcePath, final String targetPath, final String associationType) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws Exception {
                    UserRegistry.this.addAssociationInternal(sourcePath, targetPath, associationType);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (org.wso2.carbon.registry.core.exceptions.RegistryException)((Object)e.getException());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAssociationInternal(String sourcePath, String targetPath, String associationType) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Preparing operation add association, source: " + sourcePath + ", target: " + targetPath + ", type: " + associationType + "."));
        }
        if (RegistryUtils.isRegistryReadOnly(this.coreRegistry.getRegistryContext())) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Cannot continue the operation add association, the coreRegistry is read-only");
            }
            return;
        }
        try {
            this.setSessionInformation();
            String updatedTargetPath = targetPath;
            if (!updatedTargetPath.matches("^[a-zA-Z]+://.*")) {
                updatedTargetPath = this.chrootWrapper.getInPath(targetPath);
            }
            this.coreRegistry.addAssociation(this.chrootWrapper.getInPath(sourcePath), updatedTargetPath, associationType);
        }
        finally {
            this.clearSessionInformation();
        }
    }

    @Override
    public void removeAssociation(final String sourcePath, final String targetPath, final String associationType) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws Exception {
                    UserRegistry.this.removeAssociationInternal(sourcePath, targetPath, associationType);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (org.wso2.carbon.registry.core.exceptions.RegistryException)((Object)e.getException());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAssociationInternal(String sourcePath, String associationPath, String associationType) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Preparing operation remove association, source: " + sourcePath + ", path: " + associationPath + ", type: " + associationType + "."));
        }
        if (RegistryUtils.isRegistryReadOnly(this.coreRegistry.getRegistryContext())) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Cannot continue the operation remove associations, the coreRegistry is read-only");
            }
            return;
        }
        try {
            this.setSessionInformation();
            String updatedAssociationPath = associationPath;
            if (!updatedAssociationPath.matches("^[a-zA-Z]+://.*")) {
                updatedAssociationPath = this.chrootWrapper.getInPath(associationPath);
            }
            this.coreRegistry.removeAssociation(this.chrootWrapper.getInPath(sourcePath), updatedAssociationPath, associationType);
        }
        finally {
            this.clearSessionInformation();
        }
    }

    @Override
    public Association[] getAllAssociations(final String resourcePath) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Association[]>(){

                @Override
                public Association[] run() throws Exception {
                    return UserRegistry.this.getAllAssociationsInternal(resourcePath);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (org.wso2.carbon.registry.core.exceptions.RegistryException)((Object)e.getException());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Association[] getAllAssociationsInternal(String resourcePath) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Preparing operation get all associations, path: " + resourcePath + "."));
        }
        try {
            this.setSessionInformation();
            Association[] associations = this.coreRegistry.getAllAssociations(this.chrootWrapper.getInPath(resourcePath));
            Association[] associationArray = associations = this.chrootWrapper.getOutAssociations(associations);
            return associationArray;
        }
        finally {
            this.clearSessionInformation();
        }
    }

    @Override
    public Association[] getAssociations(final String resourcePath, final String associationType) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Association[]>(){

                @Override
                public Association[] run() throws Exception {
                    return UserRegistry.this.getAssociationsInternal(resourcePath, associationType);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (org.wso2.carbon.registry.core.exceptions.RegistryException)((Object)e.getException());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Association[] getAssociationsInternal(String resourcePath, String associationType) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Preparing operation get associations, path: " + resourcePath + ", association type: " + associationType + "."));
        }
        try {
            this.setSessionInformation();
            Association[] associations = this.coreRegistry.getAssociations(this.chrootWrapper.getInPath(resourcePath), associationType);
            Association[] associationArray = associations = this.chrootWrapper.getOutAssociations(associations);
            return associationArray;
        }
        finally {
            this.clearSessionInformation();
        }
    }

    @Override
    public void applyTag(final String resourcePath, final String tag) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws Exception {
                    UserRegistry.this.applyTagInternal(resourcePath, tag);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (org.wso2.carbon.registry.core.exceptions.RegistryException)((Object)e.getException());
        }
    }

    private void applyTagInternal(String resourcePath, String tag) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Preparing operation apply tag, path: " + resourcePath + ", tag: " + tag + "."));
        }
        if (RegistryUtils.isRegistryReadOnly(this.coreRegistry.getRegistryContext())) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Cannot continue the operation apply tag, the coreRegistry is read-only");
            }
            return;
        }
        try {
            this.setSessionInformation();
            this.coreRegistry.applyTag(this.chrootWrapper.getInPath(resourcePath), tag);
        }
        finally {
            this.clearSessionInformation();
        }
    }

    @Override
    public TaggedResourcePath[] getResourcePathsWithTag(final String tag) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<TaggedResourcePath[]>(){

                @Override
                public TaggedResourcePath[] run() throws Exception {
                    return UserRegistry.this.getResourcePathsWithTagInternal(tag);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (org.wso2.carbon.registry.core.exceptions.RegistryException)((Object)e.getException());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TaggedResourcePath[] getResourcePathsWithTagInternal(String tag) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Preparing operation get resource paths with tags, tag: " + tag + "."));
        }
        try {
            this.setSessionInformation();
            TaggedResourcePath[] taggedResourcePaths = this.coreRegistry.getResourcePathsWithTag(tag);
            TaggedResourcePath[] taggedResourcePathArray = taggedResourcePaths = this.chrootWrapper.getOutTaggedResourcePaths(taggedResourcePaths);
            return taggedResourcePathArray;
        }
        finally {
            this.clearSessionInformation();
        }
    }

    @Override
    public Tag[] getTags(final String resourcePath) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Tag[]>(){

                @Override
                public Tag[] run() throws Exception {
                    return UserRegistry.this.getTagsInternal(resourcePath);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (org.wso2.carbon.registry.core.exceptions.RegistryException)((Object)e.getException());
        }
    }

    private Tag[] getTagsInternal(String resourcePath) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Preparing operation get tags, path: " + resourcePath + "."));
        }
        try {
            this.setSessionInformation();
            Tag[] tagArray = this.coreRegistry.getTags(this.chrootWrapper.getInPath(resourcePath));
            return tagArray;
        }
        finally {
            this.clearSessionInformation();
        }
    }

    @Override
    public void removeTag(final String path, final String tag) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws Exception {
                    UserRegistry.this.removeTagInternal(path, tag);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (org.wso2.carbon.registry.core.exceptions.RegistryException)((Object)e.getException());
        }
    }

    private void removeTagInternal(String path, String tag) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Preparing operation remove tag, path: " + path + ", tag: " + tag + "."));
        }
        if (RegistryUtils.isRegistryReadOnly(this.coreRegistry.getRegistryContext())) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Cannot continue the operation remove tag, the coreRegistry is read-only");
            }
            return;
        }
        try {
            this.setSessionInformation();
            this.coreRegistry.removeTag(this.chrootWrapper.getInPath(path), tag);
        }
        finally {
            this.clearSessionInformation();
        }
    }

    public String addComment(final String resourcePath, final org.wso2.carbon.registry.api.Comment comment) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws Exception {
                    return UserRegistry.this.addCommentInternal(resourcePath, comment);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (org.wso2.carbon.registry.core.exceptions.RegistryException)((Object)e.getException());
        }
    }

    private String addCommentInternal(String resourcePath, org.wso2.carbon.registry.api.Comment comment) throws RegistryException {
        return this.addCommentInternal(resourcePath, (Comment)comment);
    }

    @Override
    public String addComment(final String resourcePath, final Comment comment) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws Exception {
                    return UserRegistry.this.addCommentInternal(resourcePath, comment);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (org.wso2.carbon.registry.core.exceptions.RegistryException)((Object)e.getException());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String addCommentInternal(String resourcePath, Comment comment) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Preparing operation add comment, path: " + resourcePath + "."));
        }
        if (RegistryUtils.isRegistryReadOnly(this.coreRegistry.getRegistryContext())) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Cannot continue the operation add comment, the coreRegistry is read-only");
            }
            return resourcePath;
        }
        try {
            this.setSessionInformation();
            String commentPath = this.coreRegistry.addComment(this.chrootWrapper.getInPath(resourcePath), comment);
            String string = this.chrootWrapper.getOutPath(commentPath);
            return string;
        }
        finally {
            this.clearSessionInformation();
        }
    }

    @Override
    public void editComment(final String commentPath, final String text) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws Exception {
                    UserRegistry.this.editCommentInternal(commentPath, text);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (org.wso2.carbon.registry.core.exceptions.RegistryException)((Object)e.getException());
        }
    }

    private void editCommentInternal(String commentPath, String text) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Preparing operation edit comment, path: " + commentPath + "."));
        }
        if (RegistryUtils.isRegistryReadOnly(this.coreRegistry.getRegistryContext())) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Cannot continue the operation edit comment, the coreRegistry is read-only");
            }
            return;
        }
        try {
            this.setSessionInformation();
            this.coreRegistry.editComment(this.chrootWrapper.getInPath(commentPath), text);
        }
        finally {
            this.clearSessionInformation();
        }
    }

    @Override
    public void removeComment(final String commentPath) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws Exception {
                    UserRegistry.this.removeCommentInternal(commentPath);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (org.wso2.carbon.registry.core.exceptions.RegistryException)((Object)e.getException());
        }
    }

    private void removeCommentInternal(String commentPath) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Preparing operation edit comment, path: " + commentPath + "."));
        }
        if (RegistryUtils.isRegistryReadOnly(this.coreRegistry.getRegistryContext())) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Cannot continue the operation edit comment, the coreRegistry is read-only");
            }
            return;
        }
        try {
            this.setSessionInformation();
            this.coreRegistry.removeComment(this.chrootWrapper.getInPath(commentPath));
        }
        finally {
            this.clearSessionInformation();
        }
    }

    @Override
    public Comment[] getComments(final String resourcePath) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Comment[]>(){

                @Override
                public Comment[] run() throws Exception {
                    return UserRegistry.this.getCommentsInternal(resourcePath);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (org.wso2.carbon.registry.core.exceptions.RegistryException)((Object)e.getException());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Comment[] getCommentsInternal(String resourcePath) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Preparing operation get comments, path: " + resourcePath + "."));
        }
        try {
            this.setSessionInformation();
            Comment[] returnedComments = this.coreRegistry.getComments(this.chrootWrapper.getInPath(resourcePath));
            Comment[] commentArray = returnedComments = this.chrootWrapper.getOutComments(returnedComments);
            return commentArray;
        }
        finally {
            this.clearSessionInformation();
        }
    }

    @Override
    public void rateResource(final String resourcePath, final int rating) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws Exception {
                    UserRegistry.this.rateResourceInternal(resourcePath, rating);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (org.wso2.carbon.registry.core.exceptions.RegistryException)((Object)e.getException());
        }
    }

    private void rateResourceInternal(String resourcePath, int rating) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Preparing operation rate resource, path: " + resourcePath + ", rating: " + rating + "."));
        }
        if (RegistryUtils.isRegistryReadOnly(this.coreRegistry.getRegistryContext())) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Cannot continue the operation rate resource, the coreRegistry is read-only");
            }
            return;
        }
        try {
            this.setSessionInformation();
            this.coreRegistry.rateResource(this.chrootWrapper.getInPath(resourcePath), rating);
        }
        finally {
            this.clearSessionInformation();
        }
    }

    @Override
    public float getAverageRating(final String resourcePath) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Float>(){

                @Override
                public Float run() throws Exception {
                    return Float.valueOf(UserRegistry.this.getAverageRatingInternal(resourcePath));
                }
            }).floatValue();
        }
        catch (PrivilegedActionException e) {
            throw (org.wso2.carbon.registry.core.exceptions.RegistryException)((Object)e.getException());
        }
    }

    private float getAverageRatingInternal(String resourcePath) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Preparing operation get average ratings, path: " + resourcePath + "."));
        }
        try {
            this.setSessionInformation();
            float f = this.coreRegistry.getAverageRating(this.chrootWrapper.getInPath(resourcePath));
            return f;
        }
        finally {
            this.clearSessionInformation();
        }
    }

    @Override
    public int getRating(final String path, final String userName) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Integer>(){

                @Override
                public Integer run() throws Exception {
                    return UserRegistry.this.getRatingInternal(path, userName);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (org.wso2.carbon.registry.core.exceptions.RegistryException)((Object)e.getException());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getRatingInternal(String path, String userName) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Preparing operation get ratings, path: " + path + ", user name: " + userName + "."));
        }
        try {
            this.setSessionInformation();
            int n = this.coreRegistry.getRating(this.chrootWrapper.getInPath(path), userName);
            return n;
        }
        finally {
            this.clearSessionInformation();
        }
    }

    @Override
    public Collection executeQuery(final String path, final Map parameters) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Collection>(){

                @Override
                public Collection run() throws Exception {
                    return UserRegistry.this.executeQueryInternal(path, parameters);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (org.wso2.carbon.registry.core.exceptions.RegistryException)((Object)e.getException());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection executeQueryInternal(String path, Map parameters) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        if (log.isTraceEnabled()) {
            String msg = "Preparing operation execute query, path: " + path + ", values: ";
            Object[] paramValues = parameters.values().toArray();
            StringBuilder sb = new StringBuilder(msg);
            for (int i = 0; i < paramValues.length; ++i) {
                String value = (String)paramValues[i];
                sb.append(value);
                if (i != paramValues.length - 1) {
                    sb.append(", ");
                    continue;
                }
                sb.append(".");
            }
            log.trace((Object)sb.toString());
        }
        try {
            Collection collection;
            this.setSessionInformation();
            if (path != null) {
                String newPath = this.chrootWrapper.getInPath(path);
                if (newPath != null) {
                    path = newPath.replace("/_system/governance", "/_system/config").replace("/_system/local", "/_system/config");
                    if (!path.contains("/_system/config") && !path.equals(this.chrootWrapper.getInPath("/"))) {
                        log.warn((Object)("Running Query in Backwards-Compatible mode. Queries must be stored and accessed from the Configuration System Registry in the new model. Path: " + path));
                    }
                } else {
                    path = null;
                }
            }
            if ((collection = this.coreRegistry.executeQuery(path, parameters)) != null) {
                ResourceImpl resourceImpl = (ResourceImpl)((Object)collection);
                resourceImpl.setUserName(this.userName);
                resourceImpl.setTenantId(this.tenantId);
                resourceImpl.setUserRealm(this.userRealm);
                collection = this.chrootWrapper.filterSearchResult(collection);
                collection = (Collection)this.chrootWrapper.getOutResource(collection);
            }
            Collection collection2 = collection;
            return collection2;
        }
        finally {
            this.clearSessionInformation();
        }
    }

    @Override
    public LogEntry[] getLogs(final String resourcePath, final int action, final String userName, final Date from, final Date to, final boolean recentFirst) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<LogEntry[]>(){

                @Override
                public LogEntry[] run() throws Exception {
                    return UserRegistry.this.getLogsInternal(resourcePath, action, userName, from, to, recentFirst);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (org.wso2.carbon.registry.core.exceptions.RegistryException)((Object)e.getException());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LogEntry[] getLogsInternal(String resourcePath, int action, String userName, Date from, Date to, boolean recentFirst) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Preparing operation get logs, resource path: " + resourcePath + ", action: " + action + ", user name: " + userName + ", from: " + from + ", to: " + to + ", recent first: " + recentFirst + "."));
        }
        try {
            this.setSessionInformation();
            LogEntry[] logEntries = this.coreRegistry.getLogs(this.chrootWrapper.getInPath(resourcePath), action, userName, from, to, recentFirst);
            LogEntry[] logEntryArray = this.chrootWrapper.fixLogEntries(logEntries);
            return logEntryArray;
        }
        finally {
            this.clearSessionInformation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LogEntryCollection getLogCollection(String resourcePath, int action, String userName, Date from, Date to, boolean recentFirst) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Preparing operation get logs, resource path: " + resourcePath + ", action: " + action + ", user name: " + userName + ", from: " + from + ", to: " + to + ", recent first: " + recentFirst + "."));
        }
        try {
            this.setSessionInformation();
            LogEntryCollection logEntryCollection = this.coreRegistry.getLogCollection(this.chrootWrapper.getInPath(resourcePath), action, userName, from, to, recentFirst);
            return logEntryCollection;
        }
        finally {
            this.clearSessionInformation();
        }
    }

    @Override
    public String[] getAvailableAspects() {
        return AccessController.doPrivileged(new PrivilegedAction<String[]>(){

            @Override
            public String[] run() {
                return UserRegistry.this.getAvailableAspectsInternal();
            }
        });
    }

    private String[] getAvailableAspectsInternal() {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Preparing operation get available actions.");
        }
        try {
            this.setSessionInformation();
            String[] stringArray = this.coreRegistry.getAvailableAspects();
            return stringArray;
        }
        finally {
            this.clearSessionInformation();
        }
    }

    @Override
    public void associateAspect(final String resourcePath, final String aspect) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws Exception {
                    UserRegistry.this.associateAspectInternal(resourcePath, aspect);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (org.wso2.carbon.registry.core.exceptions.RegistryException)((Object)e.getException());
        }
    }

    private void associateAspectInternal(String resourcePath, String aspect) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Preparing operation associate aspect, path: " + resourcePath + ", aspect: " + aspect + "."));
        }
        if (RegistryUtils.isRegistryReadOnly(this.coreRegistry.getRegistryContext())) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Cannot continue the operation associate aspect, the coreRegistry is read-only");
            }
            return;
        }
        try {
            this.setSessionInformation();
            this.coreRegistry.associateAspect(this.chrootWrapper.getInPath(resourcePath), aspect);
        }
        finally {
            this.clearSessionInformation();
        }
    }

    @Override
    public void invokeAspect(final String resourcePath, final String aspectName, final String action) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws Exception {
                    UserRegistry.this.invokeAspectInternal(resourcePath, aspectName, action);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (org.wso2.carbon.registry.core.exceptions.RegistryException)((Object)e.getException());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeAspectInternal(String resourcePath, String aspectName, String action) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Preparing operation invoke aspects, path: " + resourcePath + ", aspect name: " + aspectName + ", action: " + action + "."));
        }
        try {
            this.setSessionInformation();
            this.coreRegistry.invokeAspect(this.chrootWrapper.getInPath(resourcePath), aspectName, action);
        }
        finally {
            this.clearSessionInformation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invokeAspect(String resourcePath, String aspectName, String action, Map<String, String> parameters) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Preparing operation invoke aspects, path: " + resourcePath + ", aspect name: " + aspectName + ", action: " + action + "."));
        }
        try {
            this.setSessionInformation();
            this.coreRegistry.invokeAspect(this.chrootWrapper.getInPath(resourcePath), aspectName, action, parameters);
        }
        finally {
            this.clearSessionInformation();
        }
    }

    @Override
    public boolean removeAspect(String aspect) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Preparing operation remove Aspect, Aspect Name: " + aspect));
        }
        try {
            this.setSessionInformation();
            boolean bl = this.coreRegistry.removeAspect(aspect);
            return bl;
        }
        finally {
            this.clearSessionInformation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAspect(String name, Aspect aspect) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Preparing operation remove Aspect, Aspect Name: " + aspect));
        }
        try {
            this.setSessionInformation();
            boolean bl = this.coreRegistry.addAspect(name, aspect);
            return bl;
        }
        finally {
            this.clearSessionInformation();
        }
    }

    @Override
    public String[] getAspectActions(final String resourcePath, final String aspectName) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<String[]>(){

                @Override
                public String[] run() throws Exception {
                    return UserRegistry.this.getAspectActionsInternal(resourcePath, aspectName);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (org.wso2.carbon.registry.core.exceptions.RegistryException)((Object)e.getException());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getAspectActionsInternal(String resourcePath, String aspectName) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Preparing operation get aspect actions, path: " + resourcePath + ", aspect name: " + aspectName + "."));
        }
        try {
            this.setSessionInformation();
            String[] stringArray = this.coreRegistry.getAspectActions(this.chrootWrapper.getInPath(resourcePath), aspectName);
            return stringArray;
        }
        finally {
            this.clearSessionInformation();
        }
    }

    @Override
    public Collection searchContent(final String keywords) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Collection>(){

                @Override
                public Collection run() throws Exception {
                    return UserRegistry.this.searchContentInternal(keywords);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (org.wso2.carbon.registry.core.exceptions.RegistryException)((Object)e.getException());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection searchContentInternal(String keywords) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Preparing operation search content, keywords: " + keywords + "."));
        }
        try {
            this.setSessionInformation();
            Collection collection = this.coreRegistry.searchContent(keywords);
            if (collection != null) {
                ResourceImpl resourceImpl = (ResourceImpl)((Object)collection);
                resourceImpl.setUserName(this.userName);
                resourceImpl.setTenantId(this.tenantId);
                resourceImpl.setUserRealm(this.userRealm);
                collection = this.chrootWrapper.filterSearchResult(collection);
                collection = (Collection)this.chrootWrapper.getOutResource(collection);
            }
            Collection collection2 = collection;
            return collection2;
        }
        finally {
            this.clearSessionInformation();
        }
    }

    @Override
    public void createLink(final String path, final String target) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws Exception {
                    UserRegistry.this.createLinkInternal(path, target);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (org.wso2.carbon.registry.core.exceptions.RegistryException)((Object)e.getException());
        }
    }

    private void createLinkInternal(String path, String target) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Preparing operation create link, path: " + path + ", target: " + target + "."));
        }
        if (RegistryUtils.isRegistryReadOnly(this.coreRegistry.getRegistryContext())) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Cannot continue the operation create link, the coreRegistry is read-only");
            }
            return;
        }
        try {
            this.setSessionInformation();
            this.coreRegistry.createLink(this.chrootWrapper.getInPath(path), this.chrootWrapper.getInPath(target));
        }
        finally {
            this.clearSessionInformation();
        }
    }

    @Override
    public void createLink(final String path, final String target, final String subTargetPath) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws Exception {
                    UserRegistry.this.createLinkInternal(path, target, subTargetPath);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (org.wso2.carbon.registry.core.exceptions.RegistryException)((Object)e.getException());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createLinkInternal(String path, String target, String targetSubPath) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Preparing operation create link, path: " + path + ", target: " + target + ", target sub path: " + targetSubPath + "."));
        }
        if (RegistryUtils.isRegistryReadOnly(this.coreRegistry.getRegistryContext())) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Cannot continue the operation create link, the coreRegistry is read-only");
            }
            return;
        }
        try {
            this.setSessionInformation();
            this.coreRegistry.createLink(this.chrootWrapper.getInPath(path), target, targetSubPath);
        }
        finally {
            this.clearSessionInformation();
        }
    }

    @Override
    public void removeLink(final String path) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws Exception {
                    UserRegistry.this.removeLinkInternal(path);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (org.wso2.carbon.registry.core.exceptions.RegistryException)((Object)e.getException());
        }
    }

    private void removeLinkInternal(String path) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Preparing operation remove link, path: " + path + "."));
        }
        if (RegistryUtils.isRegistryReadOnly(this.coreRegistry.getRegistryContext())) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Cannot continue the operation remove link, the coreRegistry is read-only");
            }
            return;
        }
        try {
            this.setSessionInformation();
            this.coreRegistry.removeLink(this.chrootWrapper.getInPath(path));
        }
        finally {
            this.clearSessionInformation();
        }
    }

    @Override
    public void restore(final String path, final Reader reader) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws Exception {
                    UserRegistry.this.restoreInternal(path, reader);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (org.wso2.carbon.registry.core.exceptions.RegistryException)((Object)e.getException());
        }
    }

    private void restoreInternal(String path, Reader reader) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Preparing operation restore dump, path: " + path + "."));
        }
        if (RegistryUtils.isRegistryReadOnly(this.coreRegistry.getRegistryContext())) {
            log.warn((Object)"Cannot continue the operation restore dump, the coreRegistry is read-only");
            return;
        }
        try {
            this.setSessionInformation();
            this.coreRegistry.restore(this.chrootWrapper.getInPath(path), reader);
        }
        finally {
            this.clearSessionInformation();
        }
    }

    @Override
    public void dump(final String path, final Writer writer) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws Exception {
                    UserRegistry.this.dumpInternal(path, writer);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (org.wso2.carbon.registry.core.exceptions.RegistryException)((Object)e.getException());
        }
    }

    private void dumpInternal(String path, Writer writer) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Preparing operation dump, path: " + path + "."));
        }
        try {
            this.setSessionInformation();
            this.coreRegistry.dump(this.chrootWrapper.getInPath(path), writer);
        }
        finally {
            this.clearSessionInformation();
        }
    }

    @Override
    public String getEventingServiceURL(final String path) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws Exception {
                    return UserRegistry.this.getEventingServiceURLInternal(path);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (org.wso2.carbon.registry.core.exceptions.RegistryException)((Object)e.getException());
        }
    }

    private String getEventingServiceURLInternal(String path) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Preparing operation get eventing service url, path: " + path + "."));
        }
        String eventingServiceURL = null;
        try {
            this.setSessionInformation();
            eventingServiceURL = this.coreRegistry.getEventingServiceURL(this.chrootWrapper.getInPath(path));
        }
        finally {
            this.clearSessionInformation();
        }
        return eventingServiceURL;
    }

    @Override
    public void setEventingServiceURL(final String path, final String eventingServiceURL) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws Exception {
                    UserRegistry.this.setEventingServiceURLInternal(path, eventingServiceURL);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (org.wso2.carbon.registry.core.exceptions.RegistryException)((Object)e.getException());
        }
    }

    private void setEventingServiceURLInternal(String path, String eventingServiceURL) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Preparing operation set eventing service url, path: " + path + ", eventing service url: " + eventingServiceURL + "."));
        }
        if (RegistryUtils.isRegistryReadOnly(this.coreRegistry.getRegistryContext())) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Cannot continue the operation eventing service url, the coreRegistry is read-only");
            }
            return;
        }
        try {
            this.setSessionInformation();
            this.coreRegistry.setEventingServiceURL(this.chrootWrapper.getInPath(path), eventingServiceURL);
        }
        finally {
            this.clearSessionInformation();
        }
    }

    public final void setSessionInformation() {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Setting the session for registry operation, chroot: " + this.chrootWrapper.getBasePrefix() + ", username: " + this.userName + ", tenantId: " + this.tenantId + ", callerTenantId: " + this.callerTenantId + "."));
        }
        CurrentSession.setUser(this.userName);
        if (this.userRealm != null) {
            CurrentSession.setUserRealm(this.userRealm);
        }
        CurrentSession.setTenantId(this.tenantId);
        CurrentSession.setCallerTenantId(this.callerTenantId);
        CurrentSession.setChroot(this.chrootWrapper.getBasePrefix());
        CurrentSession.setUserRegistry(this);
    }

    private final void clearSessionInformation() {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Clearing the session for registry operation, chroot: " + this.chrootWrapper.getBasePrefix() + ", username: " + CurrentSession.getUser() + ", tenantId: " + CurrentSession.getTenantId() + "."));
        }
        CurrentSession.removeUser();
        CurrentSession.removeUserRealm();
        CurrentSession.removeTenantId();
        CurrentSession.removeCallerTenantId();
        CurrentSession.removeChroot();
        CurrentSession.removeUserRegistry();
        if (CurrentSession.getUserRegistry() == null) {
            CurrentSession.removeAttributes();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeVersionHistory(String path, long snapshotId) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        if (RegistryUtils.isRegistryReadOnly(this.coreRegistry.getRegistryContext())) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Cannot continue the operation removing the version history, the coreRegistry is read-only");
            }
            return false;
        }
        try {
            this.setSessionInformation();
            boolean bl = this.coreRegistry.removeVersionHistory(path, snapshotId);
            return bl;
        }
        finally {
            this.clearSessionInformation();
        }
    }

    @Override
    public void dumpLite(String path, Writer writer) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Preparing operation dump, path: " + path + "."));
        }
        try {
            this.setSessionInformation();
            this.coreRegistry.dumpLite(this.chrootWrapper.getInPath(path), writer);
        }
        finally {
            this.clearSessionInformation();
        }
    }
}

