/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.core.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Date;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.axiom.om.util.Base64;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.EmbeddedRegistryService;
import org.wso2.carbon.registry.core.secure.AuthorizationFailedException;
import org.wso2.carbon.registry.core.servlet.utils.Utils;
import org.wso2.carbon.registry.core.session.UserRegistry;

@Deprecated
public final class ResourceRequestProcessor {
    private ResourceRequestProcessor() {
    }

    public static void processResourceGET(HttpServletRequest request, HttpServletResponse response, String path) throws IOException {
        Resource resource;
        try {
            String credentials;
            String decodedCredentials;
            String[] cParts;
            String[] aParts;
            String auth = request.getHeader("Authorization");
            if (auth != null && auth.length() > 0 && (aParts = auth.trim().split(" ")).length == 2 && (cParts = (decodedCredentials = new String(Base64.decode((String)(credentials = aParts[1])))).trim().split(":")).length == 2) {
                String userName = cParts[0];
                String password = cParts[1];
                Utils.logInUser(request, userName, password);
            }
            resource = ResourceRequestProcessor.getResource(request, path);
        }
        catch (AuthorizationFailedException ae) {
            response.setStatus(401);
            if (!Utils.isLoggedIn(request)) {
                response.setHeader("WWW-Authenticate", "Basic realm=\"WSO2-Registry\"");
            }
            try {
                response.getWriter().flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return;
        }
        catch (RegistryException e) {
            request.getSession().setAttribute("error.message", (Object)e.getMessage());
            request.getRequestDispatcher("/admin/error.jsp");
            return;
        }
        if (resource == null) {
            response.setStatus(404);
            request.getSession().setAttribute("error.message", (Object)"404 Not Found");
            request.getRequestDispatcher("/admin/error.jsp");
            return;
        }
        long modifiedSince = request.getDateHeader("If-Modified-Since");
        if (modifiedSince > 0L && !resource.getLastModified().after(new Date(modifiedSince))) {
            response.setStatus(304);
            response.getWriter().flush();
            return;
        }
        if (resource instanceof Collection) {
            response.sendRedirect("/wso2registry/web" + path);
        } else {
            ResourceRequestProcessor.sendResourceContent(request, response, path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sendResourceContent(HttpServletRequest request, HttpServletResponse response, String path) {
        block12: {
            try {
                Resource resource = ResourceRequestProcessor.getResource(request, path);
                try {
                    response.setDateHeader("Last-Modified", resource.getLastModified().getTime());
                    if (resource.getMediaType() != null && resource.getMediaType().length() > 0) {
                        response.setContentType(resource.getMediaType());
                    } else {
                        response.setContentType("application/download");
                    }
                    InputStream contentStream = resource.getContentStream();
                    if (contentStream != null) {
                        try {
                            int byteCount;
                            ServletOutputStream servletOutputStream = response.getOutputStream();
                            byte[] contentChunk = new byte[1024];
                            while ((byteCount = contentStream.read(contentChunk)) != -1) {
                                servletOutputStream.write(contentChunk, 0, byteCount);
                            }
                            response.flushBuffer();
                            servletOutputStream.flush();
                            break block12;
                        }
                        finally {
                            contentStream.close();
                        }
                    }
                    Object content = resource.getContent();
                    if (content == null) break block12;
                    if (content instanceof byte[]) {
                        ServletOutputStream servletOutputStream = response.getOutputStream();
                        servletOutputStream.write((byte[])content);
                        response.flushBuffer();
                        servletOutputStream.flush();
                        break block12;
                    }
                    PrintWriter writer = response.getWriter();
                    writer.write(content.toString());
                    writer.flush();
                }
                catch (IOException e) {
                    ResourceRequestProcessor.setErrorMessage(request, e.getMessage());
                }
            }
            catch (RegistryException e) {
                ResourceRequestProcessor.setErrorMessage(request, e.getMessage());
            }
        }
    }

    private static void setErrorMessage(HttpServletRequest request, String message) {
        request.getSession().setAttribute("error.message", (Object)message);
    }

    public static Resource getResource(HttpServletRequest request, String path) throws RegistryException {
        UserRegistry userRegistry = ResourceRequestProcessor.getUserRegistry(request);
        return userRegistry.get(path);
    }

    public static UserRegistry getUserRegistry(HttpServletRequest request) throws RegistryException {
        UserRegistry userRegistry = (UserRegistry)request.getSession().getAttribute("WSO2RegistryRoot");
        if (userRegistry == null) {
            ServletContext context = request.getSession().getServletContext();
            EmbeddedRegistryService embeddedRegistryService = (EmbeddedRegistryService)context.getAttribute("CoreRegistry");
            userRegistry = embeddedRegistryService.getRegistry();
            request.getSession().setAttribute("WSO2RegistryRoot", (Object)userRegistry);
        }
        return userRegistry;
    }
}

