/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.core.secure;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.user.core.AuthorizationManager;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.common.AbstractAuthorizationManagerListener;
import org.wso2.carbon.user.core.listener.AuthorizationManagerListener;

public class AuthorizeRoleListener
extends AbstractAuthorizationManagerListener
implements AuthorizationManagerListener {
    private int executionId = 20;
    private String path = null;
    private String permission = null;
    private String executeAction = null;
    private List<String> actions = Arrays.asList("http://www.wso2.org/projects/registry/actions/get", "http://www.wso2.org/projects/registry/actions/add", "http://www.wso2.org/projects/registry/actions/delete");
    private ThreadLocal<Boolean> clearRoleActionOnAllResourcesStarted = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    private ThreadLocal<Boolean> authorizeRoleStarted = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    private static final Log log = LogFactory.getLog(AuthorizeRoleListener.class);

    public AuthorizeRoleListener(int executionId, String path, String permission, String executeAction, String[] actions) {
        this.executionId = executionId;
        this.path = path;
        this.permission = permission;
        this.executeAction = executeAction;
        if (actions != null) {
            this.actions = Arrays.asList(actions);
        }
    }

    public int getExecutionOrderId() {
        return this.executionId;
    }

    public boolean clearRoleActionOnAllResources(String roleName, String action, AuthorizationManager authorizationManager) throws UserStoreException {
        if (this.clearRoleActionOnAllResourcesStarted.get() != null && this.clearRoleActionOnAllResourcesStarted.get().booleanValue()) {
            return true;
        }
        this.clearRoleActionOnAllResourcesStarted.set(true);
        authorizationManager.clearRoleActionOnAllResources(roleName, action);
        this.clearRoleActionOnAllResourcesStarted.set(false);
        try {
            if (this.executeAction.equals(action)) {
                for (String actionName : this.actions) {
                    String[] deniedRoles;
                    boolean isDenied = false;
                    for (String deniedRole : deniedRoles = authorizationManager.getDeniedRolesForResource(this.path, actionName)) {
                        if (!deniedRole.equals(roleName)) continue;
                        isDenied = true;
                    }
                    if (isDenied) continue;
                    authorizationManager.clearRoleAuthorization(roleName, this.path, actionName);
                }
            }
        }
        catch (Exception e) {
            log.warn((Object)"Unable to clear role authorization", (Throwable)e);
            log.debug((Object)"Caused by: ", (Throwable)e);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean authorizeRole(String roleName, String resourceId, String action, AuthorizationManager authorizationManager) throws UserStoreException {
        if (this.authorizeRoleStarted.get() != null && this.authorizeRoleStarted.get().booleanValue()) {
            return true;
        }
        this.authorizeRoleStarted.set(true);
        authorizationManager.authorizeRole(roleName, resourceId, action);
        try {
            if (this.permission.startsWith(RegistryUtils.getRelativePath(RegistryContext.getBaseInstance(), resourceId)) && this.executeAction.equals(action)) {
                for (String actionName : this.actions) {
                    String[] deniedRoles;
                    boolean isDenied = false;
                    for (String deniedRole : deniedRoles = authorizationManager.getDeniedRolesForResource(this.path, actionName)) {
                        if (!deniedRole.equals(roleName)) continue;
                        isDenied = true;
                    }
                    if (isDenied) continue;
                    authorizationManager.authorizeRole(roleName, this.path, actionName);
                }
            }
        }
        catch (Exception e) {
            log.warn((Object)"Unable to set role authorization", (Throwable)e);
            log.debug((Object)"Caused by: ", (Throwable)e);
            boolean bl = true;
            return bl;
        }
        finally {
            this.authorizeRoleStarted.set(false);
        }
        return false;
    }
}

