/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.core.pagination;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.pagination.Paginate;
import org.wso2.carbon.registry.core.pagination.PaginationContext;

public class PaginationUtils {
    public static final Log log = LogFactory.getLog(PaginationUtils.class);

    public static void copyPaginationContext(ServiceClient serviceClient) throws AxisFault {
        serviceClient.addStringHeader(new QName("http://www.wso2.org/ws/pagination", "start", "cns"), Integer.toString(PaginationContext.getInstance().getStart()));
        serviceClient.addStringHeader(new QName("http://www.wso2.org/ws/pagination", "count", "cns"), Integer.toString(PaginationContext.getInstance().getCount()));
        serviceClient.addStringHeader(new QName("http://www.wso2.org/ws/pagination", "sortOrder", "cns"), PaginationContext.getInstance().getSortOrder());
        serviceClient.addStringHeader(new QName("http://www.wso2.org/ws/pagination", "sortBy", "cns"), PaginationContext.getInstance().getSortBy());
        serviceClient.addStringHeader(new QName("http://www.wso2.org/ws/pagination", "limit", "cns"), Integer.toString(PaginationContext.getInstance().getLimit()));
    }

    public static PaginationContext initPaginationContext(MessageContext messageContext) {
        HashMap<String, String> map = new HashMap<String, String>();
        SOAPHeader header = MessageContext.getCurrentMessageContext().getEnvelope().getHeader();
        ArrayList elements = header.getHeaderBlocksWithNSURI("http://www.wso2.org/ws/pagination");
        for (Object element : elements) {
            map.put(((OMElement)element).getLocalName(), ((OMElement)element).getText());
        }
        return PaginationContext.init(Integer.parseInt((String)map.get("start")), Integer.parseInt((String)map.get("count")), (String)map.get("sortOrder"), (String)map.get("sortBy"), Integer.parseInt((String)map.get("limit")));
    }

    public static boolean isPaginationHeadersExist(MessageContext messageContext) {
        SOAPHeader header = messageContext.getEnvelope().getHeader();
        if (header == null) {
            return false;
        }
        ArrayList elements = header.getHeaderBlocksWithNSURI("http://www.wso2.org/ws/pagination");
        return elements != null && elements.size() > 0;
    }

    public static boolean isPaginationAnnotationFound(String annotation) {
        StackTraceElement[] stackTrace;
        for (StackTraceElement element : stackTrace = Thread.currentThread().getStackTrace()) {
            try {
                Method[] methods;
                for (Method method : methods = Class.forName(element.getClassName()).getMethods()) {
                    if (!method.getName().equals(element.getMethodName()) || !method.isAnnotationPresent(Paginate.class) || !method.getAnnotation(Paginate.class).value().equals(annotation)) continue;
                    return true;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return false;
    }

    public static void setRowCount(MessageContext messageContext, String count) {
        try {
            messageContext.getOperationContext().getMessageContext("Out").setProperty("rowCount", (Object)count);
        }
        catch (AxisFault axisFault) {
            log.error((Object)("Failed to set row count " + (Object)((Object)axisFault)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getRowCount(ServiceClient client) throws AxisFault {
        int rowCount;
        block4: {
            rowCount = 0;
            try {
                ArrayList elements = client.getLastOperationContext().getMessageContext("In").getEnvelope().getHeader().getHeaderBlocksWithNSURI("http://www.wso2.org/ws/pagination");
                if (elements == null || elements.size() <= 0) break block4;
                for (Object element : elements) {
                    if (!((OMElement)element).getLocalName().equals("rowCount")) continue;
                    rowCount = Integer.parseInt(((OMElement)element).getText());
                    break;
                }
            }
            finally {
                PaginationContext.destroy();
            }
        }
        return rowCount;
    }
}

