/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.core.jdbc.realm;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.internal.RegistryDataHolder;
import org.wso2.carbon.registry.core.jdbc.realm.RegistryAuthorizationManager;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.AuthorizationManager;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.user.core.claim.ClaimManager;
import org.wso2.carbon.user.core.claim.ClaimMapping;
import org.wso2.carbon.user.core.profile.ProfileConfiguration;
import org.wso2.carbon.user.core.profile.ProfileConfigurationManager;
import org.wso2.carbon.user.core.service.RealmService;

public class RegistryRealm
implements UserRealm {
    private static final Log log = LogFactory.getLog(RegistryRealm.class);
    private RegistryAuthorizationManager authorizationManager;
    private UserRealm coreRealm;

    public RegistryRealm() {
    }

    public RegistryRealm(UserRealm userRealm) throws RegistryException {
        this.initialize(userRealm);
    }

    private void initialize(UserRealm userRealm) throws RegistryException {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Retrieving user manager components from the realm.");
        }
        this.authorizationManager = new RegistryAuthorizationManager(userRealm);
        this.coreRealm = userRealm;
    }

    public void init(RealmConfiguration configBean, Map<String, ClaimMapping> claimMapping, Map<String, ProfileConfiguration> profileConfigs, int tenantId) throws org.wso2.carbon.user.core.UserStoreException {
    }

    public void init(RealmConfiguration configBean, Map<String, Object> properties, int tenantId) throws org.wso2.carbon.user.core.UserStoreException {
    }

    public AuthorizationManager getAuthorizationManager() throws org.wso2.carbon.user.core.UserStoreException {
        return this.authorizationManager;
    }

    public UserStoreManager getUserStoreManager() throws org.wso2.carbon.user.core.UserStoreException {
        return this.getRealm().getUserStoreManager();
    }

    public UserRealm getRealm() throws org.wso2.carbon.user.core.UserStoreException {
        int tenantId = this.coreRealm.getAuthorizationManager().getTenantId();
        RealmService realmService = RegistryDataHolder.getInstance().getRealmService();
        if (realmService != null) {
            try {
                this.coreRealm = (UserRealm)realmService.getTenantUserRealm(tenantId);
            }
            catch (UserStoreException e) {
                throw new org.wso2.carbon.user.core.UserStoreException(e.getMessage(), (Throwable)e);
            }
        } else {
            throw new org.wso2.carbon.user.core.UserStoreException("Retrieving User Realm for tenant '" + PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain() + "' failed. Realm service is null.");
        }
        if (this.coreRealm == null) {
            String msg = "Realm service is not available. Make sure that the required version of the User Manager component is properly installed.";
            log.error((Object)msg);
            throw new org.wso2.carbon.user.core.UserStoreException(msg);
        }
        return this.coreRealm;
    }

    public void cleanUp() throws org.wso2.carbon.user.core.UserStoreException {
    }

    public RealmConfiguration getRealmConfiguration() throws org.wso2.carbon.user.core.UserStoreException {
        return this.getRealm().getRealmConfiguration();
    }

    public ProfileConfigurationManager getProfileConfigurationManager() throws org.wso2.carbon.user.core.UserStoreException {
        return this.getRealm().getProfileConfigurationManager();
    }

    public ClaimManager getClaimManager() throws org.wso2.carbon.user.core.UserStoreException {
        return this.getRealm().getClaimManager();
    }
}

