/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.core.jdbc.realm;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.registry.core.config.Mount;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.internal.RegistryDataHolder;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.AuthorizationManager;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.service.RealmService;

public class RegistryAuthorizationManager
implements AuthorizationManager {
    private UserRealm coreRealm;
    private Map<String, String> pathMap;
    private static final Log log = LogFactory.getLog(RegistryAuthorizationManager.class);

    public String computePathOnMount(String path) {
        for (Map.Entry<String, String> e : this.pathMap.entrySet()) {
            if (!path.startsWith(e.getKey()) || path.startsWith(e.getValue())) continue;
            return e.getValue() + path.substring(e.getKey().length());
        }
        return path;
    }

    public RegistryAuthorizationManager(UserRealm coreRealm) {
        this.coreRealm = coreRealm;
        this.pathMap = new HashMap<String, String>();
        RegistryContext registryContext = RegistryContext.getBaseInstance();
        for (Mount mount : registryContext.getMounts()) {
            this.pathMap.put(mount.getPath(), mount.getTargetPath());
        }
    }

    @Deprecated
    public void clearUserAuthorization(String userName, String resourceId, String action) throws org.wso2.carbon.user.core.UserStoreException {
        String unchrootedResourceId = this.computePathOnMount(RegistryUtils.getUnChrootedPath(resourceId));
        this.getAuthorizationManager().clearUserAuthorization(userName, unchrootedResourceId, action);
    }

    public void clearRoleAuthorization(String roleName, String resourceId, String action) throws org.wso2.carbon.user.core.UserStoreException {
        String unchrootedResourceId = this.computePathOnMount(RegistryUtils.getUnChrootedPath(resourceId));
        this.getAuthorizationManager().clearRoleAuthorization(roleName, unchrootedResourceId, action);
    }

    @Deprecated
    public void authorizeUser(String userName, String resourceId, String action) throws org.wso2.carbon.user.core.UserStoreException {
        String unchrootedResourceId = this.computePathOnMount(RegistryUtils.getUnChrootedPath(resourceId));
        this.getAuthorizationManager().authorizeUser(userName, unchrootedResourceId, action);
    }

    public void authorizeRole(String roleName, String resourceId, String action) throws org.wso2.carbon.user.core.UserStoreException {
        String unchrootedResourceId = this.computePathOnMount(RegistryUtils.getUnChrootedPath(resourceId));
        this.getAuthorizationManager().authorizeRole(roleName, unchrootedResourceId, action);
    }

    public void clearResourceAuthorizations(String resourceId) throws org.wso2.carbon.user.core.UserStoreException {
        String unchrootedResourceId = this.computePathOnMount(RegistryUtils.getUnChrootedPath(resourceId));
        this.getAuthorizationManager().clearResourceAuthorizations(unchrootedResourceId);
    }

    public boolean isUserAuthorized(String userName, String resourceId, String action) throws org.wso2.carbon.user.core.UserStoreException {
        String unchrootedResourceId = this.computePathOnMount(RegistryUtils.getUnChrootedPath(resourceId));
        return this.getAuthorizationManager().isUserAuthorized(userName, unchrootedResourceId, action);
    }

    public boolean isRoleAuthorized(String roleName, String resourceId, String action) throws org.wso2.carbon.user.core.UserStoreException {
        String unchrootedResourceId = this.computePathOnMount(RegistryUtils.getUnChrootedPath(resourceId));
        return this.getAuthorizationManager().isRoleAuthorized(roleName, unchrootedResourceId, action);
    }

    public String[] getAllowedRolesForResource(String resourceId, String action) throws org.wso2.carbon.user.core.UserStoreException {
        String unchrootedResourceId = this.computePathOnMount(RegistryUtils.getUnChrootedPath(resourceId));
        return this.getAuthorizationManager().getAllowedRolesForResource(unchrootedResourceId, action);
    }

    public void denyRole(String roleName, String resourceId, String action) throws org.wso2.carbon.user.core.UserStoreException {
        String unchrootedResourceId = this.computePathOnMount(RegistryUtils.getUnChrootedPath(resourceId));
        this.getAuthorizationManager().denyRole(roleName, unchrootedResourceId, action);
    }

    @Deprecated
    public void denyUser(String userName, String resourceId, String action) throws org.wso2.carbon.user.core.UserStoreException {
        String unchrootedResourceId = this.computePathOnMount(RegistryUtils.getUnChrootedPath(resourceId));
        this.getAuthorizationManager().denyUser(userName, unchrootedResourceId, action);
    }

    public String[] getDeniedRolesForResource(String resourceId, String action) throws org.wso2.carbon.user.core.UserStoreException {
        String unchrootedResourceId = this.computePathOnMount(RegistryUtils.getUnChrootedPath(resourceId));
        return this.getAuthorizationManager().getDeniedRolesForResource(unchrootedResourceId, action);
    }

    @Deprecated
    public String[] getExplicitlyAllowedUsersForResource(String resourceId, String action) throws org.wso2.carbon.user.core.UserStoreException {
        String unchrootedResourceId = this.computePathOnMount(RegistryUtils.getUnChrootedPath(resourceId));
        return this.getAuthorizationManager().getExplicitlyAllowedUsersForResource(unchrootedResourceId, action);
    }

    @Deprecated
    public String[] getExplicitlyDeniedUsersForResource(String resourceId, String action) throws org.wso2.carbon.user.core.UserStoreException {
        String unchrootedResourceId = this.computePathOnMount(RegistryUtils.getUnChrootedPath(resourceId));
        return this.getAuthorizationManager().getExplicitlyDeniedUsersForResource(unchrootedResourceId, action);
    }

    public void clearRoleActionOnAllResources(String roleName, String action) throws org.wso2.carbon.user.core.UserStoreException {
        this.getAuthorizationManager().clearRoleActionOnAllResources(roleName, action);
    }

    public String[] getAllowedUIResourcesForUser(String userName, String permissionRootPath) throws org.wso2.carbon.user.core.UserStoreException {
        return this.getAuthorizationManager().getAllowedUIResourcesForUser(userName, permissionRootPath);
    }

    public String[] getAllowedUIResourcesForRole(String roleName, String permissionRootPath) throws org.wso2.carbon.user.core.UserStoreException {
        return this.getAuthorizationManager().getAllowedUIResourcesForRole(roleName, permissionRootPath);
    }

    public void clearRoleAuthorization(String roleName) throws org.wso2.carbon.user.core.UserStoreException {
        this.getAuthorizationManager().clearRoleAuthorization(roleName);
    }

    @Deprecated
    public void clearUserAuthorization(String userName) throws org.wso2.carbon.user.core.UserStoreException {
        this.getAuthorizationManager().clearUserAuthorization(userName);
    }

    private AuthorizationManager getAuthorizationManager() throws org.wso2.carbon.user.core.UserStoreException {
        int tenantId = this.coreRealm.getAuthorizationManager().getTenantId();
        RealmService realmService = RegistryDataHolder.getInstance().getRealmService();
        if (realmService != null) {
            try {
                UserRealm userRealm = (UserRealm)realmService.getTenantUserRealm(tenantId);
                if (userRealm != null) {
                    return userRealm.getAuthorizationManager();
                }
                throw new org.wso2.carbon.user.core.UserStoreException("Retrieving Authorization Manager for tenant '" + PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain() + "' failed. User realm is null.");
            }
            catch (UserStoreException e) {
                throw new org.wso2.carbon.user.core.UserStoreException(e.getMessage(), (Throwable)e);
            }
        }
        throw new org.wso2.carbon.user.core.UserStoreException("Retrieving Authorization Manager for tenant '" + PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain() + "' failed. Realm service is null.");
    }

    public int getTenantId() throws org.wso2.carbon.user.core.UserStoreException {
        return this.getAuthorizationManager().getTenantId();
    }

    public void resetPermissionOnUpdateRole(String roleName, String newRoleName) throws org.wso2.carbon.user.core.UserStoreException {
        this.getAuthorizationManager().resetPermissionOnUpdateRole(roleName, newRoleName);
    }

    public String[] normalizeRoles(String[] roles) {
        return roles;
    }

    public void refreshAllowedRolesForResource(String resourceId) throws UserStoreException {
        this.getAuthorizationManager().refreshAllowedRolesForResource(resourceId);
    }
}

