/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.core.jdbc.realm;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.api.TenantMgtConfiguration;
import org.wso2.carbon.user.api.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.common.DefaultRealm;
import org.wso2.carbon.user.core.common.DefaultRealmService;
import org.wso2.carbon.user.core.config.RealmConfigXMLProcessor;
import org.wso2.carbon.user.core.config.multitenancy.MultiTenantRealmConfigBuilder;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.user.core.tenant.JDBCTenantManager;
import org.wso2.carbon.user.core.tenant.TenantManager;
import org.wso2.carbon.utils.dbcreator.DatabaseCreator;

public class InMemoryRealmService
implements RealmService {
    private Map<Integer, org.wso2.carbon.user.core.UserRealm> userRealmMap = new HashMap<Integer, org.wso2.carbon.user.core.UserRealm>();
    private RealmConfiguration bootstrapRealmConfig = null;
    private org.wso2.carbon.user.core.UserRealm bootstrapRealm = null;
    private static final Log log = LogFactory.getLog(InMemoryRealmService.class);
    private TenantManager tenantManager;
    private BasicDataSource dataSource;
    private DefaultRealmService realmService;

    public InMemoryRealmService() throws RegistryException {
        this.setup();
        try {
            this.realmService = new DefaultRealmService(this.bootstrapRealmConfig, this.tenantManager);
            this.bootstrapRealm = this.initializeRealm(this.bootstrapRealmConfig, (DataSource)this.dataSource, -1234);
        }
        catch (Exception e) {
            String msg = "Error in init bootstrap realm";
            throw new RegistryException(msg, e);
        }
    }

    public org.wso2.carbon.user.core.UserRealm getUserRealm(RealmConfiguration tenantRealmConfig) throws UserStoreException {
        int tenantId = tenantRealmConfig.getTenantId();
        if (tenantId == -1234) {
            return this.bootstrapRealm;
        }
        org.wso2.carbon.user.core.UserRealm userRealm = this.userRealmMap.get(tenantId);
        if (userRealm == null) {
            userRealm = this.initializeRealm(tenantRealmConfig, (DataSource)this.dataSource, tenantId);
            this.userRealmMap.put(tenantId, userRealm);
        } else {
            long existingRealmPersistedTime = -1L;
            long newRealmConfigPersistedTime = -1L;
            if (userRealm.getRealmConfiguration().getPersistedTimestamp() != null) {
                existingRealmPersistedTime = userRealm.getRealmConfiguration().getPersistedTimestamp().getTime();
            }
            if (tenantRealmConfig.getPersistedTimestamp() != null) {
                newRealmConfigPersistedTime = tenantRealmConfig.getPersistedTimestamp().getTime();
            }
            if (existingRealmPersistedTime != newRealmConfigPersistedTime) {
                userRealm = this.initializeRealm(tenantRealmConfig, (DataSource)this.dataSource, tenantId);
                this.userRealmMap.put(tenantId, userRealm);
            }
        }
        return userRealm;
    }

    public void setUserRealm(int tenantId, org.wso2.carbon.user.core.UserRealm realm) throws UserStoreException {
        this.userRealmMap.put(tenantId, realm);
    }

    public RealmConfiguration getBootstrapRealmConfiguration() {
        return this.bootstrapRealmConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setup() throws RegistryException {
        String derbyDBName = "target/databasetest/CARBON_TEST";
        String dbDirectory = "target/databasetest";
        if (new File(dbDirectory).exists()) {
            InMemoryRealmService.deleteDBDir(new File(dbDirectory));
        }
        try {
            Class.forName("org.h2.Driver");
        }
        catch (ClassNotFoundException e) {
            String msg = "Derby database embedded driver is not available in the class path. Could not create the database for the user manager.";
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, e);
        }
        this.dataSource = new BasicDataSource();
        String connectionUrl = "jdbc:h2:./" + derbyDBName;
        this.dataSource.setUrl(connectionUrl);
        this.dataSource.setDriverClassName("org.h2.Driver");
        try {
            DatabaseCreator creator = new DatabaseCreator((DataSource)this.dataSource);
            creator.createRegistryDatabase();
            RealmConfigXMLProcessor builder = new RealmConfigXMLProcessor();
            try (FileInputStream inStream = new FileInputStream("src/test/resources/user-test/user-mgt-registry-test.xml");){
                this.bootstrapRealmConfig = builder.buildRealmConfiguration((InputStream)inStream);
            }
        }
        catch (Exception e) {
            String msg = "Failed to initialize the user manager. " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, e);
        }
        this.tenantManager = new JDBCTenantManager((DataSource)this.dataSource, null);
    }

    public org.wso2.carbon.user.core.UserRealm getBootstrapRealm() throws UserStoreException {
        return this.bootstrapRealm;
    }

    public void setTenantManager(org.wso2.carbon.user.api.TenantManager tenantManager) throws org.wso2.carbon.user.api.UserStoreException {
        this.setTenantManager((TenantManager)tenantManager);
    }

    private static boolean deleteDBDir(File dir) {
        if (dir.isDirectory()) {
            String[] children;
            for (String child : children = dir.list()) {
                if (InMemoryRealmService.deleteDBDir(new File(dir, child))) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public TenantManager getTenantManager() {
        return this.tenantManager;
    }

    public UserRealm getTenantUserRealm(int tenantId) throws UserStoreException {
        try {
            if (tenantId == -1234) {
                return this.bootstrapRealm;
            }
            return this.realmService.getTenantUserRealm(tenantId);
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            String msg = "Failed to initialize the user manager. " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new UserStoreException(msg, (Throwable)e);
        }
    }

    public org.wso2.carbon.user.core.UserRealm initializeRealm(RealmConfiguration realmConfig, DataSource dataSource, int tenantId) throws UserStoreException {
        DefaultRealm userRealm = new DefaultRealm();
        userRealm.init(realmConfig, null, null, tenantId);
        return userRealm;
    }

    public void setTenantManager(TenantManager t) {
    }

    public MultiTenantRealmConfigBuilder getMultiTenantRealmConfigBuilder() throws UserStoreException {
        return null;
    }

    public org.wso2.carbon.user.core.UserRealm getCachedUserRealm(int tenantId) throws UserStoreException {
        return this.userRealmMap.get(tenantId);
    }

    public void clearCachedUserRealm(int i) throws UserStoreException {
    }

    public TenantMgtConfiguration getTenantMgtConfiguration() {
        TenantMgtConfiguration tenantMgtConfig = null;
        return tenantMgtConfig;
    }

    public void addCustomUserStore(String realmName, String userStoreClassName, Map<String, String> properties, int tenantId) throws UserStoreException {
    }

    public void setBootstrapRealmConfiguration(RealmConfiguration arg0) {
    }
}

