/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.core.jdbc.handlers.builtin;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.Association;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.Handler;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;
import org.wso2.carbon.registry.core.statistics.StatisticsLog;

public class OperationStatisticsHandler
extends Handler {
    private static Log log = LogFactory.getLog(OperationStatisticsHandler.class);
    private static Log statsLog = StatisticsLog.getLog();
    private static Map<String, Long> records = null;
    private static ExecutorService executor = null;

    private static synchronized void initializeStatisticsLogging() {
        if (executor != null) {
            return;
        }
        records = new HashMap<String, Long>();
        executor = Executors.newCachedThreadPool();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                executor.shutdownNow();
            }
        });
        for (String s : new String[]{"GET", "PUT", "IMPORT", "MOVE", "COPY", "RENAME", "DELETE", "ADD_ASSOCIATION", "REMOVE_ASSOCIATION", "GET_ASSOCIATIONS", "GET_ALL_ASSOCIATIONS", "EXECUTE_QUERY", "RESOURCE_EXISTS", "DUMP", "RESTORE"}) {
            records.put(s, 0L);
        }
        final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                scheduler.shutdownNow();
            }
        });
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (records == null) {
                    log.error((Object)"Unable to store operation statistics.");
                } else {
                    3 var1_1 = this;
                    synchronized (var1_1) {
                        statsLog.debug((Object)("Total Number of get calls                : " + records.get("GET")));
                        statsLog.debug((Object)("Total Number of put calls                : " + records.get("PUT")));
                        statsLog.debug((Object)("Total Number of import calls             : " + records.get("IMPORT")));
                        statsLog.debug((Object)("Total Number of move calls               : " + records.get("MOVE")));
                        statsLog.debug((Object)("Total Number of copy calls               : " + records.get("COPY")));
                        statsLog.debug((Object)("Total Number of rename calls             : " + records.get("RENAME")));
                        statsLog.debug((Object)("Total Number of delete calls             : " + records.get("DELETE")));
                        statsLog.debug((Object)("Total Number of addAssociation calls     : " + records.get("ADD_ASSOCIATION")));
                        statsLog.debug((Object)("Total Number of removeAssociation calls  : " + records.get("REMOVE_ASSOCIATION")));
                        statsLog.debug((Object)("Total Number of getAssociations calls    : " + records.get("GET_ASSOCIATIONS")));
                        statsLog.debug((Object)("Total Number of getAllAssociations calls : " + records.get("GET_ALL_ASSOCIATIONS")));
                        statsLog.debug((Object)("Total Number of executeQuery calls       : " + records.get("EXECUTE_QUERY")));
                        statsLog.debug((Object)("Total Number of resourceExists calls     : " + records.get("RESOURCE_EXISTS")));
                        statsLog.debug((Object)("Total Number of dump calls               : " + records.get("DUMP")));
                        statsLog.debug((Object)("Total Number of restore calls            : " + records.get("RESTORE")));
                    }
                }
            }
        };
        scheduler.scheduleAtFixedRate(runnable, 60L, 60L, TimeUnit.SECONDS);
    }

    private void incrementRecord(final String operation) {
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (records == null) {
                    log.error((Object)"Unable to store operation statistics.");
                } else {
                    4 var1_1 = this;
                    synchronized (var1_1) {
                        records.put(operation, (Long)records.get(operation) + 1L);
                    }
                }
            }
        };
        if (executor != null) {
            executor.execute(runnable);
        } else {
            OperationStatisticsHandler.initializeStatisticsLogging();
            executor.execute(runnable);
        }
    }

    @Override
    public Resource get(RequestContext requestContext) throws RegistryException {
        if (statsLog.isDebugEnabled()) {
            this.incrementRecord("GET");
        }
        return super.get(requestContext);
    }

    @Override
    public void put(RequestContext requestContext) throws RegistryException {
        if (statsLog.isDebugEnabled()) {
            this.incrementRecord("PUT");
        }
        super.put(requestContext);
    }

    @Override
    public void importResource(RequestContext requestContext) throws RegistryException {
        if (statsLog.isDebugEnabled()) {
            this.incrementRecord("IMPORT");
        }
        super.importResource(requestContext);
    }

    @Override
    public String move(RequestContext requestContext) throws RegistryException {
        if (statsLog.isDebugEnabled()) {
            this.incrementRecord("MOVE");
        }
        return super.move(requestContext);
    }

    @Override
    public String copy(RequestContext requestContext) throws RegistryException {
        if (statsLog.isDebugEnabled()) {
            this.incrementRecord("COPY");
        }
        return super.copy(requestContext);
    }

    @Override
    public String rename(RequestContext requestContext) throws RegistryException {
        if (statsLog.isDebugEnabled()) {
            this.incrementRecord("RENAME");
        }
        return super.rename(requestContext);
    }

    @Override
    public void delete(RequestContext requestContext) throws RegistryException {
        if (statsLog.isDebugEnabled()) {
            this.incrementRecord("DELETE");
        }
        super.delete(requestContext);
    }

    @Override
    public void addAssociation(RequestContext requestContext) throws RegistryException {
        if (statsLog.isDebugEnabled()) {
            this.incrementRecord("ADD_ASSOCIATION");
        }
        super.addAssociation(requestContext);
    }

    @Override
    public void removeAssociation(RequestContext requestContext) throws RegistryException {
        if (statsLog.isDebugEnabled()) {
            this.incrementRecord("REMOVE_ASSOCIATION");
        }
        super.removeAssociation(requestContext);
    }

    @Override
    public Association[] getAllAssociations(RequestContext requestContext) throws RegistryException {
        if (statsLog.isDebugEnabled()) {
            this.incrementRecord("GET_ALL_ASSOCIATIONS");
        }
        return super.getAllAssociations(requestContext);
    }

    @Override
    public Association[] getAssociations(RequestContext requestContext) throws RegistryException {
        if (statsLog.isDebugEnabled()) {
            this.incrementRecord("GET_ASSOCIATIONS");
        }
        return super.getAssociations(requestContext);
    }

    @Override
    public Collection executeQuery(RequestContext requestContext) throws RegistryException {
        if (statsLog.isDebugEnabled()) {
            this.incrementRecord("EXECUTE_QUERY");
        }
        return super.executeQuery(requestContext);
    }

    @Override
    public boolean resourceExists(RequestContext requestContext) throws RegistryException {
        if (statsLog.isDebugEnabled()) {
            this.incrementRecord("RESOURCE_EXISTS");
        }
        return super.resourceExists(requestContext);
    }

    @Override
    public void dump(RequestContext requestContext) throws RegistryException {
        if (statsLog.isDebugEnabled()) {
            this.incrementRecord("DUMP");
        }
        super.dump(requestContext);
    }

    @Override
    public void restore(RequestContext requestContext) throws RegistryException {
        if (statsLog.isDebugEnabled()) {
            this.incrementRecord("RESTORE");
        }
        super.restore(requestContext);
    }

    @Override
    public void dumpLite(RequestContext requestContext) throws RegistryException {
        if (statsLog.isDebugEnabled()) {
            this.incrementRecord("DUMP");
        }
        super.dumpLite(requestContext);
    }

    static {
        if (statsLog.isDebugEnabled()) {
            OperationStatisticsHandler.initializeStatisticsLogging();
        }
    }
}

