/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.core.jdbc.handlers;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;
import org.wso2.carbon.registry.core.jdbc.handlers.UIEnabledHandler;
import org.wso2.carbon.utils.CarbonUtils;

@Deprecated
public class XSLTBasedUIEnabledHandler
extends UIEnabledHandler {
    private static Log log = LogFactory.getLog(XSLTBasedUIEnabledHandler.class);
    protected Map<String, String> browseXSLTs = new HashMap<String, String>();
    protected Map<String, String> editXSLTs = new HashMap<String, String>();
    protected Map<String, String> newHTMLs = new HashMap<String, String>();
    protected List<String> browseViews = new ArrayList<String>();
    protected List<String> editViews = new ArrayList<String>();
    protected List<String> newViews = new ArrayList<String>();
    private TransformerFactory transformerFactory;

    public XSLTBasedUIEnabledHandler() {
        try {
            this.transformerFactory = CarbonUtils.getSecureTransformerFactory();
        }
        catch (TransformerConfigurationException e) {
            log.error((Object)"Failed to load XML Processor Featurehttp://javax.xml.XMLConstants/feature/secure-processing", (Throwable)e);
        }
    }

    public void setBrowseXSLT(OMElement browseElement) throws RegistryException {
        OMElement viewKeyElement = browseElement.getFirstChildWithName(new QName("viewKey"));
        OMElement viewXSLTElement = browseElement.getFirstChildWithName(new QName("xsltPath"));
        OMElement viewNameElement = browseElement.getFirstChildWithName(new QName("viewName"));
        if ("true".equals(browseElement.getAttributeValue(new QName("default")))) {
            this.setDefaultBrowseView(viewKeyElement.getText().trim());
        }
        if (viewKeyElement == null || viewXSLTElement == null) {
            String msg = this.getConfigFormatErrorMessage();
            log.error((Object)msg);
            throw new RegistryException(msg);
        }
        String viewKey = viewKeyElement.getText().trim();
        String viewXSLT = viewXSLTElement.getText().trim();
        this.browseXSLTs.put(viewKey, viewXSLT);
        String browseView = viewNameElement != null ? viewKey + ":" + viewNameElement.getText().trim() : viewKey;
        this.browseViews.add(browseView);
    }

    public void setEditXSLT(OMElement editElement) throws RegistryException {
        OMElement viewKeyElement = editElement.getFirstChildWithName(new QName("viewKey"));
        OMElement viewXSLTElement = editElement.getFirstChildWithName(new QName("xsltPath"));
        OMElement viewNameElement = editElement.getFirstChildWithName(new QName("viewName"));
        if ("true".equals(editElement.getAttributeValue(new QName("default")))) {
            this.setDefaultEditView(viewKeyElement.getText().trim());
        }
        if (viewKeyElement == null || viewXSLTElement == null) {
            String msg = this.getConfigFormatErrorMessage();
            log.error((Object)msg);
            throw new RegistryException(msg);
        }
        String viewKey = viewKeyElement.getText().trim();
        String viewXSLT = viewXSLTElement.getText().trim();
        this.editXSLTs.put(viewKey, viewXSLT);
        String editView = viewNameElement != null ? viewKey + ":" + viewNameElement.getText().trim() : viewKey;
        this.editViews.add(editView);
    }

    public void setNewHTML(OMElement newElement) throws RegistryException {
        OMElement viewKeyElement = newElement.getFirstChildWithName(new QName("viewKey"));
        OMElement viewHTMLElement = newElement.getFirstChildWithName(new QName("htmlPath"));
        OMElement viewNameElement = newElement.getFirstChildWithName(new QName("viewName"));
        if ("true".equals(newElement.getAttributeValue(new QName("default")))) {
            this.setDefaultNewView(viewKeyElement.getText().trim());
        }
        if (viewKeyElement == null || viewHTMLElement == null) {
            String msg = this.getConfigFormatErrorMessage();
            log.error((Object)msg);
            throw new RegistryException(msg);
        }
        String viewKey = viewKeyElement.getText().trim();
        String viewXSLT = viewHTMLElement.getText().trim();
        this.newHTMLs.put(viewKey, viewXSLT);
        String newView = viewNameElement != null ? viewKey + ":" + viewNameElement.getText().trim() : viewKey;
        this.newViews.add(newView);
    }

    @Override
    public String[] getBrowseViews() {
        return this.browseViews.toArray(new String[this.browseViews.size()]);
    }

    @Override
    public String[] getEditViews() {
        return this.editViews.toArray(new String[this.editViews.size()]);
    }

    @Override
    public String[] getNewViews() {
        return this.newViews.toArray(new String[this.newViews.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Resource getBrowseView(String viewKey, RequestContext requestContext) throws RegistryException {
        String xslt = this.browseXSLTs.get(viewKey);
        if (xslt == null) {
            String msg = "Unsupported browse view: " + viewKey + ". XSLT is not registered for this view.";
            log.error((Object)msg);
            throw new RegistryException(msg);
        }
        Transformer viewTransformer = this.getTransformer(xslt);
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        Resource resource = requestContext.getRegistry().get(requestContext.getResourcePath().getPath());
        try {
            viewTransformer.setParameter("resourcePath", requestContext.getResourcePath().toString());
            viewTransformer.transform(new StreamSource(resource.getContentStream()), new StreamResult(byteOut));
        }
        catch (TransformerException e) {
            String msg = "Failed to generate the view UI for resource " + requestContext.getResourcePath() + ". XSLT transformation failed for XSLT " + xslt + ". " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, e);
        }
        try {
            String content = byteOut.toString();
            resource.setContent(content);
        }
        finally {
            try {
                byteOut.close();
            }
            catch (IOException e) {
                log.error((Object)"Failed to close the stream", (Throwable)e);
            }
        }
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Resource getEditView(String editViewKey, RequestContext requestContext) throws RegistryException {
        String xslt = this.editXSLTs.get(editViewKey);
        if (xslt == null) {
            String msg = "Unsupported edit view: " + editViewKey + ". XSLT is not registered for this view.";
            log.error((Object)msg);
            throw new RegistryException(msg);
        }
        Transformer viewTransformer = this.getTransformer(xslt);
        if (viewTransformer == null) {
            return this.getRawResource(requestContext);
        }
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        Resource resource = requestContext.getRegistry().get(requestContext.getResourcePath().getPath());
        try {
            viewTransformer.setParameter("resourcePath", requestContext.getResourcePath().getPath());
            viewTransformer.transform(new StreamSource(resource.getContentStream()), new StreamResult(byteOut));
        }
        catch (TransformerException e) {
            String msg = "Failed to generate the edit UI for resource " + requestContext.getResourcePath() + ". XSLT transformation failed for XSLT " + xslt + ". " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, e);
        }
        try {
            String content = byteOut.toString();
            resource.setContent(content);
        }
        finally {
            try {
                byteOut.close();
            }
            catch (IOException e) {
                log.error((Object)"Failed to close the stream", (Throwable)e);
            }
        }
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Resource getNewView(String newViewKey, RequestContext requestContext) throws RegistryException {
        Resource resource;
        String htmlPath = this.newHTMLs.get(newViewKey);
        if (htmlPath == null) {
            String msg = "Unsupported resource creation view: " + newViewKey + ". HTML is not registered for this view.";
            log.error((Object)msg);
            throw new RegistryException(msg);
        }
        InputStream htmlStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(htmlPath);
        if (htmlStream == null) {
            String msg = "Could not locate the HTML file for generating the custom UI. Make sure that the file " + htmlPath + " is in the class path of the WSO2 Registry.";
            log.error((Object)msg);
            throw new RegistryException(msg);
        }
        try {
            String content = this.streamToString(htmlStream);
            resource = requestContext.getRegistry().newResource();
            resource.setContent(content);
        }
        finally {
            try {
                htmlStream.close();
            }
            catch (IOException e) {
                log.error((Object)"Failed to close the stream", (Throwable)e);
            }
        }
        return resource;
    }

    private Transformer getTransformer(String xsltPath) throws RegistryException {
        Transformer transformer;
        InputStream xsltStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(xsltPath);
        if (xsltStream == null) {
            String msg = "Could not locate the XSLT file for generating the custom UI. Make sure that the file " + xsltPath + " is in the class path of the WSO2 Registry.";
            log.error((Object)msg);
            throw new RegistryException(msg);
        }
        try {
            transformer = CarbonUtils.getSecureTransformerFactory().newTransformer(new StreamSource(xsltStream));
        }
        catch (TransformerConfigurationException e) {
            String msg = "Failed to create XSLT transformer for the XSLT file " + xsltPath + " while generating custom UI. " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, e);
        }
        finally {
            try {
                xsltStream.close();
            }
            catch (IOException e) {
                log.error((Object)"Failed to close the stream", (Throwable)e);
            }
        }
        return transformer;
    }

    private String streamToString(InputStream inputStream) throws RegistryException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        StringBuffer content = new StringBuffer();
        try {
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                content.append(line);
            }
        }
        catch (IOException e) {
            String msg = "Failed to read input stream while converting to a string. " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, e);
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (IOException e) {
                String msg = "Failed to close the input stream. " + e.getMessage();
                log.error((Object)msg, (Throwable)e);
            }
        }
        return content.toString();
    }

    private String getConfigFormatErrorMessage() {
        String configFormat = "Invalid configuration format for XSLT based UI handler.";
        return configFormat;
    }
}

