/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.core.jdbc.handlers;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.Association;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.CollectionImpl;
import org.wso2.carbon.registry.core.Comment;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.Tag;
import org.wso2.carbon.registry.core.TaggedResourcePath;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.Handler;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;
import org.wso2.carbon.registry.core.jdbc.handlers.filters.Filter;
import org.wso2.carbon.registry.core.utils.RegistryUtils;

@SuppressWarnings(value={"IS2_INCONSISTENT_SYNC"})
public class HandlerManager {
    private static final Log log = LogFactory.getLog(HandlerManager.class);
    private static final String AN_EXCEPTION_OCCURRED_WHILE_EXECUTING_HANDLER_CHAIN = "An exception occurred while executing handler chain. ";
    private static final String UNABLE_TO_PROCEED_WITH_SIMULATION = "Unable to proceed with simulation";
    private Map<Filter, Set<Handler>> getHandlerMap = new LinkedHashMap<Filter, Set<Handler>>();
    private Map<Filter, Set<Handler>> putHandlerMap = new LinkedHashMap<Filter, Set<Handler>>();
    private Map<Filter, Set<Handler>> deleteHandlerMap = new LinkedHashMap<Filter, Set<Handler>>();
    private Map<Filter, Set<Handler>> importHandlerMap = new LinkedHashMap<Filter, Set<Handler>>();
    private Map<Filter, Set<Handler>> putChildHandlerMap = new LinkedHashMap<Filter, Set<Handler>>();
    private Map<Filter, Set<Handler>> importChildHandlerMap = new LinkedHashMap<Filter, Set<Handler>>();
    private Map<Filter, Set<Handler>> invokeAspectHandlerMap = new LinkedHashMap<Filter, Set<Handler>>();
    private Map<Filter, Set<Handler>> moveHandlerMap = new LinkedHashMap<Filter, Set<Handler>>();
    private Map<Filter, Set<Handler>> copyHandlerMap = new LinkedHashMap<Filter, Set<Handler>>();
    private Map<Filter, Set<Handler>> renameHandlerMap = new LinkedHashMap<Filter, Set<Handler>>();
    private Map<Filter, Set<Handler>> createLinkHandlerMap = new LinkedHashMap<Filter, Set<Handler>>();
    private Map<Filter, Set<Handler>> removeLinkHandlerMap = new LinkedHashMap<Filter, Set<Handler>>();
    private Map<Filter, Set<Handler>> addAssociationHandlerMap = new LinkedHashMap<Filter, Set<Handler>>();
    private Map<Filter, Set<Handler>> removeAssociationHandlerMap = new LinkedHashMap<Filter, Set<Handler>>();
    private Map<Filter, Set<Handler>> getAssociationsHandlerMap = new LinkedHashMap<Filter, Set<Handler>>();
    private Map<Filter, Set<Handler>> getAllAssociationsHandlerMap = new LinkedHashMap<Filter, Set<Handler>>();
    private Map<Filter, Set<Handler>> applyTagHandlerMap = new LinkedHashMap<Filter, Set<Handler>>();
    private Map<Filter, Set<Handler>> getResourcePathsWithTagHandlerMap = new LinkedHashMap<Filter, Set<Handler>>();
    private Map<Filter, Set<Handler>> getTagsHandlerMap = new LinkedHashMap<Filter, Set<Handler>>();
    private Map<Filter, Set<Handler>> removeTagHandlerMap = new LinkedHashMap<Filter, Set<Handler>>();
    private Map<Filter, Set<Handler>> addCommentHandlerMap = new LinkedHashMap<Filter, Set<Handler>>();
    private Map<Filter, Set<Handler>> editCommentHandlerMap = new LinkedHashMap<Filter, Set<Handler>>();
    private Map<Filter, Set<Handler>> removeCommentHandlerMap = new LinkedHashMap<Filter, Set<Handler>>();
    private Map<Filter, Set<Handler>> getCommentsHandlerMap = new LinkedHashMap<Filter, Set<Handler>>();
    private Map<Filter, Set<Handler>> rateResourceHandlerMap = new LinkedHashMap<Filter, Set<Handler>>();
    private Map<Filter, Set<Handler>> getAverageRatingHandlerMap = new LinkedHashMap<Filter, Set<Handler>>();
    private Map<Filter, Set<Handler>> getRatingHandlerMap = new LinkedHashMap<Filter, Set<Handler>>();
    private Map<Filter, Set<Handler>> createVersionHandlerMap = new LinkedHashMap<Filter, Set<Handler>>();
    private Map<Filter, Set<Handler>> getVersionsHandlerMap = new LinkedHashMap<Filter, Set<Handler>>();
    private Map<Filter, Set<Handler>> restoreVersionHandlerMap = new LinkedHashMap<Filter, Set<Handler>>();
    private Map<Filter, Set<Handler>> executeQueryHandlerMap = new LinkedHashMap<Filter, Set<Handler>>();
    private Map<Filter, Set<Handler>> searchContentHandlerMap = new LinkedHashMap<Filter, Set<Handler>>();
    private Map<Filter, Set<Handler>> resourceExistsHandlerMap = new LinkedHashMap<Filter, Set<Handler>>();
    private Map<Filter, Set<Handler>> getRegistryContextHandlerMap = new LinkedHashMap<Filter, Set<Handler>>();
    private Map<Filter, Set<Handler>> dumpMap = new LinkedHashMap<Filter, Set<Handler>>();
    private Map<Filter, Set<Handler>> restoreMap = new LinkedHashMap<Filter, Set<Handler>>();
    private boolean evaluateAllHandlers = false;

    public synchronized void addHandler(String[] methods, Filter filter, Handler handler) {
        String methodInfo;
        Set<Handler> handlers;
        if (methods == null || RegistryUtils.containsString("GET", methods)) {
            handlers = this.getHandlerMap.get(filter);
            if (handlers == null) {
                handlers = new LinkedHashSet<Handler>();
            }
            handlers.add(handler);
            this.getHandlerMap.put(filter, handlers);
        }
        if (methods == null || RegistryUtils.containsString("PUT", methods)) {
            handlers = this.putHandlerMap.get(filter);
            if (handlers == null) {
                handlers = new LinkedHashSet<Handler>();
            }
            handlers.add(handler);
            this.putHandlerMap.put(filter, handlers);
        }
        if (methods == null || RegistryUtils.containsString("DELETE", methods)) {
            handlers = this.deleteHandlerMap.get(filter);
            if (handlers == null) {
                handlers = new LinkedHashSet<Handler>();
            }
            handlers.add(handler);
            this.deleteHandlerMap.put(filter, handlers);
        }
        if (methods == null || RegistryUtils.containsString("IMPORT", methods)) {
            handlers = this.importHandlerMap.get(filter);
            if (handlers == null) {
                handlers = new LinkedHashSet<Handler>();
            }
            handlers.add(handler);
            this.importHandlerMap.put(filter, handlers);
        }
        if (methods == null || RegistryUtils.containsString("PUT_CHILD", methods)) {
            handlers = this.putChildHandlerMap.get(filter);
            if (handlers == null) {
                handlers = new LinkedHashSet<Handler>();
            }
            handlers.add(handler);
            this.putChildHandlerMap.put(filter, handlers);
        }
        if (methods == null || RegistryUtils.containsString("IMPORT_CHILD", methods)) {
            handlers = this.importChildHandlerMap.get(filter);
            if (handlers == null) {
                handlers = new LinkedHashSet<Handler>();
            }
            handlers.add(handler);
            this.importChildHandlerMap.put(filter, handlers);
        }
        if (methods == null || RegistryUtils.containsString("INVOKE_ASPECT", methods)) {
            handlers = this.invokeAspectHandlerMap.get(filter);
            if (handlers == null) {
                handlers = new LinkedHashSet<Handler>();
            }
            handlers.add(handler);
            this.invokeAspectHandlerMap.put(filter, handlers);
        }
        if (methods == null || RegistryUtils.containsString("MOVE", methods)) {
            handlers = this.moveHandlerMap.get(filter);
            if (handlers == null) {
                handlers = new LinkedHashSet<Handler>();
            }
            handlers.add(handler);
            this.moveHandlerMap.put(filter, handlers);
        }
        if (methods == null || RegistryUtils.containsString("COPY", methods)) {
            handlers = this.copyHandlerMap.get(filter);
            if (handlers == null) {
                handlers = new LinkedHashSet<Handler>();
            }
            handlers.add(handler);
            this.copyHandlerMap.put(filter, handlers);
        }
        if (methods == null || RegistryUtils.containsString("RENAME", methods)) {
            handlers = this.renameHandlerMap.get(filter);
            if (handlers == null) {
                handlers = new LinkedHashSet<Handler>();
            }
            handlers.add(handler);
            this.renameHandlerMap.put(filter, handlers);
        }
        if (methods == null || RegistryUtils.containsString("CREATE_LINK", methods)) {
            handlers = this.createLinkHandlerMap.get(filter);
            if (handlers == null) {
                handlers = new LinkedHashSet<Handler>();
            }
            handlers.add(handler);
            this.createLinkHandlerMap.put(filter, handlers);
        }
        if (methods == null || RegistryUtils.containsString("REMOVE_LINK", methods)) {
            handlers = this.removeLinkHandlerMap.get(filter);
            if (handlers == null) {
                handlers = new LinkedHashSet<Handler>();
            }
            handlers.add(handler);
            this.removeLinkHandlerMap.put(filter, handlers);
        }
        if (methods == null || RegistryUtils.containsString("ADD_ASSOCIATION", methods)) {
            handlers = this.addAssociationHandlerMap.get(filter);
            if (handlers == null) {
                handlers = new LinkedHashSet<Handler>();
            }
            handlers.add(handler);
            this.addAssociationHandlerMap.put(filter, handlers);
        }
        if (methods == null || RegistryUtils.containsString("REMOVE_ASSOCIATION", methods)) {
            handlers = this.removeAssociationHandlerMap.get(filter);
            if (handlers == null) {
                handlers = new LinkedHashSet<Handler>();
            }
            handlers.add(handler);
            this.removeAssociationHandlerMap.put(filter, handlers);
        }
        if (methods == null || RegistryUtils.containsString("GET_ASSOCIATIONS", methods)) {
            handlers = this.getAssociationsHandlerMap.get(filter);
            if (handlers == null) {
                handlers = new LinkedHashSet<Handler>();
            }
            handlers.add(handler);
            this.getAssociationsHandlerMap.put(filter, handlers);
        }
        if (methods == null || RegistryUtils.containsString("GET_ALL_ASSOCIATIONS", methods)) {
            handlers = this.getAllAssociationsHandlerMap.get(filter);
            if (handlers == null) {
                handlers = new LinkedHashSet<Handler>();
            }
            handlers.add(handler);
            this.getAllAssociationsHandlerMap.put(filter, handlers);
        }
        if (methods == null || RegistryUtils.containsString("APPLY_TAG", methods)) {
            handlers = this.applyTagHandlerMap.get(filter);
            if (handlers == null) {
                handlers = new LinkedHashSet<Handler>();
            }
            handlers.add(handler);
            this.applyTagHandlerMap.put(filter, handlers);
        }
        if (methods == null || RegistryUtils.containsString("GET_RESOURCE_PATHS_WITH_TAG", methods)) {
            handlers = this.getResourcePathsWithTagHandlerMap.get(filter);
            if (handlers == null) {
                handlers = new LinkedHashSet<Handler>();
            }
            handlers.add(handler);
            this.getResourcePathsWithTagHandlerMap.put(filter, handlers);
        }
        if (methods == null || RegistryUtils.containsString("GET_TAGS", methods)) {
            handlers = this.getTagsHandlerMap.get(filter);
            if (handlers == null) {
                handlers = new LinkedHashSet<Handler>();
            }
            handlers.add(handler);
            this.getTagsHandlerMap.put(filter, handlers);
        }
        if (methods == null || RegistryUtils.containsString("REMOVE_TAG", methods)) {
            handlers = this.removeTagHandlerMap.get(filter);
            if (handlers == null) {
                handlers = new LinkedHashSet<Handler>();
            }
            handlers.add(handler);
            this.removeTagHandlerMap.put(filter, handlers);
        }
        if (methods == null || RegistryUtils.containsString("ADD_COMMENT", methods)) {
            handlers = this.addCommentHandlerMap.get(filter);
            if (handlers == null) {
                handlers = new LinkedHashSet<Handler>();
            }
            handlers.add(handler);
            this.addCommentHandlerMap.put(filter, handlers);
        }
        if (methods == null || RegistryUtils.containsString("EDIT_COMMENT", methods)) {
            handlers = this.editCommentHandlerMap.get(filter);
            if (handlers == null) {
                handlers = new LinkedHashSet<Handler>();
            }
            handlers.add(handler);
            this.editCommentHandlerMap.put(filter, handlers);
        }
        if (methods == null || RegistryUtils.containsString("REMOVE_COMMENT", methods)) {
            handlers = this.removeCommentHandlerMap.get(filter);
            if (handlers == null) {
                handlers = new LinkedHashSet<Handler>();
            }
            handlers.add(handler);
            this.removeCommentHandlerMap.put(filter, handlers);
        }
        if (methods == null || RegistryUtils.containsString("GET_COMMENTS", methods)) {
            handlers = this.getCommentsHandlerMap.get(filter);
            if (handlers == null) {
                handlers = new LinkedHashSet<Handler>();
            }
            handlers.add(handler);
            this.getCommentsHandlerMap.put(filter, handlers);
        }
        if (methods == null || RegistryUtils.containsString("RATE_RESOURCE", methods)) {
            handlers = this.rateResourceHandlerMap.get(filter);
            if (handlers == null) {
                handlers = new LinkedHashSet<Handler>();
            }
            handlers.add(handler);
            this.rateResourceHandlerMap.put(filter, handlers);
        }
        if (methods == null || RegistryUtils.containsString("GET_AVERAGE_RATING", methods)) {
            handlers = this.getAverageRatingHandlerMap.get(filter);
            if (handlers == null) {
                handlers = new LinkedHashSet<Handler>();
            }
            handlers.add(handler);
            this.getAverageRatingHandlerMap.put(filter, handlers);
        }
        if (methods == null || RegistryUtils.containsString("GET_RATING", methods)) {
            handlers = this.getRatingHandlerMap.get(filter);
            if (handlers == null) {
                handlers = new LinkedHashSet<Handler>();
            }
            handlers.add(handler);
            this.getRatingHandlerMap.put(filter, handlers);
        }
        if (methods == null || RegistryUtils.containsString("CREATE_VERSION", methods)) {
            handlers = this.createVersionHandlerMap.get(filter);
            if (handlers == null) {
                handlers = new LinkedHashSet<Handler>();
            }
            handlers.add(handler);
            this.createVersionHandlerMap.put(filter, handlers);
        }
        if (methods == null || RegistryUtils.containsString("GET_VERSIONS", methods)) {
            handlers = this.getVersionsHandlerMap.get(filter);
            if (handlers == null) {
                handlers = new LinkedHashSet<Handler>();
            }
            handlers.add(handler);
            this.getVersionsHandlerMap.put(filter, handlers);
        }
        if (methods == null || RegistryUtils.containsString("RESTORE_VERSION", methods)) {
            handlers = this.restoreVersionHandlerMap.get(filter);
            if (handlers == null) {
                handlers = new LinkedHashSet<Handler>();
            }
            handlers.add(handler);
            this.restoreVersionHandlerMap.put(filter, handlers);
        }
        if (methods == null || RegistryUtils.containsString("EXECUTE_QUERY", methods)) {
            handlers = this.executeQueryHandlerMap.get(filter);
            if (handlers == null) {
                handlers = new LinkedHashSet<Handler>();
            }
            handlers.add(handler);
            this.executeQueryHandlerMap.put(filter, handlers);
        }
        if (methods == null || RegistryUtils.containsString("SEARCH_CONTENT", methods)) {
            handlers = this.searchContentHandlerMap.get(filter);
            if (handlers == null) {
                handlers = new LinkedHashSet<Handler>();
            }
            handlers.add(handler);
            this.searchContentHandlerMap.put(filter, handlers);
        }
        if (methods == null || RegistryUtils.containsString("RESOURCE_EXISTS", methods)) {
            handlers = this.resourceExistsHandlerMap.get(filter);
            if (handlers == null) {
                handlers = new LinkedHashSet<Handler>();
            }
            handlers.add(handler);
            this.resourceExistsHandlerMap.put(filter, handlers);
        }
        if (methods == null || RegistryUtils.containsString("GET_REGISTRY_CONTEXT", methods)) {
            handlers = this.getRegistryContextHandlerMap.get(filter);
            if (handlers == null) {
                handlers = new LinkedHashSet<Handler>();
            }
            handlers.add(handler);
            this.getRegistryContextHandlerMap.put(filter, handlers);
        }
        if (methods == null || RegistryUtils.containsString("DUMP", methods)) {
            handlers = this.dumpMap.get(filter);
            if (handlers == null) {
                handlers = new LinkedHashSet<Handler>();
            }
            handlers.add(handler);
            this.dumpMap.put(filter, handlers);
        }
        if (methods == null || RegistryUtils.containsString("RESTORE", methods)) {
            handlers = this.restoreMap.get(filter);
            if (handlers == null) {
                handlers = new LinkedHashSet<Handler>();
            }
            handlers.add(handler);
            this.restoreMap.put(filter, handlers);
        }
        if (methods == null) {
            methodInfo = " all";
        } else {
            StringBuilder sb = new StringBuilder();
            for (String method : methods) {
                sb.append(" ").append(method);
            }
            methodInfo = sb.toString();
        }
        if (log.isDebugEnabled() && filter != null && handler != null) {
            log.debug((Object)("Registered the handler " + filter.getClass().getName() + " --> " + handler.getClass().getName() + " for" + methodInfo + " methods."));
        }
    }

    public void addHandler(String[] methods, Filter filter, Handler handler, String lifecyclePhase) {
        this.addHandler(methods, filter, handler);
    }

    public synchronized void addHandlerWithPriority(String[] methods, Filter filter, Handler handler) {
        Map<Filter, Set<Handler>> getHandlerMapTempRef = this.getHandlerMap;
        Map<Filter, Set<Handler>> putHandlerMapTempRef = this.putHandlerMap;
        Map<Filter, Set<Handler>> deleteHandlerMapTempRef = this.deleteHandlerMap;
        Map<Filter, Set<Handler>> importHandlerMapTempRef = this.importHandlerMap;
        Map<Filter, Set<Handler>> putChildHandlerMapTempRef = this.putChildHandlerMap;
        Map<Filter, Set<Handler>> importChildHandlerMapTempRef = this.importChildHandlerMap;
        Map<Filter, Set<Handler>> invokeAspectHandlerMapTempRef = this.invokeAspectHandlerMap;
        Map<Filter, Set<Handler>> moveHandlerMapTempRef = this.moveHandlerMap;
        Map<Filter, Set<Handler>> copyHandlerMapTempRef = this.copyHandlerMap;
        Map<Filter, Set<Handler>> renameHandlerMapTempRef = this.renameHandlerMap;
        Map<Filter, Set<Handler>> createLinkHandlerMapTempRef = this.createLinkHandlerMap;
        Map<Filter, Set<Handler>> removeLinkHandlerMapTempRef = this.removeLinkHandlerMap;
        Map<Filter, Set<Handler>> addAssociationHandlerMapTempRef = this.addAssociationHandlerMap;
        Map<Filter, Set<Handler>> removeAssociationHandlerMapTempRef = this.removeAssociationHandlerMap;
        Map<Filter, Set<Handler>> getAssociationsHandlerMapTempRef = this.getAssociationsHandlerMap;
        Map<Filter, Set<Handler>> getAllAssociationsHandlerMapTempRef = this.getAllAssociationsHandlerMap;
        Map<Filter, Set<Handler>> applyTagHandlerMapTempRef = this.applyTagHandlerMap;
        Map<Filter, Set<Handler>> getResourcePathsWithTagHandlerMapTempRef = this.getResourcePathsWithTagHandlerMap;
        Map<Filter, Set<Handler>> getTagsHandlerMapTempRef = this.getTagsHandlerMap;
        Map<Filter, Set<Handler>> removeTagHandlerMapTempRef = this.removeTagHandlerMap;
        Map<Filter, Set<Handler>> addCommentHandlerMapTempRef = this.addCommentHandlerMap;
        Map<Filter, Set<Handler>> editCommentHandlerMapTempRef = this.editCommentHandlerMap;
        Map<Filter, Set<Handler>> removeCommentHandlerMapTempRef = this.removeCommentHandlerMap;
        Map<Filter, Set<Handler>> getCommentsHandlerMapTempRef = this.getCommentsHandlerMap;
        Map<Filter, Set<Handler>> rateResourceHandlerMapTempRef = this.rateResourceHandlerMap;
        Map<Filter, Set<Handler>> getAverageRatingHandlerMapTempRef = this.getAverageRatingHandlerMap;
        Map<Filter, Set<Handler>> getRatingHandlerMapTempRef = this.getRatingHandlerMap;
        Map<Filter, Set<Handler>> createVersionHandlerMapTempRef = this.createVersionHandlerMap;
        Map<Filter, Set<Handler>> getVersionsHandlerMapTempRef = this.getVersionsHandlerMap;
        Map<Filter, Set<Handler>> restoreVersionHandlerMapTempRef = this.restoreVersionHandlerMap;
        Map<Filter, Set<Handler>> executeQueryHandlerMapTempRef = this.executeQueryHandlerMap;
        Map<Filter, Set<Handler>> searchContentHandlerMapTempRef = this.searchContentHandlerMap;
        Map<Filter, Set<Handler>> resourceExistsHandlerMapTempRef = this.resourceExistsHandlerMap;
        Map<Filter, Set<Handler>> getRegistryContextHandlerMapTempRef = this.getRegistryContextHandlerMap;
        Map<Filter, Set<Handler>> dumpMapTempRef = this.dumpMap;
        Map<Filter, Set<Handler>> restoreMapTempRef = this.restoreMap;
        this.getHandlerMap = new LinkedHashMap<Filter, Set<Handler>>();
        this.putHandlerMap = new LinkedHashMap<Filter, Set<Handler>>();
        this.deleteHandlerMap = new LinkedHashMap<Filter, Set<Handler>>();
        this.importHandlerMap = new LinkedHashMap<Filter, Set<Handler>>();
        this.putChildHandlerMap = new LinkedHashMap<Filter, Set<Handler>>();
        this.importChildHandlerMap = new LinkedHashMap<Filter, Set<Handler>>();
        this.invokeAspectHandlerMap = new LinkedHashMap<Filter, Set<Handler>>();
        this.moveHandlerMap = new LinkedHashMap<Filter, Set<Handler>>();
        this.copyHandlerMap = new LinkedHashMap<Filter, Set<Handler>>();
        this.renameHandlerMap = new LinkedHashMap<Filter, Set<Handler>>();
        this.createLinkHandlerMap = new LinkedHashMap<Filter, Set<Handler>>();
        this.removeLinkHandlerMap = new LinkedHashMap<Filter, Set<Handler>>();
        this.addAssociationHandlerMap = new LinkedHashMap<Filter, Set<Handler>>();
        this.removeAssociationHandlerMap = new LinkedHashMap<Filter, Set<Handler>>();
        this.getAssociationsHandlerMap = new LinkedHashMap<Filter, Set<Handler>>();
        this.getAllAssociationsHandlerMap = new LinkedHashMap<Filter, Set<Handler>>();
        this.applyTagHandlerMap = new LinkedHashMap<Filter, Set<Handler>>();
        this.getResourcePathsWithTagHandlerMap = new LinkedHashMap<Filter, Set<Handler>>();
        this.getTagsHandlerMap = new LinkedHashMap<Filter, Set<Handler>>();
        this.removeTagHandlerMap = new LinkedHashMap<Filter, Set<Handler>>();
        this.addCommentHandlerMap = new LinkedHashMap<Filter, Set<Handler>>();
        this.editCommentHandlerMap = new LinkedHashMap<Filter, Set<Handler>>();
        this.removeCommentHandlerMap = new LinkedHashMap<Filter, Set<Handler>>();
        this.getCommentsHandlerMap = new LinkedHashMap<Filter, Set<Handler>>();
        this.rateResourceHandlerMap = new LinkedHashMap<Filter, Set<Handler>>();
        this.getAverageRatingHandlerMap = new LinkedHashMap<Filter, Set<Handler>>();
        this.getRatingHandlerMap = new LinkedHashMap<Filter, Set<Handler>>();
        this.createVersionHandlerMap = new LinkedHashMap<Filter, Set<Handler>>();
        this.getVersionsHandlerMap = new LinkedHashMap<Filter, Set<Handler>>();
        this.restoreVersionHandlerMap = new LinkedHashMap<Filter, Set<Handler>>();
        this.executeQueryHandlerMap = new LinkedHashMap<Filter, Set<Handler>>();
        this.searchContentHandlerMap = new LinkedHashMap<Filter, Set<Handler>>();
        this.resourceExistsHandlerMap = new LinkedHashMap<Filter, Set<Handler>>();
        this.getRegistryContextHandlerMap = new LinkedHashMap<Filter, Set<Handler>>();
        this.dumpMap = new LinkedHashMap<Filter, Set<Handler>>();
        this.restoreMap = new LinkedHashMap<Filter, Set<Handler>>();
        this.addHandler(methods, filter, handler);
        this.appendHandlerMap(this.getHandlerMap, getHandlerMapTempRef);
        this.appendHandlerMap(this.putHandlerMap, putHandlerMapTempRef);
        this.appendHandlerMap(this.deleteHandlerMap, deleteHandlerMapTempRef);
        this.appendHandlerMap(this.importHandlerMap, importHandlerMapTempRef);
        this.appendHandlerMap(this.putChildHandlerMap, putChildHandlerMapTempRef);
        this.appendHandlerMap(this.importChildHandlerMap, importChildHandlerMapTempRef);
        this.appendHandlerMap(this.invokeAspectHandlerMap, invokeAspectHandlerMapTempRef);
        this.appendHandlerMap(this.moveHandlerMap, moveHandlerMapTempRef);
        this.appendHandlerMap(this.copyHandlerMap, copyHandlerMapTempRef);
        this.appendHandlerMap(this.renameHandlerMap, renameHandlerMapTempRef);
        this.appendHandlerMap(this.createLinkHandlerMap, createLinkHandlerMapTempRef);
        this.appendHandlerMap(this.removeLinkHandlerMap, removeLinkHandlerMapTempRef);
        this.appendHandlerMap(this.addAssociationHandlerMap, addAssociationHandlerMapTempRef);
        this.appendHandlerMap(this.removeAssociationHandlerMap, removeAssociationHandlerMapTempRef);
        this.appendHandlerMap(this.getAssociationsHandlerMap, getAssociationsHandlerMapTempRef);
        this.appendHandlerMap(this.getAllAssociationsHandlerMap, getAllAssociationsHandlerMapTempRef);
        this.appendHandlerMap(this.applyTagHandlerMap, applyTagHandlerMapTempRef);
        this.appendHandlerMap(this.getResourcePathsWithTagHandlerMap, getResourcePathsWithTagHandlerMapTempRef);
        this.appendHandlerMap(this.getTagsHandlerMap, getTagsHandlerMapTempRef);
        this.appendHandlerMap(this.removeTagHandlerMap, removeTagHandlerMapTempRef);
        this.appendHandlerMap(this.addCommentHandlerMap, addCommentHandlerMapTempRef);
        this.appendHandlerMap(this.editCommentHandlerMap, editCommentHandlerMapTempRef);
        this.appendHandlerMap(this.removeCommentHandlerMap, removeCommentHandlerMapTempRef);
        this.appendHandlerMap(this.getCommentsHandlerMap, getCommentsHandlerMapTempRef);
        this.appendHandlerMap(this.rateResourceHandlerMap, rateResourceHandlerMapTempRef);
        this.appendHandlerMap(this.getAverageRatingHandlerMap, getAverageRatingHandlerMapTempRef);
        this.appendHandlerMap(this.getRatingHandlerMap, getRatingHandlerMapTempRef);
        this.appendHandlerMap(this.createVersionHandlerMap, createVersionHandlerMapTempRef);
        this.appendHandlerMap(this.getVersionsHandlerMap, getVersionsHandlerMapTempRef);
        this.appendHandlerMap(this.restoreVersionHandlerMap, restoreVersionHandlerMapTempRef);
        this.appendHandlerMap(this.executeQueryHandlerMap, executeQueryHandlerMapTempRef);
        this.appendHandlerMap(this.searchContentHandlerMap, searchContentHandlerMapTempRef);
        this.appendHandlerMap(this.resourceExistsHandlerMap, resourceExistsHandlerMapTempRef);
        this.appendHandlerMap(this.getRegistryContextHandlerMap, getRegistryContextHandlerMapTempRef);
        this.appendHandlerMap(this.dumpMap, dumpMapTempRef);
        this.appendHandlerMap(this.restoreMap, restoreMapTempRef);
    }

    public void addHandlerWithPriority(String[] methods, Filter filter, Handler handler, String lifecyclePhase) {
        this.addHandlerWithPriority(methods, filter, handler);
    }

    private void appendHandlerMap(Map<Filter, Set<Handler>> map1, Map<Filter, Set<Handler>> map2) {
        for (Map.Entry<Filter, Set<Handler>> entry : map2.entrySet()) {
            Filter f = entry.getKey();
            Set<Handler> sourceHandlerSet = entry.getValue();
            Set<Handler> targetHandlerSet = map1.get(f);
            if (targetHandlerSet == null) {
                map1.put(f, sourceHandlerSet);
                continue;
            }
            targetHandlerSet.addAll(sourceHandlerSet);
        }
    }

    public synchronized void removeHandler(Handler handler) {
        for (Map.Entry<Filter, Set<Handler>> entry : this.getHandlerMap.entrySet()) {
            if (entry.getValue() == null) continue;
            entry.getValue().remove(handler);
        }
        for (Map.Entry<Filter, Set<Handler>> entry : this.putHandlerMap.entrySet()) {
            if (entry.getValue() == null) continue;
            entry.getValue().remove(handler);
        }
        for (Map.Entry<Filter, Set<Handler>> entry : this.deleteHandlerMap.entrySet()) {
            if (entry.getValue() == null) continue;
            entry.getValue().remove(handler);
        }
        for (Map.Entry<Filter, Set<Handler>> entry : this.importHandlerMap.entrySet()) {
            if (entry.getValue() == null) continue;
            entry.getValue().remove(handler);
        }
        for (Map.Entry<Filter, Set<Handler>> entry : this.putChildHandlerMap.entrySet()) {
            if (entry.getValue() == null) continue;
            entry.getValue().remove(handler);
        }
        for (Map.Entry<Filter, Set<Handler>> entry : this.importChildHandlerMap.entrySet()) {
            if (entry.getValue() == null) continue;
            entry.getValue().remove(handler);
        }
        for (Map.Entry<Filter, Set<Handler>> entry : this.invokeAspectHandlerMap.entrySet()) {
            if (entry.getValue() == null) continue;
            entry.getValue().remove(handler);
        }
        for (Map.Entry<Filter, Set<Handler>> entry : this.moveHandlerMap.entrySet()) {
            if (entry.getValue() == null) continue;
            entry.getValue().remove(handler);
        }
        for (Map.Entry<Filter, Set<Handler>> entry : this.copyHandlerMap.entrySet()) {
            if (entry.getValue() == null) continue;
            entry.getValue().remove(handler);
        }
        for (Map.Entry<Filter, Set<Handler>> entry : this.renameHandlerMap.entrySet()) {
            if (entry.getValue() == null) continue;
            entry.getValue().remove(handler);
        }
        for (Map.Entry<Filter, Set<Handler>> entry : this.createLinkHandlerMap.entrySet()) {
            if (entry.getValue() == null) continue;
            entry.getValue().remove(handler);
        }
        for (Map.Entry<Filter, Set<Handler>> entry : this.createLinkHandlerMap.entrySet()) {
            if (entry.getValue() == null) continue;
            entry.getValue().remove(handler);
        }
        for (Map.Entry<Filter, Set<Handler>> entry : this.removeLinkHandlerMap.entrySet()) {
            if (entry.getValue() == null) continue;
            entry.getValue().remove(handler);
        }
        for (Map.Entry<Filter, Set<Handler>> entry : this.addAssociationHandlerMap.entrySet()) {
            if (entry.getValue() == null) continue;
            entry.getValue().remove(handler);
        }
        for (Map.Entry<Filter, Set<Handler>> entry : this.removeAssociationHandlerMap.entrySet()) {
            if (entry.getValue() == null) continue;
            entry.getValue().remove(handler);
        }
        for (Map.Entry<Filter, Set<Handler>> entry : this.applyTagHandlerMap.entrySet()) {
            if (entry.getValue() == null) continue;
            entry.getValue().remove(handler);
        }
        for (Map.Entry<Filter, Set<Handler>> entry : this.removeTagHandlerMap.entrySet()) {
            if (entry.getValue() == null) continue;
            entry.getValue().remove(handler);
        }
        for (Map.Entry<Filter, Set<Handler>> entry : this.rateResourceHandlerMap.entrySet()) {
            if (entry.getValue() == null) continue;
            entry.getValue().remove(handler);
        }
        for (Map.Entry<Filter, Set<Handler>> entry : this.restoreVersionHandlerMap.entrySet()) {
            if (entry.getValue() == null) continue;
            entry.getValue().remove(handler);
        }
        for (Map.Entry<Filter, Set<Handler>> entry : this.createVersionHandlerMap.entrySet()) {
            if (entry.getValue() == null) continue;
            entry.getValue().remove(handler);
        }
        for (Map.Entry<Filter, Set<Handler>> entry : this.editCommentHandlerMap.entrySet()) {
            if (entry.getValue() == null) continue;
            entry.getValue().remove(handler);
        }
        for (Map.Entry<Filter, Set<Handler>> entry : this.removeCommentHandlerMap.entrySet()) {
            if (entry.getValue() == null) continue;
            entry.getValue().remove(handler);
        }
        for (Map.Entry<Filter, Set<Handler>> entry : this.getAssociationsHandlerMap.entrySet()) {
            if (entry.getValue() == null) continue;
            entry.getValue().remove(handler);
        }
        for (Map.Entry<Filter, Set<Handler>> entry : this.getAllAssociationsHandlerMap.entrySet()) {
            if (entry.getValue() == null) continue;
            entry.getValue().remove(handler);
        }
        for (Map.Entry<Filter, Set<Handler>> entry : this.getResourcePathsWithTagHandlerMap.entrySet()) {
            if (entry.getValue() == null) continue;
            entry.getValue().remove(handler);
        }
        for (Map.Entry<Filter, Set<Handler>> entry : this.getTagsHandlerMap.entrySet()) {
            if (entry.getValue() == null) continue;
            entry.getValue().remove(handler);
        }
        for (Map.Entry<Filter, Set<Handler>> entry : this.addCommentHandlerMap.entrySet()) {
            if (entry.getValue() == null) continue;
            entry.getValue().remove(handler);
        }
        for (Map.Entry<Filter, Set<Handler>> entry : this.getCommentsHandlerMap.entrySet()) {
            if (entry.getValue() == null) continue;
            entry.getValue().remove(handler);
        }
        for (Map.Entry<Filter, Set<Handler>> entry : this.getRatingHandlerMap.entrySet()) {
            if (entry.getValue() == null) continue;
            entry.getValue().remove(handler);
        }
        for (Map.Entry<Filter, Set<Handler>> entry : this.getAverageRatingHandlerMap.entrySet()) {
            if (entry.getValue() == null) continue;
            entry.getValue().remove(handler);
        }
        for (Map.Entry<Filter, Set<Handler>> entry : this.getVersionsHandlerMap.entrySet()) {
            if (entry.getValue() == null) continue;
            entry.getValue().remove(handler);
        }
        for (Map.Entry<Filter, Set<Handler>> entry : this.executeQueryHandlerMap.entrySet()) {
            if (entry.getValue() == null) continue;
            entry.getValue().remove(handler);
        }
        for (Map.Entry<Filter, Set<Handler>> entry : this.searchContentHandlerMap.entrySet()) {
            if (entry.getValue() == null) continue;
            entry.getValue().remove(handler);
        }
        for (Map.Entry<Filter, Set<Handler>> entry : this.resourceExistsHandlerMap.entrySet()) {
            if (entry.getValue() == null) continue;
            entry.getValue().remove(handler);
        }
        for (Map.Entry<Filter, Set<Handler>> entry : this.getRegistryContextHandlerMap.entrySet()) {
            if (entry.getValue() == null) continue;
            entry.getValue().remove(handler);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Removed the handler " + handler.getClass().getName() + " for all methods."));
        }
    }

    public void removeHandler(Handler handler, String lifecyclePhase) {
        this.removeHandler(handler);
    }

    public synchronized void removeHandler(String[] methods, Filter filter, Handler handler) {
        String methodInfo;
        Set<Handler> handlers;
        if ((methods == null || RegistryUtils.containsString("GET", methods)) && (handlers = this.getHandlerMap.get(filter)) != null) {
            handlers.remove(handler);
        }
        if ((methods == null || RegistryUtils.containsString("PUT", methods)) && (handlers = this.putHandlerMap.get(filter)) != null) {
            handlers.remove(handler);
        }
        if ((methods == null || RegistryUtils.containsString("DELETE", methods)) && (handlers = this.deleteHandlerMap.get(filter)) != null) {
            handlers.remove(handler);
        }
        if ((methods == null || RegistryUtils.containsString("IMPORT", methods)) && (handlers = this.importHandlerMap.get(filter)) != null) {
            handlers.remove(handler);
        }
        if ((methods == null || RegistryUtils.containsString("PUT_CHILD", methods)) && (handlers = this.putChildHandlerMap.get(filter)) != null) {
            handlers.remove(handler);
        }
        if ((methods == null || RegistryUtils.containsString("IMPORT_CHILD", methods)) && (handlers = this.importChildHandlerMap.get(filter)) != null) {
            handlers.remove(handler);
        }
        if ((methods == null || RegistryUtils.containsString("INVOKE_ASPECT", methods)) && (handlers = this.invokeAspectHandlerMap.get(filter)) != null) {
            handlers.remove(handler);
        }
        if ((methods == null || RegistryUtils.containsString("MOVE", methods)) && (handlers = this.moveHandlerMap.get(filter)) != null) {
            handlers.remove(handler);
        }
        if ((methods == null || RegistryUtils.containsString("COPY", methods)) && (handlers = this.copyHandlerMap.get(filter)) != null) {
            handlers.remove(handler);
        }
        if ((methods == null || RegistryUtils.containsString("RENAME", methods)) && (handlers = this.renameHandlerMap.get(filter)) != null) {
            handlers.remove(handler);
        }
        if ((methods == null || RegistryUtils.containsString("CREATE_LINK", methods)) && (handlers = this.createLinkHandlerMap.get(filter)) != null) {
            handlers.remove(handler);
        }
        if ((methods == null || RegistryUtils.containsString("REMOVE_LINK", methods)) && (handlers = this.removeLinkHandlerMap.get(filter)) != null) {
            handlers.remove(handler);
        }
        if ((methods == null || RegistryUtils.containsString("ADD_ASSOCIATION", methods)) && (handlers = this.addAssociationHandlerMap.get(filter)) != null) {
            handlers.remove(handler);
        }
        if ((methods == null || RegistryUtils.containsString("REMOVE_ASSOCIATION", methods)) && (handlers = this.removeAssociationHandlerMap.get(filter)) != null) {
            handlers.remove(handler);
        }
        if ((methods == null || RegistryUtils.containsString("APPLY_TAG", methods)) && (handlers = this.applyTagHandlerMap.get(filter)) != null) {
            handlers.remove(handler);
        }
        if ((methods == null || RegistryUtils.containsString("REMOVE_TAG", methods)) && (handlers = this.removeTagHandlerMap.get(filter)) != null) {
            handlers.remove(handler);
        }
        if ((methods == null || RegistryUtils.containsString("RATE_RESOURCE", methods)) && (handlers = this.rateResourceHandlerMap.get(filter)) != null) {
            handlers.remove(handler);
        }
        if ((methods == null || RegistryUtils.containsString("RESTORE_VERSION", methods)) && (handlers = this.restoreVersionHandlerMap.get(filter)) != null) {
            handlers.remove(handler);
        }
        if ((methods == null || RegistryUtils.containsString("CREATE_VERSION", methods)) && (handlers = this.createVersionHandlerMap.get(filter)) != null) {
            handlers.remove(handler);
        }
        if ((methods == null || RegistryUtils.containsString("EDIT_COMMENT", methods)) && (handlers = this.editCommentHandlerMap.get(filter)) != null) {
            handlers.remove(handler);
        }
        if ((methods == null || RegistryUtils.containsString("REMOVE_COMMENT", methods)) && (handlers = this.removeCommentHandlerMap.get(filter)) != null) {
            handlers.remove(handler);
        }
        if ((methods == null || RegistryUtils.containsString("GET_ASSOCIATIONS", methods)) && (handlers = this.getAssociationsHandlerMap.get(filter)) != null) {
            handlers.remove(handler);
        }
        if ((methods == null || RegistryUtils.containsString("GET_ALL_ASSOCIATIONS", methods)) && (handlers = this.getAllAssociationsHandlerMap.get(filter)) != null) {
            handlers.remove(handler);
        }
        if ((methods == null || RegistryUtils.containsString("GET_RESOURCE_PATHS_WITH_TAG", methods)) && (handlers = this.getResourcePathsWithTagHandlerMap.get(filter)) != null) {
            handlers.remove(handler);
        }
        if ((methods == null || RegistryUtils.containsString("GET_TAGS", methods)) && (handlers = this.getTagsHandlerMap.get(filter)) != null) {
            handlers.remove(handler);
        }
        if ((methods == null || RegistryUtils.containsString("ADD_COMMENT", methods)) && (handlers = this.addCommentHandlerMap.get(filter)) != null) {
            handlers.remove(handler);
        }
        if ((methods == null || RegistryUtils.containsString("GET_COMMENTS", methods)) && (handlers = this.getCommentsHandlerMap.get(filter)) != null) {
            handlers.remove(handler);
        }
        if ((methods == null || RegistryUtils.containsString("GET_RATING", methods)) && (handlers = this.getRatingHandlerMap.get(filter)) != null) {
            handlers.remove(handler);
        }
        if ((methods == null || RegistryUtils.containsString("GET_AVERAGE_RATING", methods)) && (handlers = this.getAverageRatingHandlerMap.get(filter)) != null) {
            handlers.remove(handler);
        }
        if ((methods == null || RegistryUtils.containsString("GET_VERSIONS", methods)) && (handlers = this.getVersionsHandlerMap.get(filter)) != null) {
            handlers.remove(handler);
        }
        if ((methods == null || RegistryUtils.containsString("EXECUTE_QUERY", methods)) && (handlers = this.executeQueryHandlerMap.get(filter)) != null) {
            handlers.remove(handler);
        }
        if ((methods == null || RegistryUtils.containsString("SEARCH_CONTENT", methods)) && (handlers = this.searchContentHandlerMap.get(filter)) != null) {
            handlers.remove(handler);
        }
        if ((methods == null || RegistryUtils.containsString("RESOURCE_EXISTS", methods)) && (handlers = this.resourceExistsHandlerMap.get(filter)) != null) {
            handlers.remove(handler);
        }
        if ((methods == null || RegistryUtils.containsString("GET_REGISTRY_CONTEXT", methods)) && (handlers = this.getRegistryContextHandlerMap.get(filter)) != null) {
            handlers.remove(handler);
        }
        if (methods == null) {
            methodInfo = " all";
        } else {
            StringBuilder sb = new StringBuilder();
            for (String method : methods) {
                sb.append(" ").append(method);
            }
            methodInfo = sb.toString();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Removed the handler " + filter.getClass().getName() + " --> " + handler.getClass().getName() + " for" + methodInfo + " methods."));
        }
    }

    public void removeHandler(String[] methods, Filter filter, Handler handler, String lifecyclePhase) {
        this.removeHandler(methods, filter, handler);
    }

    public boolean isProcessingComplete(RequestContext requestContext) {
        return requestContext.isProcessingComplete() && (requestContext.isSimulation() || !this.evaluateAllHandlers);
    }

    public void removeComment(RequestContext requestContext) throws RegistryException {
        Set<Filter> filters = this.removeCommentHandlerMap.keySet();
        for (Filter filter : filters) {
            if (filter != null && filter.handleRemoveComment(requestContext)) {
                Handler[] handlers;
                Set<Handler> handlerSet = this.removeCommentHandlerMap.get(filter);
                for (Handler handler : handlers = handlerSet.toArray(new Handler[handlerSet.size()])) {
                    try {
                        handler.removeComment(requestContext);
                        if (!requestContext.isExecutionStatusSet(handler)) {
                            requestContext.setExecutionStatus(handler, true);
                        }
                    }
                    catch (RegistryException e) {
                        requestContext.setExecutionStatus(handler, (Throwable)((Object)e));
                        throw e;
                    }
                    catch (VirtualMachineError e) {
                        log.fatal((Object)UNABLE_TO_PROCEED_WITH_SIMULATION, (Throwable)e);
                        throw e;
                    }
                    catch (Throwable e) {
                        requestContext.setExecutionStatus(handler, e);
                        throw new RegistryException(AN_EXCEPTION_OCCURRED_WHILE_EXECUTING_HANDLER_CHAIN + e.getMessage(), e);
                    }
                    if (requestContext.isProcessingComplete() && !this.evaluateAllHandlers) break;
                }
            }
            if (!requestContext.isProcessingComplete() || this.evaluateAllHandlers) continue;
            break;
        }
    }

    public void editComment(RequestContext requestContext) throws RegistryException {
        Set<Filter> filters = this.editCommentHandlerMap.keySet();
        for (Filter filter : filters) {
            if (filter != null && filter.handleEditComment(requestContext)) {
                Handler[] handlers;
                Set<Handler> handlerSet = this.editCommentHandlerMap.get(filter);
                for (Handler handler : handlers = handlerSet.toArray(new Handler[handlerSet.size()])) {
                    try {
                        handler.editComment(requestContext);
                        if (!requestContext.isExecutionStatusSet(handler)) {
                            requestContext.setExecutionStatus(handler, true);
                        }
                    }
                    catch (RegistryException e) {
                        requestContext.setExecutionStatus(handler, (Throwable)((Object)e));
                        if (requestContext.isSimulation()) {
                            return;
                        }
                        throw e;
                    }
                    catch (VirtualMachineError e) {
                        log.fatal((Object)UNABLE_TO_PROCEED_WITH_SIMULATION, (Throwable)e);
                        throw e;
                    }
                    catch (Throwable e) {
                        requestContext.setExecutionStatus(handler, e);
                        if (requestContext.isSimulation()) {
                            return;
                        }
                        throw new RegistryException(AN_EXCEPTION_OCCURRED_WHILE_EXECUTING_HANDLER_CHAIN + e.getMessage(), e);
                    }
                    if (this.isProcessingComplete(requestContext)) break;
                }
            }
            if (!this.isProcessingComplete(requestContext)) continue;
            break;
        }
    }

    public void createVersion(RequestContext requestContext) throws RegistryException {
        Set<Filter> filters = this.createVersionHandlerMap.keySet();
        for (Filter filter : filters) {
            if (filter != null && filter.handleCreateVersion(requestContext)) {
                Handler[] handlers;
                Set<Handler> handlerSet = this.createVersionHandlerMap.get(filter);
                for (Handler handler : handlers = handlerSet.toArray(new Handler[handlerSet.size()])) {
                    try {
                        handler.createVersion(requestContext);
                        if (!requestContext.isExecutionStatusSet(handler)) {
                            requestContext.setExecutionStatus(handler, true);
                        }
                    }
                    catch (RegistryException e) {
                        requestContext.setExecutionStatus(handler, (Throwable)((Object)e));
                        if (requestContext.isSimulation()) {
                            return;
                        }
                        throw e;
                    }
                    catch (VirtualMachineError e) {
                        log.fatal((Object)UNABLE_TO_PROCEED_WITH_SIMULATION, (Throwable)e);
                        throw e;
                    }
                    catch (Throwable e) {
                        requestContext.setExecutionStatus(handler, e);
                        if (requestContext.isSimulation()) {
                            return;
                        }
                        throw new RegistryException(AN_EXCEPTION_OCCURRED_WHILE_EXECUTING_HANDLER_CHAIN + e.getMessage(), e);
                    }
                    if (this.isProcessingComplete(requestContext)) break;
                }
            }
            if (!this.isProcessingComplete(requestContext)) continue;
            break;
        }
    }

    public void restoreVersion(RequestContext requestContext) throws RegistryException {
        Set<Filter> filters = this.restoreVersionHandlerMap.keySet();
        for (Filter filter : filters) {
            if (filter != null && filter.handleRestoreVersion(requestContext)) {
                Handler[] handlers;
                Set<Handler> handlerSet = this.restoreVersionHandlerMap.get(filter);
                for (Handler handler : handlers = handlerSet.toArray(new Handler[handlerSet.size()])) {
                    try {
                        handler.restoreVersion(requestContext);
                        if (!requestContext.isExecutionStatusSet(handler)) {
                            requestContext.setExecutionStatus(handler, true);
                        }
                    }
                    catch (RegistryException e) {
                        requestContext.setExecutionStatus(handler, (Throwable)((Object)e));
                        if (requestContext.isSimulation()) {
                            return;
                        }
                        throw e;
                    }
                    catch (VirtualMachineError e) {
                        log.fatal((Object)UNABLE_TO_PROCEED_WITH_SIMULATION, (Throwable)e);
                        throw e;
                    }
                    catch (Throwable e) {
                        requestContext.setExecutionStatus(handler, e);
                        if (requestContext.isSimulation()) {
                            return;
                        }
                        throw new RegistryException(AN_EXCEPTION_OCCURRED_WHILE_EXECUTING_HANDLER_CHAIN + e.getMessage(), e);
                    }
                    if (this.isProcessingComplete(requestContext)) break;
                }
            }
            if (!this.isProcessingComplete(requestContext)) continue;
            break;
        }
    }

    public void rateResource(RequestContext requestContext) throws RegistryException {
        Set<Filter> filters = this.rateResourceHandlerMap.keySet();
        for (Filter filter : filters) {
            if (filter != null && filter.handleRateResource(requestContext)) {
                Handler[] handlers;
                Set<Handler> handlerSet = this.rateResourceHandlerMap.get(filter);
                for (Handler handler : handlers = handlerSet.toArray(new Handler[handlerSet.size()])) {
                    try {
                        handler.rateResource(requestContext);
                        if (!requestContext.isExecutionStatusSet(handler)) {
                            requestContext.setExecutionStatus(handler, true);
                        }
                    }
                    catch (RegistryException e) {
                        requestContext.setExecutionStatus(handler, (Throwable)((Object)e));
                        if (requestContext.isSimulation()) {
                            return;
                        }
                        throw e;
                    }
                    catch (VirtualMachineError e) {
                        log.fatal((Object)UNABLE_TO_PROCEED_WITH_SIMULATION, (Throwable)e);
                        throw e;
                    }
                    catch (Throwable e) {
                        requestContext.setExecutionStatus(handler, e);
                        if (requestContext.isSimulation()) {
                            return;
                        }
                        throw new RegistryException(AN_EXCEPTION_OCCURRED_WHILE_EXECUTING_HANDLER_CHAIN + e.getMessage(), e);
                    }
                    if (this.isProcessingComplete(requestContext)) break;
                }
            }
            if (!this.isProcessingComplete(requestContext)) continue;
            break;
        }
    }

    public void removeTag(RequestContext requestContext) throws RegistryException {
        Set<Filter> filters = this.removeTagHandlerMap.keySet();
        for (Filter filter : filters) {
            if (filter != null && filter.handleRemoveTag(requestContext)) {
                Handler[] handlers;
                Set<Handler> handlerSet = this.removeTagHandlerMap.get(filter);
                for (Handler handler : handlers = handlerSet.toArray(new Handler[handlerSet.size()])) {
                    try {
                        handler.removeTag(requestContext);
                        if (!requestContext.isExecutionStatusSet(handler)) {
                            requestContext.setExecutionStatus(handler, true);
                        }
                    }
                    catch (RegistryException e) {
                        requestContext.setExecutionStatus(handler, (Throwable)((Object)e));
                        if (requestContext.isSimulation()) {
                            return;
                        }
                        throw e;
                    }
                    catch (VirtualMachineError e) {
                        log.fatal((Object)UNABLE_TO_PROCEED_WITH_SIMULATION, (Throwable)e);
                        throw e;
                    }
                    catch (Throwable e) {
                        requestContext.setExecutionStatus(handler, e);
                        if (requestContext.isSimulation()) {
                            return;
                        }
                        throw new RegistryException(AN_EXCEPTION_OCCURRED_WHILE_EXECUTING_HANDLER_CHAIN + e.getMessage(), e);
                    }
                    if (this.isProcessingComplete(requestContext)) break;
                }
            }
            if (!this.isProcessingComplete(requestContext)) continue;
            break;
        }
    }

    public void applyTag(RequestContext requestContext) throws RegistryException {
        Set<Filter> filters = this.applyTagHandlerMap.keySet();
        for (Filter filter : filters) {
            if (filter != null && filter.handleApplyTag(requestContext)) {
                Handler[] handlers;
                Set<Handler> handlerSet = this.applyTagHandlerMap.get(filter);
                for (Handler handler : handlers = handlerSet.toArray(new Handler[handlerSet.size()])) {
                    try {
                        handler.applyTag(requestContext);
                        if (!requestContext.isExecutionStatusSet(handler)) {
                            requestContext.setExecutionStatus(handler, true);
                        }
                    }
                    catch (RegistryException e) {
                        requestContext.setExecutionStatus(handler, (Throwable)((Object)e));
                        if (requestContext.isSimulation()) {
                            return;
                        }
                        throw e;
                    }
                    catch (VirtualMachineError e) {
                        log.fatal((Object)UNABLE_TO_PROCEED_WITH_SIMULATION, (Throwable)e);
                        throw e;
                    }
                    catch (Throwable e) {
                        requestContext.setExecutionStatus(handler, e);
                        if (requestContext.isSimulation()) {
                            return;
                        }
                        throw new RegistryException(AN_EXCEPTION_OCCURRED_WHILE_EXECUTING_HANDLER_CHAIN + e.getMessage(), e);
                    }
                    if (this.isProcessingComplete(requestContext)) break;
                }
            }
            if (!this.isProcessingComplete(requestContext)) continue;
            break;
        }
    }

    public void removeAssociation(RequestContext requestContext) throws RegistryException {
        Set<Filter> filters = this.removeAssociationHandlerMap.keySet();
        for (Filter filter : filters) {
            if (filter != null && filter.handleRemoveAssociation(requestContext)) {
                Handler[] handlers;
                Set<Handler> handlerSet = this.removeAssociationHandlerMap.get(filter);
                for (Handler handler : handlers = handlerSet.toArray(new Handler[handlerSet.size()])) {
                    try {
                        handler.removeAssociation(requestContext);
                        if (!requestContext.isExecutionStatusSet(handler)) {
                            requestContext.setExecutionStatus(handler, true);
                        }
                    }
                    catch (RegistryException e) {
                        requestContext.setExecutionStatus(handler, (Throwable)((Object)e));
                        if (requestContext.isSimulation()) {
                            return;
                        }
                        throw e;
                    }
                    catch (VirtualMachineError e) {
                        log.fatal((Object)UNABLE_TO_PROCEED_WITH_SIMULATION, (Throwable)e);
                        throw e;
                    }
                    catch (Throwable e) {
                        requestContext.setExecutionStatus(handler, e);
                        if (requestContext.isSimulation()) {
                            return;
                        }
                        throw new RegistryException(AN_EXCEPTION_OCCURRED_WHILE_EXECUTING_HANDLER_CHAIN + e.getMessage(), e);
                    }
                    if (this.isProcessingComplete(requestContext)) break;
                }
            }
            if (!this.isProcessingComplete(requestContext)) continue;
            break;
        }
    }

    public void addAssociation(RequestContext requestContext) throws RegistryException {
        Set<Filter> filters = this.addAssociationHandlerMap.keySet();
        for (Filter filter : filters) {
            if (filter != null && filter.handleAddAssociation(requestContext)) {
                Handler[] handlers;
                Set<Handler> handlerSet = this.addAssociationHandlerMap.get(filter);
                for (Handler handler : handlers = handlerSet.toArray(new Handler[handlerSet.size()])) {
                    try {
                        handler.addAssociation(requestContext);
                        if (!requestContext.isExecutionStatusSet(handler)) {
                            requestContext.setExecutionStatus(handler, true);
                        }
                    }
                    catch (RegistryException e) {
                        requestContext.setExecutionStatus(handler, (Throwable)((Object)e));
                        if (requestContext.isSimulation()) {
                            return;
                        }
                        throw e;
                    }
                    catch (VirtualMachineError e) {
                        log.fatal((Object)UNABLE_TO_PROCEED_WITH_SIMULATION, (Throwable)e);
                        throw e;
                    }
                    catch (Throwable e) {
                        requestContext.setExecutionStatus(handler, e);
                        if (requestContext.isSimulation()) {
                            return;
                        }
                        throw new RegistryException(AN_EXCEPTION_OCCURRED_WHILE_EXECUTING_HANDLER_CHAIN + e.getMessage(), e);
                    }
                    if (this.isProcessingComplete(requestContext)) break;
                }
            }
            if (!this.isProcessingComplete(requestContext)) continue;
            break;
        }
    }

    public Association[] getAllAssociations(RequestContext requestContext) throws RegistryException {
        Association[] associations = null;
        Set<Filter> filters = this.getAllAssociationsHandlerMap.keySet();
        for (Filter filter : filters) {
            if (filter != null && filter.handleGetAllAssociations(requestContext)) {
                Handler[] handlers;
                Set<Handler> handlerSet = this.getAllAssociationsHandlerMap.get(filter);
                for (Handler handler : handlers = handlerSet.toArray(new Handler[handlerSet.size()])) {
                    try {
                        associations = handler.getAllAssociations(requestContext);
                        if (!requestContext.isExecutionStatusSet(handler)) {
                            requestContext.setExecutionStatus(handler, true);
                        }
                    }
                    catch (RegistryException e) {
                        requestContext.setExecutionStatus(handler, (Throwable)((Object)e));
                        if (requestContext.isSimulation()) {
                            return null;
                        }
                        throw e;
                    }
                    catch (VirtualMachineError e) {
                        log.fatal((Object)UNABLE_TO_PROCEED_WITH_SIMULATION, (Throwable)e);
                        throw e;
                    }
                    catch (Throwable e) {
                        requestContext.setExecutionStatus(handler, e);
                        if (requestContext.isSimulation()) {
                            return null;
                        }
                        throw new RegistryException(AN_EXCEPTION_OCCURRED_WHILE_EXECUTING_HANDLER_CHAIN + e.getMessage(), e);
                    }
                    if (this.isProcessingComplete(requestContext)) break;
                }
            }
            if (!this.isProcessingComplete(requestContext)) continue;
            break;
        }
        return associations;
    }

    public Association[] getAssociations(RequestContext requestContext) throws RegistryException {
        Association[] associations = null;
        Set<Filter> filters = this.getAssociationsHandlerMap.keySet();
        for (Filter filter : filters) {
            if (filter != null && filter.handleGetAssociations(requestContext)) {
                Handler[] handlers;
                Set<Handler> handlerSet = this.getAssociationsHandlerMap.get(filter);
                for (Handler handler : handlers = handlerSet.toArray(new Handler[handlerSet.size()])) {
                    try {
                        associations = handler.getAssociations(requestContext);
                        if (!requestContext.isExecutionStatusSet(handler)) {
                            requestContext.setExecutionStatus(handler, true);
                        }
                    }
                    catch (RegistryException e) {
                        requestContext.setExecutionStatus(handler, (Throwable)((Object)e));
                        if (requestContext.isSimulation()) {
                            return null;
                        }
                        throw e;
                    }
                    catch (VirtualMachineError e) {
                        log.fatal((Object)UNABLE_TO_PROCEED_WITH_SIMULATION, (Throwable)e);
                        throw e;
                    }
                    catch (Throwable e) {
                        requestContext.setExecutionStatus(handler, e);
                        if (requestContext.isSimulation()) {
                            return null;
                        }
                        throw new RegistryException(AN_EXCEPTION_OCCURRED_WHILE_EXECUTING_HANDLER_CHAIN + e.getMessage(), e);
                    }
                    if (this.isProcessingComplete(requestContext)) break;
                }
            }
            if (!this.isProcessingComplete(requestContext)) continue;
            break;
        }
        return associations;
    }

    public TaggedResourcePath[] getResourcePathsWithTag(RequestContext requestContext) throws RegistryException {
        HashSet<TaggedResourcePath> taggedPaths = new HashSet<TaggedResourcePath>();
        Set<Filter> filters = this.getResourcePathsWithTagHandlerMap.keySet();
        for (Filter filter : filters) {
            if (filter != null && filter.handleGetResourcePathsWithTag(requestContext)) {
                Handler[] handlers;
                Set<Handler> handlerSet = this.getResourcePathsWithTagHandlerMap.get(filter);
                for (Handler handler : handlers = handlerSet.toArray(new Handler[handlerSet.size()])) {
                    try {
                        TaggedResourcePath[] temp = handler.getResourcePathsWithTag(requestContext);
                        if (temp != null && temp.length > 0) {
                            taggedPaths.addAll(Arrays.asList(temp));
                        }
                        if (!requestContext.isExecutionStatusSet(handler)) {
                            requestContext.setExecutionStatus(handler, true);
                        }
                    }
                    catch (RegistryException e) {
                        requestContext.setExecutionStatus(handler, (Throwable)((Object)e));
                        if (requestContext.isSimulation()) {
                            return null;
                        }
                        throw e;
                    }
                    catch (VirtualMachineError e) {
                        log.fatal((Object)UNABLE_TO_PROCEED_WITH_SIMULATION, (Throwable)e);
                        throw e;
                    }
                    catch (Throwable e) {
                        requestContext.setExecutionStatus(handler, e);
                        if (requestContext.isSimulation()) {
                            return null;
                        }
                        throw new RegistryException(AN_EXCEPTION_OCCURRED_WHILE_EXECUTING_HANDLER_CHAIN + e.getMessage(), e);
                    }
                    if (this.isProcessingComplete(requestContext)) break;
                }
            }
            if (!this.isProcessingComplete(requestContext)) continue;
            break;
        }
        if (taggedPaths.size() == 0) {
            return null;
        }
        return taggedPaths.toArray(new TaggedResourcePath[taggedPaths.size()]);
    }

    public Tag[] getTags(RequestContext requestContext) throws RegistryException {
        Tag[] tags = null;
        Set<Filter> filters = this.getTagsHandlerMap.keySet();
        for (Filter filter : filters) {
            if (filter != null && filter.handleGetTags(requestContext)) {
                Handler[] handlers;
                Set<Handler> handlerSet = this.getTagsHandlerMap.get(filter);
                for (Handler handler : handlers = handlerSet.toArray(new Handler[handlerSet.size()])) {
                    try {
                        tags = handler.getTags(requestContext);
                        if (!requestContext.isExecutionStatusSet(handler)) {
                            requestContext.setExecutionStatus(handler, true);
                        }
                    }
                    catch (RegistryException e) {
                        requestContext.setExecutionStatus(handler, (Throwable)((Object)e));
                        if (requestContext.isSimulation()) {
                            return null;
                        }
                        throw e;
                    }
                    catch (VirtualMachineError e) {
                        log.fatal((Object)UNABLE_TO_PROCEED_WITH_SIMULATION, (Throwable)e);
                        throw e;
                    }
                    catch (Throwable e) {
                        requestContext.setExecutionStatus(handler, e);
                        if (requestContext.isSimulation()) {
                            return null;
                        }
                        throw new RegistryException(AN_EXCEPTION_OCCURRED_WHILE_EXECUTING_HANDLER_CHAIN + e.getMessage(), e);
                    }
                    if (this.isProcessingComplete(requestContext)) break;
                }
            }
            if (!this.isProcessingComplete(requestContext)) continue;
            break;
        }
        return tags;
    }

    public Comment[] getComments(RequestContext requestContext) throws RegistryException {
        Comment[] comments = null;
        Set<Filter> filters = this.getCommentsHandlerMap.keySet();
        for (Filter filter : filters) {
            if (filter != null && filter.handleGetComments(requestContext)) {
                Handler[] handlers;
                Set<Handler> handlerSet = this.getCommentsHandlerMap.get(filter);
                for (Handler handler : handlers = handlerSet.toArray(new Handler[handlerSet.size()])) {
                    try {
                        comments = handler.getComments(requestContext);
                        if (!requestContext.isExecutionStatusSet(handler)) {
                            requestContext.setExecutionStatus(handler, true);
                        }
                    }
                    catch (RegistryException e) {
                        requestContext.setExecutionStatus(handler, (Throwable)((Object)e));
                        if (requestContext.isSimulation()) {
                            return null;
                        }
                        throw e;
                    }
                    catch (VirtualMachineError e) {
                        log.fatal((Object)UNABLE_TO_PROCEED_WITH_SIMULATION, (Throwable)e);
                        throw e;
                    }
                    catch (Throwable e) {
                        requestContext.setExecutionStatus(handler, e);
                        if (requestContext.isSimulation()) {
                            return null;
                        }
                        throw new RegistryException(AN_EXCEPTION_OCCURRED_WHILE_EXECUTING_HANDLER_CHAIN + e.getMessage(), e);
                    }
                    if (this.isProcessingComplete(requestContext)) break;
                }
            }
            if (!this.isProcessingComplete(requestContext)) continue;
            break;
        }
        return comments;
    }

    public float getAverageRating(RequestContext requestContext) throws RegistryException {
        float rating = -1.0f;
        Set<Filter> filters = this.getAverageRatingHandlerMap.keySet();
        for (Filter filter : filters) {
            if (filter != null && filter.handleGetAverageRating(requestContext)) {
                Handler[] handlers;
                Set<Handler> handlerSet = this.getAverageRatingHandlerMap.get(filter);
                for (Handler handler : handlers = handlerSet.toArray(new Handler[handlerSet.size()])) {
                    try {
                        rating = handler.getAverageRating(requestContext);
                        if (!requestContext.isExecutionStatusSet(handler)) {
                            requestContext.setExecutionStatus(handler, true);
                        }
                    }
                    catch (RegistryException e) {
                        requestContext.setExecutionStatus(handler, (Throwable)((Object)e));
                        if (requestContext.isSimulation()) {
                            return -1.0f;
                        }
                        throw e;
                    }
                    catch (VirtualMachineError e) {
                        log.fatal((Object)UNABLE_TO_PROCEED_WITH_SIMULATION, (Throwable)e);
                        throw e;
                    }
                    catch (Throwable e) {
                        requestContext.setExecutionStatus(handler, e);
                        if (requestContext.isSimulation()) {
                            return -1.0f;
                        }
                        throw new RegistryException(AN_EXCEPTION_OCCURRED_WHILE_EXECUTING_HANDLER_CHAIN + e.getMessage(), e);
                    }
                    if (this.isProcessingComplete(requestContext)) break;
                }
            }
            if (!this.isProcessingComplete(requestContext)) continue;
            break;
        }
        return rating;
    }

    public int getRating(RequestContext requestContext) throws RegistryException {
        int rating = -1;
        Set<Filter> filters = this.getRatingHandlerMap.keySet();
        for (Filter filter : filters) {
            if (filter != null && filter.handleGetRating(requestContext)) {
                Handler[] handlers;
                Set<Handler> handlerSet = this.getRatingHandlerMap.get(filter);
                for (Handler handler : handlers = handlerSet.toArray(new Handler[handlerSet.size()])) {
                    try {
                        rating = handler.getRating(requestContext);
                        if (!requestContext.isExecutionStatusSet(handler)) {
                            requestContext.setExecutionStatus(handler, true);
                        }
                    }
                    catch (RegistryException e) {
                        requestContext.setExecutionStatus(handler, (Throwable)((Object)e));
                        if (requestContext.isSimulation()) {
                            return -1;
                        }
                        throw e;
                    }
                    catch (VirtualMachineError e) {
                        log.fatal((Object)UNABLE_TO_PROCEED_WITH_SIMULATION, (Throwable)e);
                        throw e;
                    }
                    catch (Throwable e) {
                        requestContext.setExecutionStatus(handler, e);
                        if (requestContext.isSimulation()) {
                            return -1;
                        }
                        throw new RegistryException(AN_EXCEPTION_OCCURRED_WHILE_EXECUTING_HANDLER_CHAIN + e.getMessage(), e);
                    }
                    if (this.isProcessingComplete(requestContext)) break;
                }
            }
            if (!this.isProcessingComplete(requestContext)) continue;
            break;
        }
        return rating;
    }

    public String[] getVersions(RequestContext requestContext) throws RegistryException {
        String[] versions = null;
        Set<Filter> filters = this.getVersionsHandlerMap.keySet();
        for (Filter filter : filters) {
            if (filter != null && filter.handleGetVersions(requestContext)) {
                Handler[] handlers;
                Set<Handler> handlerSet = this.getVersionsHandlerMap.get(filter);
                for (Handler handler : handlers = handlerSet.toArray(new Handler[handlerSet.size()])) {
                    try {
                        versions = handler.getVersions(requestContext);
                        if (!requestContext.isExecutionStatusSet(handler)) {
                            requestContext.setExecutionStatus(handler, true);
                        }
                    }
                    catch (RegistryException e) {
                        requestContext.setExecutionStatus(handler, (Throwable)((Object)e));
                        if (requestContext.isSimulation()) {
                            return null;
                        }
                        throw e;
                    }
                    catch (VirtualMachineError e) {
                        log.fatal((Object)UNABLE_TO_PROCEED_WITH_SIMULATION, (Throwable)e);
                        throw e;
                    }
                    catch (Throwable e) {
                        requestContext.setExecutionStatus(handler, e);
                        if (requestContext.isSimulation()) {
                            return null;
                        }
                        throw new RegistryException(AN_EXCEPTION_OCCURRED_WHILE_EXECUTING_HANDLER_CHAIN + e.getMessage(), e);
                    }
                    if (this.isProcessingComplete(requestContext)) break;
                }
            }
            if (!this.isProcessingComplete(requestContext)) continue;
            break;
        }
        return versions;
    }

    public Collection executeQuery(RequestContext requestContext) throws RegistryException {
        Resource collection = null;
        LinkedList<String> results = new LinkedList<String>();
        Set<Filter> filters = this.executeQueryHandlerMap.keySet();
        for (Filter filter : filters) {
            if (filter != null && filter.handleExecuteQuery(requestContext)) {
                Handler[] handlers;
                Set<Handler> handlerSet = this.executeQueryHandlerMap.get(filter);
                for (Handler handler : handlers = handlerSet.toArray(new Handler[handlerSet.size()])) {
                    try {
                        String[] children;
                        collection = handler.executeQuery(requestContext);
                        if (collection != null && (children = collection.getChildren()) != null) {
                            for (String child : children) {
                                if (child == null) continue;
                                results.add(child);
                            }
                        }
                        if (!requestContext.isExecutionStatusSet(handler)) {
                            requestContext.setExecutionStatus(handler, true);
                        }
                    }
                    catch (RegistryException e) {
                        requestContext.setExecutionStatus(handler, (Throwable)((Object)e));
                        if (requestContext.isSimulation()) {
                            return null;
                        }
                        throw e;
                    }
                    catch (VirtualMachineError e) {
                        log.fatal((Object)UNABLE_TO_PROCEED_WITH_SIMULATION, (Throwable)e);
                        throw e;
                    }
                    catch (Throwable e) {
                        requestContext.setExecutionStatus(handler, e);
                        if (requestContext.isSimulation()) {
                            return null;
                        }
                        throw new RegistryException(AN_EXCEPTION_OCCURRED_WHILE_EXECUTING_HANDLER_CHAIN + e.getMessage(), e);
                    }
                    if (this.isProcessingComplete(requestContext)) break;
                }
            }
            if (!this.isProcessingComplete(requestContext)) continue;
            break;
        }
        if (collection != null) {
            collection.setContent(results.toArray(new String[results.size()]));
        } else if (results.size() > 0) {
            collection = new CollectionImpl(results.toArray(new String[results.size()]));
        }
        return collection;
    }

    public Collection searchContent(RequestContext requestContext) throws RegistryException {
        Collection collection = null;
        Set<Filter> filters = this.searchContentHandlerMap.keySet();
        for (Filter filter : filters) {
            if (filter != null && filter.handleSearchContent(requestContext)) {
                Handler[] handlers;
                Set<Handler> handlerSet = this.searchContentHandlerMap.get(filter);
                for (Handler handler : handlers = handlerSet.toArray(new Handler[handlerSet.size()])) {
                    try {
                        collection = handler.searchContent(requestContext);
                        if (!requestContext.isExecutionStatusSet(handler)) {
                            requestContext.setExecutionStatus(handler, true);
                        }
                    }
                    catch (RegistryException e) {
                        requestContext.setExecutionStatus(handler, (Throwable)((Object)e));
                        if (requestContext.isSimulation()) {
                            return null;
                        }
                        throw e;
                    }
                    catch (VirtualMachineError e) {
                        log.fatal((Object)UNABLE_TO_PROCEED_WITH_SIMULATION, (Throwable)e);
                        throw e;
                    }
                    catch (Throwable e) {
                        requestContext.setExecutionStatus(handler, e);
                        if (requestContext.isSimulation()) {
                            return null;
                        }
                        throw new RegistryException(AN_EXCEPTION_OCCURRED_WHILE_EXECUTING_HANDLER_CHAIN + e.getMessage(), e);
                    }
                    if (this.isProcessingComplete(requestContext)) break;
                }
            }
            if (!this.isProcessingComplete(requestContext)) continue;
            break;
        }
        return collection;
    }

    public String addComment(RequestContext requestContext) throws RegistryException {
        String comment = null;
        Set<Filter> filters = this.addCommentHandlerMap.keySet();
        for (Filter filter : filters) {
            if (filter != null && filter.handleAddComment(requestContext)) {
                Handler[] handlers;
                Set<Handler> handlerSet = this.addCommentHandlerMap.get(filter);
                for (Handler handler : handlers = handlerSet.toArray(new Handler[handlerSet.size()])) {
                    try {
                        comment = handler.addComment(requestContext);
                        if (!requestContext.isExecutionStatusSet(handler)) {
                            requestContext.setExecutionStatus(handler, true);
                        }
                    }
                    catch (RegistryException e) {
                        requestContext.setExecutionStatus(handler, (Throwable)((Object)e));
                        if (requestContext.isSimulation()) {
                            return null;
                        }
                        throw e;
                    }
                    catch (VirtualMachineError e) {
                        log.fatal((Object)UNABLE_TO_PROCEED_WITH_SIMULATION, (Throwable)e);
                        throw e;
                    }
                    catch (Throwable e) {
                        requestContext.setExecutionStatus(handler, e);
                        if (requestContext.isSimulation()) {
                            return null;
                        }
                        throw new RegistryException(AN_EXCEPTION_OCCURRED_WHILE_EXECUTING_HANDLER_CHAIN + e.getMessage(), e);
                    }
                    if (this.isProcessingComplete(requestContext)) break;
                }
            }
            if (!this.isProcessingComplete(requestContext)) continue;
            break;
        }
        return comment;
    }

    public Resource get(RequestContext requestContext) throws RegistryException {
        Resource resource = null;
        Set<Filter> filters = this.getHandlerMap.keySet();
        for (Filter filter : filters) {
            if (filter != null && filter.handleGet(requestContext)) {
                Handler[] handlers;
                Set<Handler> handlerSet = this.getHandlerMap.get(filter);
                for (Handler handler : handlers = handlerSet.toArray(new Handler[handlerSet.size()])) {
                    try {
                        resource = handler.get(requestContext);
                        if (!requestContext.isExecutionStatusSet(handler)) {
                            requestContext.setExecutionStatus(handler, true);
                        }
                    }
                    catch (RegistryException e) {
                        requestContext.setExecutionStatus(handler, (Throwable)((Object)e));
                        if (requestContext.isSimulation()) {
                            return null;
                        }
                        throw e;
                    }
                    catch (VirtualMachineError e) {
                        log.fatal((Object)UNABLE_TO_PROCEED_WITH_SIMULATION, (Throwable)e);
                        throw e;
                    }
                    catch (Throwable e) {
                        requestContext.setExecutionStatus(handler, e);
                        if (requestContext.isSimulation()) {
                            return null;
                        }
                        throw new RegistryException(AN_EXCEPTION_OCCURRED_WHILE_EXECUTING_HANDLER_CHAIN + e.getMessage(), e);
                    }
                    if (this.isProcessingComplete(requestContext)) break;
                }
            }
            if (!this.isProcessingComplete(requestContext)) continue;
            break;
        }
        return resource;
    }

    public String put(RequestContext requestContext) throws RegistryException {
        Set<Filter> filters = this.putHandlerMap.keySet();
        for (Filter filter : filters) {
            if (filter != null && filter.handlePut(requestContext)) {
                Handler[] handlers;
                Set<Handler> handlerSet = this.putHandlerMap.get(filter);
                for (Handler handler : handlers = handlerSet.toArray(new Handler[handlerSet.size()])) {
                    try {
                        handler.put(requestContext);
                        if (!requestContext.isExecutionStatusSet(handler)) {
                            requestContext.setExecutionStatus(handler, true);
                        }
                    }
                    catch (RegistryException e) {
                        requestContext.setExecutionStatus(handler, (Throwable)((Object)e));
                        if (requestContext.isSimulation()) {
                            return null;
                        }
                        throw e;
                    }
                    catch (VirtualMachineError e) {
                        log.fatal((Object)UNABLE_TO_PROCEED_WITH_SIMULATION, (Throwable)e);
                        throw e;
                    }
                    catch (Throwable e) {
                        requestContext.setExecutionStatus(handler, e);
                        if (requestContext.isSimulation()) {
                            return null;
                        }
                        throw new RegistryException(AN_EXCEPTION_OCCURRED_WHILE_EXECUTING_HANDLER_CHAIN + e.getMessage(), e);
                    }
                    if (this.isProcessingComplete(requestContext)) break;
                }
            }
            if (!this.isProcessingComplete(requestContext)) continue;
            break;
        }
        if (this.isProcessingComplete(requestContext)) {
            return requestContext.getActualPath();
        }
        return null;
    }

    public String importResource(RequestContext requestContext) throws RegistryException {
        Set<Filter> filters = this.importHandlerMap.keySet();
        for (Filter filter : filters) {
            if (filter != null && filter.handleImportResource(requestContext)) {
                Handler[] handlers;
                Set<Handler> handlerSet = this.importHandlerMap.get(filter);
                for (Handler handler : handlers = handlerSet.toArray(new Handler[handlerSet.size()])) {
                    try {
                        handler.importResource(requestContext);
                        if (!requestContext.isExecutionStatusSet(handler)) {
                            requestContext.setExecutionStatus(handler, true);
                        }
                    }
                    catch (RegistryException e) {
                        requestContext.setExecutionStatus(handler, (Throwable)((Object)e));
                        if (requestContext.isSimulation()) {
                            return null;
                        }
                        throw e;
                    }
                    catch (VirtualMachineError e) {
                        log.fatal((Object)UNABLE_TO_PROCEED_WITH_SIMULATION, (Throwable)e);
                        throw e;
                    }
                    catch (Throwable e) {
                        requestContext.setExecutionStatus(handler, e);
                        if (requestContext.isSimulation()) {
                            return null;
                        }
                        throw new RegistryException(AN_EXCEPTION_OCCURRED_WHILE_EXECUTING_HANDLER_CHAIN + e.getMessage(), e);
                    }
                    if (this.isProcessingComplete(requestContext)) break;
                }
            }
            if (!this.isProcessingComplete(requestContext)) continue;
            break;
        }
        if (this.isProcessingComplete(requestContext)) {
            return requestContext.getActualPath();
        }
        return null;
    }

    public void delete(RequestContext requestContext) throws RegistryException {
        Set<Filter> filters = this.deleteHandlerMap.keySet();
        for (Filter filter : filters) {
            if (filter != null && filter.handleDelete(requestContext)) {
                Handler[] handlers;
                Set<Handler> handlerSet = this.deleteHandlerMap.get(filter);
                for (Handler handler : handlers = handlerSet.toArray(new Handler[handlerSet.size()])) {
                    try {
                        handler.delete(requestContext);
                        if (!requestContext.isExecutionStatusSet(handler)) {
                            requestContext.setExecutionStatus(handler, true);
                        }
                    }
                    catch (RegistryException e) {
                        requestContext.setExecutionStatus(handler, (Throwable)((Object)e));
                        if (requestContext.isSimulation()) {
                            return;
                        }
                        throw e;
                    }
                    catch (VirtualMachineError e) {
                        log.fatal((Object)UNABLE_TO_PROCEED_WITH_SIMULATION, (Throwable)e);
                        throw e;
                    }
                    catch (Throwable e) {
                        requestContext.setExecutionStatus(handler, e);
                        if (requestContext.isSimulation()) {
                            return;
                        }
                        throw new RegistryException(AN_EXCEPTION_OCCURRED_WHILE_EXECUTING_HANDLER_CHAIN + e.getMessage(), e);
                    }
                    if (this.isProcessingComplete(requestContext)) break;
                }
            }
            if (!this.isProcessingComplete(requestContext)) continue;
            break;
        }
    }

    public void putChild(RequestContext requestContext) throws RegistryException {
        Set<Filter> filters = this.putChildHandlerMap.keySet();
        for (Filter filter : filters) {
            if (filter != null && filter.handlePutChild(requestContext)) {
                Handler[] handlers;
                Set<Handler> handlerSet = this.putChildHandlerMap.get(filter);
                for (Handler handler : handlers = handlerSet.toArray(new Handler[handlerSet.size()])) {
                    try {
                        handler.putChild(requestContext);
                        if (!requestContext.isExecutionStatusSet(handler)) {
                            requestContext.setExecutionStatus(handler, true);
                        }
                    }
                    catch (RegistryException e) {
                        requestContext.setExecutionStatus(handler, (Throwable)((Object)e));
                        if (requestContext.isSimulation()) {
                            return;
                        }
                        throw e;
                    }
                    catch (VirtualMachineError e) {
                        log.fatal((Object)UNABLE_TO_PROCEED_WITH_SIMULATION, (Throwable)e);
                        throw e;
                    }
                    catch (Throwable e) {
                        requestContext.setExecutionStatus(handler, e);
                        if (requestContext.isSimulation()) {
                            return;
                        }
                        throw new RegistryException(AN_EXCEPTION_OCCURRED_WHILE_EXECUTING_HANDLER_CHAIN + e.getMessage(), e);
                    }
                    if (this.isProcessingComplete(requestContext)) break;
                }
            }
            if (!this.isProcessingComplete(requestContext)) continue;
            break;
        }
    }

    public void importChild(RequestContext requestContext) throws RegistryException {
        Set<Filter> filters = this.importChildHandlerMap.keySet();
        for (Filter filter : filters) {
            if (filter != null && filter.handleImportChild(requestContext)) {
                Handler[] handlers;
                Set<Handler> handlerSet = this.importChildHandlerMap.get(filter);
                for (Handler handler : handlers = handlerSet.toArray(new Handler[handlerSet.size()])) {
                    try {
                        handler.importChild(requestContext);
                        if (!requestContext.isExecutionStatusSet(handler)) {
                            requestContext.setExecutionStatus(handler, true);
                        }
                    }
                    catch (RegistryException e) {
                        requestContext.setExecutionStatus(handler, (Throwable)((Object)e));
                        if (requestContext.isSimulation()) {
                            return;
                        }
                        throw e;
                    }
                    catch (VirtualMachineError e) {
                        log.fatal((Object)UNABLE_TO_PROCEED_WITH_SIMULATION, (Throwable)e);
                        throw e;
                    }
                    catch (Throwable e) {
                        requestContext.setExecutionStatus(handler, e);
                        if (requestContext.isSimulation()) {
                            return;
                        }
                        throw new RegistryException(AN_EXCEPTION_OCCURRED_WHILE_EXECUTING_HANDLER_CHAIN + e.getMessage(), e);
                    }
                    if (this.isProcessingComplete(requestContext)) break;
                }
            }
            if (!this.isProcessingComplete(requestContext)) continue;
            break;
        }
    }

    public void invokeAspect(RequestContext requestContext) throws RegistryException {
        Set<Filter> filters = this.invokeAspectHandlerMap.keySet();
        for (Filter filter : filters) {
            if (filter != null && filter.handleInvokeAspect(requestContext)) {
                Handler[] handlers;
                Set<Handler> handlerSet = this.invokeAspectHandlerMap.get(filter);
                for (Handler handler : handlers = handlerSet.toArray(new Handler[handlerSet.size()])) {
                    try {
                        handler.invokeAspect(requestContext);
                        if (!requestContext.isExecutionStatusSet(handler)) {
                            requestContext.setExecutionStatus(handler, true);
                        }
                    }
                    catch (RegistryException e) {
                        requestContext.setExecutionStatus(handler, (Throwable)((Object)e));
                        if (requestContext.isSimulation()) {
                            return;
                        }
                        throw e;
                    }
                    catch (VirtualMachineError e) {
                        log.fatal((Object)UNABLE_TO_PROCEED_WITH_SIMULATION, (Throwable)e);
                        throw e;
                    }
                    catch (Throwable e) {
                        requestContext.setExecutionStatus(handler, e);
                        if (requestContext.isSimulation()) {
                            return;
                        }
                        throw new RegistryException(AN_EXCEPTION_OCCURRED_WHILE_EXECUTING_HANDLER_CHAIN + e.getMessage(), e);
                    }
                    if (this.isProcessingComplete(requestContext)) break;
                }
            }
            if (!this.isProcessingComplete(requestContext)) continue;
            break;
        }
    }

    public String copy(RequestContext requestContext) throws RegistryException {
        String copiedPath = null;
        Set<Filter> filters = this.copyHandlerMap.keySet();
        for (Filter filter : filters) {
            if (filter != null && filter.handleCopy(requestContext)) {
                Handler[] handlers;
                Set<Handler> handlerSet = this.copyHandlerMap.get(filter);
                for (Handler handler : handlers = handlerSet.toArray(new Handler[handlerSet.size()])) {
                    try {
                        copiedPath = handler.copy(requestContext);
                        if (!requestContext.isExecutionStatusSet(handler)) {
                            requestContext.setExecutionStatus(handler, true);
                        }
                    }
                    catch (RegistryException e) {
                        requestContext.setExecutionStatus(handler, (Throwable)((Object)e));
                        if (requestContext.isSimulation()) {
                            return null;
                        }
                        throw e;
                    }
                    catch (VirtualMachineError e) {
                        log.fatal((Object)UNABLE_TO_PROCEED_WITH_SIMULATION, (Throwable)e);
                        throw e;
                    }
                    catch (Throwable e) {
                        requestContext.setExecutionStatus(handler, e);
                        if (requestContext.isSimulation()) {
                            return null;
                        }
                        throw new RegistryException(AN_EXCEPTION_OCCURRED_WHILE_EXECUTING_HANDLER_CHAIN + e.getMessage(), e);
                    }
                    if (this.isProcessingComplete(requestContext)) break;
                }
            }
            if (!this.isProcessingComplete(requestContext)) continue;
            break;
        }
        return copiedPath;
    }

    public String move(RequestContext requestContext) throws RegistryException {
        String movedPath = null;
        Set<Filter> filters = this.moveHandlerMap.keySet();
        for (Filter filter : filters) {
            if (filter != null && filter.handleMove(requestContext)) {
                Handler[] handlers;
                Set<Handler> handlerSet = this.moveHandlerMap.get(filter);
                for (Handler handler : handlers = handlerSet.toArray(new Handler[handlerSet.size()])) {
                    try {
                        movedPath = handler.move(requestContext);
                        if (!requestContext.isExecutionStatusSet(handler)) {
                            requestContext.setExecutionStatus(handler, true);
                        }
                    }
                    catch (RegistryException e) {
                        requestContext.setExecutionStatus(handler, (Throwable)((Object)e));
                        if (requestContext.isSimulation()) {
                            return null;
                        }
                        throw e;
                    }
                    catch (VirtualMachineError e) {
                        log.fatal((Object)UNABLE_TO_PROCEED_WITH_SIMULATION, (Throwable)e);
                        throw e;
                    }
                    catch (Throwable e) {
                        requestContext.setExecutionStatus(handler, e);
                        if (requestContext.isSimulation()) {
                            return null;
                        }
                        throw new RegistryException(AN_EXCEPTION_OCCURRED_WHILE_EXECUTING_HANDLER_CHAIN + e.getMessage(), e);
                    }
                    if (this.isProcessingComplete(requestContext)) break;
                }
            }
            if (!this.isProcessingComplete(requestContext)) continue;
            break;
        }
        return movedPath;
    }

    public String rename(RequestContext requestContext) throws RegistryException {
        String renamedPath = null;
        Set<Filter> filters = this.renameHandlerMap.keySet();
        for (Filter filter : filters) {
            if (filter != null && filter.handleRename(requestContext)) {
                Handler[] handlers;
                Set<Handler> handlerSet = this.renameHandlerMap.get(filter);
                for (Handler handler : handlers = handlerSet.toArray(new Handler[handlerSet.size()])) {
                    try {
                        renamedPath = handler.rename(requestContext);
                        if (!requestContext.isExecutionStatusSet(handler)) {
                            requestContext.setExecutionStatus(handler, true);
                        }
                    }
                    catch (RegistryException e) {
                        requestContext.setExecutionStatus(handler, (Throwable)((Object)e));
                        if (requestContext.isSimulation()) {
                            return null;
                        }
                        throw e;
                    }
                    catch (VirtualMachineError e) {
                        log.fatal((Object)UNABLE_TO_PROCEED_WITH_SIMULATION, (Throwable)e);
                        throw e;
                    }
                    catch (Throwable e) {
                        requestContext.setExecutionStatus(handler, e);
                        if (requestContext.isSimulation()) {
                            return null;
                        }
                        throw new RegistryException(AN_EXCEPTION_OCCURRED_WHILE_EXECUTING_HANDLER_CHAIN + e.getMessage(), e);
                    }
                    if (this.isProcessingComplete(requestContext)) break;
                }
            }
            if (!this.isProcessingComplete(requestContext)) continue;
            break;
        }
        return renamedPath;
    }

    public void createLink(RequestContext requestContext) throws RegistryException {
        Set<Filter> filters = this.createLinkHandlerMap.keySet();
        for (Filter filter : filters) {
            if (filter != null && filter.handleCreateLink(requestContext)) {
                Handler[] handlers;
                Set<Handler> handlerSet = this.createLinkHandlerMap.get(filter);
                for (Handler handler : handlers = handlerSet.toArray(new Handler[handlerSet.size()])) {
                    try {
                        handler.createLink(requestContext);
                        if (!requestContext.isExecutionStatusSet(handler)) {
                            requestContext.setExecutionStatus(handler, true);
                        }
                    }
                    catch (RegistryException e) {
                        requestContext.setExecutionStatus(handler, (Throwable)((Object)e));
                        if (requestContext.isSimulation()) {
                            return;
                        }
                        throw e;
                    }
                    catch (VirtualMachineError e) {
                        log.fatal((Object)UNABLE_TO_PROCEED_WITH_SIMULATION, (Throwable)e);
                        throw e;
                    }
                    catch (Throwable e) {
                        requestContext.setExecutionStatus(handler, e);
                        if (requestContext.isSimulation()) {
                            return;
                        }
                        throw new RegistryException(AN_EXCEPTION_OCCURRED_WHILE_EXECUTING_HANDLER_CHAIN + e.getMessage(), e);
                    }
                    if (this.isProcessingComplete(requestContext)) break;
                }
            }
            if (!this.isProcessingComplete(requestContext)) continue;
            break;
        }
    }

    public void removeLink(RequestContext requestContext) throws RegistryException {
        Set<Filter> filters = this.removeLinkHandlerMap.keySet();
        for (Filter filter : filters) {
            if (filter != null && filter.handleRemoveLink(requestContext)) {
                Handler[] handlers;
                Set<Handler> handlerSet = this.removeLinkHandlerMap.get(filter);
                for (Handler handler : handlers = handlerSet.toArray(new Handler[handlerSet.size()])) {
                    try {
                        handler.removeLink(requestContext);
                        if (!requestContext.isExecutionStatusSet(handler)) {
                            requestContext.setExecutionStatus(handler, true);
                        }
                    }
                    catch (RegistryException e) {
                        requestContext.setExecutionStatus(handler, (Throwable)((Object)e));
                        if (requestContext.isSimulation()) {
                            return;
                        }
                        throw e;
                    }
                    catch (VirtualMachineError e) {
                        log.fatal((Object)UNABLE_TO_PROCEED_WITH_SIMULATION, (Throwable)e);
                        throw e;
                    }
                    catch (Throwable e) {
                        requestContext.setExecutionStatus(handler, e);
                        if (requestContext.isSimulation()) {
                            return;
                        }
                        throw new RegistryException(AN_EXCEPTION_OCCURRED_WHILE_EXECUTING_HANDLER_CHAIN + e.getMessage(), e);
                    }
                    if (this.isProcessingComplete(requestContext)) break;
                }
            }
            if (!this.isProcessingComplete(requestContext)) continue;
            break;
        }
    }

    public boolean resourceExists(RequestContext requestContext) throws RegistryException {
        boolean resourceExist = false;
        Set<Filter> filters = this.resourceExistsHandlerMap.keySet();
        for (Filter filter : filters) {
            if (filter != null && filter.handleResourceExists(requestContext)) {
                Handler[] handlers;
                Set<Handler> handlerSet = this.resourceExistsHandlerMap.get(filter);
                for (Handler handler : handlers = handlerSet.toArray(new Handler[handlerSet.size()])) {
                    try {
                        resourceExist = handler.resourceExists(requestContext);
                        if (!requestContext.isExecutionStatusSet(handler)) {
                            requestContext.setExecutionStatus(handler, true);
                        }
                    }
                    catch (RegistryException e) {
                        requestContext.setExecutionStatus(handler, (Throwable)((Object)e));
                        if (requestContext.isSimulation()) {
                            return false;
                        }
                        throw e;
                    }
                    catch (VirtualMachineError e) {
                        log.fatal((Object)UNABLE_TO_PROCEED_WITH_SIMULATION, (Throwable)e);
                        throw e;
                    }
                    catch (Throwable e) {
                        requestContext.setExecutionStatus(handler, e);
                        if (requestContext.isSimulation()) {
                            return false;
                        }
                        throw new RegistryException(AN_EXCEPTION_OCCURRED_WHILE_EXECUTING_HANDLER_CHAIN + e.getMessage(), e);
                    }
                    if (this.isProcessingComplete(requestContext)) break;
                }
            }
            if (!this.isProcessingComplete(requestContext)) continue;
            break;
        }
        return resourceExist;
    }

    public RegistryContext getRegistryContext(RequestContext requestContext) {
        RegistryContext registryContext = null;
        Set<Filter> filters = this.getRegistryContextHandlerMap.keySet();
        for (Filter filter : filters) {
            if (filter != null && filter.handleGetRegistryContext(requestContext)) {
                Handler[] handlers;
                Set<Handler> handlerSet = this.getRegistryContextHandlerMap.get(filter);
                for (Handler handler : handlers = handlerSet.toArray(new Handler[handlerSet.size()])) {
                    registryContext = handler.getRegistryContext(requestContext);
                    if (!requestContext.isExecutionStatusSet(handler)) {
                        requestContext.setExecutionStatus(handler, true);
                    }
                    if (this.isProcessingComplete(requestContext)) break;
                }
            }
            if (!this.isProcessingComplete(requestContext)) continue;
            break;
        }
        return registryContext;
    }

    public OMElement dump(RequestContext requestContext) throws RegistryException {
        OMElement dumpedElement = null;
        Set<Filter> filters = this.dumpMap.keySet();
        for (Filter filter : filters) {
            if (filter != null && filter.handleDump(requestContext)) {
                Handler[] handlers;
                Set<Handler> handlerSet = this.dumpMap.get(filter);
                for (Handler handler : handlers = handlerSet.toArray(new Handler[handlerSet.size()])) {
                    try {
                        handler.dump(requestContext);
                        if (!requestContext.isExecutionStatusSet(handler)) {
                            requestContext.setExecutionStatus(handler, true);
                        }
                    }
                    catch (RegistryException e) {
                        requestContext.setExecutionStatus(handler, (Throwable)((Object)e));
                        if (requestContext.isSimulation()) {
                            return null;
                        }
                        throw e;
                    }
                    catch (VirtualMachineError e) {
                        log.fatal((Object)UNABLE_TO_PROCEED_WITH_SIMULATION, (Throwable)e);
                        throw e;
                    }
                    catch (Throwable e) {
                        requestContext.setExecutionStatus(handler, e);
                        if (requestContext.isSimulation()) {
                            return null;
                        }
                        throw new RegistryException(AN_EXCEPTION_OCCURRED_WHILE_EXECUTING_HANDLER_CHAIN + e.getMessage(), e);
                    }
                    if (this.isProcessingComplete(requestContext)) break;
                }
            }
            if (!this.isProcessingComplete(requestContext)) continue;
            break;
        }
        return dumpedElement;
    }

    public void restore(RequestContext requestContext) throws RegistryException {
        Set<Filter> filters = this.restoreMap.keySet();
        for (Filter filter : filters) {
            if (filter != null && filter.handleRestore(requestContext)) {
                Handler[] handlers;
                Set<Handler> handlerSet = this.restoreMap.get(filter);
                for (Handler handler : handlers = handlerSet.toArray(new Handler[handlerSet.size()])) {
                    try {
                        handler.restore(requestContext);
                        if (!requestContext.isExecutionStatusSet(handler)) {
                            requestContext.setExecutionStatus(handler, true);
                        }
                    }
                    catch (RegistryException e) {
                        requestContext.setExecutionStatus(handler, (Throwable)((Object)e));
                        if (requestContext.isSimulation()) {
                            return;
                        }
                        throw e;
                    }
                    catch (VirtualMachineError e) {
                        log.fatal((Object)UNABLE_TO_PROCEED_WITH_SIMULATION, (Throwable)e);
                        throw e;
                    }
                    catch (Throwable e) {
                        requestContext.setExecutionStatus(handler, e);
                        if (requestContext.isSimulation()) {
                            return;
                        }
                        throw new RegistryException(AN_EXCEPTION_OCCURRED_WHILE_EXECUTING_HANDLER_CHAIN + e.getMessage(), e);
                    }
                    if (this.isProcessingComplete(requestContext)) break;
                }
            }
            if (!this.isProcessingComplete(requestContext)) continue;
            break;
        }
    }

    public void setEvaluateAllHandlers(boolean evaluateAllHandlers) {
        this.evaluateAllHandlers = evaluateAllHandlers;
    }

    public OMElement dumpLite(RequestContext requestContext) throws RegistryException {
        OMElement dumpedElement = null;
        Set<Filter> filters = this.dumpMap.keySet();
        for (Filter filter : filters) {
            if (filter != null && filter.handleDump(requestContext)) {
                Handler[] handlers;
                Set<Handler> handlerSet = this.dumpMap.get(filter);
                for (Handler handler : handlers = handlerSet.toArray(new Handler[handlerSet.size()])) {
                    try {
                        handler.dumpLite(requestContext);
                        if (!requestContext.isExecutionStatusSet(handler)) {
                            requestContext.setExecutionStatus(handler, true);
                        }
                    }
                    catch (RegistryException e) {
                        requestContext.setExecutionStatus(handler, (Throwable)((Object)e));
                        if (requestContext.isSimulation()) {
                            return null;
                        }
                        throw e;
                    }
                    catch (VirtualMachineError e) {
                        log.fatal((Object)UNABLE_TO_PROCEED_WITH_SIMULATION, (Throwable)e);
                        throw e;
                    }
                    catch (Throwable e) {
                        requestContext.setExecutionStatus(handler, e);
                        if (requestContext.isSimulation()) {
                            return null;
                        }
                        throw new RegistryException(AN_EXCEPTION_OCCURRED_WHILE_EXECUTING_HANDLER_CHAIN + e.getMessage(), e);
                    }
                    if (this.isProcessingComplete(requestContext)) break;
                }
            }
            if (!this.isProcessingComplete(requestContext)) continue;
            break;
        }
        return dumpedElement;
    }
}

