/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.core.jdbc.handlers;

import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.Association;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Comment;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.Tag;
import org.wso2.carbon.registry.core.TaggedResourcePath;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.Handler;
import org.wso2.carbon.registry.core.jdbc.handlers.HandlerManager;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;
import org.wso2.carbon.registry.core.jdbc.handlers.UserDefinedHandlerManager;
import org.wso2.carbon.registry.core.jdbc.handlers.filters.Filter;
import org.wso2.carbon.registry.core.session.CurrentSession;

public class HandlerLifecycleManager
extends HandlerManager {
    private Dictionary<String, HandlerManager> handlerManagers = new Hashtable<String, HandlerManager>();
    public static final String DEFAULT_SYSTEM_HANDLER_PHASE = "default";
    public static final String TENANT_SPECIFIC_SYSTEM_HANDLER_PHASE = "tenant";
    public static final String USER_DEFINED_SYSTEM_HANDLER_PHASE = "system";
    public static final String DEFAULT_REPORTING_HANDLER_PHASE = "reporting";
    public static final String USER_DEFINED_HANDLER_PHASE = "user";
    public static final String COMMIT_HANDLER_PHASE = "commit";
    public static final String ROLLBACK_HANDLER_PHASE = "rollback";
    private static final Log log = LogFactory.getLog(HandlerLifecycleManager.class);

    public HandlerLifecycleManager() {
        HandlerManager defaultHandlerManager = new HandlerManager();
        defaultHandlerManager.setEvaluateAllHandlers(false);
        this.handlerManagers.put(DEFAULT_SYSTEM_HANDLER_PHASE, defaultHandlerManager);
        UserDefinedHandlerManager defaultTenantSpecificHandlerManager = new UserDefinedHandlerManager();
        ((HandlerManager)defaultTenantSpecificHandlerManager).setEvaluateAllHandlers(false);
        this.handlerManagers.put(TENANT_SPECIFIC_SYSTEM_HANDLER_PHASE, defaultTenantSpecificHandlerManager);
        HandlerManager userDefinedSystemHandlerManager = new HandlerManager();
        userDefinedSystemHandlerManager.setEvaluateAllHandlers(false);
        this.handlerManagers.put(USER_DEFINED_SYSTEM_HANDLER_PHASE, userDefinedSystemHandlerManager);
        UserDefinedHandlerManager userDefinedHandlerManager = new UserDefinedHandlerManager();
        ((HandlerManager)userDefinedHandlerManager).setEvaluateAllHandlers(false);
        this.handlerManagers.put(USER_DEFINED_HANDLER_PHASE, userDefinedHandlerManager);
        HandlerManager reportingHandlerManager = new HandlerManager();
        reportingHandlerManager.setEvaluateAllHandlers(true);
        this.handlerManagers.put(DEFAULT_REPORTING_HANDLER_PHASE, reportingHandlerManager);
        UserDefinedHandlerManager commitHandlerManager = new UserDefinedHandlerManager();
        ((HandlerManager)commitHandlerManager).setEvaluateAllHandlers(true);
        this.handlerManagers.put(COMMIT_HANDLER_PHASE, commitHandlerManager);
        UserDefinedHandlerManager rollbackHandlerManager = new UserDefinedHandlerManager();
        ((HandlerManager)rollbackHandlerManager).setEvaluateAllHandlers(true);
        this.handlerManagers.put(ROLLBACK_HANDLER_PHASE, rollbackHandlerManager);
        this.init(-1234);
    }

    public synchronized void init(int tenantId) {
        CurrentSession.setCallerTenantId(tenantId);
        try {
            UserDefinedHandlerManager userDefinedHandlerManager = (UserDefinedHandlerManager)this.handlerManagers.get(TENANT_SPECIFIC_SYSTEM_HANDLER_PHASE);
            userDefinedHandlerManager.getUserHandlerManager();
            userDefinedHandlerManager = (UserDefinedHandlerManager)this.handlerManagers.get(USER_DEFINED_HANDLER_PHASE);
            userDefinedHandlerManager.getUserHandlerManager();
        }
        finally {
            CurrentSession.removeCallerTenantId();
        }
    }

    public HandlerManager getHandlerManagerForPhase(String lifecyclePhase) {
        if (lifecyclePhase.equals(COMMIT_HANDLER_PHASE) || lifecyclePhase.equals(ROLLBACK_HANDLER_PHASE)) {
            return this.handlerManagers.get(lifecyclePhase);
        }
        String msg = "Unable to provide handler manager for internally managed or invalid phase" + lifecyclePhase;
        log.error((Object)msg);
        throw new SecurityException(msg);
    }

    @Override
    public void addHandler(String[] methods, Filter filter, Handler handler) {
        this.handlerManagers.get(DEFAULT_SYSTEM_HANDLER_PHASE).addHandler(methods, filter, handler);
    }

    @Override
    public void addHandlerWithPriority(String[] methods, Filter filter, Handler handler) {
        this.handlerManagers.get(DEFAULT_SYSTEM_HANDLER_PHASE).addHandlerWithPriority(methods, filter, handler);
    }

    @Override
    public void removeHandler(Handler handler) {
        this.handlerManagers.get(DEFAULT_SYSTEM_HANDLER_PHASE).removeHandler(handler);
    }

    @Override
    public void removeHandler(String[] methods, Filter filter, Handler handler) {
        this.handlerManagers.get(DEFAULT_SYSTEM_HANDLER_PHASE).removeHandler(methods, filter, handler);
    }

    @Override
    public void addHandler(String[] methods, Filter filter, Handler handler, String lifecyclePhase) {
        if (lifecyclePhase == null) {
            this.addHandler(methods, filter, handler);
            return;
        }
        HandlerManager hm = this.handlerManagers.get(lifecyclePhase);
        if (hm == null) {
            log.warn((Object)("Invalid handler lifecycle phase: " + lifecyclePhase + ". Adding handler to the default phase."));
            this.addHandler(methods, filter, handler);
        } else {
            hm.addHandler(methods, filter, handler);
        }
    }

    @Override
    public void addHandlerWithPriority(String[] methods, Filter filter, Handler handler, String lifecyclePhase) {
        if (lifecyclePhase == null) {
            this.addHandlerWithPriority(methods, filter, handler);
            return;
        }
        HandlerManager hm = this.handlerManagers.get(lifecyclePhase);
        if (hm == null) {
            log.warn((Object)("Invalid handler lifecycle phase: " + lifecyclePhase + ". Adding handler to the default phase."));
            this.addHandlerWithPriority(methods, filter, handler);
        } else {
            hm.addHandlerWithPriority(methods, filter, handler, lifecyclePhase);
        }
    }

    @Override
    public void removeHandler(Handler handler, String lifecyclePhase) {
        if (lifecyclePhase == null) {
            this.removeHandler(handler);
            return;
        }
        HandlerManager hm = this.handlerManagers.get(lifecyclePhase);
        if (hm == null) {
            log.warn((Object)("Invalid handler lifecycle phase: " + lifecyclePhase + ". Removing handler from the default phase."));
            this.removeHandler(handler);
        } else {
            hm.removeHandler(handler, lifecyclePhase);
        }
    }

    @Override
    public void removeHandler(String[] methods, Filter filter, Handler handler, String lifecyclePhase) {
        if (lifecyclePhase == null) {
            this.removeHandler(methods, filter, handler);
            return;
        }
        HandlerManager hm = this.handlerManagers.get(lifecyclePhase);
        if (hm == null) {
            log.warn((Object)("Invalid handler lifecycle phase: " + lifecyclePhase + ". Removing handler from the default phase."));
            this.removeHandler(methods, filter, handler);
        } else {
            hm.removeHandler(methods, filter, handler, lifecyclePhase);
        }
    }

    @Override
    public void editComment(RequestContext requestContext) throws RegistryException {
        this.handlerManagers.get(DEFAULT_SYSTEM_HANDLER_PHASE).editComment(requestContext);
        boolean isProcessingComplete = requestContext.isProcessingComplete();
        if (!isProcessingComplete) {
            this.handlerManagers.get(TENANT_SPECIFIC_SYSTEM_HANDLER_PHASE).editComment(requestContext);
            isProcessingComplete = requestContext.isProcessingComplete();
        }
        if (!isProcessingComplete) {
            this.handlerManagers.get(USER_DEFINED_SYSTEM_HANDLER_PHASE).editComment(requestContext);
            isProcessingComplete = requestContext.isProcessingComplete();
        }
        requestContext.setProcessingComplete(false);
        this.handlerManagers.get(USER_DEFINED_HANDLER_PHASE).editComment(requestContext);
        requestContext.setProcessingComplete(isProcessingComplete |= requestContext.isProcessingComplete());
        this.handlerManagers.get(DEFAULT_REPORTING_HANDLER_PHASE).editComment(requestContext);
    }

    @Override
    public void removeComment(RequestContext requestContext) throws RegistryException {
        this.handlerManagers.get(DEFAULT_SYSTEM_HANDLER_PHASE).removeComment(requestContext);
        boolean isProcessingComplete = requestContext.isProcessingComplete();
        if (!isProcessingComplete) {
            this.handlerManagers.get(TENANT_SPECIFIC_SYSTEM_HANDLER_PHASE).removeComment(requestContext);
            isProcessingComplete = requestContext.isProcessingComplete();
        }
        if (!isProcessingComplete) {
            this.handlerManagers.get(USER_DEFINED_SYSTEM_HANDLER_PHASE).removeComment(requestContext);
            isProcessingComplete = requestContext.isProcessingComplete();
        }
        requestContext.setProcessingComplete(false);
        this.handlerManagers.get(USER_DEFINED_HANDLER_PHASE).removeComment(requestContext);
        requestContext.setProcessingComplete(isProcessingComplete |= requestContext.isProcessingComplete());
        this.handlerManagers.get(DEFAULT_REPORTING_HANDLER_PHASE).removeComment(requestContext);
    }

    @Override
    public void createVersion(RequestContext requestContext) throws RegistryException {
        this.handlerManagers.get(DEFAULT_SYSTEM_HANDLER_PHASE).createVersion(requestContext);
        boolean isProcessingComplete = requestContext.isProcessingComplete();
        if (!isProcessingComplete) {
            this.handlerManagers.get(TENANT_SPECIFIC_SYSTEM_HANDLER_PHASE).createVersion(requestContext);
            isProcessingComplete = requestContext.isProcessingComplete();
        }
        if (!isProcessingComplete) {
            this.handlerManagers.get(USER_DEFINED_SYSTEM_HANDLER_PHASE).createVersion(requestContext);
            isProcessingComplete = requestContext.isProcessingComplete();
        }
        requestContext.setProcessingComplete(false);
        this.handlerManagers.get(USER_DEFINED_HANDLER_PHASE).createVersion(requestContext);
        requestContext.setProcessingComplete(isProcessingComplete |= requestContext.isProcessingComplete());
        this.handlerManagers.get(DEFAULT_REPORTING_HANDLER_PHASE).createVersion(requestContext);
    }

    @Override
    public void restoreVersion(RequestContext requestContext) throws RegistryException {
        this.handlerManagers.get(DEFAULT_SYSTEM_HANDLER_PHASE).restoreVersion(requestContext);
        boolean isProcessingComplete = requestContext.isProcessingComplete();
        if (!isProcessingComplete) {
            this.handlerManagers.get(TENANT_SPECIFIC_SYSTEM_HANDLER_PHASE).restoreVersion(requestContext);
            isProcessingComplete = requestContext.isProcessingComplete();
        }
        if (!isProcessingComplete) {
            this.handlerManagers.get(USER_DEFINED_SYSTEM_HANDLER_PHASE).restoreVersion(requestContext);
            isProcessingComplete = requestContext.isProcessingComplete();
        }
        requestContext.setProcessingComplete(false);
        this.handlerManagers.get(USER_DEFINED_HANDLER_PHASE).restoreVersion(requestContext);
        requestContext.setProcessingComplete(isProcessingComplete |= requestContext.isProcessingComplete());
        this.handlerManagers.get(DEFAULT_REPORTING_HANDLER_PHASE).restoreVersion(requestContext);
    }

    @Override
    public void rateResource(RequestContext requestContext) throws RegistryException {
        this.handlerManagers.get(DEFAULT_SYSTEM_HANDLER_PHASE).rateResource(requestContext);
        boolean isProcessingComplete = requestContext.isProcessingComplete();
        if (!isProcessingComplete) {
            this.handlerManagers.get(TENANT_SPECIFIC_SYSTEM_HANDLER_PHASE).rateResource(requestContext);
            isProcessingComplete = requestContext.isProcessingComplete();
        }
        if (!isProcessingComplete) {
            this.handlerManagers.get(USER_DEFINED_SYSTEM_HANDLER_PHASE).rateResource(requestContext);
            isProcessingComplete = requestContext.isProcessingComplete();
        }
        requestContext.setProcessingComplete(false);
        this.handlerManagers.get(USER_DEFINED_HANDLER_PHASE).rateResource(requestContext);
        requestContext.setProcessingComplete(isProcessingComplete |= requestContext.isProcessingComplete());
        this.handlerManagers.get(DEFAULT_REPORTING_HANDLER_PHASE).rateResource(requestContext);
    }

    @Override
    public void removeTag(RequestContext requestContext) throws RegistryException {
        this.handlerManagers.get(DEFAULT_SYSTEM_HANDLER_PHASE).removeTag(requestContext);
        boolean isProcessingComplete = requestContext.isProcessingComplete();
        if (!isProcessingComplete) {
            this.handlerManagers.get(TENANT_SPECIFIC_SYSTEM_HANDLER_PHASE).removeTag(requestContext);
            isProcessingComplete = requestContext.isProcessingComplete();
        }
        if (!isProcessingComplete) {
            this.handlerManagers.get(USER_DEFINED_SYSTEM_HANDLER_PHASE).removeTag(requestContext);
            isProcessingComplete = requestContext.isProcessingComplete();
        }
        requestContext.setProcessingComplete(false);
        this.handlerManagers.get(USER_DEFINED_HANDLER_PHASE).removeTag(requestContext);
        requestContext.setProcessingComplete(isProcessingComplete |= requestContext.isProcessingComplete());
        this.handlerManagers.get(DEFAULT_REPORTING_HANDLER_PHASE).removeTag(requestContext);
    }

    @Override
    public void applyTag(RequestContext requestContext) throws RegistryException {
        this.handlerManagers.get(DEFAULT_SYSTEM_HANDLER_PHASE).applyTag(requestContext);
        boolean isProcessingComplete = requestContext.isProcessingComplete();
        if (!isProcessingComplete) {
            this.handlerManagers.get(TENANT_SPECIFIC_SYSTEM_HANDLER_PHASE).applyTag(requestContext);
            isProcessingComplete = requestContext.isProcessingComplete();
        }
        if (!isProcessingComplete) {
            this.handlerManagers.get(USER_DEFINED_SYSTEM_HANDLER_PHASE).applyTag(requestContext);
            isProcessingComplete = requestContext.isProcessingComplete();
        }
        requestContext.setProcessingComplete(false);
        this.handlerManagers.get(USER_DEFINED_HANDLER_PHASE).applyTag(requestContext);
        requestContext.setProcessingComplete(isProcessingComplete |= requestContext.isProcessingComplete());
        this.handlerManagers.get(DEFAULT_REPORTING_HANDLER_PHASE).applyTag(requestContext);
    }

    @Override
    public void removeAssociation(RequestContext requestContext) throws RegistryException {
        this.handlerManagers.get(DEFAULT_SYSTEM_HANDLER_PHASE).removeAssociation(requestContext);
        boolean isProcessingComplete = requestContext.isProcessingComplete();
        if (!isProcessingComplete) {
            this.handlerManagers.get(TENANT_SPECIFIC_SYSTEM_HANDLER_PHASE).removeAssociation(requestContext);
            isProcessingComplete = requestContext.isProcessingComplete();
        }
        if (!isProcessingComplete) {
            this.handlerManagers.get(USER_DEFINED_SYSTEM_HANDLER_PHASE).removeAssociation(requestContext);
            isProcessingComplete = requestContext.isProcessingComplete();
        }
        requestContext.setProcessingComplete(false);
        this.handlerManagers.get(USER_DEFINED_HANDLER_PHASE).removeAssociation(requestContext);
        requestContext.setProcessingComplete(isProcessingComplete |= requestContext.isProcessingComplete());
        this.handlerManagers.get(DEFAULT_REPORTING_HANDLER_PHASE).removeAssociation(requestContext);
    }

    @Override
    public void addAssociation(RequestContext requestContext) throws RegistryException {
        this.handlerManagers.get(DEFAULT_SYSTEM_HANDLER_PHASE).addAssociation(requestContext);
        boolean isProcessingComplete = requestContext.isProcessingComplete();
        if (!isProcessingComplete) {
            this.handlerManagers.get(TENANT_SPECIFIC_SYSTEM_HANDLER_PHASE).addAssociation(requestContext);
            isProcessingComplete = requestContext.isProcessingComplete();
        }
        if (!isProcessingComplete) {
            this.handlerManagers.get(USER_DEFINED_SYSTEM_HANDLER_PHASE).addAssociation(requestContext);
            isProcessingComplete = requestContext.isProcessingComplete();
        }
        requestContext.setProcessingComplete(false);
        this.handlerManagers.get(USER_DEFINED_HANDLER_PHASE).addAssociation(requestContext);
        requestContext.setProcessingComplete(isProcessingComplete |= requestContext.isProcessingComplete());
        this.handlerManagers.get(DEFAULT_REPORTING_HANDLER_PHASE).addAssociation(requestContext);
    }

    @Override
    public void delete(RequestContext requestContext) throws RegistryException {
        this.handlerManagers.get(DEFAULT_SYSTEM_HANDLER_PHASE).delete(requestContext);
        boolean isProcessingComplete = requestContext.isProcessingComplete();
        if (!isProcessingComplete) {
            this.handlerManagers.get(TENANT_SPECIFIC_SYSTEM_HANDLER_PHASE).delete(requestContext);
            isProcessingComplete = requestContext.isProcessingComplete();
        }
        if (!isProcessingComplete) {
            this.handlerManagers.get(USER_DEFINED_SYSTEM_HANDLER_PHASE).delete(requestContext);
            isProcessingComplete = requestContext.isProcessingComplete();
        }
        requestContext.setProcessingComplete(false);
        this.handlerManagers.get(USER_DEFINED_HANDLER_PHASE).delete(requestContext);
        requestContext.setProcessingComplete(isProcessingComplete |= requestContext.isProcessingComplete());
        this.handlerManagers.get(DEFAULT_REPORTING_HANDLER_PHASE).delete(requestContext);
    }

    @Override
    public void putChild(RequestContext requestContext) throws RegistryException {
        this.handlerManagers.get(DEFAULT_SYSTEM_HANDLER_PHASE).putChild(requestContext);
        boolean isProcessingComplete = requestContext.isProcessingComplete();
        if (!isProcessingComplete) {
            this.handlerManagers.get(TENANT_SPECIFIC_SYSTEM_HANDLER_PHASE).putChild(requestContext);
            isProcessingComplete = requestContext.isProcessingComplete();
        }
        if (!isProcessingComplete) {
            this.handlerManagers.get(USER_DEFINED_SYSTEM_HANDLER_PHASE).putChild(requestContext);
            isProcessingComplete = requestContext.isProcessingComplete();
        }
        requestContext.setProcessingComplete(false);
        this.handlerManagers.get(USER_DEFINED_HANDLER_PHASE).putChild(requestContext);
        requestContext.setProcessingComplete(isProcessingComplete |= requestContext.isProcessingComplete());
        this.handlerManagers.get(DEFAULT_REPORTING_HANDLER_PHASE).putChild(requestContext);
    }

    @Override
    public void importChild(RequestContext requestContext) throws RegistryException {
        this.handlerManagers.get(DEFAULT_SYSTEM_HANDLER_PHASE).importChild(requestContext);
        boolean isProcessingComplete = requestContext.isProcessingComplete();
        if (!isProcessingComplete) {
            this.handlerManagers.get(TENANT_SPECIFIC_SYSTEM_HANDLER_PHASE).importChild(requestContext);
            isProcessingComplete = requestContext.isProcessingComplete();
        }
        if (!isProcessingComplete) {
            this.handlerManagers.get(USER_DEFINED_SYSTEM_HANDLER_PHASE).importChild(requestContext);
            isProcessingComplete = requestContext.isProcessingComplete();
        }
        requestContext.setProcessingComplete(false);
        this.handlerManagers.get(USER_DEFINED_HANDLER_PHASE).importChild(requestContext);
        requestContext.setProcessingComplete(isProcessingComplete |= requestContext.isProcessingComplete());
        this.handlerManagers.get(DEFAULT_REPORTING_HANDLER_PHASE).importChild(requestContext);
    }

    @Override
    public void invokeAspect(RequestContext requestContext) throws RegistryException {
        this.handlerManagers.get(DEFAULT_SYSTEM_HANDLER_PHASE).invokeAspect(requestContext);
        boolean isProcessingComplete = requestContext.isProcessingComplete();
        if (!isProcessingComplete) {
            this.handlerManagers.get(TENANT_SPECIFIC_SYSTEM_HANDLER_PHASE).invokeAspect(requestContext);
            isProcessingComplete = requestContext.isProcessingComplete();
        }
        if (!isProcessingComplete) {
            this.handlerManagers.get(USER_DEFINED_SYSTEM_HANDLER_PHASE).invokeAspect(requestContext);
            isProcessingComplete = requestContext.isProcessingComplete();
        }
        requestContext.setProcessingComplete(false);
        this.handlerManagers.get(USER_DEFINED_HANDLER_PHASE).invokeAspect(requestContext);
        requestContext.setProcessingComplete(isProcessingComplete |= requestContext.isProcessingComplete());
        this.handlerManagers.get(DEFAULT_REPORTING_HANDLER_PHASE).invokeAspect(requestContext);
    }

    @Override
    public void createLink(RequestContext requestContext) throws RegistryException {
        this.handlerManagers.get(DEFAULT_SYSTEM_HANDLER_PHASE).createLink(requestContext);
        boolean isProcessingComplete = requestContext.isProcessingComplete();
        if (!isProcessingComplete) {
            this.handlerManagers.get(TENANT_SPECIFIC_SYSTEM_HANDLER_PHASE).createLink(requestContext);
            isProcessingComplete = requestContext.isProcessingComplete();
        }
        if (!isProcessingComplete) {
            this.handlerManagers.get(USER_DEFINED_SYSTEM_HANDLER_PHASE).createLink(requestContext);
            isProcessingComplete = requestContext.isProcessingComplete();
        }
        requestContext.setProcessingComplete(false);
        this.handlerManagers.get(USER_DEFINED_HANDLER_PHASE).createLink(requestContext);
        requestContext.setProcessingComplete(isProcessingComplete |= requestContext.isProcessingComplete());
        this.handlerManagers.get(DEFAULT_REPORTING_HANDLER_PHASE).createLink(requestContext);
    }

    @Override
    public void removeLink(RequestContext requestContext) throws RegistryException {
        this.handlerManagers.get(DEFAULT_SYSTEM_HANDLER_PHASE).removeLink(requestContext);
        boolean isProcessingComplete = requestContext.isProcessingComplete();
        if (!isProcessingComplete) {
            this.handlerManagers.get(TENANT_SPECIFIC_SYSTEM_HANDLER_PHASE).removeLink(requestContext);
            isProcessingComplete = requestContext.isProcessingComplete();
        }
        if (!isProcessingComplete) {
            this.handlerManagers.get(USER_DEFINED_SYSTEM_HANDLER_PHASE).removeLink(requestContext);
            isProcessingComplete = requestContext.isProcessingComplete();
        }
        requestContext.setProcessingComplete(false);
        this.handlerManagers.get(USER_DEFINED_HANDLER_PHASE).removeLink(requestContext);
        requestContext.setProcessingComplete(isProcessingComplete |= requestContext.isProcessingComplete());
        this.handlerManagers.get(DEFAULT_REPORTING_HANDLER_PHASE).removeLink(requestContext);
    }

    @Override
    public void restore(RequestContext requestContext) throws RegistryException {
        this.handlerManagers.get(DEFAULT_SYSTEM_HANDLER_PHASE).restore(requestContext);
        boolean isProcessingComplete = requestContext.isProcessingComplete();
        if (!isProcessingComplete) {
            this.handlerManagers.get(TENANT_SPECIFIC_SYSTEM_HANDLER_PHASE).restore(requestContext);
            isProcessingComplete = requestContext.isProcessingComplete();
        }
        if (!isProcessingComplete) {
            this.handlerManagers.get(USER_DEFINED_SYSTEM_HANDLER_PHASE).restore(requestContext);
            isProcessingComplete = requestContext.isProcessingComplete();
        }
        requestContext.setProcessingComplete(false);
        this.handlerManagers.get(USER_DEFINED_HANDLER_PHASE).restore(requestContext);
        requestContext.setProcessingComplete(isProcessingComplete |= requestContext.isProcessingComplete());
        this.handlerManagers.get(DEFAULT_REPORTING_HANDLER_PHASE).restore(requestContext);
    }

    @Override
    public Association[] getAllAssociations(RequestContext requestContext) throws RegistryException {
        Association[] defaultValue = this.handlerManagers.get(DEFAULT_SYSTEM_HANDLER_PHASE).getAllAssociations(requestContext);
        boolean isProcessingComplete = requestContext.isProcessingComplete();
        if (!isProcessingComplete) {
            Association[] tenantSpecificValue = this.handlerManagers.get(TENANT_SPECIFIC_SYSTEM_HANDLER_PHASE).getAllAssociations(requestContext);
            if (tenantSpecificValue != null) {
                defaultValue = tenantSpecificValue;
            }
            isProcessingComplete = requestContext.isProcessingComplete();
        }
        if (!isProcessingComplete) {
            Association[] systemSpecificValue = this.handlerManagers.get(USER_DEFINED_SYSTEM_HANDLER_PHASE).getAllAssociations(requestContext);
            if (systemSpecificValue != null) {
                defaultValue = systemSpecificValue;
            }
            isProcessingComplete = requestContext.isProcessingComplete();
        }
        requestContext.setProcessingComplete(false);
        Association[] userDefinedValue = this.handlerManagers.get(USER_DEFINED_HANDLER_PHASE).getAllAssociations(requestContext);
        requestContext.setProcessingComplete(isProcessingComplete |= requestContext.isProcessingComplete());
        this.handlerManagers.get(DEFAULT_REPORTING_HANDLER_PHASE).getAllAssociations(requestContext);
        if (userDefinedValue != null) {
            return userDefinedValue;
        }
        return defaultValue;
    }

    @Override
    public Association[] getAssociations(RequestContext requestContext) throws RegistryException {
        Association[] defaultValue = this.handlerManagers.get(DEFAULT_SYSTEM_HANDLER_PHASE).getAssociations(requestContext);
        boolean isProcessingComplete = requestContext.isProcessingComplete();
        if (!isProcessingComplete) {
            Association[] tenantSpecificValue = this.handlerManagers.get(TENANT_SPECIFIC_SYSTEM_HANDLER_PHASE).getAssociations(requestContext);
            if (tenantSpecificValue != null) {
                defaultValue = tenantSpecificValue;
            }
            isProcessingComplete = requestContext.isProcessingComplete();
        }
        if (!isProcessingComplete) {
            Association[] systemSpecificValue = this.handlerManagers.get(USER_DEFINED_SYSTEM_HANDLER_PHASE).getAssociations(requestContext);
            if (systemSpecificValue != null) {
                defaultValue = systemSpecificValue;
            }
            isProcessingComplete = requestContext.isProcessingComplete();
        }
        requestContext.setProcessingComplete(false);
        Association[] userDefinedValue = this.handlerManagers.get(USER_DEFINED_HANDLER_PHASE).getAssociations(requestContext);
        requestContext.setProcessingComplete(isProcessingComplete |= requestContext.isProcessingComplete());
        this.handlerManagers.get(DEFAULT_REPORTING_HANDLER_PHASE).getAssociations(requestContext);
        if (userDefinedValue != null) {
            return userDefinedValue;
        }
        return defaultValue;
    }

    @Override
    public TaggedResourcePath[] getResourcePathsWithTag(RequestContext requestContext) throws RegistryException {
        TaggedResourcePath[] defaultValue = this.handlerManagers.get(DEFAULT_SYSTEM_HANDLER_PHASE).getResourcePathsWithTag(requestContext);
        boolean isProcessingComplete = requestContext.isProcessingComplete();
        if (!isProcessingComplete) {
            TaggedResourcePath[] tenantSpecificValue = this.handlerManagers.get(TENANT_SPECIFIC_SYSTEM_HANDLER_PHASE).getResourcePathsWithTag(requestContext);
            if (tenantSpecificValue != null) {
                defaultValue = tenantSpecificValue;
            }
            isProcessingComplete = requestContext.isProcessingComplete();
        }
        if (!isProcessingComplete) {
            TaggedResourcePath[] systemSpecificValue = this.handlerManagers.get(USER_DEFINED_SYSTEM_HANDLER_PHASE).getResourcePathsWithTag(requestContext);
            if (systemSpecificValue != null) {
                defaultValue = systemSpecificValue;
            }
            isProcessingComplete = requestContext.isProcessingComplete();
        }
        requestContext.setProcessingComplete(false);
        TaggedResourcePath[] userDefinedValue = this.handlerManagers.get(USER_DEFINED_HANDLER_PHASE).getResourcePathsWithTag(requestContext);
        isProcessingComplete |= requestContext.isProcessingComplete();
        this.handlerManagers.get(DEFAULT_REPORTING_HANDLER_PHASE).getResourcePathsWithTag(requestContext);
        if (userDefinedValue != null) {
            return userDefinedValue;
        }
        return defaultValue;
    }

    @Override
    public Tag[] getTags(RequestContext requestContext) throws RegistryException {
        Tag[] defaultValue = this.handlerManagers.get(DEFAULT_SYSTEM_HANDLER_PHASE).getTags(requestContext);
        boolean isProcessingComplete = requestContext.isProcessingComplete();
        if (!isProcessingComplete) {
            Tag[] tenantSpecificValue = this.handlerManagers.get(TENANT_SPECIFIC_SYSTEM_HANDLER_PHASE).getTags(requestContext);
            if (tenantSpecificValue != null) {
                defaultValue = tenantSpecificValue;
            }
            isProcessingComplete = requestContext.isProcessingComplete();
        }
        if (!isProcessingComplete) {
            Tag[] systemSpecificValue = this.handlerManagers.get(USER_DEFINED_SYSTEM_HANDLER_PHASE).getTags(requestContext);
            if (systemSpecificValue != null) {
                defaultValue = systemSpecificValue;
            }
            isProcessingComplete = requestContext.isProcessingComplete();
        }
        requestContext.setProcessingComplete(false);
        Tag[] userDefinedValue = this.handlerManagers.get(USER_DEFINED_HANDLER_PHASE).getTags(requestContext);
        requestContext.setProcessingComplete(isProcessingComplete |= requestContext.isProcessingComplete());
        this.handlerManagers.get(DEFAULT_REPORTING_HANDLER_PHASE).getTags(requestContext);
        if (userDefinedValue != null) {
            return userDefinedValue;
        }
        return defaultValue;
    }

    @Override
    public Comment[] getComments(RequestContext requestContext) throws RegistryException {
        Comment[] defaultValue = this.handlerManagers.get(DEFAULT_SYSTEM_HANDLER_PHASE).getComments(requestContext);
        boolean isProcessingComplete = requestContext.isProcessingComplete();
        if (!isProcessingComplete) {
            Comment[] tenantSpecificValue = this.handlerManagers.get(TENANT_SPECIFIC_SYSTEM_HANDLER_PHASE).getComments(requestContext);
            if (tenantSpecificValue != null) {
                defaultValue = tenantSpecificValue;
            }
            isProcessingComplete = requestContext.isProcessingComplete();
        }
        if (!isProcessingComplete) {
            Comment[] systemSpecificValue = this.handlerManagers.get(USER_DEFINED_SYSTEM_HANDLER_PHASE).getComments(requestContext);
            if (systemSpecificValue != null) {
                defaultValue = systemSpecificValue;
            }
            isProcessingComplete = requestContext.isProcessingComplete();
        }
        requestContext.setProcessingComplete(false);
        Comment[] userDefinedValue = this.handlerManagers.get(USER_DEFINED_HANDLER_PHASE).getComments(requestContext);
        requestContext.setProcessingComplete(isProcessingComplete |= requestContext.isProcessingComplete());
        this.handlerManagers.get(DEFAULT_REPORTING_HANDLER_PHASE).getComments(requestContext);
        if (userDefinedValue != null) {
            return userDefinedValue;
        }
        return defaultValue;
    }

    @Override
    public String[] getVersions(RequestContext requestContext) throws RegistryException {
        String[] defaultValue = this.handlerManagers.get(DEFAULT_SYSTEM_HANDLER_PHASE).getVersions(requestContext);
        boolean isProcessingComplete = requestContext.isProcessingComplete();
        if (!isProcessingComplete) {
            String[] tenantSpecificValue = this.handlerManagers.get(TENANT_SPECIFIC_SYSTEM_HANDLER_PHASE).getVersions(requestContext);
            if (tenantSpecificValue != null) {
                defaultValue = tenantSpecificValue;
            }
            isProcessingComplete = requestContext.isProcessingComplete();
        }
        if (!isProcessingComplete) {
            String[] systemSpecificValue = this.handlerManagers.get(USER_DEFINED_SYSTEM_HANDLER_PHASE).getVersions(requestContext);
            if (systemSpecificValue != null) {
                defaultValue = systemSpecificValue;
            }
            isProcessingComplete = requestContext.isProcessingComplete();
        }
        requestContext.setProcessingComplete(false);
        String[] userDefinedValue = this.handlerManagers.get(USER_DEFINED_HANDLER_PHASE).getVersions(requestContext);
        requestContext.setProcessingComplete(isProcessingComplete |= requestContext.isProcessingComplete());
        this.handlerManagers.get(DEFAULT_REPORTING_HANDLER_PHASE).getVersions(requestContext);
        if (userDefinedValue != null) {
            return userDefinedValue;
        }
        return defaultValue;
    }

    @Override
    public Collection executeQuery(RequestContext requestContext) throws RegistryException {
        Collection defaultValue = this.handlerManagers.get(DEFAULT_SYSTEM_HANDLER_PHASE).executeQuery(requestContext);
        boolean isProcessingComplete = requestContext.isProcessingComplete();
        if (!isProcessingComplete) {
            Collection tenantSpecificValue = this.handlerManagers.get(TENANT_SPECIFIC_SYSTEM_HANDLER_PHASE).executeQuery(requestContext);
            if (tenantSpecificValue != null) {
                defaultValue = tenantSpecificValue;
            }
            isProcessingComplete = requestContext.isProcessingComplete();
        }
        if (!isProcessingComplete) {
            Collection systemSpecificValue = this.handlerManagers.get(USER_DEFINED_SYSTEM_HANDLER_PHASE).executeQuery(requestContext);
            if (systemSpecificValue != null) {
                defaultValue = systemSpecificValue;
            }
            isProcessingComplete = requestContext.isProcessingComplete();
        }
        requestContext.setProcessingComplete(false);
        Collection userDefinedValue = this.handlerManagers.get(USER_DEFINED_HANDLER_PHASE).executeQuery(requestContext);
        requestContext.setProcessingComplete(isProcessingComplete |= requestContext.isProcessingComplete());
        this.handlerManagers.get(DEFAULT_REPORTING_HANDLER_PHASE).executeQuery(requestContext);
        if (userDefinedValue != null) {
            return userDefinedValue;
        }
        return defaultValue;
    }

    @Override
    public Collection searchContent(RequestContext requestContext) throws RegistryException {
        Collection defaultValue = this.handlerManagers.get(DEFAULT_SYSTEM_HANDLER_PHASE).searchContent(requestContext);
        boolean isProcessingComplete = requestContext.isProcessingComplete();
        if (!isProcessingComplete) {
            Collection tenantSpecificValue = this.handlerManagers.get(TENANT_SPECIFIC_SYSTEM_HANDLER_PHASE).searchContent(requestContext);
            if (tenantSpecificValue != null) {
                defaultValue = tenantSpecificValue;
            }
            isProcessingComplete = requestContext.isProcessingComplete();
        }
        if (!isProcessingComplete) {
            Collection systemSpecificValue = this.handlerManagers.get(USER_DEFINED_SYSTEM_HANDLER_PHASE).searchContent(requestContext);
            if (systemSpecificValue != null) {
                defaultValue = systemSpecificValue;
            }
            isProcessingComplete = requestContext.isProcessingComplete();
        }
        requestContext.setProcessingComplete(false);
        Collection userDefinedValue = this.handlerManagers.get(USER_DEFINED_HANDLER_PHASE).searchContent(requestContext);
        requestContext.setProcessingComplete(isProcessingComplete |= requestContext.isProcessingComplete());
        this.handlerManagers.get(DEFAULT_REPORTING_HANDLER_PHASE).searchContent(requestContext);
        if (userDefinedValue != null) {
            return userDefinedValue;
        }
        return defaultValue;
    }

    @Override
    public String addComment(RequestContext requestContext) throws RegistryException {
        String defaultValue = this.handlerManagers.get(DEFAULT_SYSTEM_HANDLER_PHASE).addComment(requestContext);
        boolean isProcessingComplete = requestContext.isProcessingComplete();
        if (!isProcessingComplete) {
            String tenantSpecificValue = this.handlerManagers.get(TENANT_SPECIFIC_SYSTEM_HANDLER_PHASE).addComment(requestContext);
            if (tenantSpecificValue != null) {
                defaultValue = tenantSpecificValue;
            }
            isProcessingComplete = requestContext.isProcessingComplete();
        }
        if (!isProcessingComplete) {
            String systemSpecificValue = this.handlerManagers.get(USER_DEFINED_SYSTEM_HANDLER_PHASE).addComment(requestContext);
            if (systemSpecificValue != null) {
                defaultValue = systemSpecificValue;
            }
            isProcessingComplete = requestContext.isProcessingComplete();
        }
        requestContext.setProcessingComplete(false);
        String userDefinedValue = this.handlerManagers.get(USER_DEFINED_HANDLER_PHASE).addComment(requestContext);
        requestContext.setProcessingComplete(isProcessingComplete |= requestContext.isProcessingComplete());
        this.handlerManagers.get(DEFAULT_REPORTING_HANDLER_PHASE).addComment(requestContext);
        if (userDefinedValue != null) {
            return userDefinedValue;
        }
        return defaultValue;
    }

    @Override
    public Resource get(RequestContext requestContext) throws RegistryException {
        Resource defaultValue = this.handlerManagers.get(DEFAULT_SYSTEM_HANDLER_PHASE).get(requestContext);
        boolean isProcessingComplete = requestContext.isProcessingComplete();
        if (!isProcessingComplete) {
            Resource tenantSpecificValue = this.handlerManagers.get(TENANT_SPECIFIC_SYSTEM_HANDLER_PHASE).get(requestContext);
            if (tenantSpecificValue != null) {
                defaultValue = tenantSpecificValue;
            }
            isProcessingComplete = requestContext.isProcessingComplete();
        }
        if (!isProcessingComplete) {
            Resource systemSpecificValue = this.handlerManagers.get(USER_DEFINED_SYSTEM_HANDLER_PHASE).get(requestContext);
            if (systemSpecificValue != null) {
                defaultValue = systemSpecificValue;
            }
            isProcessingComplete = requestContext.isProcessingComplete();
        }
        requestContext.setProcessingComplete(false);
        Resource userDefinedValue = this.handlerManagers.get(USER_DEFINED_HANDLER_PHASE).get(requestContext);
        requestContext.setProcessingComplete(isProcessingComplete |= requestContext.isProcessingComplete());
        Resource resourceOnContext = requestContext.getResource();
        Resource output = userDefinedValue != null ? userDefinedValue : defaultValue;
        requestContext.setResource(output);
        this.handlerManagers.get(DEFAULT_REPORTING_HANDLER_PHASE).get(requestContext);
        requestContext.setResource(resourceOnContext);
        return output;
    }

    @Override
    public String put(RequestContext requestContext) throws RegistryException {
        String defaultValue = this.handlerManagers.get(DEFAULT_SYSTEM_HANDLER_PHASE).put(requestContext);
        boolean isProcessingComplete = requestContext.isProcessingComplete();
        if (!isProcessingComplete) {
            String tenantSpecificValue = this.handlerManagers.get(TENANT_SPECIFIC_SYSTEM_HANDLER_PHASE).put(requestContext);
            if (tenantSpecificValue != null) {
                defaultValue = tenantSpecificValue;
            }
            isProcessingComplete = requestContext.isProcessingComplete();
        }
        if (!isProcessingComplete) {
            String systemSpecificValue = this.handlerManagers.get(USER_DEFINED_SYSTEM_HANDLER_PHASE).put(requestContext);
            if (systemSpecificValue != null) {
                defaultValue = systemSpecificValue;
            }
            isProcessingComplete = requestContext.isProcessingComplete();
        }
        requestContext.setProcessingComplete(false);
        String userDefinedValue = this.handlerManagers.get(USER_DEFINED_HANDLER_PHASE).put(requestContext);
        requestContext.setProcessingComplete(isProcessingComplete |= requestContext.isProcessingComplete());
        this.handlerManagers.get(DEFAULT_REPORTING_HANDLER_PHASE).put(requestContext);
        if (userDefinedValue != null) {
            return userDefinedValue;
        }
        return defaultValue;
    }

    @Override
    public String importResource(RequestContext requestContext) throws RegistryException {
        String defaultValue = this.handlerManagers.get(DEFAULT_SYSTEM_HANDLER_PHASE).importResource(requestContext);
        boolean isProcessingComplete = requestContext.isProcessingComplete();
        if (!isProcessingComplete) {
            String tenantSpecificValue = this.handlerManagers.get(TENANT_SPECIFIC_SYSTEM_HANDLER_PHASE).importResource(requestContext);
            if (tenantSpecificValue != null) {
                defaultValue = tenantSpecificValue;
            }
            isProcessingComplete = requestContext.isProcessingComplete();
        }
        if (!isProcessingComplete) {
            String systemSpecificValue = this.handlerManagers.get(USER_DEFINED_SYSTEM_HANDLER_PHASE).importResource(requestContext);
            if (systemSpecificValue != null) {
                defaultValue = systemSpecificValue;
            }
            isProcessingComplete = requestContext.isProcessingComplete();
        }
        requestContext.setProcessingComplete(false);
        String userDefinedValue = this.handlerManagers.get(USER_DEFINED_HANDLER_PHASE).importResource(requestContext);
        requestContext.setProcessingComplete(isProcessingComplete |= requestContext.isProcessingComplete());
        this.handlerManagers.get(DEFAULT_REPORTING_HANDLER_PHASE).importResource(requestContext);
        if (userDefinedValue != null) {
            return userDefinedValue;
        }
        return defaultValue;
    }

    @Override
    public String copy(RequestContext requestContext) throws RegistryException {
        String defaultValue = this.handlerManagers.get(DEFAULT_SYSTEM_HANDLER_PHASE).copy(requestContext);
        boolean isProcessingComplete = requestContext.isProcessingComplete();
        if (!isProcessingComplete) {
            String tenantSpecificValue = this.handlerManagers.get(TENANT_SPECIFIC_SYSTEM_HANDLER_PHASE).copy(requestContext);
            if (tenantSpecificValue != null) {
                defaultValue = tenantSpecificValue;
            }
            isProcessingComplete = requestContext.isProcessingComplete();
        }
        if (!isProcessingComplete) {
            String systemSpecificValue = this.handlerManagers.get(USER_DEFINED_SYSTEM_HANDLER_PHASE).copy(requestContext);
            if (systemSpecificValue != null) {
                defaultValue = systemSpecificValue;
            }
            isProcessingComplete = requestContext.isProcessingComplete();
        }
        requestContext.setProcessingComplete(false);
        String userDefinedValue = this.handlerManagers.get(USER_DEFINED_HANDLER_PHASE).copy(requestContext);
        requestContext.setProcessingComplete(isProcessingComplete |= requestContext.isProcessingComplete());
        this.handlerManagers.get(DEFAULT_REPORTING_HANDLER_PHASE).copy(requestContext);
        if (userDefinedValue != null) {
            return userDefinedValue;
        }
        return defaultValue;
    }

    @Override
    public String move(RequestContext requestContext) throws RegistryException {
        String defaultValue = this.handlerManagers.get(DEFAULT_SYSTEM_HANDLER_PHASE).move(requestContext);
        boolean isProcessingComplete = requestContext.isProcessingComplete();
        if (!isProcessingComplete) {
            String tenantSpecificValue = this.handlerManagers.get(TENANT_SPECIFIC_SYSTEM_HANDLER_PHASE).move(requestContext);
            if (tenantSpecificValue != null) {
                defaultValue = tenantSpecificValue;
            }
            isProcessingComplete = requestContext.isProcessingComplete();
        }
        if (!isProcessingComplete) {
            String systemSpecificValue = this.handlerManagers.get(USER_DEFINED_SYSTEM_HANDLER_PHASE).move(requestContext);
            if (systemSpecificValue != null) {
                defaultValue = systemSpecificValue;
            }
            isProcessingComplete = requestContext.isProcessingComplete();
        }
        requestContext.setProcessingComplete(false);
        String userDefinedValue = this.handlerManagers.get(USER_DEFINED_HANDLER_PHASE).move(requestContext);
        requestContext.setProcessingComplete(isProcessingComplete |= requestContext.isProcessingComplete());
        this.handlerManagers.get(DEFAULT_REPORTING_HANDLER_PHASE).move(requestContext);
        if (userDefinedValue != null) {
            return userDefinedValue;
        }
        return defaultValue;
    }

    @Override
    public String rename(RequestContext requestContext) throws RegistryException {
        String defaultValue = this.handlerManagers.get(DEFAULT_SYSTEM_HANDLER_PHASE).rename(requestContext);
        boolean isProcessingComplete = requestContext.isProcessingComplete();
        if (!isProcessingComplete) {
            String tenantSpecificValue = this.handlerManagers.get(TENANT_SPECIFIC_SYSTEM_HANDLER_PHASE).rename(requestContext);
            if (tenantSpecificValue != null) {
                defaultValue = tenantSpecificValue;
            }
            isProcessingComplete = requestContext.isProcessingComplete();
        }
        if (!isProcessingComplete) {
            String systemSpecificValue = this.handlerManagers.get(USER_DEFINED_SYSTEM_HANDLER_PHASE).rename(requestContext);
            if (systemSpecificValue != null) {
                defaultValue = systemSpecificValue;
            }
            isProcessingComplete = requestContext.isProcessingComplete();
        }
        requestContext.setProcessingComplete(false);
        String userDefinedValue = this.handlerManagers.get(USER_DEFINED_HANDLER_PHASE).rename(requestContext);
        requestContext.setProcessingComplete(isProcessingComplete |= requestContext.isProcessingComplete());
        this.handlerManagers.get(DEFAULT_REPORTING_HANDLER_PHASE).rename(requestContext);
        if (userDefinedValue != null) {
            return userDefinedValue;
        }
        return defaultValue;
    }

    @Override
    public OMElement dump(RequestContext requestContext) throws RegistryException {
        OMElement defaultValue = this.handlerManagers.get(DEFAULT_SYSTEM_HANDLER_PHASE).dump(requestContext);
        boolean isProcessingComplete = requestContext.isProcessingComplete();
        if (!isProcessingComplete) {
            OMElement tenantSpecificValue = this.handlerManagers.get(TENANT_SPECIFIC_SYSTEM_HANDLER_PHASE).dump(requestContext);
            if (tenantSpecificValue != null) {
                defaultValue = tenantSpecificValue;
            }
            isProcessingComplete = requestContext.isProcessingComplete();
        }
        if (!isProcessingComplete) {
            OMElement systemSpecificValue = this.handlerManagers.get(USER_DEFINED_SYSTEM_HANDLER_PHASE).dump(requestContext);
            if (systemSpecificValue != null) {
                defaultValue = systemSpecificValue;
            }
            isProcessingComplete = requestContext.isProcessingComplete();
        }
        requestContext.setProcessingComplete(false);
        OMElement userDefinedValue = this.handlerManagers.get(USER_DEFINED_HANDLER_PHASE).dump(requestContext);
        requestContext.setProcessingComplete(isProcessingComplete |= requestContext.isProcessingComplete());
        this.handlerManagers.get(DEFAULT_REPORTING_HANDLER_PHASE).dump(requestContext);
        if (userDefinedValue != null) {
            return userDefinedValue;
        }
        return defaultValue;
    }

    @Override
    public float getAverageRating(RequestContext requestContext) throws RegistryException {
        float defaultValue = this.handlerManagers.get(DEFAULT_SYSTEM_HANDLER_PHASE).getAverageRating(requestContext);
        boolean isProcessingComplete = requestContext.isProcessingComplete();
        if (!isProcessingComplete) {
            float tenantSpecificValue = this.handlerManagers.get(TENANT_SPECIFIC_SYSTEM_HANDLER_PHASE).getAverageRating(requestContext);
            if (tenantSpecificValue != -1.0f) {
                defaultValue = tenantSpecificValue;
            }
            isProcessingComplete = requestContext.isProcessingComplete();
        }
        if (!isProcessingComplete) {
            float systemSpecificValue = this.handlerManagers.get(USER_DEFINED_SYSTEM_HANDLER_PHASE).getAverageRating(requestContext);
            if (systemSpecificValue != -1.0f) {
                defaultValue = systemSpecificValue;
            }
            isProcessingComplete = requestContext.isProcessingComplete();
        }
        requestContext.setProcessingComplete(false);
        float userDefinedValue = this.handlerManagers.get(USER_DEFINED_HANDLER_PHASE).getAverageRating(requestContext);
        requestContext.setProcessingComplete(isProcessingComplete |= requestContext.isProcessingComplete());
        this.handlerManagers.get(DEFAULT_REPORTING_HANDLER_PHASE).getAverageRating(requestContext);
        if (userDefinedValue != -1.0f) {
            return userDefinedValue;
        }
        return defaultValue;
    }

    @Override
    public int getRating(RequestContext requestContext) throws RegistryException {
        int defaultValue = this.handlerManagers.get(DEFAULT_SYSTEM_HANDLER_PHASE).getRating(requestContext);
        boolean isProcessingComplete = requestContext.isProcessingComplete();
        if (!isProcessingComplete) {
            int tenantSpecificValue = this.handlerManagers.get(TENANT_SPECIFIC_SYSTEM_HANDLER_PHASE).getRating(requestContext);
            if (tenantSpecificValue != -1) {
                defaultValue = tenantSpecificValue;
            }
            isProcessingComplete = requestContext.isProcessingComplete();
        }
        if (!isProcessingComplete) {
            int systemSpecificValue = this.handlerManagers.get(USER_DEFINED_SYSTEM_HANDLER_PHASE).getRating(requestContext);
            if (systemSpecificValue != -1) {
                defaultValue = systemSpecificValue;
            }
            isProcessingComplete = requestContext.isProcessingComplete();
        }
        requestContext.setProcessingComplete(false);
        int userDefinedValue = this.handlerManagers.get(USER_DEFINED_HANDLER_PHASE).getRating(requestContext);
        requestContext.setProcessingComplete(isProcessingComplete |= requestContext.isProcessingComplete());
        this.handlerManagers.get(DEFAULT_REPORTING_HANDLER_PHASE).getRating(requestContext);
        if (userDefinedValue != -1) {
            return userDefinedValue;
        }
        return defaultValue;
    }

    @Override
    public boolean resourceExists(RequestContext requestContext) throws RegistryException {
        boolean defaultValue = this.handlerManagers.get(DEFAULT_SYSTEM_HANDLER_PHASE).resourceExists(requestContext);
        boolean isProcessingComplete = requestContext.isProcessingComplete();
        if (!isProcessingComplete) {
            boolean tenantSpecificValue = this.handlerManagers.get(TENANT_SPECIFIC_SYSTEM_HANDLER_PHASE).resourceExists(requestContext);
            defaultValue = defaultValue || tenantSpecificValue;
            isProcessingComplete = requestContext.isProcessingComplete();
        }
        if (!isProcessingComplete) {
            boolean systemSpecificValue = this.handlerManagers.get(USER_DEFINED_SYSTEM_HANDLER_PHASE).resourceExists(requestContext);
            defaultValue = defaultValue || systemSpecificValue;
            isProcessingComplete = requestContext.isProcessingComplete();
        }
        requestContext.setProcessingComplete(false);
        boolean userDefinedValue = this.handlerManagers.get(USER_DEFINED_HANDLER_PHASE).resourceExists(requestContext);
        requestContext.setProcessingComplete(isProcessingComplete |= requestContext.isProcessingComplete());
        this.handlerManagers.get(DEFAULT_REPORTING_HANDLER_PHASE).resourceExists(requestContext);
        return userDefinedValue || defaultValue;
    }

    @Override
    public RegistryContext getRegistryContext(RequestContext requestContext) {
        RegistryContext defaultValue = this.handlerManagers.get(DEFAULT_SYSTEM_HANDLER_PHASE).getRegistryContext(requestContext);
        boolean isProcessingComplete = requestContext.isProcessingComplete();
        if (!isProcessingComplete) {
            RegistryContext tenantSpecificValue = this.handlerManagers.get(TENANT_SPECIFIC_SYSTEM_HANDLER_PHASE).getRegistryContext(requestContext);
            if (tenantSpecificValue != null) {
                defaultValue = tenantSpecificValue;
            }
            isProcessingComplete = requestContext.isProcessingComplete();
        }
        if (!isProcessingComplete) {
            RegistryContext systemSpecificValue = this.handlerManagers.get(USER_DEFINED_SYSTEM_HANDLER_PHASE).getRegistryContext(requestContext);
            if (systemSpecificValue != null) {
                defaultValue = systemSpecificValue;
            }
            isProcessingComplete = requestContext.isProcessingComplete();
        }
        requestContext.setProcessingComplete(false);
        RegistryContext userDefinedValue = this.handlerManagers.get(USER_DEFINED_HANDLER_PHASE).getRegistryContext(requestContext);
        requestContext.setProcessingComplete(isProcessingComplete |= requestContext.isProcessingComplete());
        this.handlerManagers.get(DEFAULT_REPORTING_HANDLER_PHASE).getRegistryContext(requestContext);
        if (userDefinedValue != null) {
            return userDefinedValue;
        }
        return defaultValue;
    }

    @Override
    public OMElement dumpLite(RequestContext requestContext) throws RegistryException {
        OMElement defaultValue = this.handlerManagers.get(DEFAULT_SYSTEM_HANDLER_PHASE).dumpLite(requestContext);
        boolean isProcessingComplete = requestContext.isProcessingComplete();
        if (!isProcessingComplete) {
            OMElement tenantSpecificValue = this.handlerManagers.get(TENANT_SPECIFIC_SYSTEM_HANDLER_PHASE).dumpLite(requestContext);
            if (tenantSpecificValue != null) {
                defaultValue = tenantSpecificValue;
            }
            isProcessingComplete = requestContext.isProcessingComplete();
        }
        if (!isProcessingComplete) {
            OMElement systemSpecificValue = this.handlerManagers.get(USER_DEFINED_SYSTEM_HANDLER_PHASE).dumpLite(requestContext);
            if (systemSpecificValue != null) {
                defaultValue = systemSpecificValue;
            }
            isProcessingComplete = requestContext.isProcessingComplete();
        }
        requestContext.setProcessingComplete(false);
        OMElement userDefinedValue = this.handlerManagers.get(USER_DEFINED_HANDLER_PHASE).dumpLite(requestContext);
        requestContext.setProcessingComplete(isProcessingComplete |= requestContext.isProcessingComplete());
        this.handlerManagers.get(DEFAULT_REPORTING_HANDLER_PHASE).dumpLite(requestContext);
        if (userDefinedValue != null) {
            return userDefinedValue;
        }
        return defaultValue;
    }
}

