/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.core.jdbc.dataaccess;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.dataaccess.DataAccessManager;
import org.wso2.carbon.registry.core.dataaccess.TransactionManager;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.dataaccess.AbstractConnection;
import org.wso2.carbon.registry.core.jdbc.dataaccess.ConnectionWrapper;
import org.wso2.carbon.registry.core.jdbc.dataaccess.JDBCDataAccessManager;
import org.wso2.carbon.registry.core.jdbc.dataaccess.JDBCDatabaseTransaction;
import org.wso2.carbon.registry.core.jdbc.utils.Transaction;
import org.wso2.carbon.registry.core.utils.RegistryUtils;

public class JDBCTransactionManager
implements TransactionManager {
    private DataAccessManager dataAccessManager;
    private static final Log log = LogFactory.getLog(TransactionManager.class);

    public JDBCTransactionManager(DataAccessManager dataAccessManager) {
        this.dataAccessManager = dataAccessManager;
    }

    @Override
    public void beginTransaction() throws RegistryException {
        if (this.dataAccessManager.getDatabaseTransaction().getNestedDepth() != 0) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("The transaction was not started, because it is called within a transaction, nested depth: " + this.dataAccessManager.getDatabaseTransaction().getNestedDepth() + "."));
            }
            this.dataAccessManager.getDatabaseTransaction().incNestedDepth();
            if (JDBCDatabaseTransaction.getConnection() != null) {
                return;
            }
            while (this.dataAccessManager.getDatabaseTransaction().getNestedDepth() > 0) {
                this.dataAccessManager.getDatabaseTransaction().decNestedDepth();
            }
            while (this.dataAccessManager.getDatabaseTransaction().getNestedDepth() < 0) {
                this.dataAccessManager.getDatabaseTransaction().incNestedDepth();
            }
        }
        Connection conn = null;
        String connectionId = null;
        try {
            if (!(this.dataAccessManager instanceof JDBCDataAccessManager)) {
                String msg = "Failed to begin transaction. Invalid data access manager.";
                log.error((Object)msg);
                throw new RegistryException(msg);
            }
            DataSource dataSource = ((JDBCDataAccessManager)this.dataAccessManager).getDataSource();
            connectionId = RegistryUtils.getConnectionId(dataSource);
            conn = new ConnectionWrapper(dataSource.getConnection(), connectionId);
            JDBCDatabaseTransaction.ManagedRegistryConnection temp = JDBCDatabaseTransaction.getManagedRegistryConnection((AbstractConnection)conn);
            if (temp != null) {
                conn.close();
                conn = temp;
            }
            if (conn.getTransactionIsolation() != 2) {
                conn.setTransactionIsolation(2);
            }
            conn.setAutoCommit(false);
            this.dataAccessManager.getDatabaseTransaction().incNestedDepth();
        }
        catch (SQLException e) {
            String msg = "Failed to start new registry transaction.";
            log.error((Object)msg, (Throwable)e);
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e1) {
                    String msgFailed = "Failed to close connection.";
                    log.error((Object)msgFailed, (Throwable)e);
                }
            }
            throw new RegistryException(msg, e);
        }
        JDBCDatabaseTransaction.setConnection((AbstractConnection)conn);
    }

    @Override
    public void rollbackTransaction() throws RegistryException {
        this.dataAccessManager.getDatabaseTransaction().setRollbacked(true);
        if (this.dataAccessManager.getDatabaseTransaction().getNestedDepth() != 1) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("The transaction was not rollbacked, because it is called within a transaction, nested depth: " + this.dataAccessManager.getDatabaseTransaction().getNestedDepth() + "."));
            }
            this.dataAccessManager.getDatabaseTransaction().decNestedDepth();
            return;
        }
        JDBCDatabaseTransaction.ManagedRegistryConnection conn = JDBCDatabaseTransaction.getConnection();
        try {
            conn.rollback();
        }
        catch (SQLException e) {
            String msg = "Failed to rollback transaction.";
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, e);
        }
        finally {
            this.endTransaction();
            this.dataAccessManager.getDatabaseTransaction().decNestedDepth();
        }
    }

    @Override
    public void commitTransaction() throws RegistryException {
        if (this.dataAccessManager.getDatabaseTransaction().getNestedDepth() != 1) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("The transaction was not committed, because it is called within a transaction, nested depth: " + this.dataAccessManager.getDatabaseTransaction().getNestedDepth() + "."));
            }
            this.dataAccessManager.getDatabaseTransaction().decNestedDepth();
            return;
        }
        if (this.dataAccessManager.getDatabaseTransaction().isRollbacked()) {
            String msg = "The transaction is already rollbacked, you can not commit a transaction already rollbacked, nested depth: " + this.dataAccessManager.getDatabaseTransaction().getNestedDepth() + ".";
            log.debug((Object)msg);
            this.dataAccessManager.getDatabaseTransaction().decNestedDepth();
            throw new RegistryException(msg);
        }
        JDBCDatabaseTransaction.ManagedRegistryConnection conn = JDBCDatabaseTransaction.getConnection();
        try {
            conn.commit();
        }
        catch (SQLException e) {
            String msg = "Failed to commit transaction.";
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, e);
        }
        finally {
            this.endTransaction();
            this.dataAccessManager.getDatabaseTransaction().decNestedDepth();
        }
    }

    private void endTransaction() throws RegistryException {
        if (Transaction.isStarted()) {
            JDBCDatabaseTransaction.ManagedRegistryConnection conn = JDBCDatabaseTransaction.getConnection();
            try {
                conn.close();
            }
            catch (SQLException e) {
                String msg = "Failed to close transaction.";
                log.error((Object)msg, (Throwable)e);
                throw new RegistryException(msg, e);
            }
            finally {
                this.dataAccessManager.getDatabaseTransaction().setStarted(false);
                JDBCDatabaseTransaction.setConnection(null);
            }
        }
    }
}

