/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.core.jdbc.dataaccess;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tomcat.jdbc.pool.DataSource;
import org.apache.tomcat.jdbc.pool.PoolConfiguration;
import org.apache.tomcat.jdbc.pool.PoolProperties;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.registry.core.config.DataBaseConfiguration;
import org.wso2.carbon.registry.core.dataaccess.ClusterLock;
import org.wso2.carbon.registry.core.dataaccess.DAOManager;
import org.wso2.carbon.registry.core.dataaccess.DataAccessManager;
import org.wso2.carbon.registry.core.dataaccess.DatabaseTransaction;
import org.wso2.carbon.registry.core.dataaccess.QueryProcessor;
import org.wso2.carbon.registry.core.dataaccess.TransactionManager;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.dataaccess.JDBCClusterLock;
import org.wso2.carbon.registry.core.jdbc.dataaccess.JDBCDAOManager;
import org.wso2.carbon.registry.core.jdbc.dataaccess.JDBCDatabaseTransaction;
import org.wso2.carbon.registry.core.jdbc.dataaccess.JDBCTransactionManager;
import org.wso2.carbon.registry.core.jdbc.dataaccess.SQLQueryProcessor;
import org.wso2.carbon.utils.dbcreator.DatabaseCreator;

public class JDBCDataAccessManager
implements DataAccessManager {
    private static final Log log = LogFactory.getLog(JDBCDataAccessManager.class);
    private javax.sql.DataSource dataSource;
    private static ClusterLock clusterLock = new JDBCClusterLock();
    private static DatabaseTransaction databaseTransaction = new JDBCDatabaseTransaction();
    private static DAOManager daoManager = new JDBCDAOManager();
    private static Map<String, javax.sql.DataSource> dataSources = new HashMap<String, javax.sql.DataSource>();

    public JDBCDataAccessManager(javax.sql.DataSource dataSource) {
        this.dataSource = dataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JDBCDataAccessManager(DataBaseConfiguration dataBaseConfiguration) {
        String dataSourceName = dataBaseConfiguration.getDataSourceName();
        if (dataSourceName != null) {
            this.dataSource = dataSources.get(dataSourceName);
            if (this.dataSource == null) {
                int tenantId;
                block14: {
                    tenantId = CarbonContext.getThreadLocalCarbonContext().getTenantId();
                    try {
                        InitialContext context = new InitialContext();
                        this.dataSource = (javax.sql.DataSource)context.lookup(dataSourceName);
                    }
                    catch (NamingException ignored) {
                        if (!log.isDebugEnabled()) break block14;
                        StringBuilder messageBuilder = new StringBuilder("Couldn't find dataSource '").append(dataSourceName).append("' in current tenant space (").append("Tenant Id : '").append(tenantId).append("', Hence searching for dataSource in Super Tenant space");
                        log.debug((Object)messageBuilder.toString());
                    }
                }
                if (this.dataSource == null && tenantId != -1234) {
                    PrivilegedCarbonContext.startTenantFlow();
                    try {
                        PrivilegedCarbonContext privilegedCarbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
                        privilegedCarbonContext.setTenantId(-1234);
                        privilegedCarbonContext.setTenantDomain("carbon.super");
                        try {
                            InitialContext context = new InitialContext();
                            this.dataSource = (javax.sql.DataSource)context.lookup(dataSourceName);
                        }
                        catch (NamingException e) {
                            log.error((Object)("Couldn't find dataSource '" + dataSourceName + "'"), (Throwable)e);
                        }
                    }
                    finally {
                        PrivilegedCarbonContext.endTenantFlow();
                    }
                }
                if (this.dataSource != null) {
                    dataSources.put(dataSourceName, this.dataSource);
                } else {
                    log.error((Object)("Couldn't find dataSource '" + dataSourceName + "'"));
                }
            }
        } else {
            String configName = dataBaseConfiguration.getConfigName();
            this.dataSource = dataSources.get(configName);
            if (this.dataSource == null) {
                this.dataSource = JDBCDataAccessManager.buildDataSource(dataBaseConfiguration);
                dataSources.put(configName, this.dataSource);
            }
        }
    }

    @Override
    public ClusterLock getClusterLock() {
        return clusterLock;
    }

    @Override
    public TransactionManager getTransactionManager() {
        return new JDBCTransactionManager(this);
    }

    @Override
    public DatabaseTransaction getDatabaseTransaction() {
        return databaseTransaction;
    }

    @Override
    public QueryProcessor getQueryProcessor() {
        return new SQLQueryProcessor(this);
    }

    @Override
    public DAOManager getDAOManager() {
        return daoManager;
    }

    @Override
    public void createDatabase() throws RegistryException {
        DatabaseCreator databaseCreator = new DatabaseCreator(this.getDataSource());
        try {
            databaseCreator.createRegistryDatabase();
        }
        catch (Exception e) {
            String msg = "Error in creating the database";
            throw new RegistryException(msg, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDatabaseExisting() {
        try {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Running a query to test the database tables existence.");
            }
            Connection conn = this.dataSource.getConnection();
            String sql = "SELECT REG_PATH_ID FROM REG_PATH WHERE REG_PATH_VALUE='/'";
            Statement statement = null;
            try {
                statement = conn.createStatement();
                ResultSet rs = statement.executeQuery(sql);
                if (rs != null) {
                    rs.close();
                }
            }
            finally {
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                finally {
                    if (conn != null) {
                        conn.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            return false;
        }
        return true;
    }

    public javax.sql.DataSource getDataSource() {
        return this.dataSource;
    }

    public static javax.sql.DataSource buildDataSource(DataBaseConfiguration config) {
        PoolProperties poolProperties = new PoolProperties();
        poolProperties.setUrl(config.getDbUrl());
        poolProperties.setDriverClassName(config.getDriverName());
        poolProperties.setUsername(config.getUserName());
        poolProperties.setPassword(config.getResolvedPassword());
        if (config.getTestWhileIdle() != null) {
            poolProperties.setTestWhileIdle(Boolean.parseBoolean(config.getTestWhileIdle()));
        }
        if (config.getTimeBetweenEvictionRunsMillis() != null) {
            poolProperties.setTimeBetweenEvictionRunsMillis(Integer.parseInt(config.getTimeBetweenEvictionRunsMillis()));
        }
        if (config.getMinEvictableIdleTimeMillis() != null) {
            poolProperties.setMinEvictableIdleTimeMillis(Integer.parseInt(config.getMinEvictableIdleTimeMillis()));
        }
        if (config.getNumTestsPerEvictionRun() != null) {
            poolProperties.setNumTestsPerEvictionRun(Integer.parseInt(config.getNumTestsPerEvictionRun()));
        }
        if (config.getMaxActive() != null) {
            poolProperties.setMaxActive(Integer.parseInt(config.getMaxActive()));
        } else {
            poolProperties.setMaxActive(40);
        }
        if (config.getMaxWait() != null) {
            poolProperties.setMaxWait(Integer.parseInt(config.getMaxWait()));
        } else {
            poolProperties.setMaxWait(60000);
        }
        if (config.getMaxIdle() != null) {
            poolProperties.setMaxIdle(Integer.parseInt(config.getMaxIdle()));
        }
        if (config.getMinIdle() != null) {
            poolProperties.setMinIdle(Integer.parseInt(config.getMinIdle()));
        } else {
            poolProperties.setMinIdle(5);
        }
        if (config.getValidationQuery() != null) {
            poolProperties.setValidationQuery(config.getValidationQuery());
        }
        try {
            return new DataSource((PoolConfiguration)poolProperties);
        }
        catch (Exception e) {
            throw new RuntimeException("Error in creating data source for the registry: " + e.getMessage(), e);
        }
    }
}

