/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.core.jdbc.dao;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.CollectionImpl;
import org.wso2.carbon.registry.core.CollectionVersionImpl;
import org.wso2.carbon.registry.core.ResourceIDImpl;
import org.wso2.carbon.registry.core.ResourceImpl;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.config.StaticConfiguration;
import org.wso2.carbon.registry.core.dao.AssociationDAO;
import org.wso2.carbon.registry.core.dao.CommentsDAO;
import org.wso2.carbon.registry.core.dao.RatingsDAO;
import org.wso2.carbon.registry.core.dao.ResourceDAO;
import org.wso2.carbon.registry.core.dao.ResourceVersionDAO;
import org.wso2.carbon.registry.core.dao.TagsDAO;
import org.wso2.carbon.registry.core.dataaccess.DAOManager;
import org.wso2.carbon.registry.core.dataaccess.DataAccessManager;
import org.wso2.carbon.registry.core.exceptions.ConcurrentModificationException;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.dataaccess.AbstractConnection;
import org.wso2.carbon.registry.core.jdbc.dataaccess.ConnectionWrapper;
import org.wso2.carbon.registry.core.jdbc.dataaccess.JDBCDataAccessManager;
import org.wso2.carbon.registry.core.jdbc.dataaccess.JDBCDatabaseTransaction;
import org.wso2.carbon.registry.core.jdbc.dataobjects.ResourceDO;
import org.wso2.carbon.registry.core.jdbc.utils.Transaction;
import org.wso2.carbon.registry.core.jdbc.utils.VersionRetriever;
import org.wso2.carbon.registry.core.session.CurrentSession;
import org.wso2.carbon.registry.core.utils.AuthorizationUtils;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.registry.core.utils.VersionedPath;
import org.wso2.carbon.utils.DBUtils;

public class JDBCResourceVersionDAO
implements ResourceVersionDAO {
    private static Log log = LogFactory.getLog(JDBCResourceVersionDAO.class);
    private ResourceDAO resourceDAO;
    private CommentsDAO commentsDAO;
    private RatingsDAO ratingsDAO;
    private AssociationDAO associationDAO;
    private TagsDAO tagsDAO;
    private static final Object ADD_SNAPSHOT_LOCK = new Object();

    public JDBCResourceVersionDAO(DAOManager daoManager) {
        this.resourceDAO = daoManager.getResourceDAO();
        this.commentsDAO = daoManager.getCommentsDAO(StaticConfiguration.isVersioningComments());
        this.ratingsDAO = daoManager.getRatingsDAO(StaticConfiguration.isVersioningRatings());
        this.tagsDAO = daoManager.getTagsDAO(StaticConfiguration.isVersioningTags());
        this.associationDAO = daoManager.getAssociationDAO();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long[] getSnapshotIDs(String resourcePath) throws RegistryException {
        JDBCDatabaseTransaction.ManagedRegistryConnection conn = JDBCDatabaseTransaction.getConnection();
        ResultSet results = null;
        Statement ps = null;
        try {
            String sql;
            ResourceIDImpl resourceIdImpl = this.resourceDAO.getResourceID(resourcePath);
            if (resourceIdImpl == null) {
                Long[] longArray = new Long[]{};
                return longArray;
            }
            if (resourceIdImpl.isCollection()) {
                sql = "SELECT REG_SNAPSHOT_ID FROM REG_SNAPSHOT WHERE REG_PATH_ID=? AND REG_RESOURCE_NAME IS NULL AND REG_TENANT_ID=?";
                ps = conn.prepareStatement(sql);
                ps.setInt(1, resourceIdImpl.getPathID());
                ps.setInt(2, CurrentSession.getTenantId());
            } else {
                sql = "SELECT REG_SNAPSHOT_ID FROM REG_SNAPSHOT WHERE REG_PATH_ID=? AND REG_RESOURCE_NAME=? AND REG_TENANT_ID=?";
                ps = conn.prepareStatement(sql);
                ps.setInt(1, resourceIdImpl.getPathID());
                ps.setString(2, resourceIdImpl.getName());
                ps.setInt(3, CurrentSession.getTenantId());
            }
            results = ps.executeQuery();
            ArrayList<Long> snapshotIDs = new ArrayList<Long>();
            while (results.next()) {
                long snapshotNumber = results.getLong("REG_SNAPSHOT_ID");
                snapshotIDs.add(snapshotNumber);
            }
            Collections.sort(snapshotIDs, Collections.reverseOrder());
            Long[] longArray = snapshotIDs.toArray(new Long[snapshotIDs.size()]);
            return longArray;
        }
        catch (SQLException e) {
            String msg = "Failed to get snapshot numbers of resource " + resourcePath + ". " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, e);
        }
        finally {
            try {
                try {
                    if (results != null) {
                        results.close();
                    }
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
            }
            catch (SQLException ex) {
                String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg, (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fillResourceContentArchived(ResourceImpl resourceImpl) throws RegistryException {
        JDBCDatabaseTransaction.ManagedRegistryConnection conn = JDBCDatabaseTransaction.getConnection();
        ResultSet result1 = null;
        PreparedStatement ps1 = null;
        try {
            String resourceContentSQL = "SELECT REG_CONTENT_DATA FROM REG_CONTENT_HISTORY WHERE REG_CONTENT_ID = ? AND REG_TENANT_ID=?";
            ps1 = conn.prepareStatement(resourceContentSQL);
            int contentId = resourceImpl.getDbBasedContentID();
            ps1.setInt(1, contentId);
            ps1.setInt(2, CurrentSession.getTenantId());
            result1 = ps1.executeQuery();
            if (result1.next()) {
                resourceImpl.setContentStreamWithNoUpdate(RegistryUtils.getMemoryStream(result1.getBinaryStream("REG_CONTENT_DATA")));
            }
        }
        catch (SQLException ex) {
            String msg = "Failed in filling resource content for resource " + resourceImpl.getPath() + ex.getMessage();
            log.error((Object)msg, (Throwable)ex);
            throw new RegistryException(msg, ex);
        }
        finally {
            try {
                try {
                    if (result1 != null) {
                        result1.close();
                    }
                }
                finally {
                    if (ps1 != null) {
                        ps1.close();
                    }
                }
            }
            catch (SQLException ex) {
                String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg, (Throwable)ex);
            }
        }
    }

    @Override
    public ResourceImpl get(ResourceIDImpl resourceID, long snapshotID) throws RegistryException {
        ResourceImpl resourceImpl;
        long version;
        VersionRetriever versionRetriever = this.getVersionList(snapshotID);
        ResourceDO resourceDO = null;
        int versionIndex = 0;
        while (!((version = versionRetriever.getVersion(versionIndex)) == -1L || (resourceDO = this.getResourceDOArchived(version)).getPathID() == resourceID.getPathID() && (resourceID.isCollection() && resourceDO.getName() == null || resourceID.getName() != null && resourceID.getName().equals(resourceDO.getName())))) {
            resourceDO = null;
            ++versionIndex;
        }
        if (resourceDO == null) {
            String msg = "The resource was not found at " + resourceID.getPath() + " for the snapshot " + snapshotID + ".";
            log.debug((Object)msg);
            return null;
        }
        if (resourceID.isCollection()) {
            CollectionVersionImpl collectionImpl = new CollectionVersionImpl(resourceID.getPath(), resourceDO);
            collectionImpl.setVersionListIndex(versionIndex);
            collectionImpl.setVersionList(versionRetriever);
            resourceImpl = collectionImpl;
            int tempTenantId = CurrentSession.getTenantId();
            if (tempTenantId != -1234 && tempTenantId != -1) {
                String[] childPaths = this.getChildPaths(resourceID, versionRetriever, versionIndex, 0, -1, snapshotID, JDBCDatabaseTransaction.getConnection());
                collectionImpl.setContent(childPaths);
            }
        } else {
            resourceImpl = new ResourceImpl(resourceID.getPath(), resourceDO);
        }
        return resourceImpl;
    }

    @Override
    public boolean resourceExists(ResourceIDImpl resourceID, long snapshotID) throws RegistryException {
        long version;
        VersionRetriever versionRetriever = this.getVersionList(snapshotID);
        if (versionRetriever == null) {
            return false;
        }
        ResourceDO resourceDO = null;
        int versionIndex = 0;
        while (!((version = versionRetriever.getVersion(versionIndex)) == -1L || (resourceDO = this.getResourceDOArchived(version)).getPathID() == resourceID.getPathID() && (resourceID.isCollection() && resourceDO.getName() == null || resourceID.getName() != null && resourceID.getName().equals(resourceDO.getName())))) {
            resourceDO = null;
            ++versionIndex;
        }
        return resourceDO != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VersionRetriever getVersionList(ResourceIDImpl resourceID, long snapshotID) throws RegistryException {
        JDBCDatabaseTransaction.ManagedRegistryConnection conn = JDBCDatabaseTransaction.getConnection();
        ResultSet result = null;
        PreparedStatement ps = null;
        VersionRetriever versionRetriever = null;
        try {
            String sql;
            if (resourceID.isCollection()) {
                sql = "SELECT REG_PATH_ID, REG_RESOURCE_VIDS FROM REG_SNAPSHOT WHERE REG_SNAPSHOT_ID=? AND REG_PATH_ID = ? AND REG_RESOURCE_NAME IS NULL AND REG_TENANT_ID=?";
                ps = conn.prepareStatement(sql);
                ps.setLong(1, snapshotID);
                ps.setInt(2, resourceID.getPathID());
                ps.setInt(3, CurrentSession.getTenantId());
            } else {
                sql = "SELECT REG_PATH_ID, REG_RESOURCE_VIDS FROM REG_SNAPSHOT WHERE REG_SNAPSHOT_ID=? AND REG_PATH_ID = ? AND REG_RESOURCE_NAME=? AND REG_TENANT_ID=?";
                ps = conn.prepareStatement(sql);
                ps.setLong(1, snapshotID);
                ps.setInt(2, resourceID.getPathID());
                ps.setString(3, resourceID.getName());
                ps.setInt(4, CurrentSession.getTenantId());
            }
            result = ps.executeQuery();
            if (result.next()) {
                InputStream resourceVIDStream = RegistryUtils.getMemoryStream(result.getBinaryStream("REG_RESOURCE_VIDS"));
                versionRetriever = new VersionRetriever(resourceVIDStream);
            }
        }
        catch (Exception e) {
            String msg = "Failed to get version of resource " + resourceID.getPath() + " of snapshot " + snapshotID + ". " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, e);
        }
        finally {
            try {
                try {
                    if (result != null) {
                        result.close();
                    }
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
            }
            catch (SQLException ex) {
                String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg, (Throwable)ex);
            }
        }
        return versionRetriever;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VersionRetriever getVersionList(long snapshotID) throws RegistryException {
        JDBCDatabaseTransaction.ManagedRegistryConnection conn = JDBCDatabaseTransaction.getConnection();
        ResultSet result = null;
        PreparedStatement ps = null;
        VersionRetriever versionRetriever = null;
        try {
            String sql = "SELECT REG_PATH_ID, REG_RESOURCE_VIDS FROM REG_SNAPSHOT WHERE REG_SNAPSHOT_ID=? AND REG_TENANT_ID=?";
            ps = conn.prepareStatement(sql);
            ps.setLong(1, snapshotID);
            ps.setInt(2, CurrentSession.getTenantId());
            result = ps.executeQuery();
            if (result.next()) {
                InputStream resourceVIDStream = RegistryUtils.getMemoryStream(result.getBinaryStream("REG_RESOURCE_VIDS"));
                versionRetriever = new VersionRetriever(resourceVIDStream);
            }
        }
        catch (Exception e) {
            String msg = "Failed to get version of the snapshot " + snapshotID + ". " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, e);
        }
        finally {
            try {
                try {
                    if (result != null) {
                        result.close();
                    }
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
            }
            catch (SQLException ex) {
                String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg, (Throwable)ex);
            }
        }
        return versionRetriever;
    }

    @Override
    public CollectionImpl get(ResourceIDImpl resourceID, long snapshotID, int start, int pageLen) throws RegistryException {
        long version;
        if (!resourceID.isCollection()) {
            String msg = "Child resource range can only be specified for collections. " + resourceID.getPath() + " is not a collection.";
            log.error((Object)msg);
            throw new RegistryException(msg);
        }
        VersionRetriever versionRetriever = this.getVersionList(snapshotID);
        int versionIndex = 0;
        ResourceDO resourceDO = null;
        while (!((version = versionRetriever.getVersion(versionIndex)) == -1L || (resourceDO = this.getResourceDOArchived(version)).getPathID() == resourceID.getPathID() && (resourceID.isCollection() && resourceDO.getName() == null || resourceID.getName() != null && resourceID.getName().equals(resourceDO.getName())))) {
            resourceDO = null;
            ++versionIndex;
        }
        if (resourceDO == null) {
            String msg = "The resource was not found for " + resourceID.getPath() + " for the snapshot " + snapshotID + ".";
            log.debug((Object)msg);
            return null;
        }
        CollectionVersionImpl collectionImpl = new CollectionVersionImpl(resourceID.getPath(), resourceDO);
        collectionImpl.setVersionListIndex(versionIndex);
        collectionImpl.setVersionList(versionRetriever);
        this.fillChildren(collectionImpl, versionRetriever, versionIndex, start, pageLen, snapshotID);
        this.resourceDAO.fillResourceProperties(collectionImpl);
        return collectionImpl;
    }

    @Override
    public void fillChildren(CollectionImpl collectionImpl, VersionRetriever versionRetriever, int parentVersionIndex, int start, int pageLen, long snapshotID) throws RegistryException {
        JDBCDatabaseTransaction.ManagedRegistryConnection conn = JDBCDatabaseTransaction.getConnection();
        String[] childPaths = this.getChildPaths(collectionImpl.getResourceIDImpl(), versionRetriever, parentVersionIndex, start, pageLen, snapshotID, conn);
        collectionImpl.setContent(childPaths);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getChildCount(String resourceID, long versionNumber, Connection conn) throws RegistryException {
        ResultSet results = null;
        PreparedStatement ps = null;
        try {
            int childCount = 0;
            String sql = "SELECT REG_CHILD_RID FROM REG_DEPENDENCY_VERSION WHERE REG_PARENT_RID=? AND REG_PARENT_VERSION=? AND REG_TENANT_ID=?";
            ps = conn.prepareStatement(sql);
            ps.setString(1, resourceID);
            ps.setLong(2, versionNumber);
            ps.setInt(3, CurrentSession.getTenantId());
            results = ps.executeQuery();
            while (results.next()) {
                String childID = results.getString("REG_CHILD_RID");
                if (!AuthorizationUtils.authorize(childID, "http://www.wso2.org/projects/registry/actions/get")) continue;
                ++childCount;
            }
            int n = childCount;
            return n;
        }
        catch (SQLException e) {
            String msg = "Failed to get child count of resource " + resourceID + ". " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, e);
        }
        finally {
            try {
                try {
                    if (results != null) {
                        results.close();
                    }
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
            }
            catch (SQLException ex) {
                String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg, (Throwable)ex);
            }
        }
    }

    @Override
    public String[] getChildPaths(ResourceIDImpl resourceID, VersionRetriever versionRetriever, int parentVersionIndex, int start, int pageLen, long snapshotID, DataAccessManager dataAccessManager) throws RegistryException {
        String[] childPaths = null;
        if (Transaction.isStarted()) {
            childPaths = this.getChildPaths(resourceID, versionRetriever, parentVersionIndex, start, pageLen, snapshotID, JDBCDatabaseTransaction.getConnection());
        } else {
            Connection conn = null;
            boolean transactionSucceeded = false;
            try {
                DataSource dataSource = ((JDBCDataAccessManager)dataAccessManager).getDataSource();
                conn = new ConnectionWrapper(dataSource.getConnection(), RegistryUtils.getConnectionId(dataSource));
                JDBCDatabaseTransaction.ManagedRegistryConnection temp = JDBCDatabaseTransaction.getManagedRegistryConnection((AbstractConnection)conn);
                if (temp != null) {
                    conn.close();
                    conn = temp;
                }
                if (conn.getTransactionIsolation() != 2) {
                    conn.setTransactionIsolation(2);
                }
                conn.setAutoCommit(false);
                childPaths = this.getChildPaths(resourceID, versionRetriever, parentVersionIndex, start, pageLen, snapshotID, conn);
                transactionSucceeded = true;
            }
            catch (SQLException e) {
                String msg = "Failed to get the child paths " + pageLen + " child paths from " + start + " of resource " + resourceID.getPath() + ". " + e.getMessage();
                log.error((Object)msg, (Throwable)e);
                throw new RegistryException(msg, e);
            }
            finally {
                if (transactionSucceeded) {
                    try {
                        conn.commit();
                    }
                    catch (SQLException e) {
                        log.error((Object)("Failed to commit the database connection used in getting child paths of the collection " + resourceID.getPath()));
                    }
                } else if (conn != null) {
                    try {
                        conn.rollback();
                    }
                    catch (SQLException e) {
                        log.error((Object)("Failed to rollback the database connection used in getting child paths of the collection " + resourceID.getPath()));
                    }
                }
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException e) {
                        log.error((Object)("Failed to close the database connection used in getting child paths of collection " + resourceID.getPath()));
                    }
                }
            }
        }
        return childPaths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getChildPaths(ResourceIDImpl resourceID, VersionRetriever versionRetriever, int parentVersionIndex, int start, int pageLen, long snapshotID, Connection conn) throws RegistryException {
        ArrayList<String> childPathList = new ArrayList<String>();
        String parentPath = this.getCurrentPath(resourceID.getPath());
        int current = 0;
        int end = start + pageLen;
        boolean isValidPath = false;
        int versionIndex = parentVersionIndex + 1;
        while (true) {
            Statement ps = null;
            Statement ps2 = null;
            ResultSet result = null;
            ResultSet result2 = null;
            try {
                long version;
                if (pageLen != -1 && current > end || (version = versionRetriever.getVersion(versionIndex)) == -1L) break;
                String sql = "(SELECT REG_PATH_ID, REG_NAME FROM REG_RESOURCE WHERE REG_VERSION=? AND REG_TENANT_ID=?)UNION (SELECT REG_PATH_ID, REG_NAME FROM REG_RESOURCE_HISTORY WHERE REG_VERSION=? AND REG_TENANT_ID=?)";
                ps = conn.prepareStatement(sql);
                ps.setLong(1, version);
                ps.setInt(2, CurrentSession.getTenantId());
                ps.setLong(3, version);
                ps.setInt(4, CurrentSession.getTenantId());
                result = ps.executeQuery();
                if (result.next()) {
                    int pathId = result.getInt("REG_PATH_ID");
                    String resourceName = result.getString("REG_NAME");
                    if (pathId == resourceID.getPathID() && resourceName != null) {
                        String childPath = parentPath + (parentPath.equals("/") ? "" : "/") + resourceName + ";version:" + snapshotID;
                        if (current >= start) {
                            childPathList.add(childPath);
                        }
                        isValidPath = true;
                        ++current;
                    } else if (resourceName == null) {
                        int parentPathId;
                        sql = "SELECT REG_PATH_PARENT_ID, REG_PATH_VALUE FROM REG_PATH WHERE REG_PATH_ID=? AND REG_TENANT_ID=?";
                        ps2 = conn.prepareStatement(sql);
                        ps2.setLong(1, pathId);
                        ps2.setInt(2, CurrentSession.getTenantId());
                        result2 = ps2.executeQuery();
                        if (result2.next() && (parentPathId = result2.getInt("REG_PATH_PARENT_ID")) == resourceID.getPathID()) {
                            String childPath = result2.getString("REG_PATH_VALUE") + ";version:" + snapshotID;
                            if (current >= start) {
                                childPathList.add(childPath);
                            }
                            isValidPath = true;
                            ++current;
                        }
                    }
                }
            }
            catch (SQLException e) {
                String msg = "Failed to get child paths of resource " + resourceID.getPath() + "for version. " + e.getMessage();
                log.error((Object)msg, (Throwable)e);
                throw new RegistryException(msg, e);
            }
            finally {
                try {
                    try {
                        if (result != null) {
                            result.close();
                        }
                    }
                    finally {
                        try {
                            if (ps != null) {
                                ps.close();
                            }
                        }
                        finally {
                            try {
                                if (result2 != null) {
                                    result2.close();
                                }
                            }
                            finally {
                                if (ps2 != null) {
                                    ps2.close();
                                }
                            }
                        }
                    }
                }
                catch (SQLException ex) {
                    String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                    log.error((Object)msg, (Throwable)ex);
                }
            }
            if (!isValidPath && current > 0) break;
            ++versionIndex;
        }
        return childPathList.toArray(new String[childPathList.size()]);
    }

    private String getCurrentPath(String resourcePath) {
        String currentPath = resourcePath;
        if (resourcePath.indexOf(63) > 0) {
            currentPath = resourcePath.split("\\?")[0];
        } else if (resourcePath.indexOf(";") > 0) {
            currentPath = resourcePath.split("\\;")[0];
        }
        return currentPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long createSnapshot(int pathId, String name, InputStream versionsStream) throws RegistryException {
        JDBCDatabaseTransaction.ManagedRegistryConnection conn = JDBCDatabaseTransaction.getConnection();
        Statement ps = null;
        Statement ps1 = null;
        ResultSet result = null;
        try {
            String sql = "INSERT INTO REG_SNAPSHOT (REG_PATH_ID, REG_RESOURCE_NAME, REG_RESOURCE_VIDS, REG_TENANT_ID) VALUES (?, ?, ?, ?)";
            String sql1 = "SELECT MAX(REG_SNAPSHOT_ID) FROM REG_SNAPSHOT";
            int size = versionsStream.available();
            String dbProductName = conn.getMetaData().getDatabaseProductName();
            boolean returnsGeneratedKeys = DBUtils.canReturnGeneratedKeys((String)dbProductName);
            ps = returnsGeneratedKeys ? conn.prepareStatement(sql, new String[]{DBUtils.getConvertedAutoGeneratedColumnName((String)dbProductName, (String)"REG_SNAPSHOT_ID")}) : conn.prepareStatement(sql);
            ps.setInt(1, pathId);
            ps.setString(2, name);
            ps.setBinaryStream(3, versionsStream, size);
            ps.setInt(4, CurrentSession.getTenantId());
            if (returnsGeneratedKeys) {
                ps.executeUpdate();
                result = ps.getGeneratedKeys();
            } else {
                Object object = ADD_SNAPSHOT_LOCK;
                synchronized (object) {
                    ps.executeUpdate();
                    if (dbProductName.equals("OpenEdge RDBMS")) {
                        String sql2 = "UPDATE REG_SNAPSHOT SET REG_SNAPSHOT_ID = PUB.REG_SNAPSHOT_SEQUENCE.NEXTVAL WHERE REG_SNAPSHOT_ID = 0";
                        try (PreparedStatement ps2 = null;){
                            ps2 = conn.prepareStatement(sql2);
                            ps2.executeUpdate();
                        }
                    }
                    ps1 = conn.prepareStatement(sql1);
                    result = ps1.executeQuery();
                }
            }
            long snapshotID = -1L;
            if (result.next()) {
                snapshotID = result.getLong(1);
            }
            long l = snapshotID;
            return l;
        }
        catch (Exception e) {
            String msg = "Failed to write resource content to the database. " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, e);
        }
        finally {
            try {
                try {
                    if (result != null) {
                        result.close();
                    }
                }
                finally {
                    try {
                        if (ps1 != null) {
                            ps1.close();
                        }
                    }
                    finally {
                        if (ps != null) {
                            ps.close();
                        }
                    }
                }
            }
            catch (SQLException ex) {
                String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg, (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isResourceHistoryExist(long version) throws RegistryException {
        JDBCDatabaseTransaction.ManagedRegistryConnection conn = JDBCDatabaseTransaction.getConnection();
        PreparedStatement ps = null;
        ResultSet result = null;
        try {
            String sql = "SELECT REG_PATH_ID FROM REG_RESOURCE_HISTORY WHERE REG_VERSION=? AND REG_TENANT_ID=?";
            ps = conn.prepareStatement(sql);
            ps.setLong(1, version);
            ps.setInt(2, CurrentSession.getTenantId());
            result = ps.executeQuery();
            if (result.next()) {
                boolean bl = true;
                return bl;
            }
        }
        catch (SQLException e) {
            String msg = "Failed reading the history table for resource version  " + version + " . " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, e);
        }
        finally {
            try {
                try {
                    if (result != null) {
                        result.close();
                    }
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
            }
            catch (SQLException ex) {
                String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg, (Throwable)ex);
            }
        }
        return false;
    }

    @Override
    public boolean isResourceHistoryExist(String path) throws RegistryException {
        ResourceIDImpl resourceID = this.resourceDAO.getResourceID(path, true);
        if (resourceID != null) {
            return this.isResourceHistoryExist(resourceID);
        }
        resourceID = this.resourceDAO.getResourceID(path, false);
        return resourceID == null || this.isResourceHistoryExist(resourceID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isResourceHistoryExist(ResourceIDImpl resourceID) throws RegistryException {
        JDBCDatabaseTransaction.ManagedRegistryConnection conn = JDBCDatabaseTransaction.getConnection();
        ResultSet result = null;
        PreparedStatement ps = null;
        try {
            String sql;
            if (resourceID.isCollection()) {
                sql = "SELECT REG_PATH_ID FROM REG_RESOURCE_HISTORY WHERE REG_PATH_ID=? AND REG_NAME IS NULL AND REG_TENANT_ID=?";
                ps = conn.prepareStatement(sql);
                ps.setInt(1, resourceID.getPathID());
                ps.setInt(2, CurrentSession.getTenantId());
                result = ps.executeQuery();
                if (result.next()) {
                    boolean bl = true;
                    return bl;
                }
            } else {
                sql = "SELECT REG_PATH_ID FROM REG_RESOURCE_HISTORY WHERE REG_PATH_ID=? AND REG_NAME = ? AND REG_TENANT_ID=?";
                ps = conn.prepareStatement(sql);
                ps.setInt(1, resourceID.getPathID());
                ps.setString(2, resourceID.getName());
                ps.setInt(3, CurrentSession.getTenantId());
                result = ps.executeQuery();
                if (result.next()) {
                    boolean bl = true;
                    return bl;
                }
            }
        }
        catch (SQLException e) {
            String msg = "Failed reading the history table for resource path " + resourceID.getPath() + " . " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, e);
        }
        finally {
            try {
                try {
                    if (result != null) {
                        result.close();
                    }
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
            }
            catch (SQLException ex) {
                String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg, (Throwable)ex);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isContentHistoryExist(int contentId) throws RegistryException {
        JDBCDatabaseTransaction.ManagedRegistryConnection conn = JDBCDatabaseTransaction.getConnection();
        ResultSet result = null;
        PreparedStatement ps = null;
        try {
            String sql = "SELECT REG_CONTENT_DATA FROM REG_CONTENT_HISTORY WHERE REG_CONTENT_ID = ? AND REG_TENANT_ID=?";
            ps = conn.prepareStatement(sql);
            ps.setInt(1, contentId);
            ps.setInt(2, CurrentSession.getTenantId());
            result = ps.executeQuery();
            if (result.next()) {
                boolean bl = true;
                return bl;
            }
        }
        catch (SQLException e) {
            String msg = "Failed reading the history table for content " + contentId + " . " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, e);
        }
        finally {
            try {
                try {
                    if (result != null) {
                        result.close();
                    }
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
            }
            catch (SQLException ex) {
                String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg, (Throwable)ex);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String restoreResources(long version, long snapshotID) throws RegistryException {
        ResourceDO resourceDO = this.getResourceDOArchived(version);
        String resourcePath = this.resourceDAO.getPath(resourceDO.getPathID(), resourceDO.getName(), false);
        ResourceImpl oldResource = resourceDO.getName() == null ? new CollectionImpl(resourcePath, resourceDO) : new ResourceImpl(resourcePath, resourceDO);
        int oldContentID = resourceDO.getContentID();
        if (oldContentID > 0) {
            InputStream contentData = null;
            try {
                contentData = this.getContentArchived(oldContentID);
                if (contentData != null) {
                    resourceDO.setContentID(this.resourceDAO.addContentBytes(contentData));
                }
            }
            finally {
                if (contentData != null) {
                    try {
                        contentData.close();
                    }
                    catch (IOException e) {
                        log.error((Object)"Failed to close the stream", (Throwable)e);
                    }
                }
            }
        }
        this.resourceDAO.addResourceDO(resourceDO);
        ResourceImpl newResource = resourceDO.getName() == null ? new CollectionImpl(resourcePath, resourceDO) : new ResourceImpl(resourcePath, resourceDO);
        if (StaticConfiguration.isVersioningProperties()) {
            this.resourceDAO.fillResourceProperties(oldResource);
            newResource.setProperties(oldResource.getProperties());
            this.resourceDAO.addProperties(newResource);
            String linkRestoration = newResource.getProperty("registry.linkrestoration");
            if (linkRestoration != null) {
                String[] parts = linkRestoration.split(";");
                if (parts.length == 4) {
                    if (parts[2] != null && parts[2].length() == 0) {
                        parts[2] = null;
                    }
                    RegistryUtils.registerHandlerForRemoteLinks(RegistryContext.getBaseInstance(), parts[0], parts[1], parts[2], parts[3]);
                } else if (parts.length == 3) {
                    RegistryUtils.registerHandlerForSymbolicLinks(RegistryContext.getBaseInstance(), parts[0], parts[1], parts[2]);
                }
            }
        }
        this.commentsDAO.copyComments(oldResource, newResource);
        this.tagsDAO.copyTags(oldResource, newResource);
        this.ratingsDAO.copyRatings(oldResource, newResource);
        VersionedPath versionedPath = new VersionedPath();
        versionedPath.setVersion(snapshotID);
        versionedPath.setPath(oldResource.getPath());
        this.associationDAO.removeAllAssociations(newResource.getPath());
        this.associationDAO.copyAssociations(versionedPath.toString(), newResource.getPath());
        return resourcePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourceDO getResourceDOArchived(long version) throws RegistryException {
        JDBCDatabaseTransaction.ManagedRegistryConnection conn = JDBCDatabaseTransaction.getConnection();
        ResultSet result = null;
        PreparedStatement ps = null;
        try {
            String sql = "SELECT REG_PATH_ID, REG_NAME, REG_VERSION, REG_MEDIA_TYPE, REG_CREATOR, REG_CREATED_TIME, REG_LAST_UPDATOR, REG_LAST_UPDATED_TIME, REG_DESCRIPTION, REG_CONTENT_ID, REG_UUID FROM REG_RESOURCE_HISTORY WHERE REG_VERSION =? AND REG_TENANT_ID=?";
            ps = conn.prepareStatement(sql);
            ps.setLong(1, version);
            ps.setInt(2, CurrentSession.getTenantId());
            result = ps.executeQuery();
            if (result.next()) {
                ResourceDO resourceDO = new ResourceDO();
                resourceDO.setPathID(result.getInt("REG_PATH_ID"));
                resourceDO.setName(result.getString("REG_NAME"));
                resourceDO.setVersion(result.getInt("REG_VERSION"));
                resourceDO.setMediaType(result.getString("REG_MEDIA_TYPE"));
                resourceDO.setAuthor(result.getString("REG_CREATOR"));
                resourceDO.setCreatedOn(result.getTimestamp("REG_CREATED_TIME").getTime());
                resourceDO.setLastUpdater(result.getString("REG_LAST_UPDATOR"));
                resourceDO.setLastUpdatedOn(result.getTimestamp("REG_LAST_UPDATED_TIME").getTime());
                resourceDO.setDescription(result.getString("REG_DESCRIPTION"));
                resourceDO.setContentID(result.getInt("REG_CONTENT_ID"));
                resourceDO.setUUID(result.getString("REG_UUID"));
                ResourceDO resourceDO2 = resourceDO;
                return resourceDO2;
            }
        }
        catch (SQLException e) {
            String msg = "Failed to get the resource version " + version + ". " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, e);
        }
        finally {
            try {
                try {
                    if (result != null) {
                        result.close();
                    }
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
            }
            catch (SQLException ex) {
                String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg, (Throwable)ex);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream getContentArchived(int contentID) throws RegistryException {
        JDBCDatabaseTransaction.ManagedRegistryConnection conn = JDBCDatabaseTransaction.getConnection();
        ResultSet result = null;
        PreparedStatement ps = null;
        try {
            InputStream rawStream;
            String resourceContentSQL = "SELECT REG_CONTENT_DATA  FROM  REG_CONTENT_HISTORY WHERE REG_CONTENT_ID = ? AND REG_TENANT_ID=?";
            ps = conn.prepareStatement(resourceContentSQL);
            ps.setLong(1, contentID);
            ps.setInt(2, CurrentSession.getTenantId());
            result = ps.executeQuery();
            if (result.next() && (rawStream = result.getBinaryStream("REG_CONTENT_DATA")) != null) {
                InputStream inputStream = RegistryUtils.getMemoryStream(rawStream);
                return inputStream;
            }
        }
        catch (SQLException e) {
            String msg = "Failed to get the archived content " + contentID + ". " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, e);
        }
        finally {
            try {
                try {
                    if (result != null) {
                        result.close();
                    }
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
            }
            catch (SQLException ex) {
                String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg, (Throwable)ex);
            }
        }
        return null;
    }

    @Override
    public void versionResource(ResourceDO resourceDO, boolean keepProperties) throws RegistryException {
        int contentID;
        if (resourceDO.getName() != null && (contentID = resourceDO.getContentID()) > 0) {
            this.versionContent(contentID);
        }
        if (!this.isResourceHistoryExist(resourceDO.getVersion())) {
            this.putResourceToHistory(resourceDO);
        }
        if (!StaticConfiguration.isVersioningProperties() && !keepProperties) {
            this.resourceDAO.removeProperties(resourceDO);
        }
        this.resourceDAO.deleteResource(resourceDO);
        if (resourceDO.getName() != null && (contentID = resourceDO.getContentID()) > 0) {
            this.resourceDAO.deleteContentStream(contentID);
        }
    }

    @Override
    public void putResourceToHistory(ResourceDO resourceDO) throws RegistryException {
        JDBCDatabaseTransaction.ManagedRegistryConnection conn = JDBCDatabaseTransaction.getConnection();
        PreparedStatement ps = null;
        try {
            String sql = "INSERT INTO REG_RESOURCE_HISTORY (REG_PATH_ID, REG_NAME, REG_VERSION, REG_MEDIA_TYPE, REG_CREATOR, REG_CREATED_TIME, REG_LAST_UPDATOR, REG_LAST_UPDATED_TIME, REG_DESCRIPTION, REG_CONTENT_ID, REG_TENANT_ID, REG_UUID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
            ps = conn.prepareStatement(sql);
            ps.setInt(1, resourceDO.getPathID());
            ps.setString(2, resourceDO.getName());
            ps.setLong(3, resourceDO.getVersion());
            ps.setString(4, resourceDO.getMediaType());
            ps.setString(5, resourceDO.getAuthor());
            ps.setTimestamp(6, new Timestamp(resourceDO.getCreatedOn()));
            ps.setString(7, resourceDO.getLastUpdater());
            ps.setTimestamp(8, new Timestamp(resourceDO.getLastUpdatedOn()));
            ps.setString(9, resourceDO.getDescription());
            if (resourceDO.getContentID() > 0) {
                ps.setInt(10, resourceDO.getContentID());
            } else {
                ps.setNull(10, 4);
            }
            ps.setInt(11, CurrentSession.getTenantId());
            ps.setString(12, resourceDO.getUUID());
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            String msg = "Failed to copy resource version" + resourceDO.getVersion() + " to the history table " + ex.getMessage();
            log.error((Object)msg, (Throwable)ex);
            throw new RegistryException(msg, ex);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException ex) {
                String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg, (Throwable)ex);
            }
        }
    }

    private void versionContent(int contentID) throws RegistryException {
        if (!this.isContentHistoryExist(contentID)) {
            InputStream contentStream = this.resourceDAO.getContentStream(contentID);
            if (contentStream == null) {
                contentStream = new ByteArrayInputStream(RegistryUtils.encodeString(""));
            }
            JDBCDatabaseTransaction.ManagedRegistryConnection conn = JDBCDatabaseTransaction.getConnection();
            Statement ps = null;
            try {
                String sql = "INSERT INTO REG_CONTENT_HISTORY (REG_CONTENT_ID, REG_CONTENT_DATA, REG_TENANT_ID) VALUES (?, ?, ?)";
                int size = contentStream.available();
                ps = conn.prepareStatement(sql);
                ps.setInt(1, contentID);
                ps.setBinaryStream(2, contentStream, size);
                ps.setInt(3, CurrentSession.getTenantId());
                ps.executeUpdate();
            }
            catch (Exception ex) {
                String msg = "Failed to put the content into history with the content id " + contentID + ". " + ex.getMessage();
                if (this.isContentHistoryExist(contentID)) {
                    log.error((Object)("Concurrent Modification: " + msg), (Throwable)ex);
                    throw new ConcurrentModificationException(msg, ex);
                }
                log.error((Object)msg, (Throwable)ex);
                throw new RegistryException(msg, ex);
            }
            finally {
                try {
                    if (ps != null) {
                        ps.close();
                    }
                }
                catch (SQLException ex) {
                    String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                    log.error((Object)msg, (Throwable)ex);
                }
            }
        }
    }

    @Override
    public void removeSnapshot(long snapshotId) throws RegistryException {
        JDBCDatabaseTransaction.ManagedRegistryConnection conn = JDBCDatabaseTransaction.getConnection();
        PreparedStatement ps = null;
        try {
            String sql = "DELETE FROM REG_SNAPSHOT WHERE REG_SNAPSHOT_ID = ? ";
            ps = conn.prepareStatement(sql);
            ps.setLong(1, snapshotId);
            ps.executeUpdate();
        }
        catch (Exception ex) {
            String msg = "Failed to remove the snapshot with the id: " + snapshotId + ". " + ex.getMessage();
            log.error((Object)msg, (Throwable)ex);
            throw new RegistryException(msg, ex);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException ex) {
                String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg, (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePropertyValues(long regVersionId) throws RegistryException {
        JDBCDatabaseTransaction.ManagedRegistryConnection conn = JDBCDatabaseTransaction.getConnection();
        Statement ps1 = null;
        Statement ps2 = null;
        try {
            List<Long> idList = this.getPropertyIds(regVersionId);
            String sqlChild = "DELETE FROM REG_RESOURCE_PROPERTY WHERE REG_PROPERTY_ID = ? AND REG_TENANT_ID = ? ";
            String sqlParent = "DELETE FROM REG_PROPERTY WHERE REG_ID = ? AND REG_TENANT_ID = ?";
            ps1 = conn.prepareStatement(sqlChild);
            ps2 = conn.prepareStatement(sqlParent);
            for (long id : idList) {
                ps1.setLong(1, id);
                ps1.setInt(2, CurrentSession.getTenantId());
                ps2.setLong(1, id);
                ps2.setInt(2, CurrentSession.getTenantId());
                ps1.executeUpdate();
                ps2.executeUpdate();
            }
        }
        catch (Exception ex) {
            String msg = "Failed to remove the properties with the version id: " + regVersionId + ". " + ex.getMessage();
            log.error((Object)msg, (Throwable)ex);
            throw new RegistryException(msg, ex);
        }
        finally {
            try {
                try {
                    if (ps1 != null) {
                        ps1.close();
                    }
                }
                finally {
                    if (ps2 != null) {
                        ps2.close();
                    }
                }
            }
            catch (SQLException ex) {
                String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg, (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Long> getPropertyIds(long regVersionId) throws RegistryException {
        JDBCDatabaseTransaction.ManagedRegistryConnection conn = JDBCDatabaseTransaction.getConnection();
        PreparedStatement ps = null;
        ResultSet results = null;
        ArrayList<Long> idList = new ArrayList<Long>();
        try {
            String sql = "SELECT P.REG_ID FROM REG_PROPERTY P, REG_RESOURCE_PROPERTY RP WHERE RP.REG_VERSION = ? AND RP.REG_TENANT_ID = ? AND RP.REG_TENANT_ID=P.REG_TENANT_ID AND RP.REG_PROPERTY_ID=P.REG_ID";
            ps = conn.prepareStatement(sql);
            ps.setLong(1, regVersionId);
            ps.setInt(2, CurrentSession.getTenantId());
            results = ps.executeQuery();
            while (results.next()) {
                idList.add(results.getLong(1));
            }
        }
        catch (Exception ex) {
            String msg = "Failed to retrieve the properties with the REG_VERSION: " + regVersionId + ". " + ex.getMessage();
            log.error((Object)msg, (Throwable)ex);
            throw new RegistryException(msg, ex);
        }
        finally {
            try {
                try {
                    if (results != null) {
                        results.close();
                    }
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
            }
            catch (SQLException ex) {
                String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg, (Throwable)ex);
            }
        }
        return idList;
    }
}

