/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.core.jdbc.dao;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.Statement;
import javax.cache.Cache;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.caching.PathCache;
import org.wso2.carbon.registry.core.caching.RegistryCacheEntry;
import org.wso2.carbon.registry.core.caching.RegistryCacheKey;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.dataaccess.DataAccessManager;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.dataaccess.AbstractConnection;
import org.wso2.carbon.registry.core.jdbc.dataaccess.ConnectionWrapper;
import org.wso2.carbon.registry.core.jdbc.dataaccess.JDBCDataAccessManager;
import org.wso2.carbon.registry.core.session.CurrentSession;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.utils.DBUtils;

public class JDBCPathCache
extends PathCache {
    private static final Log log = LogFactory.getLog(JDBCPathCache.class);
    private static final Object ADD_ENTRY_LOCK = new Object();

    public static JDBCPathCache getPathCache() {
        return new JDBCPathCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int addEntry(String path, int parentPathId) throws SQLException, RegistryException {
        ResultSet results = null;
        Statement ps = null;
        Statement ps1 = null;
        DataAccessManager dataAccessManager = CurrentSession.getUserRegistry() != null && CurrentSession.getUserRegistry().getRegistryContext() != null ? CurrentSession.getUserRegistry().getRegistryContext().getDataAccessManager() : RegistryContext.getBaseInstance().getDataAccessManager();
        if (!(dataAccessManager instanceof JDBCDataAccessManager)) {
            String msg = "Failed to add path entry. Invalid data access manager.";
            log.error((Object)msg);
            throw new RegistryException(msg);
        }
        DataSource dataSource = ((JDBCDataAccessManager)dataAccessManager).getDataSource();
        ConnectionWrapper conn = new ConnectionWrapper(dataSource.getConnection(), RegistryUtils.getConnectionId(dataSource));
        if (conn == null) {
            log.error((Object)"Unable to acquire connection to database.");
            return -1;
        }
        if (conn.getTransactionIsolation() != 2) {
            conn.setTransactionIsolation(2);
        }
        conn.setAutoCommit(false);
        boolean success = false;
        int pathId = 0;
        try {
            String sql = "INSERT INTO REG_PATH(REG_PATH_VALUE, REG_PATH_PARENT_ID, REG_TENANT_ID) VALUES (?, ?, ?)";
            String sql1 = "SELECT MAX(REG_PATH_ID) FROM REG_PATH";
            String dbProductName = conn.getMetaData().getDatabaseProductName();
            boolean returnsGeneratedKeys = DBUtils.canReturnGeneratedKeys((String)dbProductName);
            ps = returnsGeneratedKeys ? conn.prepareStatement(sql, new String[]{DBUtils.getConvertedAutoGeneratedColumnName((String)dbProductName, (String)"REG_PATH_ID")}) : conn.prepareStatement(sql);
            ps.setString(1, path);
            ps.setInt(2, parentPathId);
            ps.setInt(3, CurrentSession.getTenantId());
            if (returnsGeneratedKeys) {
                ps.executeUpdate();
                results = ps.getGeneratedKeys();
            } else {
                Object object = ADD_ENTRY_LOCK;
                synchronized (object) {
                    ps.executeUpdate();
                    ps1 = conn.prepareStatement(sql1);
                    results = ps1.executeQuery();
                }
            }
            if (!results.next()) return -1;
            pathId = results.getInt(1);
            if (pathId <= 0) return -1;
            success = true;
            int n = pathId;
            return n;
        }
        catch (SQLException e) {
            if (!(e instanceof SQLIntegrityConstraintViolationException) && !"23505".equals(e.getSQLState())) {
                String msg = "Failed to insert resource to " + path + ". " + e.getMessage();
                log.error((Object)msg, (Throwable)e);
                throw e;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Failed to insert due to already exist in database : " + path));
            }
            if ((pathId = this.getPathID(conn, path)) <= 0) return -1;
            success = true;
            int msg = pathId;
            return msg;
        }
        finally {
            if (success) {
                String msg;
                try {
                    conn.commit();
                    RegistryCacheEntry e = new RegistryCacheEntry(pathId);
                    String connectionId = null;
                    if (conn.getConnectionId() != null) {
                        connectionId = conn.getConnectionId();
                    }
                    RegistryCacheKey key = RegistryUtils.buildRegistryCacheKey(connectionId, CurrentSession.getTenantId(), path);
                    JDBCPathCache.getCache().put((Object)key, (Object)e);
                }
                catch (SQLException e) {
                    msg = "Failed to commit transaction. Inserting " + path + ". " + e.getMessage();
                    log.error((Object)msg, (Throwable)e);
                }
                finally {
                    try {
                        try {
                            if (results != null) {
                                results.close();
                            }
                        }
                        finally {
                            try {
                                if (ps1 != null) {
                                    ps1.close();
                                }
                            }
                            finally {
                                try {
                                    if (ps != null) {
                                        ps.close();
                                    }
                                }
                                finally {
                                    conn.close();
                                }
                            }
                        }
                    }
                    catch (SQLException e) {
                        msg = "A SQLException error has occurred when trying to close result set or prepared statement" + e.getMessage();
                        log.error((Object)msg, (Throwable)e);
                    }
                }
            } else {
                String msg;
                try {
                    conn.rollback();
                }
                catch (SQLException e) {
                    msg = "Failed to rollback transaction. Inserting " + path + ". " + e.getMessage();
                    log.error((Object)msg, (Throwable)e);
                }
                finally {
                    try {
                        try {
                            if (results != null) {
                                results.close();
                            }
                        }
                        finally {
                            try {
                                if (ps != null) {
                                    ps.close();
                                }
                            }
                            finally {
                                if (conn != null) {
                                    conn.close();
                                }
                            }
                        }
                    }
                    catch (SQLException e) {
                        msg = "A SQLException error has occurred when trying to close result set or prepared statement" + e.getMessage();
                        log.error((Object)msg, (Throwable)e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPath(AbstractConnection conn, int id) throws SQLException {
        if (conn == null || conn.getConnectionId() == null) {
            throw new SQLException("Connection is null");
        }
        String connectionId = conn.getConnectionId();
        RegistryCacheKey key = RegistryUtils.buildRegistryCacheKey(connectionId, CurrentSession.getTenantId(), Integer.toString(id));
        Cache<RegistryCacheKey, RegistryCacheEntry> cache = JDBCPathCache.getCache();
        RegistryCacheEntry result = (RegistryCacheEntry)cache.get((Object)key);
        if (result != null) {
            return result.getPath();
        }
        PreparedStatement ps = null;
        ResultSet results = null;
        try {
            String sql = "SELECT REG_PATH_VALUE FROM REG_PATH WHERE REG_PATH_ID=? AND REG_TENANT_ID=?";
            ps = conn.prepareStatement(sql);
            ps.setInt(1, id);
            ps.setInt(2, CurrentSession.getTenantId());
            results = ps.executeQuery();
            if (results.next()) {
                result = new RegistryCacheEntry(results.getString("REG_PATH_VALUE"));
                cache.put((Object)key, (Object)result);
                String string = result.getPath();
                return string;
            }
        }
        finally {
            try {
                try {
                    if (results != null) {
                        results.close();
                    }
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
            }
            catch (SQLException ex) {
                String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg, (Throwable)ex);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPathID(AbstractConnection conn, String path) throws SQLException {
        String connectionId = null;
        if (conn == null || conn.getConnectionId() == null) {
            throw new SQLException("Connection is null");
        }
        connectionId = conn.getConnectionId();
        RegistryCacheKey key = RegistryUtils.buildRegistryCacheKey(connectionId, CurrentSession.getTenantId(), path);
        Cache<RegistryCacheKey, RegistryCacheEntry> cache = JDBCPathCache.getCache();
        RegistryCacheEntry result = (RegistryCacheEntry)cache.get((Object)key);
        if (result != null) {
            return result.getPathId();
        }
        ResultSet results = null;
        PreparedStatement ps = null;
        try {
            int pathId;
            String sql = "SELECT REG_PATH_ID FROM REG_PATH WHERE REG_PATH_VALUE=? AND REG_TENANT_ID=?";
            ps = conn.prepareStatement(sql);
            ps.setString(1, path);
            ps.setInt(2, CurrentSession.getTenantId());
            results = ps.executeQuery();
            if (results.next() && (pathId = results.getInt("REG_PATH_ID")) > 0) {
                RegistryCacheEntry e = new RegistryCacheEntry(pathId);
                cache.put((Object)key, (Object)e);
                int n = pathId;
                return n;
            }
        }
        catch (SQLException e) {
            String msg = "Failed to retrieving resource from " + path + ". " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw e;
        }
        finally {
            try {
                try {
                    if (results != null) {
                        results.close();
                    }
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
            }
            catch (SQLException e) {
                String msg = "A SQLException error has occurred when trying to close result set or prepared statement" + e.getMessage();
                log.error((Object)msg, (Throwable)e);
            }
        }
        return -1;
    }
}

