/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.core.jdbc.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.LogEntry;
import org.wso2.carbon.registry.core.config.DataBaseConfiguration;
import org.wso2.carbon.registry.core.config.Mount;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.config.RemoteConfiguration;
import org.wso2.carbon.registry.core.dao.LogsDAO;
import org.wso2.carbon.registry.core.dataaccess.DataAccessManager;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.dataaccess.JDBCDataAccessManager;
import org.wso2.carbon.registry.core.jdbc.dataaccess.JDBCDatabaseTransaction;
import org.wso2.carbon.registry.core.jdbc.utils.Transaction;
import org.wso2.carbon.registry.core.pagination.PaginationConstants;
import org.wso2.carbon.registry.core.pagination.PaginationContext;
import org.wso2.carbon.registry.core.pagination.PaginationUtils;
import org.wso2.carbon.registry.core.session.CurrentSession;
import org.wso2.carbon.registry.core.utils.LogRecord;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreManager;

public class JDBCLogsDAO
implements LogsDAO {
    private static final Log log = LogFactory.getLog(JDBCLogsDAO.class);
    private String enableApiPagination = PaginationConstants.ENABLE_API_PAGINATE;
    private String MSSQL_DATABASE_TYPE = "Microsoft";
    private Map<String, DataBaseConfiguration> dbConfigs = new HashMap<String, DataBaseConfiguration>();
    private Map<String, String> pathMap = new HashMap<String, String>();

    public JDBCLogsDAO() {
        RegistryContext registryContext = RegistryContext.getBaseInstance();
        for (Mount mount : registryContext.getMounts()) {
            for (RemoteConfiguration configuration : registryContext.getRemoteInstances()) {
                if (configuration.getDbConfig() == null || !mount.getInstanceId().equals(configuration.getId())) continue;
                this.dbConfigs.put(mount.getPath(), registryContext.getDBConfig(configuration.getDbConfig()));
                this.pathMap.put(mount.getPath(), mount.getTargetPath());
            }
        }
    }

    @Override
    public void saveLogBatch(LogRecord[] logRecords) throws RegistryException {
        DataAccessManager dataAccessManager = CurrentSession.getUserRegistry() != null && CurrentSession.getUserRegistry().getRegistryContext() != null ? CurrentSession.getUserRegistry().getRegistryContext().getDataAccessManager() : RegistryContext.getBaseInstance().getDataAccessManager();
        if (!(dataAccessManager instanceof JDBCDataAccessManager)) {
            String msg = "Failed to get logs. Invalid data access manager.";
            log.error((Object)msg);
            throw new RegistryException(msg);
        }
        if (this.dbConfigs.size() > 0) {
            HashMap entryMap = new HashMap();
            LinkedList<LogRecord> localEntries = new LinkedList<LogRecord>();
            for (LogRecord entry : logRecords) {
                String resourcePath = entry.getResourcePath();
                boolean pathAdded = false;
                for (String sourcePath : this.dbConfigs.keySet()) {
                    if (resourcePath.startsWith(sourcePath)) {
                        if (!entryMap.containsKey(sourcePath)) {
                            entryMap.put(sourcePath, new LinkedList());
                        }
                        entry.setResourcePath(this.pathMap.get(sourcePath) + resourcePath.substring(sourcePath.length()));
                        ((List)entryMap.get(sourcePath)).add(entry);
                        pathAdded = true;
                        break;
                    }
                    if (!resourcePath.startsWith(this.pathMap.get(sourcePath))) continue;
                    if (!entryMap.containsKey(sourcePath)) {
                        entryMap.put(sourcePath, new LinkedList());
                    }
                    ((List)entryMap.get(sourcePath)).add(entry);
                    pathAdded = true;
                    break;
                }
                if (pathAdded) continue;
                localEntries.add(entry);
            }
            for (String sourcePath : this.dbConfigs.keySet()) {
                List temp = (List)entryMap.get(sourcePath);
                if (temp == null) continue;
                this.addLogRecords(temp.toArray(new LogRecord[temp.size()]), new JDBCDataAccessManager(this.dbConfigs.get(sourcePath)));
            }
            this.addLogRecords(localEntries.toArray(new LogRecord[localEntries.size()]), (JDBCDataAccessManager)dataAccessManager);
        } else {
            this.addLogRecords(logRecords, (JDBCDataAccessManager)dataAccessManager);
        }
    }

    private void addLogRecords(LogRecord[] logRecords, JDBCDataAccessManager dataAccessManager) throws RegistryException {
        Statement s = null;
        Connection conn = null;
        try {
            conn = dataAccessManager.getDataSource().getConnection();
            if (conn.getTransactionIsolation() != 2) {
                conn.setTransactionIsolation(2);
            }
            conn.setAutoCommit(false);
            String sql = "INSERT INTO REG_LOG (REG_PATH, REG_USER_ID, REG_LOGGED_TIME, REG_ACTION, REG_ACTION_DATA, REG_TENANT_ID) VALUES (?, ?, ?, ?, ?, ?)";
            s = conn.prepareStatement(sql);
            for (LogRecord logRecord : logRecords) {
                s.clearParameters();
                s.setString(1, logRecord.getResourcePath());
                s.setString(2, logRecord.getUserName());
                s.setTimestamp(3, new Timestamp(logRecord.getTimestamp().getTime()));
                s.setInt(4, logRecord.getAction());
                s.setString(5, logRecord.getActionData());
                s.setInt(6, logRecord.getTenantId());
                s.addBatch();
            }
            int[] status = s.executeBatch();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Successfully added " + status.length + " log records."));
            }
            conn.commit();
        }
        catch (SQLException e) {
            try {
                if (conn != null) {
                    conn.rollback();
                }
            }
            catch (SQLException e1) {
                log.error((Object)"Failed to rollback log insertion.", (Throwable)e);
            }
            String msg = "Failed to update log batch records . " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, e);
        }
        finally {
            try {
                if (s != null) {
                    s.close();
                }
                if (conn != null && !conn.isClosed()) {
                    conn.close();
                }
            }
            catch (SQLException ex) {
                String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg, (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getLogList(String path, int action, String userName, Date from, Date to, boolean descending, DataAccessManager dataAccessManager) throws RegistryException {
        List<Object> logEntries;
        JDBCDataAccessManager jdbcDataAccessManager;
        try {
            UserRealm realm;
            UserStoreManager reader;
            Object roles;
            List<String> list;
            if (userName == null && CurrentSession.getUser() != null && !CurrentSession.getUser().equals("wso2.system.user") && !(list = Arrays.asList(roles = (reader = (realm = CurrentSession.getUserRealm()).getUserStoreManager()).getRoleListOfUser(CurrentSession.getUser()))).contains(CurrentSession.getUserRealm().getRealmConfiguration().getAdminRoleName())) {
                userName = CurrentSession.getUser();
            }
        }
        catch (UserStoreException e) {
            String msg = "Failed to get list of roles of user " + userName;
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, e);
        }
        String resourcePath = path;
        if (resourcePath != null) {
            jdbcDataAccessManager = null;
            if (this.dbConfigs.size() > 0) {
                for (String sourcePath : this.dbConfigs.keySet()) {
                    if (!resourcePath.startsWith(sourcePath)) continue;
                    resourcePath = this.pathMap.get(sourcePath) + resourcePath.substring(sourcePath.length());
                    jdbcDataAccessManager = new JDBCDataAccessManager(this.dbConfigs.get(sourcePath));
                }
            }
            if (jdbcDataAccessManager != null) {
                boolean transactionSucceeded = false;
                try {
                    this.beginTransaction(jdbcDataAccessManager);
                    logEntries = this.internalGetLogs(true, resourcePath, action, userName, from, to, descending, JDBCDatabaseTransaction.getConnection());
                    transactionSucceeded = true;
                    List<Object> list = logEntries;
                    return list;
                }
                finally {
                    if (transactionSucceeded) {
                        this.commitTransaction(jdbcDataAccessManager);
                    } else {
                        this.rollbackTransaction(jdbcDataAccessManager);
                    }
                }
            }
            boolean foundMounts = false;
            logEntries = new LinkedList();
            for (String sourcePath : this.dbConfigs.keySet()) {
                if (!sourcePath.startsWith(resourcePath)) continue;
                boolean transactionSucceeded = false;
                JDBCDataAccessManager manager = new JDBCDataAccessManager(this.dbConfigs.get(sourcePath));
                List<LogEntry> temp = null;
                try {
                    this.beginTransaction(manager);
                    foundMounts = true;
                    temp = this.internalGetLogs(false, resourcePath, action, userName, from, to, descending, JDBCDatabaseTransaction.getConnection());
                    transactionSucceeded = true;
                }
                finally {
                    if (transactionSucceeded) {
                        this.commitTransaction(manager);
                    } else {
                        this.rollbackTransaction(manager);
                    }
                }
                if (temp == null) continue;
                for (LogEntry entry : temp) {
                    this.fixLogEntries(logEntries, sourcePath, entry);
                }
            }
            logEntries.addAll(this.internalGetLogs(!foundMounts, resourcePath, action, userName, from, to, descending, JDBCDatabaseTransaction.getConnection()));
            return foundMounts && logEntries.size() > 0 ? Arrays.asList(JDBCLogsDAO.getPaginatedLogs(logEntries.toArray(new LogEntry[logEntries.size()]))) : logEntries;
        }
        if (!(dataAccessManager instanceof JDBCDataAccessManager)) {
            String msg = "Failed to get logs. Invalid data access manager.";
            log.error((Object)msg);
            throw new RegistryException(msg);
        }
        jdbcDataAccessManager = (JDBCDataAccessManager)dataAccessManager;
        boolean foundMounts = false;
        logEntries = new LinkedList<LogEntry>();
        if (this.dbConfigs.size() > 0) {
            for (String sourcePath : this.dbConfigs.keySet()) {
                boolean transactionSucceeded = false;
                JDBCDataAccessManager manager = new JDBCDataAccessManager(this.dbConfigs.get(sourcePath));
                List<LogEntry> temp = null;
                try {
                    this.beginTransaction(manager);
                    foundMounts = true;
                    temp = this.internalGetLogs(false, resourcePath, action, userName, from, to, descending, JDBCDatabaseTransaction.getConnection());
                    transactionSucceeded = true;
                }
                finally {
                    if (transactionSucceeded) {
                        this.commitTransaction(manager);
                    } else {
                        this.rollbackTransaction(manager);
                    }
                }
                if (temp == null) continue;
                for (LogEntry entry : temp) {
                    this.fixLogEntries(logEntries, sourcePath, entry);
                }
            }
        }
        logEntries.addAll(this.internalGetLogs(!foundMounts, resourcePath, action, userName, from, to, descending, JDBCDatabaseTransaction.getConnection()));
        return foundMounts && logEntries.size() > 0 ? Arrays.asList(JDBCLogsDAO.getPaginatedLogs(logEntries.toArray(new LogEntry[logEntries.size()]))) : logEntries;
    }

    private void beginTransaction(JDBCDataAccessManager dataAccessManager) throws RegistryException {
        Transaction.pushTransaction();
        dataAccessManager.getTransactionManager().beginTransaction();
    }

    private void commitTransaction(JDBCDataAccessManager dataAccessManager) throws RegistryException {
        dataAccessManager.getTransactionManager().commitTransaction();
        Transaction.popTransaction();
    }

    private void rollbackTransaction(JDBCDataAccessManager dataAccessManager) throws RegistryException {
        dataAccessManager.getTransactionManager().rollbackTransaction();
        Transaction.popTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<LogEntry> internalGetLogs(boolean paginate, String resourcePath, int action, String userName, Date from, Date to, boolean descending, Connection conn) throws RegistryException {
        try {
            String dbName = conn.getMetaData().getDatabaseProductName();
            if (dbName.contains("Microsoft") || dbName.equals("Oracle")) {
                this.enableApiPagination = "false";
            }
        }
        catch (SQLException e) {
            throw new RegistryException("Failed to get Database product name ", e);
        }
        if (conn == null) {
            log.fatal((Object)"Failed to get Logs. Communications link failure. The connection to the database could not be acquired.");
            throw new RegistryException("Failed to get Logs. Communications link failure. The connection to the database could not be acquired.");
        }
        PreparedStatement s = null;
        ResultSet results = null;
        boolean paginated = false;
        int start = 0;
        int count = 0;
        String sortOrder = "";
        String sortBy = "";
        MessageContext messageContext = null;
        if ((this.enableApiPagination == null || this.enableApiPagination.equals("true")) && (messageContext = MessageContext.getCurrentMessageContext()) != null && PaginationUtils.isPaginationHeadersExist(messageContext)) {
            PaginationContext paginationContext = PaginationUtils.initPaginationContext(messageContext);
            start = paginationContext.getStart();
            count = paginationContext.getCount();
            if (start == 0) {
                start = 1;
            }
            sortBy = paginationContext.getSortBy();
            sortOrder = paginationContext.getSortOrder();
            paginated = paginate;
        }
        String sql = "SELECT REG_PATH, REG_USER_ID, REG_LOGGED_TIME, REG_ACTION, REG_ACTION_DATA FROM REG_LOG";
        boolean queryStarted = false;
        boolean isMssql = false;
        try {
            if (conn.getMetaData().getDatabaseProductName().contains(this.MSSQL_DATABASE_TYPE)) {
                isMssql = true;
            }
        }
        catch (SQLException e) {
            throw new RegistryException("Failed to get Database product name ", e);
        }
        sql = this.addWherePart(resourcePath, queryStarted, sql, userName, from, to, action, isMssql);
        if ("ASC".equals(sortOrder)) {
            descending = false;
        }
        sql = descending ? sql + " ORDER BY REG_LOGGED_TIME DESC" : sql + " ORDER BY REG_LOGGED_TIME ASC";
        try {
            s = this.enableApiPagination == null || this.enableApiPagination.equals("true") ? conn.prepareStatement(sql, 1004, 1008) : conn.prepareStatement(sql);
            int paramNumber = 1;
            if (resourcePath != null) {
                s.setString(paramNumber, resourcePath);
                ++paramNumber;
            }
            if (userName != null) {
                s.setString(paramNumber, userName);
                ++paramNumber;
            }
            if (from != null) {
                s.setTimestamp(paramNumber, new Timestamp(from.getTime()));
                ++paramNumber;
            }
            if (to != null) {
                s.setTimestamp(paramNumber, new Timestamp(to.getTime()));
                ++paramNumber;
            }
            if (action != -1) {
                s.setInt(paramNumber, action);
                ++paramNumber;
            }
            s.setInt(paramNumber, CurrentSession.getTenantId());
            results = s.executeQuery();
            List<Object> resultList = new ArrayList<LogEntry>();
            if (paginated) {
                if (results.relative(start)) {
                    results.previous();
                    for (int i = 0; results.next() && i < count; ++i) {
                        resultList.add((Object)this.getLogEntry(results));
                    }
                } else {
                    log.debug((Object)"start index doesn't exist in the result set");
                }
                if (results.last()) {
                    log.debug((Object)"cursor move to the last index of result set");
                } else {
                    log.debug((Object)"cursor doesn't move to the last index of result set");
                }
                PaginationUtils.setRowCount(messageContext, Integer.toString(results.getRow()));
            } else {
                while (results.next()) {
                    resultList.add((Object)this.getLogEntry(results));
                }
                LogEntry[] logEntries = resultList.toArray(new LogEntry[resultList.size()]);
                resultList = Arrays.asList(logEntries);
            }
            List<Object> list = resultList;
            return list;
        }
        catch (SQLException e) {
            String msg = "Failed to get logs. " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, e);
        }
        finally {
            try {
                try {
                    if (results != null) {
                        results.close();
                    }
                }
                finally {
                    if (s != null) {
                        s.close();
                    }
                }
            }
            catch (SQLException ex) {
                String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg, (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static LogEntry[] getPaginatedLogs(LogEntry[] logEntries) {
        MessageContext messageContext = MessageContext.getCurrentMessageContext();
        if (messageContext != null && PaginationUtils.isPaginationHeadersExist(messageContext)) {
            int rowCount = logEntries.length;
            try {
                LogEntry[] paginatedResult;
                PaginationUtils.setRowCount(messageContext, Integer.toString(rowCount));
                PaginationContext paginationContext = PaginationUtils.initPaginationContext(messageContext);
                int start = paginationContext.getStart();
                int count = paginationContext.getCount();
                int startIndex = start == 1 ? 0 : start;
                if (rowCount < start + count) {
                    paginatedResult = new LogEntry[rowCount - startIndex];
                    System.arraycopy(logEntries, startIndex, paginatedResult, 0, rowCount - startIndex);
                } else {
                    paginatedResult = new LogEntry[count];
                    System.arraycopy(logEntries, startIndex, paginatedResult, 0, count);
                }
                LogEntry[] logEntryArray = paginatedResult;
                return logEntryArray;
            }
            finally {
                PaginationContext.destroy();
            }
        }
        return logEntries;
    }

    private LogEntry getLogEntry(ResultSet results) throws SQLException {
        LogEntry logEntry = new LogEntry();
        logEntry.setResourcePath(results.getString("REG_PATH"));
        logEntry.setUserName(results.getString("REG_USER_ID"));
        logEntry.setDate(new Date(results.getTimestamp("REG_LOGGED_TIME").getTime()));
        logEntry.setAction(results.getInt("REG_ACTION"));
        logEntry.setActionData(results.getString("REG_ACTION_DATA"));
        return logEntry;
    }

    private String addWherePart(String resourcePath, boolean queryStarted, String sql, String userName, Date from, Date to, int action, boolean isMssql) {
        if (resourcePath != null) {
            if (queryStarted) {
                sql = sql + " AND REG_PATH=?";
            } else {
                sql = sql + " WHERE REG_PATH=?";
                queryStarted = true;
            }
        }
        if (userName != null) {
            if (queryStarted) {
                sql = sql + "  AND REG_USER_ID=?";
            } else {
                sql = sql + "  WHERE REG_USER_ID=?";
                queryStarted = true;
            }
        }
        if (from != null) {
            if (isMssql) {
                if (queryStarted) {
                    sql = sql + " AND REG_LOGGED_TIME > CONVERT(datetime, ?)";
                } else {
                    sql = sql + " WHERE REG_LOGGED_TIME > CONVERT(datetime, ?)";
                    queryStarted = true;
                }
            } else if (queryStarted) {
                sql = sql + " AND REG_LOGGED_TIME>?";
            } else {
                sql = sql + " WHERE REG_LOGGED_TIME>?";
                queryStarted = true;
            }
        }
        if (to != null) {
            if (isMssql) {
                if (queryStarted) {
                    sql = sql + " AND REG_LOGGED_TIME < CONVERT(datetime, ?)";
                } else {
                    sql = sql + " WHERE REG_LOGGED_TIME < CONVERT(datetime, ?)";
                    queryStarted = true;
                }
            } else if (queryStarted) {
                sql = sql + " AND REG_LOGGED_TIME<?";
            } else {
                sql = sql + " WHERE REG_LOGGED_TIME<?";
                queryStarted = true;
            }
        }
        if (action != -1) {
            if (queryStarted) {
                sql = sql + " AND REG_ACTION=?";
            } else {
                sql = sql + " WHERE REG_ACTION=?";
                queryStarted = true;
            }
        }
        sql = queryStarted ? sql + " AND REG_TENANT_ID=?" : sql + " WHERE REG_TENANT_ID=?";
        return sql;
    }

    @Override
    public LogEntry[] getLogs(String path, int action, String userName, Date from, Date to, boolean descending, int start, int pageLen, DataAccessManager dataAccessManager) throws RegistryException {
        if (!(dataAccessManager instanceof JDBCDataAccessManager)) {
            String msg = "Failed to get logs. Invalid data access manager.";
            log.error((Object)msg);
            throw new RegistryException(msg);
        }
        String resourcePath = path;
        if (resourcePath != null) {
            DataSource dataSource = null;
            if (this.dbConfigs.size() > 0) {
                for (String string : this.dbConfigs.keySet()) {
                    if (!resourcePath.startsWith(string)) continue;
                    resourcePath = this.pathMap.get(string) + resourcePath.substring(string.length());
                    dataSource = new JDBCDataAccessManager(this.dbConfigs.get(string)).getDataSource();
                }
            }
            if (dataSource != null) {
                return this.internalGetLogs(action, userName, from, to, descending, start, pageLen, resourcePath, dataSource);
            }
            LinkedList<LogEntry> logEntries = new LinkedList<LogEntry>();
            for (String sourcePath : this.dbConfigs.keySet()) {
                LogEntry[] temp;
                if (!sourcePath.startsWith(resourcePath) || (temp = this.internalGetLogs(action, userName, from, to, descending, start, pageLen, resourcePath, new JDBCDataAccessManager(this.dbConfigs.get(sourcePath)).getDataSource())) == null) continue;
                for (LogEntry entry : temp) {
                    this.fixLogEntries(logEntries, sourcePath, entry);
                }
            }
            logEntries.addAll(Arrays.asList(this.internalGetLogs(action, userName, from, to, descending, start, pageLen, resourcePath, ((JDBCDataAccessManager)dataAccessManager).getDataSource())));
            return logEntries.toArray(new LogEntry[logEntries.size()]);
        }
        LinkedList<LogEntry> logEntries = new LinkedList<LogEntry>();
        if (this.dbConfigs.size() > 0) {
            for (String string : this.dbConfigs.keySet()) {
                LogEntry[] temp = this.internalGetLogs(action, userName, from, to, descending, start, pageLen, resourcePath, new JDBCDataAccessManager(this.dbConfigs.get(string)).getDataSource());
                if (temp == null) continue;
                for (LogEntry entry : temp) {
                    this.fixLogEntries(logEntries, string, entry);
                }
            }
        }
        logEntries.addAll(Arrays.asList(this.internalGetLogs(action, userName, from, to, descending, start, pageLen, resourcePath, ((JDBCDataAccessManager)dataAccessManager).getDataSource())));
        return logEntries.toArray(new LogEntry[logEntries.size()]);
    }

    private void fixLogEntries(List<LogEntry> logEntries, String sourcePath, LogEntry entry) {
        String targetPath;
        String entryPath = entry.getResourcePath();
        if (entryPath.startsWith(targetPath = this.pathMap.get(sourcePath))) {
            entry.setResourcePath(sourcePath + entryPath.substring(targetPath.length()));
            logEntries.add(entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LogEntry[] internalGetLogs(int action, String userName, Date from, Date to, boolean descending, int start, int pageLen, String resourcePath, DataSource dataSource) throws RegistryException {
        String sql = "SELECT REG_PATH, REG_USER_ID, REG_LOGGED_TIME, REG_ACTION, REG_ACTION_DATA FROM REG_LOG";
        boolean queryStarted = false;
        Connection conn = null;
        Statement s = null;
        ResultSet results = null;
        boolean isMssql = false;
        try {
            conn = dataSource.getConnection();
            if (conn.getMetaData().getDatabaseProductName().contains(this.MSSQL_DATABASE_TYPE)) {
                isMssql = true;
            }
            sql = this.addWherePart(resourcePath, queryStarted, sql, userName, from, to, action, isMssql);
            if (descending) {
                sql = sql + " ORDER BY REG_LOGGED_TIME DESC";
            }
            s = conn.prepareStatement(sql);
            int paramNumber = 1;
            if (resourcePath != null) {
                s.setString(paramNumber, resourcePath);
                ++paramNumber;
            }
            if (userName != null) {
                s.setString(paramNumber, userName);
                ++paramNumber;
            }
            if (from != null) {
                s.setTimestamp(paramNumber, new Timestamp(from.getTime()));
                ++paramNumber;
            }
            if (to != null) {
                s.setTimestamp(paramNumber, new Timestamp(to.getTime()));
                ++paramNumber;
            }
            if (action != -1) {
                s.setInt(paramNumber, action);
                ++paramNumber;
            }
            s.setInt(paramNumber, CurrentSession.getTenantId());
            results = s.executeQuery();
            ArrayList<LogEntry> resultList = new ArrayList<LogEntry>();
            int current = 0;
            while (results.next()) {
                if (current >= start && (pageLen == -1 || current < start + pageLen)) {
                    LogEntry logEntry = new LogEntry();
                    logEntry.setResourcePath(results.getString("REG_PATH"));
                    logEntry.setUserName(results.getString("REG_USER_ID"));
                    logEntry.setDate(new Date(results.getTimestamp("REG_LOGGED_TIME").getTime()));
                    logEntry.setAction(results.getInt("REG_ACTION"));
                    logEntry.setActionData(results.getString("REG_ACTION_DATA"));
                    resultList.add(logEntry);
                }
                ++current;
            }
            LogEntry[] logEntryArray = resultList.toArray(new LogEntry[resultList.size()]);
            return logEntryArray;
        }
        catch (SQLException e) {
            String msg = "Failed to get logs. " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, e);
        }
        finally {
            try {
                try {
                    if (results != null) {
                        results.close();
                    }
                }
                finally {
                    try {
                        if (s != null) {
                            s.close();
                        }
                    }
                    finally {
                        if (conn != null) {
                            conn.close();
                        }
                    }
                }
            }
            catch (SQLException ex) {
                String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg, (Throwable)ex);
            }
        }
    }

    @Override
    public LogEntry[] getLogs(String path, int action, String userName, Date from, Date to, boolean descending, DataAccessManager dataAccessManager) throws RegistryException {
        if (!(dataAccessManager instanceof JDBCDataAccessManager)) {
            String msg = "Failed to get logs. Invalid data access manager.";
            log.error((Object)msg);
            throw new RegistryException(msg);
        }
        String resourcePath = path;
        if (resourcePath != null) {
            DataSource dataSource = null;
            if (this.dbConfigs.size() > 0) {
                for (String string : this.dbConfigs.keySet()) {
                    if (!resourcePath.startsWith(string)) continue;
                    resourcePath = this.pathMap.get(string) + resourcePath.substring(string.length());
                    dataSource = new JDBCDataAccessManager(this.dbConfigs.get(string)).getDataSource();
                }
            }
            if (dataSource != null) {
                return this.internalGetLogs(action, userName, from, to, descending, resourcePath, dataSource);
            }
            LinkedList<LogEntry> logEntries = new LinkedList<LogEntry>();
            for (String sourcePath : this.dbConfigs.keySet()) {
                LogEntry[] temp;
                if (!sourcePath.startsWith(resourcePath) || (temp = this.internalGetLogs(action, userName, from, to, descending, resourcePath, new JDBCDataAccessManager(this.dbConfigs.get(sourcePath)).getDataSource())) == null) continue;
                for (LogEntry entry : temp) {
                    this.fixLogEntries(logEntries, sourcePath, entry);
                }
            }
            logEntries.addAll(Arrays.asList(this.internalGetLogs(action, userName, from, to, descending, resourcePath, ((JDBCDataAccessManager)dataAccessManager).getDataSource())));
            return logEntries.toArray(new LogEntry[logEntries.size()]);
        }
        LinkedList<LogEntry> logEntries = new LinkedList<LogEntry>();
        if (this.dbConfigs.size() > 0) {
            for (String string : this.dbConfigs.keySet()) {
                LogEntry[] temp = this.internalGetLogs(action, userName, from, to, descending, resourcePath, new JDBCDataAccessManager(this.dbConfigs.get(string)).getDataSource());
                if (temp == null) continue;
                for (LogEntry entry : temp) {
                    this.fixLogEntries(logEntries, string, entry);
                }
            }
        }
        logEntries.addAll(Arrays.asList(this.internalGetLogs(action, userName, from, to, descending, resourcePath, ((JDBCDataAccessManager)dataAccessManager).getDataSource())));
        return logEntries.toArray(new LogEntry[logEntries.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LogEntry[] internalGetLogs(int action, String userName, Date from, Date to, boolean descending, String resourcePath, DataSource dataSource) throws RegistryException {
        boolean queryStarted = false;
        Statement s = null;
        ResultSet results = null;
        Connection conn = null;
        String sql = "SELECT REG_PATH, REG_USER_ID, REG_LOGGED_TIME, REG_ACTION, REG_ACTION_DATA FROM REG_LOG";
        boolean isMssql = false;
        try {
            conn = dataSource.getConnection();
            if (conn.getMetaData().getDatabaseProductName().contains(this.MSSQL_DATABASE_TYPE)) {
                isMssql = true;
            }
            sql = this.addWherePart(resourcePath, queryStarted, sql, userName, from, to, action, isMssql);
            if (descending) {
                sql = sql + " ORDER BY REG_LOGGED_TIME DESC";
            }
            s = conn.prepareStatement(sql);
            int paramNumber = 1;
            if (resourcePath != null) {
                s.setString(paramNumber, resourcePath);
                ++paramNumber;
            }
            if (userName != null) {
                s.setString(paramNumber, userName);
                ++paramNumber;
            }
            if (from != null) {
                s.setTimestamp(paramNumber, new Timestamp(from.getTime()));
                ++paramNumber;
            }
            if (to != null) {
                s.setTimestamp(paramNumber, new Timestamp(to.getTime()));
                ++paramNumber;
            }
            if (action != -1) {
                s.setInt(paramNumber, action);
                ++paramNumber;
            }
            s.setInt(paramNumber, CurrentSession.getTenantId());
            results = s.executeQuery();
            ArrayList<LogEntry> resultList = new ArrayList<LogEntry>();
            while (results.next()) {
                LogEntry logEntry = new LogEntry();
                logEntry.setResourcePath(results.getString("REG_PATH"));
                logEntry.setUserName(results.getString("REG_USER_ID"));
                logEntry.setDate(new Date(results.getTimestamp("REG_LOGGED_TIME").getTime()));
                logEntry.setAction(results.getInt("REG_ACTION"));
                logEntry.setActionData(results.getString("REG_ACTION_DATA"));
                resultList.add(logEntry);
            }
            LogEntry[] logEntryArray = resultList.toArray(new LogEntry[resultList.size()]);
            return logEntryArray;
        }
        catch (SQLException e) {
            String msg = "Failed to get logs. " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, e);
        }
        finally {
            try {
                try {
                    if (results != null) {
                        results.close();
                    }
                }
                finally {
                    try {
                        if (s != null) {
                            s.close();
                        }
                    }
                    finally {
                        if (conn != null) {
                            conn.close();
                        }
                    }
                }
            }
            catch (SQLException ex) {
                String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg, (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getLogsCount(String resourcePath, int action, String userName, Date from, Date to, boolean descending) throws RegistryException {
        int count = 0;
        JDBCDatabaseTransaction.ManagedRegistryConnection conn = JDBCDatabaseTransaction.getConnection();
        String sql = "SELECT COUNT(*) AS REG_LOG_COUNT FROM REG_LOG";
        boolean queryStarted = false;
        boolean isMssql = false;
        try {
            if (conn.getMetaData().getDatabaseProductName().contains(this.MSSQL_DATABASE_TYPE)) {
                isMssql = true;
            }
        }
        catch (SQLException e) {
            throw new RegistryException("Failed to get Database product name ", e);
        }
        sql = this.addWherePart(resourcePath, queryStarted, sql, userName, from, to, action, isMssql);
        PreparedStatement s = null;
        ResultSet results = null;
        try {
            s = conn.prepareStatement(sql);
            int paramNumber = 1;
            if (resourcePath != null) {
                s.setString(paramNumber, resourcePath);
                ++paramNumber;
            }
            if (userName != null) {
                s.setString(paramNumber, userName);
                ++paramNumber;
            }
            if (from != null) {
                s.setTimestamp(paramNumber, new Timestamp(from.getTime()));
                ++paramNumber;
            }
            if (to != null) {
                s.setTimestamp(paramNumber, new Timestamp(to.getTime()));
                ++paramNumber;
            }
            if (action != -1) {
                s.setInt(paramNumber, action);
                ++paramNumber;
            }
            s.setInt(paramNumber, CurrentSession.getTenantId());
            results = s.executeQuery();
            if (results.next()) {
                count = results.getInt("REG_LOG_COUNT");
            }
        }
        catch (SQLException e) {
            String msg = "Failed to get logs. " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, e);
        }
        finally {
            try {
                try {
                    if (results != null) {
                        results.close();
                    }
                }
                finally {
                    if (s != null) {
                        s.close();
                    }
                }
            }
            catch (SQLException ex) {
                String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg, (Throwable)ex);
            }
        }
        return count;
    }
}

