/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.core.jdbc;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.CollectionImpl;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourceIDImpl;
import org.wso2.carbon.registry.core.ResourceImpl;
import org.wso2.carbon.registry.core.ResourcePath;
import org.wso2.carbon.registry.core.config.StaticConfiguration;
import org.wso2.carbon.registry.core.dao.AssociationDAO;
import org.wso2.carbon.registry.core.dao.CommentsDAO;
import org.wso2.carbon.registry.core.dao.RatingsDAO;
import org.wso2.carbon.registry.core.dao.ResourceDAO;
import org.wso2.carbon.registry.core.dao.ResourceVersionDAO;
import org.wso2.carbon.registry.core.dao.TagsDAO;
import org.wso2.carbon.registry.core.dataaccess.DataAccessManager;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.dataobjects.ResourceDO;
import org.wso2.carbon.registry.core.jdbc.utils.VersionInputStream;
import org.wso2.carbon.registry.core.jdbc.utils.VersionRetriever;
import org.wso2.carbon.registry.core.secure.AuthorizationFailedException;
import org.wso2.carbon.registry.core.session.CurrentSession;
import org.wso2.carbon.registry.core.utils.AuthorizationUtils;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.registry.core.utils.VersionedPath;

public class VersionRepository {
    private static Log log = LogFactory.getLog(VersionRepository.class);
    private DataAccessManager dataAccessManager;
    private ResourceDAO resourceDAO;
    private ResourceVersionDAO resourceVersionDAO;
    private CommentsDAO commentsDAO;
    private RatingsDAO ratingsDAO;
    private AssociationDAO associationDAO;
    private TagsDAO tagsDAO;

    public VersionRepository(DataAccessManager dataAccessManager) {
        this.dataAccessManager = dataAccessManager;
        this.resourceDAO = dataAccessManager.getDAOManager().getResourceDAO();
        this.resourceVersionDAO = dataAccessManager.getDAOManager().getResourceVersionDAO();
        this.commentsDAO = dataAccessManager.getDAOManager().getCommentsDAO(StaticConfiguration.isVersioningComments());
        this.ratingsDAO = dataAccessManager.getDAOManager().getRatingsDAO(StaticConfiguration.isVersioningRatings());
        this.associationDAO = dataAccessManager.getDAOManager().getAssociationDAO();
        this.tagsDAO = dataAccessManager.getDAOManager().getTagsDAO(StaticConfiguration.isVersioningTags());
    }

    public void createSnapshot(Resource resource, boolean isRenewing, boolean keepProperties) throws RegistryException {
        String resourceName;
        ResourceImpl resourceImpl = (ResourceImpl)resource;
        this.createVersionForResource(resourceImpl, isRenewing, keepProperties);
        long version = resourceImpl.getVersionNumber();
        boolean isCollection = resourceImpl instanceof CollectionImpl;
        ResourceIDImpl rootResourceID = resourceImpl.getResourceIDImpl();
        ArrayList<Long> versionList = new ArrayList<Long>();
        versionList.add(version);
        if (isCollection) {
            this.addDescendants(rootResourceID, versionList, isRenewing, keepProperties);
        }
        VersionInputStream versionsInputStream = new VersionInputStream(versionList);
        int pathId = rootResourceID.getPathID();
        long snapshotID = this.resourceVersionDAO.createSnapshot(pathId, resourceName = rootResourceID.getName(), versionsInputStream);
        if (snapshotID != -1L) {
            VersionedPath versionedPath = new VersionedPath();
            versionedPath.setVersion(snapshotID);
            versionedPath.setPath(resourceImpl.getPath());
            this.associationDAO.copyAssociations(resourceImpl.getPath(), versionedPath.toString());
        }
    }

    public void createSnapshot(ResourcePath resourcePath, boolean isRenewing, boolean keepProperties) throws RegistryException {
        if (!resourcePath.isCurrentVersion()) {
            String msg = "Failed to create snapshot of the resource " + resourcePath + ". Given path refers to an archived version of the resource.";
            log.error((Object)msg);
            throw new RegistryException(msg);
        }
        String path = resourcePath.getPath();
        ResourceIDImpl resourceID = this.resourceDAO.getResourceID(path = RegistryUtils.getPureResourcePath(path));
        if (resourceID == null) {
            String msg = "Failed to get resource id to create a snapshot to the resource " + path + ". ";
            throw new RegistryException(msg);
        }
        ResourceImpl resource = this.resourceDAO.getResourceMetaData(resourceID);
        this.createSnapshot(resource, isRenewing, keepProperties);
    }

    public void addDescendants(ResourceIDImpl resourceID, ArrayList<Long> versionList, boolean isRenewing, boolean keepProperties) throws RegistryException {
        List<ResourceIDImpl> childIds = this.resourceDAO.getChildPathIds(resourceID);
        for (ResourceIDImpl childId : childIds) {
            ResourceImpl childResourceImpl = this.resourceDAO.getResourceWithNoUpdate(childId);
            long version = childResourceImpl.getVersionNumber();
            versionList.add(version);
            this.createVersionForResource(childResourceImpl, isRenewing, keepProperties);
        }
        for (ResourceIDImpl childId : childIds) {
            if (!childId.isCollection()) continue;
            this.addDescendants(childId, versionList, isRenewing, keepProperties);
        }
        ResourceDO resourceDO = this.resourceDAO.getResourceDO(resourceID);
        if (resourceID.isCollection() && !this.resourceVersionDAO.isResourceHistoryExist(resourceDO.getVersion())) {
            this.resourceVersionDAO.putResourceToHistory(resourceDO);
        }
    }

    private void createVersionForResource(ResourceImpl resourceImpl, boolean isRenewing, boolean keepProperties) throws RegistryException {
        ResourceDO resourceDO = resourceImpl.getResourceDO();
        if (resourceDO.getVersion() <= 0L) {
            resourceDO = this.resourceDAO.getResourceDO(resourceImpl.getResourceIDImpl());
            isRenewing = false;
        }
        if (isRenewing) {
            if (!(resourceImpl instanceof CollectionImpl)) {
                this.resourceDAO.fillResourceContentWithNoUpdate(resourceImpl);
            }
            if (StaticConfiguration.isVersioningProperties() || !keepProperties) {
                this.resourceDAO.fillResourcePropertiesWithNoUpdate(resourceImpl);
            }
        }
        this.resourceVersionDAO.versionResource(resourceDO, keepProperties);
        if (isRenewing) {
            ResourceImpl renewedResourceImpl = resourceImpl.getShallowCopy();
            if (!(renewedResourceImpl instanceof CollectionImpl)) {
                this.resourceDAO.addContent(renewedResourceImpl);
            }
            this.resourceDAO.addResourceWithNoUpdate(renewedResourceImpl);
            if (StaticConfiguration.isVersioningProperties() || !keepProperties) {
                this.resourceDAO.addProperties(renewedResourceImpl);
            }
            this.commentsDAO.copyComments(resourceImpl, renewedResourceImpl);
            this.tagsDAO.copyTags(resourceImpl, renewedResourceImpl);
            this.ratingsDAO.copyRatings(resourceImpl, renewedResourceImpl);
        }
    }

    public String[] getVersions(String resourcePath) throws RegistryException {
        resourcePath = RegistryUtils.getPureResourcePath(resourcePath);
        Long[] snapshotNumbers = this.resourceVersionDAO.getSnapshotIDs(resourcePath);
        ArrayList<String> versionPaths = new ArrayList<String>();
        for (Long snapshotNumber : snapshotNumbers) {
            String versionPath = resourcePath + ";" + "version:" + snapshotNumber;
            versionPaths.add(versionPath);
        }
        return versionPaths.toArray(new String[versionPaths.size()]);
    }

    public Resource getMetaData(VersionedPath versionedPath) throws RegistryException {
        ResourceIDImpl resourceID = this.resourceDAO.getResourceID(versionedPath.getPath());
        if (!AuthorizationUtils.authorize(versionedPath.getPath(), "http://www.wso2.org/projects/registry/actions/get")) {
            String msg = "User " + CurrentSession.getUser() + " is not authorized to read the resource " + versionedPath + ".";
            log.warn((Object)msg);
            throw new AuthorizationFailedException(msg);
        }
        long snapshotID = versionedPath.getVersion();
        ResourceImpl resourceImpl = this.resourceVersionDAO.get(resourceID, snapshotID);
        if (resourceImpl == null) {
            String msg = "Resource " + versionedPath.getPath() + " does not have a version " + versionedPath.getVersion();
            log.error((Object)msg);
            throw new RegistryException(msg);
        }
        resourceImpl.setDataAccessManager(this.dataAccessManager);
        resourceImpl.setPath(versionedPath.getPath());
        resourceImpl.setSnapshotID(snapshotID);
        resourceImpl.setMatchingSnapshotID(snapshotID);
        return resourceImpl;
    }

    public boolean resourceExists(VersionedPath versionedPath) throws RegistryException {
        ResourceIDImpl resourceID = this.resourceDAO.getResourceID(versionedPath.getPath());
        long snapshotID = versionedPath.getVersion();
        return this.resourceVersionDAO.resourceExists(resourceID, snapshotID);
    }

    public Resource get(VersionedPath versionedPath) throws RegistryException {
        ResourceIDImpl resourceID = this.resourceDAO.getResourceID(versionedPath.getPath());
        if (!AuthorizationUtils.authorize(versionedPath.getPath(), "http://www.wso2.org/projects/registry/actions/get")) {
            String msg = "User " + CurrentSession.getUser() + " is not authorized to read the resource " + versionedPath + ".";
            log.warn((Object)msg);
            throw new AuthorizationFailedException(msg);
        }
        long snapshotID = versionedPath.getVersion();
        ResourceImpl resourceImpl = this.resourceVersionDAO.get(resourceID, snapshotID);
        if (resourceImpl == null) {
            String msg = "Resource " + versionedPath.getPath() + " does not have a version " + versionedPath.getVersion();
            log.error((Object)msg);
            throw new RegistryException(msg);
        }
        int contentId = resourceImpl.getDbBasedContentID();
        if (contentId > 0) {
            this.resourceVersionDAO.fillResourceContentArchived(resourceImpl);
        }
        this.resourceDAO.fillResourcePropertiesWithNoUpdate(resourceImpl);
        resourceImpl.setDataAccessManager(this.dataAccessManager);
        resourceImpl.setUserName(CurrentSession.getUser());
        resourceImpl.setTenantId(CurrentSession.getTenantId());
        resourceImpl.setUserRealm(CurrentSession.getUserRealm());
        resourceImpl.setPath(versionedPath.getPath());
        resourceImpl.setSnapshotID(snapshotID);
        resourceImpl.setMatchingSnapshotID(snapshotID);
        return resourceImpl;
    }

    public Collection get(VersionedPath versionedPath, int start, int pageLen) throws RegistryException {
        long snapshotID;
        ResourceIDImpl resourceID = this.resourceDAO.getResourceID(versionedPath.getPath());
        CollectionImpl collectionImpl = this.resourceVersionDAO.get(resourceID, snapshotID = versionedPath.getVersion(), start, pageLen);
        if (collectionImpl == null) {
            String msg = "Resource " + versionedPath.getPath() + " does not have a version " + versionedPath.getVersion();
            log.error((Object)msg);
            throw new RegistryException(msg);
        }
        collectionImpl.setDataAccessManager(this.dataAccessManager);
        collectionImpl.setUserName(CurrentSession.getUser());
        collectionImpl.setTenantId(CurrentSession.getTenantId());
        collectionImpl.setUserRealm(CurrentSession.getUserRealm());
        collectionImpl.setPath(versionedPath.getPath());
        collectionImpl.setSnapshotID(snapshotID);
        collectionImpl.setMatchingSnapshotID(snapshotID);
        return collectionImpl;
    }

    public void restoreVersion(ResourcePath resourcePath) throws RegistryException {
        VersionedPath versionedPath = RegistryUtils.getVersionedPath(resourcePath);
        if (versionedPath.getVersion() == -1L) {
            String msg = "Failed to restore resource. " + versionedPath + " is not a valid version path.";
            log.error((Object)msg);
            throw new RegistryException(msg);
        }
        String versionedResourcePath = versionedPath.getPath();
        long snapshotID = versionedPath.getVersion();
        ResourceIDImpl resourceID = this.resourceDAO.getResourceID(versionedResourcePath);
        if (!AuthorizationUtils.authorize(versionedResourcePath, "http://www.wso2.org/projects/registry/actions/add")) {
            String msg = "User " + CurrentSession.getUser() + " is not authorized to restore the resource " + versionedResourcePath + ".";
            log.warn((Object)msg);
            throw new AuthorizationFailedException(msg);
        }
        this.restoreSnapshotNetwork(resourceID, snapshotID);
    }

    private void restoreSnapshotNetwork(ResourceIDImpl resourceID, long snapshotID) throws RegistryException {
        long version;
        VersionRetriever versionRetriever = this.resourceVersionDAO.getVersionList(resourceID, snapshotID);
        if (versionRetriever == null) {
            String msg = "The snapshot " + snapshotID + " doesn't contain the resource " + resourceID.getPath();
            log.warn((Object)msg);
            throw new AuthorizationFailedException(msg);
        }
        int versionIndex = 0;
        while ((version = versionRetriever.getVersion(versionIndex)) != -1L) {
            this.resourceVersionDAO.restoreResources(version, snapshotID);
            ++versionIndex;
        }
    }

    public boolean removeVersionHistory(String path, long snapshotId) throws RegistryException {
        if (!AuthorizationUtils.authorize(path, "http://www.wso2.org/projects/registry/actions/delete")) {
            String msg = "User " + CurrentSession.getUser() + " is not authorized to remove the version of the resource " + path + ".";
            log.warn((Object)msg);
            throw new AuthorizationFailedException(msg);
        }
        VersionRetriever versionRetriever = this.resourceVersionDAO.getVersionList(snapshotId);
        if (versionRetriever == null) {
            String msg = "The snapshot with the ID: " + snapshotId + " doesn't exists";
            log.warn((Object)msg);
            throw new AuthorizationFailedException(msg);
        }
        int versionIndex = 0;
        long regVersion = versionRetriever.getVersion(versionIndex);
        if (regVersion == -1L) {
            return false;
        }
        this.tagsDAO.removeVersionTags(regVersion);
        this.commentsDAO.removeVersionComments(regVersion);
        this.ratingsDAO.removeVersionRatings(regVersion);
        this.resourceVersionDAO.removePropertyValues(regVersion);
        this.resourceVersionDAO.removeSnapshot(snapshotId);
        return true;
    }
}

