/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.core.jdbc;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.util.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.Association;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.CollectionImpl;
import org.wso2.carbon.registry.core.Comment;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourceIDImpl;
import org.wso2.carbon.registry.core.ResourceImpl;
import org.wso2.carbon.registry.core.ResourcePath;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.config.StaticConfiguration;
import org.wso2.carbon.registry.core.dao.AssociationDAO;
import org.wso2.carbon.registry.core.dao.CommentsDAO;
import org.wso2.carbon.registry.core.dao.RatingsDAO;
import org.wso2.carbon.registry.core.dao.ResourceDAO;
import org.wso2.carbon.registry.core.dao.ResourceVersionDAO;
import org.wso2.carbon.registry.core.dao.TagsDAO;
import org.wso2.carbon.registry.core.dataaccess.DataAccessManager;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.exceptions.ResourceNotFoundException;
import org.wso2.carbon.registry.core.jdbc.RecursionRepository;
import org.wso2.carbon.registry.core.jdbc.VersionRepository;
import org.wso2.carbon.registry.core.jdbc.dataobjects.CommentDO;
import org.wso2.carbon.registry.core.jdbc.dataobjects.RatingDO;
import org.wso2.carbon.registry.core.jdbc.dataobjects.ResourceDO;
import org.wso2.carbon.registry.core.jdbc.dataobjects.TaggingDO;
import org.wso2.carbon.registry.core.jdbc.utils.DumpReader;
import org.wso2.carbon.registry.core.jdbc.utils.DumpWriter;
import org.wso2.carbon.registry.core.secure.AuthorizationFailedException;
import org.wso2.carbon.registry.core.session.CurrentSession;
import org.wso2.carbon.registry.core.utils.AuthorizationUtils;
import org.wso2.carbon.registry.core.utils.MediaTypesUtils;
import org.wso2.carbon.registry.core.utils.RegistryUtils;

public class Repository {
    private static final Log log = LogFactory.getLog(Repository.class);
    private ResourceDAO resourceDAO;
    private ResourceVersionDAO resourceVersionDAO;
    private AssociationDAO associationDAO;
    private CommentsDAO commentsDAO;
    private RatingsDAO ratingsDAO;
    private TagsDAO tagsDAO;
    private static final String ILLEGAL_CHARACTERS_FOR_PATH = ".*[~!@#;%^*+={}\\|\\\\<>\",'].*";
    private Pattern illegalCharactersPattern;
    static final String IS_LOGGING_ACTIVITY = "isLoggingActivity";
    private boolean versionOnChange = false;
    private VersionRepository versionRepository;
    private RecursionRepository recursionRepository;
    private DataAccessManager dataAccessManager;

    public Repository(DataAccessManager dataAccessManager, VersionRepository versionRepository, boolean versionOnChange, RecursionRepository recursionRepository) {
        this.dataAccessManager = dataAccessManager;
        this.versionRepository = versionRepository;
        this.versionOnChange = versionOnChange;
        this.recursionRepository = recursionRepository;
        recursionRepository.setRepository(this);
        this.resourceDAO = dataAccessManager.getDAOManager().getResourceDAO();
        this.resourceVersionDAO = dataAccessManager.getDAOManager().getResourceVersionDAO();
        this.associationDAO = dataAccessManager.getDAOManager().getAssociationDAO();
        this.commentsDAO = dataAccessManager.getDAOManager().getCommentsDAO(StaticConfiguration.isVersioningComments());
        this.ratingsDAO = dataAccessManager.getDAOManager().getRatingsDAO(StaticConfiguration.isVersioningRatings());
        this.tagsDAO = dataAccessManager.getDAOManager().getTagsDAO(StaticConfiguration.isVersioningTags());
        this.illegalCharactersPattern = Pattern.compile(ILLEGAL_CHARACTERS_FOR_PATH);
    }

    public boolean resourceExists(String path) throws RegistryException {
        String purePath = RegistryUtils.getPureResourcePath(path);
        return this.resourceDAO.resourceExists(purePath);
    }

    public Resource getMetaData(String path) throws RegistryException {
        String purePath = RegistryUtils.getPureResourcePath(path);
        ResourceImpl resource = this.resourceDAO.getResourceMetaData(purePath);
        if (resource == null) {
            return null;
        }
        if (!AuthorizationUtils.authorize(purePath, "http://www.wso2.org/projects/registry/actions/get")) {
            String msg = this.getUserNotAuthorizedMsg() + "read the resource " + purePath + ".";
            log.warn((Object)msg);
            throw new AuthorizationFailedException(msg);
        }
        resource.setDataAccessManager(this.dataAccessManager);
        resource.setUserName(CurrentSession.getUser());
        resource.setTenantId(CurrentSession.getTenantId());
        resource.setUserRealm(CurrentSession.getUserRealm());
        return resource;
    }

    public Resource get(String path) throws RegistryException {
        String purePath = RegistryUtils.getPureResourcePath(path);
        ResourceImpl resource = this.resourceDAO.getResourceMetaData(purePath);
        if (resource == null) {
            return null;
        }
        if (!AuthorizationUtils.authorize(purePath, "http://www.wso2.org/projects/registry/actions/get")) {
            String msg = this.getUserNotAuthorizedMsg() + "read the resource " + purePath + ".";
            log.warn((Object)msg);
            throw new AuthorizationFailedException(msg);
        }
        this.resourceDAO.fillResource(resource);
        resource.setDataAccessManager(this.dataAccessManager);
        resource.setUserName(CurrentSession.getUser());
        resource.setTenantId(CurrentSession.getTenantId());
        resource.setUserRealm(CurrentSession.getUserRealm());
        return resource;
    }

    public Collection get(String path, int start, int pageLen) throws RegistryException {
        String purePath = RegistryUtils.getPureResourcePath(path);
        CollectionImpl resource = (CollectionImpl)this.resourceDAO.getResourceMetaData(purePath);
        if (resource == null) {
            return null;
        }
        if (!AuthorizationUtils.authorize(purePath, "http://www.wso2.org/projects/registry/actions/get")) {
            String msg = this.getUserNotAuthorizedMsg() + "read the resource " + purePath + ".";
            log.warn((Object)msg);
            throw new AuthorizationFailedException(msg);
        }
        this.resourceDAO.fillResource(resource, start, pageLen);
        resource.setDataAccessManager(this.dataAccessManager);
        resource.setUserName(CurrentSession.getUser());
        resource.setTenantId(CurrentSession.getTenantId());
        resource.setUserRealm(CurrentSession.getUserRealm());
        return resource;
    }

    private String getUserNotAuthorizedMsg() {
        return "User " + CurrentSession.getUser() + " is not authorized to ";
    }

    public void put(String path, Resource resource) throws RegistryException {
        ResourceDO oldResourceDO;
        if (this.illegalCharactersPattern.matcher(path).matches()) {
            throw new RegistryException("The path '" + path + "' contains one or more illegal characters (~!@#;%^*()+={}|\\<>\"',)");
        }
        if (".meta".equals(path)) {
            throw new RegistryException(".meta is an illegal name for a resource.");
        }
        this.validateProperties(path, resource);
        String purePath = RegistryUtils.getPureResourcePath(path);
        ResourceIDImpl resourceID = this.resourceDAO.getResourceID(purePath, resource instanceof CollectionImpl);
        boolean resourceExists = false;
        if (resourceID != null && (oldResourceDO = this.resourceDAO.getResourceDO(resourceID)) != null) {
            resourceExists = true;
            this.prepareUpdate(resource, resourceID, oldResourceDO);
            this.update(resourceID, (ResourceImpl)resource, oldResourceDO);
        }
        if (!resourceExists) {
            ResourceDO inverseResourceDO;
            ResourceIDImpl inverseResourceID = this.resourceDAO.getResourceID(purePath, !(resource instanceof CollectionImpl));
            if (inverseResourceID != null && (inverseResourceDO = this.resourceDAO.getResourceDO(inverseResourceID)) != null) {
                this.deleteSubTree(inverseResourceID, inverseResourceDO, false);
            }
            this.add(purePath, (ResourceImpl)resource);
        }
    }

    private void validateProperties(String path, Resource resource) throws RegistryException {
        Properties properties = resource.getProperties();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            if (!this.rejectIfNull(entry.getKey())) continue;
            String errMsg = "The resource at " + path + " contains a property that has a key with NULL.";
            log.warn((Object)errMsg);
            throw new RegistryException(errMsg);
        }
    }

    private boolean rejectIfNull(Object value) {
        return value == null;
    }

    private void prepareUpdate(Resource resource, ResourceIDImpl resourceID, ResourceDO oldResourceDO) throws RegistryException {
        ((ResourceImpl)resource).setPathID(resourceID.getPathID());
        ((ResourceImpl)resource).setName(resourceID.getName());
        ((ResourceImpl)resource).setPath(resourceID.getPath());
        ((ResourceImpl)resource).setCreatedTime(new Date(oldResourceDO.getCreatedOn()));
        ((ResourceImpl)resource).setAuthorUserName(oldResourceDO.getAuthor());
        if (!(resource instanceof Collection) && this.versionOnChange && resource.isVersionableChange()) {
            ResourceImpl oldResourceImpl = new ResourceImpl(resourceID.getPath(), oldResourceDO);
            this.versionRepository.createSnapshot(oldResourceImpl, false, false);
        } else {
            ResourceImpl oldResourceImpl = resourceID.isCollection() ? new CollectionImpl(resourceID.getPath(), oldResourceDO) : new ResourceImpl(resourceID.getPath(), oldResourceDO);
            this.removeResource(oldResourceImpl, false);
        }
    }

    public String importResource(String path, String sourceURL, Resource metaResource) throws RegistryException {
        URL url;
        String purePath = RegistryUtils.getPureResourcePath(path);
        try {
            if (sourceURL == null || sourceURL.toLowerCase().startsWith("file:")) {
                String msg = "The source URL must not be file in the server's local file system";
                throw new RegistryException(msg);
            }
            url = new URL(sourceURL);
        }
        catch (MalformedURLException e) {
            String msg = "Given source URL is not valid.";
            throw new RegistryException(msg, e);
        }
        try {
            URLConnection uc = url.openConnection();
            InputStream in = uc.getInputStream();
            String mediaType = metaResource.getMediaType();
            if (mediaType == null) {
                mediaType = uc.getContentType();
            }
            metaResource.setMediaType(mediaType);
            metaResource.setDescription(metaResource.getDescription());
            metaResource.setContentStream(in);
            this.put(purePath, metaResource);
        }
        catch (IOException e) {
            String msg = "Could not read from the given URL: " + sourceURL;
            throw new RegistryException(msg, e);
        }
        return purePath;
    }

    public void delete(String _path) throws RegistryException {
        String path = _path;
        ResourceIDImpl resourceID = this.resourceDAO.getResourceID(path = RegistryUtils.getPureResourcePath(path));
        ResourceDO resourceDO = this.resourceDAO.getResourceDO(resourceID);
        if (resourceDO == null) {
            boolean isCollection = resourceID.isCollection();
            if (isCollection && (resourceID = this.resourceDAO.getResourceID(path, false)) != null) {
                resourceDO = this.resourceDAO.getResourceDO(resourceID);
            }
            if (resourceDO == null) {
                String msg = "Failed to delete resource " + path + ". Resource does not exist.";
                log.error((Object)msg);
                throw new RegistryException(msg);
            }
        }
        if (!AuthorizationUtils.authorize(path, "http://www.wso2.org/projects/registry/actions/delete")) {
            String msg = this.getUserNotAuthorizedMsg() + "delete the resource " + path + ".";
            log.warn((Object)msg);
            throw new AuthorizationFailedException(msg);
        }
        this.deleteSubTree(resourceID, resourceDO, false);
        this.updateParent(this.resourceDAO.getResourceID(RegistryUtils.getParentPath(path), true));
    }

    public void prepareVersionRestore(String _path) throws RegistryException {
        String path = _path;
        ResourceIDImpl resourceID = this.resourceDAO.getResourceID(path = RegistryUtils.getPureResourcePath(path));
        ResourceDO resourceDO = this.resourceDAO.getResourceDO(resourceID);
        if (resourceDO == null) {
            boolean isCollection = resourceID.isCollection();
            if (isCollection && (resourceID = this.resourceDAO.getResourceID(path, false)) != null) {
                resourceDO = this.resourceDAO.getResourceDO(resourceID);
            }
            if (resourceDO == null) {
                return;
            }
        }
        this.deleteSubTree(resourceID, resourceDO, true);
    }

    public void prepareDumpRestore(String path) throws RegistryException {
        ResourceIDImpl resourceID = this.resourceDAO.getResourceID(path = RegistryUtils.getPureResourcePath(path));
        ResourceDO resourceDO = this.resourceDAO.getResourceDO(resourceID);
        if (resourceDO == null) {
            boolean isCollection = resourceID.isCollection();
            if (isCollection && (resourceID = this.resourceDAO.getResourceID(path, false)) != null) {
                resourceDO = this.resourceDAO.getResourceDO(resourceID);
            }
            if (resourceDO == null) {
                return;
            }
        }
        this.deleteNode(resourceID, resourceDO, true);
    }

    public void deleteSubTree(ResourceIDImpl resourceID, ResourceDO resourceDO, boolean keepAuthorization) throws RegistryException {
        if (resourceID.isCollection()) {
            List<ResourceIDImpl> childIDs = this.resourceDAO.getChildPathIds(resourceID);
            for (ResourceIDImpl childID : childIDs) {
                ResourceDO childResourceDO = this.resourceDAO.getResourceDO(childID);
                if (childResourceDO == null) continue;
                this.recursionRepository.deleteSubTree(childID, childResourceDO, keepAuthorization);
            }
        }
        this.deleteNode(resourceID, resourceDO, keepAuthorization);
    }

    public void deleteNode(ResourceIDImpl resourceID, ResourceDO resourceDO, boolean keepAuthorization) throws RegistryException {
        ResourceImpl resourceImpl = resourceID.isCollection() ? new CollectionImpl(resourceID.getPath(), resourceDO) : new ResourceImpl(resourceID.getPath(), resourceDO);
        if (!(resourceImpl instanceof CollectionImpl) && this.versionOnChange && resourceImpl.isVersionableChange()) {
            this.versionRepository.createSnapshot(resourceImpl, false, true);
            this.associationDAO.removeAllAssociations(resourceImpl.getPath());
        } else {
            Association[] associations;
            boolean isResourcePathVersioned = this.resourceVersionDAO.isResourceHistoryExist(resourceImpl.getResourceIDImpl());
            this.removeResource(resourceImpl, isResourcePathVersioned);
            if (!StaticConfiguration.isVersioningComments() && !isResourcePathVersioned) {
                this.commentsDAO.removeComments(resourceImpl);
            }
            if (!StaticConfiguration.isVersioningTags() && !isResourcePathVersioned) {
                this.tagsDAO.removeTags(resourceImpl);
            }
            if (!StaticConfiguration.isVersioningRatings() && !isResourcePathVersioned) {
                this.ratingsDAO.removeRatings(resourceImpl);
            }
            if ((associations = this.associationDAO.getAllAssociations(resourceImpl.getPath())) != null && associations.length > 0) {
                this.associationDAO.removeAllAssociations(resourceImpl.getPath());
            }
            if (!keepAuthorization && !isResourcePathVersioned) {
                AuthorizationUtils.clearAuthorizations(resourceID.getPath());
            }
        }
    }

    private void removeResource(ResourceImpl resourceImpl, boolean keepProperties) throws RegistryException {
        int contentID;
        this.resourceDAO.deleteResource(resourceImpl.getResourceDO());
        if (!(resourceImpl instanceof CollectionImpl) && (contentID = resourceImpl.getDbBasedContentID()) > 0) {
            this.resourceDAO.deleteContentStream(contentID);
        }
        if (!StaticConfiguration.isVersioningProperties() && !keepProperties) {
            this.resourceDAO.removeProperties(resourceImpl.getResourceDO());
        }
    }

    public String rename(ResourcePath oldResourcePath, String newName) throws RegistryException {
        if (!oldResourcePath.isCurrentVersion()) {
            String msg = "Failed to rename the resource " + oldResourcePath + ". Given path refers to an archived version of the resource.";
            log.error((Object)msg);
            throw new RegistryException(msg);
        }
        String oldPath = RegistryUtils.getPureResourcePath(oldResourcePath.getPath());
        if (!newName.startsWith("/")) {
            String oldDir = oldPath.substring(0, oldPath.lastIndexOf("/") + 1);
            newName = oldDir + newName;
        }
        if (!AuthorizationUtils.authorize(oldPath, "http://www.wso2.org/projects/registry/actions/add") && !AuthorizationUtils.authorize(oldPath, "http://www.wso2.org/projects/registry/actions/delete")) {
            String msg = this.getUserNotAuthorizedMsg() + "rename the resource " + oldResourcePath + ".";
            log.warn((Object)msg);
            throw new AuthorizationFailedException(msg);
        }
        this.move(oldResourcePath, newName);
        return newName;
    }

    public String move(ResourcePath oldResourcePath, String newPath) throws RegistryException {
        ResourceImpl sourceResource;
        if (!oldResourcePath.isCurrentVersion()) {
            String msg = "Failed to copy the resource " + oldResourcePath + ". Given path refers to an archived version of the resource.";
            log.error((Object)msg);
            throw new RegistryException(msg);
        }
        String oldPath = oldResourcePath.getPath();
        if (newPath.equals(oldPath)) {
            return newPath;
        }
        String targetParentPath = RegistryUtils.getParentPath(newPath);
        ResourceIDImpl targetParentResourceID = this.resourceDAO.getResourceID(targetParentPath, true);
        if (targetParentResourceID == null || !this.resourceDAO.resourceExists(targetParentResourceID)) {
            this.addEmptyCollection(targetParentPath);
            if (targetParentResourceID == null) {
                targetParentResourceID = this.resourceDAO.getResourceID(targetParentPath, true);
            }
        } else if (!AuthorizationUtils.authorize(targetParentPath, "http://www.wso2.org/projects/registry/actions/add")) {
            String msg = "Resource Move failed. User " + CurrentSession.getUser() + " is not authorized to update the parent collection of target " + targetParentPath + ".";
            log.warn((Object)msg);
            throw new AuthorizationFailedException(msg);
        }
        if ((sourceResource = (ResourceImpl)this.getMetaData(oldPath)) == null) {
            throw new ResourceNotFoundException(oldPath);
        }
        ResourceIDImpl sourceID = sourceResource.getResourceIDImpl();
        if (!(sourceResource instanceof CollectionImpl)) {
            this.prepareMove(oldPath, newPath);
            ResourceIDImpl targetID = this.resourceDAO.getResourceID(newPath, false);
            if (targetID == null) {
                targetID = this.resourceDAO.createResourceID(newPath, targetParentResourceID, false);
            }
            this.resourceDAO.moveResources(sourceID, targetID);
            this.resourceDAO.moveProperties(sourceID, targetID);
            this.tagsDAO.moveTags(sourceID, targetID);
            this.ratingsDAO.moveRatings(sourceID, targetID);
            this.commentsDAO.moveComments(sourceID, targetID);
            if (!StaticConfiguration.isVersioningAssociations()) {
                this.associationDAO.replaceAssociations(oldPath, newPath);
                this.associationDAO.copyAssociations(oldPath, newPath);
                this.associationDAO.removeAllAssociations(oldPath);
            }
            return newPath;
        }
        this.moveRecursively(sourceID, newPath, targetParentResourceID);
        String sourceParentPath = RegistryUtils.getParentPath(oldPath);
        if (sourceParentPath.equals(targetParentPath)) {
            this.updateParent(targetParentResourceID);
        } else {
            this.updateParent(targetParentResourceID);
            this.updateParent(this.resourceDAO.getResourceID(sourceParentPath, true));
        }
        return newPath;
    }

    public String moveRecursively(ResourceIDImpl sourceID, String targetPath, ResourceIDImpl targetParentResourceID) throws RegistryException {
        String targetChildPath;
        String sourceChildResourceName;
        String sourceChildPath;
        this.prepareMove(sourceID.getPath(), targetPath);
        ResourceIDImpl targetID = this.resourceDAO.getResourceID(targetPath, sourceID.isCollection());
        if (targetID == null) {
            targetID = this.resourceDAO.createResourceID(targetPath, targetParentResourceID, sourceID.isCollection());
        }
        List<ResourceIDImpl> sourceChildIDs = this.resourceDAO.getChildPathIds(sourceID);
        for (ResourceIDImpl sourceChildID : sourceChildIDs) {
            if (sourceChildID.isCollection()) continue;
            sourceChildPath = sourceChildID.getPath();
            sourceChildResourceName = RegistryUtils.getResourceName(sourceChildPath);
            targetChildPath = targetPath + (targetPath.endsWith("/") ? "" : "/") + sourceChildResourceName;
            if (this.recursionRepository.moveRecursively(sourceChildID, targetChildPath, targetID) != null) continue;
            this.prepareMove(sourceChildPath, targetChildPath);
            if (StaticConfiguration.isVersioningAssociations()) continue;
            this.associationDAO.replaceAssociations(sourceChildPath, targetChildPath);
            this.associationDAO.copyAssociations(sourceChildPath, targetChildPath);
            this.associationDAO.removeAllAssociations(sourceChildPath);
        }
        this.resourceDAO.moveResourcePaths(sourceID, targetID);
        this.resourceDAO.movePropertyPaths(sourceID, targetID);
        this.tagsDAO.moveTagPaths(sourceID, targetID);
        this.ratingsDAO.moveRatingPaths(sourceID, targetID);
        this.commentsDAO.moveCommentPaths(sourceID, targetID);
        if (!StaticConfiguration.isVersioningAssociations()) {
            this.associationDAO.replaceAssociations(sourceID.getPath(), targetPath);
            this.associationDAO.copyAssociations(sourceID.getPath(), targetPath);
            this.associationDAO.removeAllAssociations(sourceID.getPath());
        }
        for (ResourceIDImpl sourceChildID : sourceChildIDs) {
            if (!sourceChildID.isCollection()) continue;
            sourceChildPath = sourceChildID.getPath();
            sourceChildResourceName = RegistryUtils.getResourceName(sourceChildPath);
            targetChildPath = targetPath + (targetPath.endsWith("/") ? "" : "/") + sourceChildResourceName;
            this.recursionRepository.moveRecursively(sourceChildID, targetChildPath, targetID);
        }
        return targetPath;
    }

    private void prepareMove(String sourcePath, String targetPath) throws RegistryException {
        if (!AuthorizationUtils.authorize(sourcePath, "http://www.wso2.org/projects/registry/actions/get")) {
            String msg = "Resource Move failed. User " + CurrentSession.getUser() + " is not authorized to read the resource at " + sourcePath + ".";
            log.warn((Object)msg);
            throw new AuthorizationFailedException(msg);
        }
        if (!AuthorizationUtils.authorize(sourcePath, "http://www.wso2.org/projects/registry/actions/delete")) {
            String msg = "Resource Move failed. User " + CurrentSession.getUser() + " is not authorized to delete the resource at " + sourcePath + ".";
            log.warn((Object)msg);
            throw new AuthorizationFailedException(msg);
        }
        ResourceIDImpl targetExistingResourceID = this.resourceDAO.getResourceID(targetPath);
        if (targetExistingResourceID != null) {
            ResourceDO targetExistingResourceDO = this.resourceDAO.getResourceDO(targetExistingResourceID);
            if (targetExistingResourceDO == null && targetExistingResourceID.isCollection() && (targetExistingResourceID = this.resourceDAO.getResourceID(targetPath, false)) != null) {
                targetExistingResourceDO = this.resourceDAO.getResourceDO(targetExistingResourceID);
            }
            if (targetExistingResourceDO != null) {
                if (!AuthorizationUtils.authorize(targetPath, "http://www.wso2.org/projects/registry/actions/add")) {
                    String msg = "Resource Move failed. User " + CurrentSession.getUser() + " is not authorized to update the target path " + targetPath + ".";
                    log.warn((Object)msg);
                    throw new AuthorizationFailedException(msg);
                }
                this.removeIndividual(targetExistingResourceID, targetExistingResourceDO);
            }
        }
        AuthorizationUtils.copyAuthorizations(sourcePath, targetPath);
        if (!this.resourceVersionDAO.isResourceHistoryExist(sourcePath)) {
            AuthorizationUtils.clearAuthorizations(sourcePath);
        }
    }

    private void removeIndividual(ResourceIDImpl resourceID, ResourceDO resourceDO) throws RegistryException {
        ResourceImpl resource = resourceID.isCollection() ? new CollectionImpl(resourceID.getPath(), resourceDO) : new ResourceImpl(resourceID.getPath(), resourceDO);
        if (!(resource instanceof Collection) && this.versionOnChange && resource.isVersionableChange()) {
            this.versionRepository.createSnapshot(resource, false, false);
        } else {
            this.removeResource(resource, false);
        }
    }

    public String copy(ResourcePath sourceResourcePath, ResourcePath targetResourcePath) throws RegistryException {
        if (!sourceResourcePath.isCurrentVersion() || !targetResourcePath.isCurrentVersion()) {
            String msg = "Failed to copy the resource " + sourceResourcePath + " to path " + targetResourcePath + ". Both paths should refer to current versions.";
            log.error((Object)msg);
            throw new RegistryException(msg);
        }
        String sourcePath = sourceResourcePath.getPath();
        String targetPath = targetResourcePath.getPath();
        if ((sourcePath = RegistryUtils.getPureResourcePath(sourcePath)).equals(targetPath = RegistryUtils.getPureResourcePath(targetPath))) {
            return targetPath;
        }
        if (sourcePath.indexOf(targetPath) == 0) {
            String msg = "Failed to copy the resource " + sourceResourcePath + " to path " + targetResourcePath + ". The target path is a part of the source path.";
            log.error((Object)msg);
            throw new RegistryException(msg);
        }
        ResourceImpl sourceResource = (ResourceImpl)this.get(sourcePath);
        if (sourceResource instanceof CollectionImpl) {
            this.resourceDAO.fillChildren((CollectionImpl)sourceResource, 0, -1);
        }
        if (this.resourceDAO.resourceExists(targetPath)) {
            this.delete(targetPath);
        }
        ResourceImpl targetResource = sourceResource.getShallowCopy();
        this.setUUIDForResource(targetResource);
        this.put(targetPath, targetResource);
        if (sourceResource instanceof CollectionImpl) {
            CollectionImpl collection = (CollectionImpl)sourceResource;
            for (String childSourcePath : collection.getChildren()) {
                String childResourceName = RegistryUtils.getResourceName(childSourcePath);
                String childTargetPath = targetPath + "/" + childResourceName;
                ResourcePath childSourceResourcePath = new ResourcePath(childSourcePath);
                ResourcePath childTargetResourcePath = new ResourcePath(childTargetPath);
                this.recursionRepository.copy(childSourceResourcePath, childTargetResourcePath);
            }
        }
        this.commentsDAO.copyComments(sourceResource, targetResource);
        this.tagsDAO.copyTags(sourceResource, targetResource);
        this.ratingsDAO.copyRatings(sourceResource, targetResource);
        this.associationDAO.copyAssociations(sourceResource.getPath(), targetResource.getPath());
        return targetPath;
    }

    private void add(String path, ResourceImpl resource) throws RegistryException {
        String temp;
        String parentPath = RegistryUtils.getParentPath(path);
        ResourceIDImpl parentResourceID = this.resourceDAO.getResourceID(parentPath, true);
        if (parentResourceID == null || !this.resourceDAO.resourceExists(parentResourceID)) {
            this.addEmptyCollection(parentPath);
            if (parentResourceID == null) {
                parentResourceID = this.resourceDAO.getResourceID(parentPath, true);
            }
        } else if (!AuthorizationUtils.authorize(parentPath, "http://www.wso2.org/projects/registry/actions/add")) {
            String msg = "Failed to add new resource " + path + ". User " + CurrentSession.getUser() + " is not authorized to update the parent collection " + parentPath + ".";
            log.warn((Object)msg);
            throw new AuthorizationFailedException(msg);
        }
        if (!AuthorizationUtils.authorize(path, "http://www.wso2.org/projects/registry/actions/add")) {
            String msg = "Failed to add new resource " + path + ". User " + CurrentSession.getUser() + " is not authorized to update the resource path " + path + ".";
            log.warn((Object)msg);
            throw new AuthorizationFailedException(msg);
        }
        RegistryContext registryContext = null;
        if (CurrentSession.getUserRegistry() != null) {
            registryContext = CurrentSession.getUserRegistry().getRegistryContext();
        }
        if (registryContext == null) {
            registryContext = RegistryContext.getBaseInstance();
        }
        if (!Boolean.FALSE.equals(CurrentSession.getAttribute(IS_LOGGING_ACTIVITY))) {
            registryContext.getLogWriter().addLog(path, CurrentSession.getUser(), 0, null);
        }
        if (!(resource instanceof CollectionImpl || resource.getMediaType() != null && resource.getMediaType().length() != 0 || (temp = MediaTypesUtils.getMediaType(RegistryUtils.getResourceName(path))) == null)) {
            resource.setMediaType(temp);
        }
        if (resource.getUUID() == null) {
            this.setUUIDForResource(resource);
        }
        this.resourceDAO.add(path, parentResourceID, resource);
        this.updateParent(parentResourceID);
    }

    private void updateParent(ResourceIDImpl parentResourceID) throws RegistryException {
    }

    private void update(ResourceIDImpl resourceID, ResourceImpl resource, ResourceDO oldResourceDO) throws RegistryException {
        String temp;
        if (!AuthorizationUtils.authorize(resourceID.getPath(), "http://www.wso2.org/projects/registry/actions/add")) {
            String msg = "Resource update failed. User " + CurrentSession.getUser() + " is not authorized to update the resource " + resourceID.getPath() + ".";
            log.warn((Object)msg);
            throw new AuthorizationFailedException(msg);
        }
        RegistryContext registryContext = null;
        if (CurrentSession.getUserRegistry() != null) {
            registryContext = CurrentSession.getUserRegistry().getRegistryContext();
        }
        if (registryContext == null) {
            registryContext = RegistryContext.getBaseInstance();
        }
        if (!Boolean.FALSE.equals(CurrentSession.getAttribute(IS_LOGGING_ACTIVITY))) {
            registryContext.getLogWriter().addLog(resourceID.getPath(), CurrentSession.getUser(), 1, null);
        }
        if (!(resource instanceof CollectionImpl || resource.getMediaType() != null && resource.getMediaType().length() != 0 || (temp = MediaTypesUtils.getMediaType(RegistryUtils.getResourceName(resourceID.getPath()))) == null)) {
            resource.setMediaType(temp);
        }
        if (resource.getUUID() == null) {
            this.setUUIDForResource(resource);
        }
        this.resourceDAO.update(resource);
        ResourceImpl oldResourceImpl = oldResourceDO.getName() == null ? new CollectionImpl(resourceID.getPath(), oldResourceDO) : new ResourceImpl(resourceID.getPath(), oldResourceDO);
        this.commentsDAO.copyComments(oldResourceImpl, resource);
        this.tagsDAO.copyTags(oldResourceImpl, resource);
        this.ratingsDAO.copyRatings(oldResourceImpl, resource);
    }

    private void setUUIDForResource(ResourceImpl resource) {
        resource.setUUID(UUID.randomUUID().toString());
    }

    private void addEmptyCollection(String path) throws RegistryException {
        ResourceIDImpl assumedResourceID = this.resourceDAO.getResourceID(path, false);
        if (assumedResourceID != null && this.resourceDAO.resourceExists(assumedResourceID)) {
            String msg = "Failed to add new Collection " + path + "There already exist non collection resource.";
            log.error((Object)msg);
            throw new RegistryException(msg);
        }
        String parentPath = RegistryUtils.getParentPath(path);
        ResourceIDImpl parentResourceID = null;
        if (parentPath != null) {
            parentResourceID = this.resourceDAO.getResourceID(parentPath, true);
            if (parentResourceID == null || !this.resourceDAO.resourceExists(parentResourceID)) {
                this.addEmptyCollection(parentPath);
                if (parentResourceID == null) {
                    parentResourceID = this.resourceDAO.getResourceID(parentPath, true);
                }
            } else if (!AuthorizationUtils.authorize(parentPath, "http://www.wso2.org/projects/registry/actions/add")) {
                String msg = "Failed to add new resource. User " + CurrentSession.getUser() + " does not have authorization to update the collection " + parentPath + ".";
                log.error((Object)msg);
                throw new RegistryException(msg);
            }
        } else if (!path.equals("/")) {
            return;
        }
        if (!AuthorizationUtils.authorize(path, "http://www.wso2.org/projects/registry/actions/add")) {
            String msg = "Failed to add new resource. User " + CurrentSession.getUser() + " does not have authorization to add the collection at" + path + ".";
            log.error((Object)msg);
            throw new RegistryException(msg);
        }
        CollectionImpl collection = new CollectionImpl();
        RegistryContext registryContext = null;
        if (CurrentSession.getUserRegistry() != null) {
            registryContext = CurrentSession.getUserRegistry().getRegistryContext();
        }
        if (registryContext == null) {
            registryContext = RegistryContext.getBaseInstance();
        }
        if (!Boolean.FALSE.equals(CurrentSession.getAttribute(IS_LOGGING_ACTIVITY))) {
            registryContext.getLogWriter().addLog(path, CurrentSession.getUser(), 0, null);
        }
        if (collection.getUUID() == null) {
            this.setUUIDForResource(collection);
        }
        this.resourceDAO.add(path, parentResourceID, collection);
    }

    public void restore(String _path, Reader reader) throws RegistryException {
        XMLStreamReader xmlReader;
        ResourceImpl currentResource;
        String path = _path;
        boolean rootResourceExists = this.resourceExists(path);
        long currentVersion = -1L;
        if (rootResourceExists && !((currentResource = this.resourceDAO.getResourceMetaData(path)) instanceof Collection)) {
            currentVersion = currentResource.getVersionNumber();
        }
        if (!path.equals("/") && path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if (path.equals("/")) {
            if (!AuthorizationUtils.authorize(path, "http://www.wso2.org/projects/registry/actions/add")) {
                String msg = this.getUserNotAuthorizedMsg() + "check in to the path " + path + ".";
                log.warn((Object)msg);
                throw new AuthorizationFailedException(msg);
            }
        } else {
            String parentPath = RegistryUtils.getParentPath(path);
            ResourceImpl parentResource = this.resourceDAO.getResourceMetaData(parentPath);
            if (parentResource == null) {
                this.addEmptyCollection(parentPath);
            } else {
                if (!(parentResource instanceof CollectionImpl)) {
                    String msg = "Cannot restore into a non-collection at " + parentPath + ".";
                    log.error((Object)msg);
                    throw new RegistryException(msg);
                }
                if (!rootResourceExists && !AuthorizationUtils.authorize(parentPath, "http://www.wso2.org/projects/registry/actions/add")) {
                    String msg = this.getUserNotAuthorizedMsg() + "check in to the parent path " + parentPath + ".";
                    log.warn((Object)msg);
                    throw new AuthorizationFailedException(msg);
                }
            }
        }
        DumpReader dumpReader = new DumpReader(reader){

            @Override
            public void close() throws IOException {
            }
        };
        try {
            xmlReader = XMLInputFactory.newInstance().createXMLStreamReader(dumpReader);
        }
        catch (Exception e) {
            String msg = "Error in creating the xml reader.";
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, e);
        }
        try {
            this.restoreRecursively(path, xmlReader, dumpReader, currentVersion, rootResourceExists);
        }
        catch (XMLStreamException e) {
            String msg = "Failed to serialize the dumped element at " + path + ".";
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void dump(String _path, Writer writer) throws RegistryException {
        String path = _path;
        if (!path.equals("/") && path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        XMLStreamWriter xmlWriter = null;
        try {
            XMLOutputFactory xof = XMLOutputFactory.newInstance();
            xmlWriter = xof.createXMLStreamWriter(writer);
            this.dumpRecursively(path, xmlWriter, writer);
        }
        catch (XMLStreamException e) {
            String msg = "Failed to serialize the dumped element at " + path + ".";
            log.error((Object)msg);
            throw new RegistryException(msg, e);
        }
        finally {
            if (xmlWriter != null) {
                try {
                    xmlWriter.close();
                }
                catch (XMLStreamException xMLStreamException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreRecursively(String path, XMLStreamReader xmlReader, DumpReader dumpReader, long currentVersion, boolean resourceExists) throws RegistryException, XMLStreamException {
        String[] parts;
        String linkRestoration;
        if (!AuthorizationUtils.authorize(path, "http://www.wso2.org/projects/registry/actions/add")) {
            String msg = "Failed to check-in resource " + path + ". User " + CurrentSession.getUser() + " is not authorized to update the current collection path " + path + ".";
            log.warn((Object)msg);
            throw new AuthorizationFailedException(msg);
        }
        while (!xmlReader.isStartElement() && xmlReader.hasNext()) {
            xmlReader.next();
        }
        if (!xmlReader.hasNext()) {
            return;
        }
        if (!xmlReader.getLocalName().equals("resource")) {
            String msg = "Invalid dump to restore at " + path;
            log.error((Object)msg);
            throw new RegistryException(msg);
        }
        String incomingParentPath = xmlReader.getAttributeValue(null, "path");
        String resourceName = xmlReader.getAttributeValue(null, "name");
        String ignoreConflictsStrValue = xmlReader.getAttributeValue(null, "ignoreConflicts");
        boolean ignoreConflicts = true;
        if (ignoreConflictsStrValue != null && Boolean.toString(false).equals(ignoreConflictsStrValue)) {
            ignoreConflicts = false;
        }
        String isCollectionString = xmlReader.getAttributeValue(null, "isCollection");
        boolean isCollection = isCollectionString.equals("true");
        if (path.equals("/") && !isCollection) {
            String msg = "Illegal to restore a non-collection in place of root collection.";
            log.error((Object)msg);
            throw new RegistryException(msg);
        }
        String status = xmlReader.getAttributeValue(null, "status");
        if ("deleted".equals(status) && resourceExists) {
            this.delete(path);
            return;
        }
        byte[] contentBytes = new byte[]{};
        ResourceImpl resourceImpl = isCollection ? new CollectionImpl() : new ResourceImpl();
        ArrayList<CommentDO> commentDOList = new ArrayList<CommentDO>();
        ArrayList<TaggingDO> taggingDOList = new ArrayList<TaggingDO>();
        ArrayList<RatingDO> ratingDOList = new ArrayList<RatingDO>();
        ArrayList<Association> associationList = new ArrayList<Association>();
        boolean isCreatorExisting = false;
        boolean isCreatedTimeExisting = false;
        boolean isUpdaterExisting = false;
        boolean isUpdatedTimeExisting = false;
        long dumpingResourceVersion = -1L;
        do {
            xmlReader.next();
        } while (!xmlReader.isStartElement() && xmlReader.hasNext());
        while (xmlReader.hasNext()) {
            long date;
            String text;
            String localName = xmlReader.getLocalName();
            if (localName.equals("mediaType")) {
                text = xmlReader.getElementText();
                if (text.indexOf(47) < 0) {
                    text = MediaTypesUtils.getMediaType("dummy." + text);
                }
                if (text != null) {
                    resourceImpl.setMediaType(text);
                }
                do {
                    xmlReader.next();
                } while (!xmlReader.isStartElement() && xmlReader.hasNext());
                continue;
            }
            if (localName.equals("creator")) {
                text = xmlReader.getElementText();
                if (text != null) {
                    resourceImpl.setAuthorUserName(text);
                    isCreatorExisting = true;
                }
                do {
                    xmlReader.next();
                } while (!xmlReader.isStartElement() && xmlReader.hasNext());
                continue;
            }
            if (localName.equals("version")) {
                text = xmlReader.getElementText();
                if (text != null) {
                    dumpingResourceVersion = Long.parseLong(text);
                }
                do {
                    xmlReader.next();
                } while (!xmlReader.isStartElement() && xmlReader.hasNext());
                continue;
            }
            if (localName.equals("uuid")) {
                text = xmlReader.getElementText();
                if (text != null) {
                    resourceImpl.setUUID(text);
                }
                do {
                    xmlReader.next();
                } while (!xmlReader.isStartElement() && xmlReader.hasNext());
                continue;
            }
            if (localName.equals("createdTime")) {
                text = xmlReader.getElementText();
                if (text != null) {
                    date = Long.parseLong(text);
                    resourceImpl.setCreatedTime(new Date(date));
                    isCreatedTimeExisting = true;
                }
                do {
                    xmlReader.next();
                } while (!xmlReader.isStartElement() && xmlReader.hasNext());
                continue;
            }
            if (localName.equals("lastUpdater")) {
                text = xmlReader.getElementText();
                if (text != null) {
                    resourceImpl.setLastUpdaterUserName(text);
                    isUpdaterExisting = true;
                }
                do {
                    xmlReader.next();
                } while (!xmlReader.isStartElement() && xmlReader.hasNext());
                continue;
            }
            if (localName.equals("lastModified")) {
                text = xmlReader.getElementText();
                if (text != null) {
                    date = Long.parseLong(text);
                    resourceImpl.setLastModified(new Date(date));
                    isUpdatedTimeExisting = true;
                }
                do {
                    xmlReader.next();
                } while (!xmlReader.isStartElement() && xmlReader.hasNext());
                continue;
            }
            if (localName.equals("description")) {
                text = xmlReader.getElementText();
                if (text != null) {
                    resourceImpl.setDescription(text);
                }
                do {
                    xmlReader.next();
                } while (!xmlReader.isStartElement() && xmlReader.hasNext());
                continue;
            }
            if (localName.equals("properties")) {
                do {
                    xmlReader.next();
                } while (!xmlReader.isStartElement() && xmlReader.hasNext());
                while (xmlReader.hasNext() && xmlReader.getLocalName().equals("property")) {
                    String key = xmlReader.getAttributeValue(null, "key");
                    String text2 = xmlReader.getElementText();
                    if (text2.equals("")) {
                        text2 = null;
                    }
                    if (text2 != null) {
                        resourceImpl.addPropertyWithNoUpdate(key, text2);
                    }
                    do {
                        xmlReader.next();
                    } while (!xmlReader.isStartElement() && xmlReader.hasNext());
                }
                continue;
            }
            if (localName.equals("content")) {
                text = xmlReader.getElementText();
                if (text != null) {
                    contentBytes = Base64.decode((String)text);
                }
                do {
                    xmlReader.next();
                } while (!xmlReader.isStartElement() && xmlReader.hasNext() && (!xmlReader.isEndElement() || !xmlReader.getLocalName().equals("resource")));
                continue;
            }
            if (localName.equals("comments")) {
                do {
                    xmlReader.next();
                } while (!xmlReader.isStartElement() && xmlReader.hasNext());
                while (xmlReader.hasNext() && xmlReader.getLocalName().equals("comment")) {
                    CommentDO commentDO = new CommentDO();
                    do {
                        xmlReader.next();
                    } while (!xmlReader.isStartElement() && xmlReader.hasNext());
                    localName = xmlReader.getLocalName();
                    while (xmlReader.hasNext() && (localName.equals("user") || localName.equals("text"))) {
                        String text3;
                        if (localName.equals("user")) {
                            text3 = xmlReader.getElementText();
                            if (text3 != null) {
                                commentDO.setCommentedUser(text3);
                            }
                        } else if (localName.equals("text") && (text3 = xmlReader.getElementText()) != null) {
                            commentDO.setCommentText(text3);
                        }
                        do {
                            xmlReader.next();
                        } while (!xmlReader.isStartElement() && xmlReader.hasNext());
                        if (!xmlReader.hasNext()) continue;
                        localName = xmlReader.getLocalName();
                    }
                    commentDOList.add(commentDO);
                }
                continue;
            }
            if (localName.equals("taggings")) {
                do {
                    xmlReader.next();
                } while (!xmlReader.isStartElement() && xmlReader.hasNext());
                while (xmlReader.hasNext() && xmlReader.getLocalName().equals("tagging")) {
                    TaggingDO taggingDO = new TaggingDO();
                    do {
                        xmlReader.next();
                    } while (!xmlReader.isStartElement() && xmlReader.hasNext());
                    localName = xmlReader.getLocalName();
                    while (xmlReader.hasNext() && (localName.equals("user") || localName.equals("date") || localName.equals("tagName"))) {
                        String text4;
                        if (localName.equals("user")) {
                            text4 = xmlReader.getElementText();
                            if (text4 != null) {
                                taggingDO.setTaggedUserName(text4);
                            }
                        } else if (localName.equals("date")) {
                            text4 = xmlReader.getElementText();
                            if (text4 != null) {
                                long date2 = Long.parseLong(text4);
                                taggingDO.setTaggedTime(new Date(date2));
                            }
                        } else if (localName.equals("tagName") && (text4 = xmlReader.getElementText()) != null) {
                            taggingDO.setTagName(text4);
                        }
                        do {
                            xmlReader.next();
                        } while (!xmlReader.isStartElement() && xmlReader.hasNext());
                        if (!xmlReader.hasNext()) continue;
                        localName = xmlReader.getLocalName();
                    }
                    taggingDOList.add(taggingDO);
                }
                continue;
            }
            if (localName.equals("ratings")) {
                do {
                    xmlReader.next();
                } while (!xmlReader.isStartElement() && xmlReader.hasNext());
                while (xmlReader.hasNext() && xmlReader.getLocalName().equals("rating")) {
                    RatingDO ratingDO = new RatingDO();
                    do {
                        xmlReader.next();
                    } while (!xmlReader.isStartElement() && xmlReader.hasNext());
                    localName = xmlReader.getLocalName();
                    while (xmlReader.hasNext() && (localName.equals("user") || localName.equals("date") || localName.equals("rate"))) {
                        String text5;
                        if (localName.equals("user")) {
                            text5 = xmlReader.getElementText();
                            if (text5 != null) {
                                ratingDO.setRatedUserName(text5);
                            }
                        } else if (localName.equals("date")) {
                            text5 = xmlReader.getElementText();
                            if (text5 != null) {
                                long date3 = Long.parseLong(text5);
                                ratingDO.setRatedTime(new Date(date3));
                            }
                        } else if (localName.equals("rate") && (text5 = xmlReader.getElementText()) != null) {
                            int ratingValue = Integer.parseInt(text5);
                            ratingDO.setRating(ratingValue);
                        }
                        do {
                            xmlReader.next();
                        } while (!xmlReader.isStartElement() && xmlReader.hasNext());
                        if (!xmlReader.hasNext()) continue;
                        localName = xmlReader.getLocalName();
                    }
                    ratingDOList.add(ratingDO);
                }
                continue;
            }
            if (localName.equals("associations")) {
                do {
                    xmlReader.next();
                } while (!xmlReader.isStartElement() && xmlReader.hasNext());
                while (xmlReader.hasNext() && xmlReader.getLocalName().equals("association")) {
                    String source = null;
                    String destination = null;
                    String type = null;
                    do {
                        xmlReader.next();
                    } while (!xmlReader.isStartElement() && xmlReader.hasNext());
                    localName = xmlReader.getLocalName();
                    while (xmlReader.hasNext() && (localName.equals("source") || localName.equals("destination") || localName.equals("type"))) {
                        String text6;
                        if (localName.equals("source")) {
                            text6 = xmlReader.getElementText();
                            if (text6 != null) {
                                source = text6;
                            }
                        } else if (localName.equals("destination")) {
                            text6 = xmlReader.getElementText();
                            if (text6 != null) {
                                destination = text6;
                            }
                        } else if (localName.equals("type") && (text6 = xmlReader.getElementText()) != null) {
                            type = text6;
                        }
                        do {
                            xmlReader.next();
                        } while (!xmlReader.isStartElement() && xmlReader.hasNext());
                        if (!xmlReader.hasNext()) continue;
                        localName = xmlReader.getLocalName();
                    }
                    source = RegistryUtils.getAbsoluteAssociationPath(source, path);
                    destination = destination != null && destination.startsWith(":") ? destination.substring(":".length()) : RegistryUtils.getAbsoluteAssociationPath(destination, path);
                    associationList.add(new Association(source, destination, type));
                }
                continue;
            }
            if (localName.equals("children") || localName.equals("childs") || localName.equals("resource")) break;
            do {
                xmlReader.next();
            } while (!xmlReader.isStartElement() && xmlReader.hasNext());
        }
        if (!ignoreConflicts && dumpingResourceVersion > 0L) {
            String msg;
            if (currentVersion == -1L) {
                msg = "Resource is deleted in the server, resource path: " + path + ".";
                log.error((Object)msg);
                throw new RegistryException(msg);
            }
            if (currentVersion > dumpingResourceVersion) {
                msg = "Resource is in a newer version than the restoring version. resource path: " + path + ".";
                log.error((Object)msg);
                throw new RegistryException(msg);
            }
        }
        if (!isCreatorExisting) {
            String creator = CurrentSession.getUser();
            resourceImpl.setAuthorUserName(creator);
        }
        if (!isCreatedTimeExisting) {
            long now = System.currentTimeMillis();
            resourceImpl.setCreatedTime(new Date(now));
        }
        if (!isUpdaterExisting) {
            String updater = CurrentSession.getUser();
            resourceImpl.setLastUpdaterUserName(updater);
        }
        if (!isUpdatedTimeExisting) {
            long now = System.currentTimeMillis();
            resourceImpl.setLastModified(new Date(now));
        }
        if (resourceImpl.getUUID() == null) {
            this.setUUIDForResource(resourceImpl);
        }
        if ((linkRestoration = resourceImpl.getProperty("registry.linkrestoration")) != null) {
            parts = linkRestoration.split(";");
            if (parts.length == 4) {
                if (parts[2] != null && parts[2].length() == 0) {
                    parts[2] = null;
                }
                if (parts[0] != null && parts[1] != null && parts[3] != null) {
                    RegistryUtils.registerHandlerForRemoteLinks(RegistryContext.getBaseInstance(), parts[0], parts[1], parts[2], parts[3]);
                }
            } else if (parts.length == 3 && parts[0] != null && parts[1] != null) {
                String relativeTargetPath = RegistryUtils.getRelativeAssociationPath(parts[1], parts[0]);
                String absoluteTargetPath = RegistryUtils.getAbsoluteAssociationPath(relativeTargetPath, path);
                RegistryUtils.registerHandlerForSymbolicLinks(RegistryContext.getBaseInstance(), path, absoluteTargetPath, parts[2]);
            }
        }
        parts = this;
        synchronized (this) {
            ResourceIDImpl resourceID = null;
            String[] resourceDO = null;
            if (this.resourceDAO.resourceExists(path) && (resourceDO = this.resourceDAO.getResourceDO(resourceID = this.resourceDAO.getResourceID(path))) == null) {
                if (isCollection && (resourceID = this.resourceDAO.getResourceID(path, isCollection)) != null) {
                    resourceDO = this.resourceDAO.getResourceDO(resourceID);
                }
                if (resourceDO == null) {
                    // ** MonitorExit[parts] (shouldn't be in output)
                    return;
                }
            }
            if ("updated".equals(status) || "added".equals(status) || "dump".equals(status)) {
                if (this.resourceDAO.resourceExists(path)) {
                    if ("dump".equals(status)) {
                        this.delete(path);
                    } else {
                        this.deleteNode(resourceID, (ResourceDO)resourceDO, true);
                    }
                }
                if (resourceID == null) {
                    String parentPath = RegistryUtils.getParentPath(path);
                    ResourceIDImpl parentResourceID = this.resourceDAO.getResourceID(parentPath, true);
                    if (parentResourceID == null || !this.resourceDAO.resourceExists(parentResourceID)) {
                        super.addEmptyCollection(parentPath);
                        if (parentResourceID == null) {
                            parentResourceID = this.resourceDAO.getResourceID(parentPath, true);
                        }
                    }
                    this.resourceDAO.createAndApplyResourceID(path, parentResourceID, resourceImpl);
                } else {
                    resourceImpl.setPathID(resourceID.getPathID());
                    resourceImpl.setPath(path);
                    resourceImpl.setName(resourceID.getName());
                }
                if (!isCollection) {
                    int contentId = 0;
                    if (contentBytes.length > 0) {
                        contentId = this.resourceDAO.addContentBytes(new ByteArrayInputStream(contentBytes));
                    }
                    resourceImpl.setDbBasedContentID(contentId);
                }
                resourceDO = resourceImpl.getResourceDO();
                this.resourceDAO.addResourceDO((ResourceDO)resourceDO);
                resourceImpl.setVersionNumber(resourceDO.getVersion());
                this.resourceDAO.addProperties(resourceImpl);
                this.commentsDAO.addComments(resourceImpl, commentDOList.toArray(new CommentDO[commentDOList.size()]));
                this.tagsDAO.addTaggings(resourceImpl, taggingDOList.toArray(new TaggingDO[taggingDOList.size()]));
                this.ratingsDAO.addRatings(resourceImpl, ratingDOList.toArray(new RatingDO[ratingDOList.size()]));
                for (Association association : associationList) {
                    this.associationDAO.addAssociation(association.getSourcePath(), association.getDestinationPath(), association.getAssociationType());
                }
            }
            // ** MonitorExit[parts] (shouldn't be in output)
            if (!xmlReader.hasNext() || !xmlReader.getLocalName().equals("children") && !xmlReader.getLocalName().equals("childs")) {
                return;
            }
            do {
                Resource resource;
                xmlReader.next();
                if (!xmlReader.isEndElement() || !xmlReader.getLocalName().equals("children") && !xmlReader.getLocalName().equals("childs")) continue;
                if (xmlReader.hasNext()) {
                    do {
                        xmlReader.next();
                    } while (!xmlReader.isStartElement() && xmlReader.hasNext() && (!xmlReader.isEndElement() || !xmlReader.getLocalName().equals("resource")));
                }
                if ((resource = this.get(path)) instanceof Collection) {
                    String[] existingChildren;
                    for (String existingChild : existingChildren = ((Collection)resource).getChildren()) {
                        this.delete(existingChild);
                    }
                }
                return;
            } while (!xmlReader.isStartElement() && xmlReader.hasNext());
            int i = 0;
            if (xmlReader.hasNext() && xmlReader.getLocalName().equals("resource")) {
                String[] existingChildren;
                HashSet<String> childPathSet = new HashSet<String>();
                while (true) {
                    String absoluteChildPath;
                    if (i != 0) {
                        dumpReader.setReadingChildResourceIndex(i);
                        xmlReader = XMLInputFactory.newInstance().createXMLStreamReader(dumpReader);
                        while (!xmlReader.isStartElement() && xmlReader.hasNext()) {
                            xmlReader.next();
                        }
                    }
                    if (incomingParentPath != null) {
                        String incomingChildPath = xmlReader.getAttributeValue(null, "path");
                        String relativeChildPath = incomingParentPath.equals("/") ? incomingChildPath : (incomingParentPath.contains(incomingChildPath) ? incomingChildPath.substring(incomingParentPath.length()) : null);
                        if (relativeChildPath != null) {
                            absoluteChildPath = path.equals("/") ? relativeChildPath : path + relativeChildPath;
                        } else {
                            String checkoutRoot = path.substring(0, path.length() - incomingParentPath.length());
                            absoluteChildPath = checkoutRoot + incomingChildPath;
                        }
                    } else if (resourceName != null) {
                        String childName = xmlReader.getAttributeValue(null, "name");
                        absoluteChildPath = path + (path.equals("/") ? "" : "/") + childName;
                    } else {
                        String msg = "Error in deriving the child paths for collection. path: " + path + ".";
                        log.error((Object)msg);
                        throw new RegistryException(msg);
                    }
                    dumpReader.setCheckingChildByParent(false);
                    dumpReader.setReadingChildResourceIndex(i);
                    this.recursionRepository.restoreRecursively(absoluteChildPath, dumpReader);
                    childPathSet.add(absoluteChildPath);
                    dumpReader.setCheckingChildByParent(true);
                    try {
                        if (dumpReader.isLastResource(i)) {
                            dumpReader.setCheckingChildByParent(false);
                            break;
                        }
                    }
                    catch (IOException e) {
                        String msg = "Error in checking the last resource exists.";
                        log.error((Object)msg, (Throwable)e);
                        throw new RegistryException(msg + e.getMessage(), e);
                    }
                    ++i;
                }
                Collection parent = (Collection)this.get(path);
                for (String existingChild : existingChildren = parent.getChildren()) {
                    if (childPathSet.contains(existingChild)) continue;
                    this.delete(existingChild);
                }
            }
            return;
        }
    }

    private void dumpRecursively(String path, XMLStreamWriter xmlWriter, Writer writer) throws RegistryException, XMLStreamException {
        Association[] associations;
        RatingDO[] ratings;
        TaggingDO[] taggings;
        Comment[] comments;
        ResourceImpl resource = this.resourceDAO.getResourceMetaData(path);
        if (resource == null) {
            return;
        }
        if (!AuthorizationUtils.authorize(path, "http://www.wso2.org/projects/registry/actions/get")) {
            String msg = this.getUserNotAuthorizedMsg() + "check out the path " + path + ".";
            log.warn((Object)msg);
            throw new AuthorizationFailedException(msg);
        }
        xmlWriter.writeStartElement("resource");
        xmlWriter.writeAttribute("name", RegistryUtils.getResourceName(path));
        xmlWriter.writeAttribute("status", "dump");
        xmlWriter.writeAttribute("isCollection", resource instanceof CollectionImpl ? "true" : "false");
        String mediaType = resource.getMediaType();
        OMFactory factory = OMAbstractFactory.getOMFactory();
        OMElement child = factory.createOMElement(new QName("mediaType"));
        child.setText(mediaType);
        child.serialize(xmlWriter);
        long version = resource.getVersionNumber();
        child = factory.createOMElement(new QName("version"));
        child.setText(version + "");
        child.serialize(xmlWriter);
        String creator = resource.getAuthorUserName();
        child = factory.createOMElement(new QName("creator"));
        child.setText(creator);
        child.serialize(xmlWriter);
        Date createdTime = resource.getCreatedTime();
        child = factory.createOMElement(new QName("createdTime"));
        child.setText(Long.toString(createdTime.getTime()));
        child.serialize(xmlWriter);
        String updater = resource.getLastUpdaterUserName();
        child = factory.createOMElement(new QName("lastUpdater"));
        child.setText(updater);
        child.serialize(xmlWriter);
        Date lastModified = resource.getLastModified();
        child = factory.createOMElement(new QName("lastModified"));
        child.setText(Long.toString(lastModified.getTime()));
        child.serialize(xmlWriter);
        String uuid = resource.getUUID();
        child = factory.createOMElement(new QName("uuid"));
        child.setText(uuid);
        child.serialize(xmlWriter);
        String description = resource.getDescription();
        child = factory.createOMElement(new QName("description"));
        child.setText(description);
        child.serialize(xmlWriter);
        this.resourceDAO.fillResourceProperties(resource);
        Properties properties = resource.getProperties();
        if (properties != null && properties.size() > 0) {
            OMElement propertiesOM = factory.createOMElement(new QName("properties"));
            for (Object keyObject : properties.keySet()) {
                String key = (String)keyObject;
                List<String> propValues = resource.getPropertyValues(key);
                for (String value : propValues) {
                    OMElement propertyOM = factory.createOMElement(new QName("property"));
                    OMAttribute keyAttribute = factory.createOMAttribute("key", null, key);
                    propertyOM.addAttribute(keyAttribute);
                    if (value != null) {
                        propertyOM.setText(value);
                    }
                    propertiesOM.addChild((OMNode)propertyOM);
                }
            }
            propertiesOM.serialize(xmlWriter);
        }
        if ((comments = this.commentsDAO.getComments(resource)) != null && comments.length > 0) {
            child = factory.createOMElement(new QName("comments"));
            for (Comment comment : comments) {
                OMElement commentElement = factory.createOMElement(new QName("comment"));
                String user = comment.getAuthorUserName();
                String text = comment.getText();
                OMElement userElement = factory.createOMElement(new QName("user"));
                userElement.setText(user);
                commentElement.addChild((OMNode)userElement);
                OMElement textElement = factory.createOMElement(new QName("text"));
                textElement.setText(text);
                commentElement.addChild((OMNode)textElement);
                child.addChild((OMNode)commentElement);
            }
            child.serialize(xmlWriter);
        }
        if ((taggings = this.tagsDAO.getTagging(resource)) != null && taggings.length > 0) {
            child = factory.createOMElement(new QName("taggings"));
            for (TaggingDO tagging : taggings) {
                OMElement taggingElement = factory.createOMElement(new QName("tagging"));
                String user = tagging.getTaggedUserName();
                Date date = tagging.getTaggedTime();
                String tagName = tagging.getTagName();
                OMElement userElement = factory.createOMElement(new QName("user"));
                userElement.setText(user);
                taggingElement.addChild((OMNode)userElement);
                OMElement dateElement = factory.createOMElement(new QName("date"));
                String dateString = Long.toString(date.getTime());
                dateElement.setText(dateString);
                taggingElement.addChild((OMNode)dateElement);
                OMElement textElement = factory.createOMElement(new QName("tagName"));
                textElement.setText(tagName);
                taggingElement.addChild((OMNode)textElement);
                child.addChild((OMNode)taggingElement);
            }
            child.serialize(xmlWriter);
        }
        if ((ratings = this.ratingsDAO.getResourceRatingDO(resource)) != null && ratings.length > 0) {
            child = factory.createOMElement(new QName("ratings"));
            for (RatingDO rating : ratings) {
                OMElement ratingElement = factory.createOMElement(new QName("rating"));
                String user = rating.getRatedUserName();
                Date date = rating.getRatedTime();
                int rate = rating.getRating();
                OMElement userElement = factory.createOMElement(new QName("user"));
                userElement.setText(user);
                ratingElement.addChild((OMNode)userElement);
                OMElement dateElement = factory.createOMElement(new QName("date"));
                String dateString = Long.toString(date.getTime());
                dateElement.setText(dateString);
                ratingElement.addChild((OMNode)dateElement);
                OMElement textElement = factory.createOMElement(new QName("rate"));
                String rateString = String.valueOf(rate);
                textElement.setText(rateString);
                ratingElement.addChild((OMNode)textElement);
                child.addChild((OMNode)ratingElement);
            }
            child.serialize(xmlWriter);
        }
        if ((associations = this.associationDAO.getAllAssociations(path)) != null && associations.length > 0) {
            child = factory.createOMElement(new QName("associations"));
            for (Association association : associations) {
                OMElement associationElement = factory.createOMElement(new QName("association"));
                String source = association.getSourcePath();
                String destination = association.getDestinationPath();
                String type = association.getAssociationType();
                source = RegistryUtils.getRelativeAssociationPath(source, path);
                destination = destination.startsWith("/") ? RegistryUtils.getRelativeAssociationPath(destination, path) : ":" + destination;
                OMElement sourceElement = factory.createOMElement(new QName("source"));
                sourceElement.setText(source);
                associationElement.addChild((OMNode)sourceElement);
                OMElement destinationElement = factory.createOMElement(new QName("destination"));
                destinationElement.setText(destination);
                associationElement.addChild((OMNode)destinationElement);
                OMElement typeElement = factory.createOMElement(new QName("type"));
                typeElement.setText(type);
                associationElement.addChild((OMNode)typeElement);
                child.addChild((OMNode)associationElement);
            }
            child.serialize(xmlWriter);
        }
        if (!(resource instanceof CollectionImpl)) {
            this.resourceDAO.fillResourceContent(resource);
            byte[] content = (byte[])resource.getContent();
            if (content != null) {
                child = factory.createOMElement(new QName("content"));
                child.setText(Base64.encode((byte[])content));
                child.serialize(xmlWriter);
            }
        }
        if (resource instanceof CollectionImpl) {
            CollectionImpl collection = (CollectionImpl)resource;
            this.resourceDAO.fillChildren(collection, 0, -1);
            String[] childPaths = collection.getChildren();
            xmlWriter.writeStartElement("children");
            OMText emptyText = factory.createOMText("");
            emptyText.serialize(xmlWriter);
            xmlWriter.flush();
            for (String childPath : childPaths) {
                try {
                    String resourceName = RegistryUtils.getResourceName(childPath);
                    writer.write("<resource name=\"" + resourceName + "\"");
                    writer.flush();
                }
                catch (IOException e) {
                    String msg = "Error in writing the start element for the path: " + childPath + ".";
                    log.error((Object)msg, (Throwable)e);
                    throw new RegistryException(msg, e);
                }
                this.recursionRepository.dumpRecursively(childPath, new DumpWriter(writer));
            }
            xmlWriter.writeEndElement();
        }
        xmlWriter.writeEndElement();
        xmlWriter.flush();
    }

    protected void dumpLite(String _path, Writer writer) throws RegistryException {
        String path = _path;
        if (!path.equals("/") && path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        try {
            XMLOutputFactory xof = XMLOutputFactory.newInstance();
            XMLStreamWriter xmlWriter = xof.createXMLStreamWriter(writer);
            this.dumpRecursivelyLight(path, xmlWriter, writer);
        }
        catch (XMLStreamException e) {
            String msg = "Failed to serialize the dumped element at " + path + ".";
            log.error((Object)msg);
            throw new RegistryException(msg, e);
        }
    }

    private void dumpRecursivelyLight(String path, XMLStreamWriter xmlWriter, Writer writer) throws RegistryException, XMLStreamException {
        ResourceImpl resource = this.resourceDAO.getResourceMetaData(path);
        if (resource == null) {
            return;
        }
        if (!AuthorizationUtils.authorize(path, "http://www.wso2.org/projects/registry/actions/get")) {
            String msg = this.getUserNotAuthorizedMsg() + "check out the path " + path + ".";
            log.warn((Object)msg);
            throw new AuthorizationFailedException(msg);
        }
        xmlWriter.writeStartElement("resource");
        xmlWriter.writeAttribute("name", RegistryUtils.getResourceName(path));
        xmlWriter.writeAttribute("isCollection", resource instanceof CollectionImpl ? "true" : "false");
        String mediaType = resource.getMediaType();
        OMFactory factory = OMAbstractFactory.getOMFactory();
        OMElement child = factory.createOMElement(new QName("mediaType"));
        child.setText(mediaType);
        child.serialize(xmlWriter);
        long version = resource.getVersionNumber();
        child = factory.createOMElement(new QName("version"));
        child.setText(version + "");
        child.serialize(xmlWriter);
        String creator = resource.getAuthorUserName();
        child = factory.createOMElement(new QName("creator"));
        child.setText(creator);
        child.serialize(xmlWriter);
        Date createdTime = resource.getCreatedTime();
        child = factory.createOMElement(new QName("createdTime"));
        child.setText(Long.toString(createdTime.getTime()));
        child.serialize(xmlWriter);
        String updater = resource.getLastUpdaterUserName();
        child = factory.createOMElement(new QName("lastUpdater"));
        child.setText(updater);
        child.serialize(xmlWriter);
        Date lastModified = resource.getLastModified();
        child = factory.createOMElement(new QName("lastModified"));
        child.setText(Long.toString(lastModified.getTime()));
        child.serialize(xmlWriter);
        String uuid = resource.getUUID();
        child = factory.createOMElement(new QName("uuid"));
        child.setText(uuid);
        child.serialize(xmlWriter);
        String description = resource.getDescription();
        child = factory.createOMElement(new QName("description"));
        child.setText(description);
        child.serialize(xmlWriter);
        if (!(resource instanceof CollectionImpl)) {
            this.resourceDAO.fillResourceContent(resource);
            byte[] content = (byte[])resource.getContent();
            if (content != null) {
                child = factory.createOMElement(new QName("content"));
                child.setText(Base64.encode((byte[])content));
                child.serialize(xmlWriter);
            }
        }
        if (resource instanceof CollectionImpl) {
            CollectionImpl collection = (CollectionImpl)resource;
            this.resourceDAO.fillChildren(collection, 0, -1);
            String[] childPaths = collection.getChildren();
            xmlWriter.writeStartElement("children");
            OMText emptyText = factory.createOMText("");
            emptyText.serialize(xmlWriter);
            xmlWriter.flush();
            for (String childPath : childPaths) {
                try {
                    String resourceName = RegistryUtils.getResourceName(childPath);
                    writer.write("<resource name=\"" + resourceName + "\"");
                    writer.flush();
                }
                catch (IOException e) {
                    String msg = "Error in writing the start element for the path: " + childPath + ".";
                    log.error((Object)msg, (Throwable)e);
                    throw new RegistryException(msg, e);
                }
                if (path.equals(childPath)) continue;
                this.recursionRepository.dumpRecursivelyLite(childPath, new DumpWriter(writer));
            }
            xmlWriter.writeEndElement();
        }
        xmlWriter.writeEndElement();
        xmlWriter.flush();
    }
}

