/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.core.jdbc;

import java.io.Reader;
import java.io.Writer;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourceIDImpl;
import org.wso2.carbon.registry.core.ResourcePath;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.Repository;
import org.wso2.carbon.registry.core.jdbc.dataobjects.ResourceDO;

public class RecursionRepository {
    private Repository repository;
    private Registry registry;

    public RecursionRepository(Repository repository, Registry registry) {
        this.repository = repository;
        this.registry = registry;
    }

    public RecursionRepository(Registry registry) {
        this.registry = registry;
    }

    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    private boolean isNonRecursive(String path) throws RegistryException {
        Resource source = this.repository.get(path);
        if (source != null) {
            String isNonRecursive = source.getProperty("registry.nonrecursive");
            return isNonRecursive != null && Boolean.toString(true).equals(isNonRecursive);
        }
        return false;
    }

    public String copy(ResourcePath sourceResourcePath, ResourcePath targetResourcePath) throws RegistryException {
        if (this.isNonRecursive(sourceResourcePath.getPath())) {
            return this.registry.copy(sourceResourcePath.getPath(), targetResourcePath.getPath());
        }
        return this.repository.copy(sourceResourcePath, targetResourcePath);
    }

    public String moveRecursively(ResourceIDImpl sourceID, String targetPath, ResourceIDImpl targetParentResourceID) throws RegistryException {
        if (this.isNonRecursive(sourceID.getPath())) {
            return this.registry.move(sourceID.getPath(), targetPath);
        }
        if (sourceID.isCollection()) {
            return this.repository.moveRecursively(sourceID, targetPath, targetParentResourceID);
        }
        return null;
    }

    public void deleteSubTree(ResourceIDImpl resourceID, ResourceDO resourceDO, boolean keepAuthorization) throws RegistryException {
        if (this.isNonRecursive(resourceID.getPath())) {
            this.registry.delete(resourceID.getPath());
        } else {
            this.repository.deleteSubTree(resourceID, resourceDO, keepAuthorization);
        }
    }

    public void dumpRecursively(String path, Writer writer) throws RegistryException {
        if (this.isNonRecursive(path)) {
            this.registry.dump(path, writer);
        } else {
            this.repository.dump(path, writer);
        }
    }

    public void restoreRecursively(String path, Reader reader) throws RegistryException {
        if (this.isNonRecursive(path)) {
            this.registry.restore(path, reader);
        } else {
            this.repository.restore(path, reader);
        }
    }

    public void dumpRecursivelyLite(String path, Writer writer) throws RegistryException {
        if (this.isNonRecursive(path)) {
            this.registry.dumpLite(path, writer);
        } else {
            this.repository.dumpLite(path, writer);
        }
    }
}

