/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.core.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.exceptions.RegistryException;

@Deprecated
public class RegistryConfiguration {
    private static final Log log = LogFactory.getLog(RegistryConfiguration.class);
    public static final String REGISTRY_CONFIG = "Registry";
    public static final String TYPE = "Type";
    public static final String USERNAME = "Username";
    public static final String PASSWORD = "Password";
    public static final String URL = "Url";
    public static final String REGISTRY_ROOT = "registryRoot";
    public static final String READ_ONLY = "ReadOnly";
    public static final String SYSTEM_USER_NAME = "RegistrySystemUserName";
    public static final String REMOTE_REGISTRY = "remote";
    public static final String EMBEDDED_REGISTRY = "embedded";
    private Map<String, String> registryConfiguration = new HashMap<String, String>();

    public RegistryConfiguration(String carbonXMLPath) throws RegistryException {
        InputStream inSXml = null;
        try {
            File carbonXML = new File(carbonXMLPath);
            inSXml = new FileInputStream(carbonXML);
            OMElement config = new StAXOMBuilder(inSXml).getDocumentElement();
            OMElement registryConfig = config.getFirstChildWithName(new QName("http://wso2.org/projects/carbon/carbon.xml", REGISTRY_CONFIG));
            if (registryConfig != null) {
                Iterator childElements = registryConfig.getChildElements();
                while (childElements.hasNext()) {
                    OMElement element = (OMElement)childElements.next();
                    this.registryConfiguration.put(element.getLocalName(), element.getText());
                }
            }
            if (this.registryConfiguration.get(TYPE) == null) {
                this.registryConfiguration.put(TYPE, EMBEDDED_REGISTRY);
            }
            this.validate();
        }
        catch (Exception e) {
            throw new RegistryException("Error occurred while initialization", e);
        }
        finally {
            if (inSXml != null) {
                try {
                    inSXml.close();
                }
                catch (IOException e) {
                    log.error((Object)"Failed to close the stream", (Throwable)e);
                }
            }
        }
    }

    private void validate() throws RegistryException {
        this.registryConfiguration.put(SYSTEM_USER_NAME, "wso2.system.user");
        String type = this.registryConfiguration.get(TYPE);
        if (type == null || type.trim().length() == 0) {
            type = EMBEDDED_REGISTRY;
        }
        if (REMOTE_REGISTRY.equals(type)) {
            if (this.registryConfiguration.get(URL) == null) {
                throw new RegistryException("URL not given");
            }
            if (this.registryConfiguration.get(REGISTRY_ROOT) != null && !this.registryConfiguration.get(REGISTRY_ROOT).startsWith("/")) {
                log.error((Object)"Invalid Registry Configuration : CHROOT must start with a /");
                throw new RegistryException("Invalid Registry Configuration : CHROOT must start with a /");
            }
        } else if (!EMBEDDED_REGISTRY.equals(type)) {
            throw new RegistryException("Unkown type");
        }
    }

    public String getValue(String key) {
        return this.registryConfiguration.get(key);
    }

    public String getRegistryType() {
        return this.registryConfiguration.get(TYPE);
    }
}

