/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.core.caching;

import java.io.Reader;
import java.io.Writer;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.cache.Cache;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonConstants;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.registry.api.GhostResource;
import org.wso2.carbon.registry.api.RegistryException;
import org.wso2.carbon.registry.core.Aspect;
import org.wso2.carbon.registry.core.Association;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Comment;
import org.wso2.carbon.registry.core.LogEntry;
import org.wso2.carbon.registry.core.LogEntryCollection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourcePath;
import org.wso2.carbon.registry.core.Tag;
import org.wso2.carbon.registry.core.TaggedResourcePath;
import org.wso2.carbon.registry.core.caching.RegistryCacheKey;
import org.wso2.carbon.registry.core.config.DataBaseConfiguration;
import org.wso2.carbon.registry.core.config.Mount;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.config.RemoteConfiguration;
import org.wso2.carbon.registry.core.jdbc.EmbeddedRegistry;
import org.wso2.carbon.registry.core.secure.AuthorizationFailedException;
import org.wso2.carbon.registry.core.session.CurrentSession;
import org.wso2.carbon.registry.core.utils.AuthorizationUtils;
import org.wso2.carbon.registry.core.utils.RegistryUtils;

public class CacheBackedRegistry
implements Registry {
    private Registry registry;
    private int tenantId = -1;
    private Map<String, String> cacheIds = new HashMap<String, String>();
    private Map<String, DataBaseConfiguration> dbConfigs = new HashMap<String, DataBaseConfiguration>();
    private Map<String, String> pathMap = new HashMap<String, String>();
    private static final Log log = LogFactory.getLog(CacheBackedRegistry.class);
    private static final Log audit = CarbonConstants.AUDIT_LOG;

    private static Cache<RegistryCacheKey, GhostResource> getDistributedCache() {
        return RegistryUtils.getResourceCache("REG_CACHE_BACKED_ID");
    }

    private static Cache<RegistryCacheKey, GhostResource> getLocalCache() {
        return RegistryUtils.getResourceCache("$__local__$.REG_LOCAL_CACHE_BACKED_ID");
    }

    public CacheBackedRegistry(Registry registry) {
        this.registry = registry;
        RegistryContext registryContext = RegistryContext.getBaseInstance();
        for (Mount mount : registryContext.getMounts()) {
            for (RemoteConfiguration configuration : registryContext.getRemoteInstances()) {
                if (configuration.getDbConfig() != null && mount.getInstanceId().equals(configuration.getId())) {
                    this.dbConfigs.put(mount.getPath(), registryContext.getDBConfig(configuration.getDbConfig()));
                    this.pathMap.put(mount.getPath(), mount.getTargetPath());
                    continue;
                }
                if (configuration.getCacheId() == null || !mount.getInstanceId().equals(configuration.getId())) continue;
                this.cacheIds.put(mount.getPath(), configuration.getCacheId());
                this.pathMap.put(mount.getPath(), mount.getTargetPath());
            }
        }
    }

    public CacheBackedRegistry(Registry registry, int tenantId) {
        this(registry);
        this.tenantId = tenantId;
    }

    private RegistryCacheKey getRegistryCacheKey(Registry registry, String path) {
        RegistryContext registryContext;
        int tenantId;
        String connectionId = "";
        if (this.tenantId == -1) {
            tenantId = CurrentSession.getTenantId();
            if (tenantId == -1) {
                tenantId = CarbonContext.getThreadLocalCarbonContext().getTenantId();
            }
        } else {
            tenantId = this.tenantId;
        }
        if ((registryContext = registry.getRegistryContext()) == null) {
            registryContext = RegistryContext.getBaseInstance();
        }
        String resourceCachePath = registry instanceof EmbeddedRegistry ? path : RegistryUtils.getAbsolutePath(registryContext, path);
        DataBaseConfiguration dataBaseConfiguration = null;
        if (this.dbConfigs.size() > 0) {
            for (String sourcePath : this.dbConfigs.keySet()) {
                if (!resourceCachePath.startsWith(sourcePath)) continue;
                resourceCachePath = this.pathMap.get(sourcePath) + resourceCachePath.substring(sourcePath.length());
                dataBaseConfiguration = this.dbConfigs.get(sourcePath);
                break;
            }
        } else if (this.cacheIds.size() > 0) {
            for (String sourcePath : this.cacheIds.keySet()) {
                if (!resourceCachePath.startsWith(sourcePath)) continue;
                resourceCachePath = this.pathMap.get(sourcePath) + resourceCachePath.substring(sourcePath.length());
                connectionId = this.cacheIds.get(sourcePath);
                break;
            }
        }
        if (connectionId.length() == 0) {
            if (dataBaseConfiguration == null) {
                dataBaseConfiguration = registryContext.getDefaultDataBaseConfiguration();
            }
            if (dataBaseConfiguration != null) {
                connectionId = (dataBaseConfiguration.getUserName() != null ? dataBaseConfiguration.getUserName().split("@")[0] : dataBaseConfiguration.getUserName()) + "@" + dataBaseConfiguration.getDbUrl();
            }
        }
        return RegistryUtils.buildRegistryCacheKey(connectionId, tenantId, resourceCachePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Resource get(String path) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        if (this.registry.getRegistryContext().isNoCachePath(path) || this.isCommunityFeatureRequest(path)) {
            Resource resource = this.registry.get(path);
            if (this.registry.getRegistryContext().isNoCachePath(path)) {
                RegistryCacheKey registryCacheKey = this.getRegistryCacheKey(this.registry, path);
                Cache<RegistryCacheKey, GhostResource> cache = this.getCache(path);
                if (cache.get((Object)registryCacheKey) != null) {
                    GhostResource ghostResource = new GhostResource((Object)resource);
                    if (resource.getProperty("registry.link") == null || resource.getProperty("registry.mount") != null) {
                        cache.put((Object)registryCacheKey, (Object)ghostResource);
                    }
                }
            }
            return resource;
        }
        if (!AuthorizationUtils.authorize(path, "http://www.wso2.org/projects/registry/actions/get")) {
            String msg = "User " + CurrentSession.getUser() + " is not authorized to read the resource " + path + ".";
            audit.warn((Object)msg);
            throw new AuthorizationFailedException(msg);
        }
        GhostResource<Resource> ghostResource = this.getGhostResourceFromCache(path);
        Resource resource = (Resource)ghostResource.getResource();
        if (resource == null) {
            String string = path.intern();
            synchronized (string) {
                resource = this.registry.get(path);
                if (resource.getProperty("registry.link") == null || resource.getProperty("registry.mount") != null) {
                    ghostResource.setResource((Object)resource);
                }
            }
        }
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GhostResource<Resource> getGhostResourceFromCache(String path) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        GhostResource ghostResource;
        RegistryCacheKey registryCacheKey = this.getRegistryCacheKey(this.registry, path);
        Cache<RegistryCacheKey, GhostResource> cache = this.getCache(path);
        Object ghostResourceObject = cache.get((Object)registryCacheKey);
        if (ghostResourceObject == null) {
            String string = path.intern();
            synchronized (string) {
                ghostResourceObject = cache.get((Object)registryCacheKey);
                if (ghostResourceObject == null) {
                    Resource resource = this.registry.get(path);
                    ghostResource = new GhostResource((Object)resource);
                    if (resource.getProperty("registry.link") == null || resource.getProperty("registry.mount") != null) {
                        cache.put((Object)registryCacheKey, (Object)ghostResource);
                    }
                } else {
                    ghostResource = (GhostResource)ghostResourceObject;
                }
            }
        } else {
            ghostResource = (GhostResource)ghostResourceObject;
        }
        return ghostResource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GhostResource<Resource> getGhostCollectionFromCache(String path, int start, int pageSize) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        GhostResource ghostResource;
        RegistryCacheKey registryCacheKey = this.getRegistryCacheKey(this.registry, path + ";start=" + start + ";pageSize=" + pageSize);
        Cache<RegistryCacheKey, GhostResource> cache = this.getCache(path);
        if (!cache.containsKey((Object)registryCacheKey)) {
            String string = path.intern();
            synchronized (string) {
                if (!cache.containsKey((Object)registryCacheKey)) {
                    Collection collection = this.registry.get(path, start, pageSize);
                    ghostResource = new GhostResource((Object)collection);
                    if (collection.getProperty("registry.link") == null) {
                        cache.put((Object)registryCacheKey, (Object)ghostResource);
                    }
                } else {
                    ghostResource = (GhostResource)cache.get((Object)registryCacheKey);
                }
            }
        } else {
            ghostResource = (GhostResource)cache.get((Object)registryCacheKey);
        }
        return ghostResource;
    }

    private Cache<RegistryCacheKey, GhostResource> getCache(String path) {
        Cache<RegistryCacheKey, GhostResource> cache = path != null && this.isResourcePathMounted(path) ? CacheBackedRegistry.getDistributedCache() : CacheBackedRegistry.getLocalCache();
        return cache;
    }

    private boolean isResourcePathMounted(String path) {
        RegistryContext registryContext = RegistryContext.getBaseInstance();
        List<Mount> mounts = registryContext.getMounts();
        for (Mount mount : mounts) {
            if (!path.startsWith(mount.getPath())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection get(String path, int start, int pageSize) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        if (this.registry.getRegistryContext().isNoCachePath(path) || this.isCommunityFeatureRequest(path)) {
            GhostResource<Resource> ghostResource;
            Collection collection = this.registry.get(path, start, pageSize);
            if (this.registry.getRegistryContext().isNoCachePath(path) && (ghostResource = this.getGhostCollectionFromCache(path, start, pageSize)) != null && collection.getProperty("registry.link") == null) {
                ghostResource.setResource((Object)collection);
            }
            return collection;
        }
        if (!AuthorizationUtils.authorize(path, "http://www.wso2.org/projects/registry/actions/get")) {
            String msg = "User " + CurrentSession.getUser() + " is not authorized to read the resource " + path + ".";
            audit.warn((Object)msg);
            throw new AuthorizationFailedException(msg);
        }
        GhostResource<Resource> ghostResource = this.getGhostCollectionFromCache(path, start, pageSize);
        Collection collection = (Collection)ghostResource.getResource();
        if (collection == null) {
            String string = path.intern();
            synchronized (string) {
                collection = this.registry.get(path, start, pageSize);
                if (collection.getProperty("registry.link") == null) {
                    ghostResource.setResource((Object)collection);
                }
            }
        }
        return collection;
    }

    private boolean isCommunityFeatureRequest(String path) {
        if (path == null) {
            return false;
        }
        String resourcePath = new ResourcePath(path).getPath();
        if (path.length() > resourcePath.length()) {
            String fragment = path.substring(resourcePath.length());
            for (String temp : new String[]{"tags", "comments", "ratings"}) {
                if (!fragment.contains(temp)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean resourceExists(String path) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        RegistryCacheKey registryCacheKey;
        if (this.registry.getRegistryContext().isNoCachePath(path)) {
            RegistryCacheKey registryCacheKey2;
            Cache<RegistryCacheKey, GhostResource> cache;
            boolean isResourceExists = this.registry.resourceExists(path);
            if (isResourceExists && (cache = this.getCache(path)).containsKey((Object)(registryCacheKey2 = this.getRegistryCacheKey(this.registry, path))) && cache.get((Object)registryCacheKey2) != null) {
                cache.put((Object)registryCacheKey2, (Object)new GhostResource(null));
            }
            return isResourceExists;
        }
        Cache<RegistryCacheKey, GhostResource> cache = this.getCache(path);
        if (cache.containsKey((Object)(registryCacheKey = this.getRegistryCacheKey(this.registry, path)))) {
            return true;
        }
        if (this.registry.resourceExists(path)) {
            cache.put((Object)registryCacheKey, (Object)new GhostResource(null));
            return true;
        }
        return false;
    }

    @Override
    public Resource getMetaData(String path) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        return this.registry.getMetaData(path);
    }

    @Override
    public String importResource(String suggestedPath, String sourceURL, Resource resource) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        return this.registry.importResource(suggestedPath, sourceURL, resource);
    }

    @Override
    public String rename(String currentPath, String newName) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        return this.registry.rename(currentPath, newName);
    }

    @Override
    public String move(String currentPath, String newPath) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        return this.registry.move(currentPath, newPath);
    }

    @Override
    public String copy(String sourcePath, String targetPath) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        return this.registry.copy(sourcePath, targetPath);
    }

    @Override
    public void createVersion(String path) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        this.registry.createVersion(path);
    }

    @Override
    public String[] getVersions(String path) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        return this.registry.getVersions(path);
    }

    @Override
    public void restoreVersion(String versionPath) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        this.registry.restoreVersion(versionPath);
    }

    @Override
    public void addAssociation(String sourcePath, String targetPath, String associationType) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        this.registry.addAssociation(sourcePath, targetPath, associationType);
    }

    @Override
    public void removeAssociation(String sourcePath, String targetPath, String associationType) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        this.registry.removeAssociation(sourcePath, targetPath, associationType);
    }

    @Override
    public Association[] getAllAssociations(String resourcePath) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        return this.registry.getAllAssociations(resourcePath);
    }

    @Override
    public Association[] getAssociations(String resourcePath, String associationType) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        return this.registry.getAssociations(resourcePath, associationType);
    }

    @Override
    public void applyTag(String resourcePath, String tag) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        this.registry.applyTag(resourcePath, tag);
    }

    @Override
    public TaggedResourcePath[] getResourcePathsWithTag(String tag) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        return this.registry.getResourcePathsWithTag(tag);
    }

    @Override
    public Tag[] getTags(String resourcePath) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        return this.registry.getTags(resourcePath);
    }

    @Override
    public void removeTag(String path, String tag) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        this.registry.removeTag(path, tag);
    }

    @Override
    public String addComment(String resourcePath, Comment comment) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        return this.registry.addComment(resourcePath, comment);
    }

    @Override
    public void editComment(String commentPath, String text) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        this.registry.editComment(commentPath, text);
    }

    @Override
    public void removeComment(String commentPath) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        this.registry.removeComment(commentPath);
    }

    @Override
    public Comment[] getComments(String resourcePath) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        return this.registry.getComments(resourcePath);
    }

    @Override
    public void rateResource(String resourcePath, int rating) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        this.registry.rateResource(resourcePath, rating);
    }

    @Override
    public float getAverageRating(String resourcePath) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        return this.registry.getAverageRating(resourcePath);
    }

    @Override
    public int getRating(String path, String userName) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        return this.registry.getRating(path, userName);
    }

    @Override
    public Collection executeQuery(String path, Map parameters) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        return this.registry.executeQuery(path, parameters);
    }

    @Override
    public LogEntry[] getLogs(String resourcePath, int action, String userName, Date from, Date to, boolean recentFirst) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        return this.registry.getLogs(resourcePath, action, userName, from, to, recentFirst);
    }

    @Override
    public LogEntryCollection getLogCollection(String resourcePath, int action, String userName, Date from, Date to, boolean recentFirst) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        return this.registry.getLogCollection(resourcePath, action, userName, from, to, recentFirst);
    }

    @Override
    public String[] getAvailableAspects() {
        return this.registry.getAvailableAspects();
    }

    @Override
    public void associateAspect(String resourcePath, String aspect) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        this.registry.associateAspect(resourcePath, aspect);
    }

    @Override
    public void invokeAspect(String resourcePath, String aspectName, String action) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        this.registry.invokeAspect(resourcePath, aspectName, action);
    }

    @Override
    public void invokeAspect(String resourcePath, String aspectName, String action, Map<String, String> parameters) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        this.registry.invokeAspect(resourcePath, aspectName, action, parameters);
    }

    @Override
    public String[] getAspectActions(String resourcePath, String aspectName) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        return this.registry.getAspectActions(resourcePath, aspectName);
    }

    @Override
    public RegistryContext getRegistryContext() {
        return this.registry.getRegistryContext();
    }

    @Override
    public Collection searchContent(String keywords) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        return this.registry.searchContent(keywords);
    }

    @Override
    public void createLink(String path, String target) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        this.registry.createLink(path, target);
    }

    @Override
    public void createLink(String path, String target, String subTargetPath) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        this.registry.createLink(path, target, subTargetPath);
    }

    @Override
    public void removeLink(String path) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        this.registry.removeLink(path);
    }

    @Override
    public void restore(String path, Reader reader) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        this.registry.restore(path, reader);
    }

    @Override
    public void dump(String path, Writer writer) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        this.registry.dump(path, writer);
    }

    @Override
    public String getEventingServiceURL(String path) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        return this.registry.getEventingServiceURL(path);
    }

    @Override
    public void setEventingServiceURL(String path, String eventingServiceURL) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        this.registry.setEventingServiceURL(path, eventingServiceURL);
    }

    @Override
    public boolean removeAspect(String aspect) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        return this.registry.removeAspect(aspect);
    }

    @Override
    public boolean addAspect(String name, Aspect aspect) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        return this.registry.addAspect(name, aspect);
    }

    @Override
    public void beginTransaction() throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        this.registry.beginTransaction();
    }

    @Override
    public void commitTransaction() throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        this.registry.commitTransaction();
    }

    @Override
    public void rollbackTransaction() throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        this.registry.rollbackTransaction();
    }

    @Override
    public Resource newResource() throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        return this.registry.newResource();
    }

    @Override
    public Collection newCollection() throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        return this.registry.newCollection();
    }

    public String importResource(String suggestedPath, String sourceURL, org.wso2.carbon.registry.api.Resource resource) throws RegistryException {
        return this.registry.importResource(suggestedPath, sourceURL, resource);
    }

    @Override
    public String put(String suggestedPath, Resource resource) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        return this.registry.put(suggestedPath, resource);
    }

    @Override
    public void delete(String path) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        this.registry.delete(path);
    }

    public String addComment(String resourcePath, org.wso2.carbon.registry.api.Comment comment) throws RegistryException {
        return this.registry.addComment(resourcePath, comment);
    }

    public String put(String suggestedPath, org.wso2.carbon.registry.api.Resource resource) throws RegistryException {
        return this.registry.put(suggestedPath, resource);
    }

    @Override
    public boolean removeVersionHistory(String path, long snapshotId) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        return this.registry.removeVersionHistory(path, snapshotId);
    }

    @Override
    public void dumpLite(String path, Writer writer) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        this.registry.dumpLite(path, writer);
    }
}

