/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.app;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.abdera.Abdera;
import org.apache.abdera.factory.Factory;
import org.apache.abdera.i18n.iri.IRI;
import org.apache.abdera.model.AtomDate;
import org.apache.abdera.model.Base;
import org.apache.abdera.model.Content;
import org.apache.abdera.model.Document;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.ExtensibleElement;
import org.apache.abdera.model.Feed;
import org.apache.abdera.model.Link;
import org.apache.abdera.protocol.Response;
import org.apache.abdera.protocol.client.AbderaClient;
import org.apache.abdera.protocol.client.ClientResponse;
import org.apache.abdera.protocol.client.RequestOptions;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.Base64;
import org.apache.commons.io.input.ReaderInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.api.RegistryException;
import org.wso2.carbon.registry.app.APPConstants;
import org.wso2.carbon.registry.app.CachedResources;
import org.wso2.carbon.registry.app.Properties;
import org.wso2.carbon.registry.app.Property;
import org.wso2.carbon.registry.app.PropertyExtensionFactory;
import org.wso2.carbon.registry.app.PropertyName;
import org.wso2.carbon.registry.app.PropertyValue;
import org.wso2.carbon.registry.app.RemoteResourceImpl;
import org.wso2.carbon.registry.app.Utils;
import org.wso2.carbon.registry.core.Aspect;
import org.wso2.carbon.registry.core.Association;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.CollectionImpl;
import org.wso2.carbon.registry.core.Comment;
import org.wso2.carbon.registry.core.LogEntry;
import org.wso2.carbon.registry.core.LogEntryCollection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourceImpl;
import org.wso2.carbon.registry.core.Tag;
import org.wso2.carbon.registry.core.TaggedResourcePath;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.exceptions.ResourceNotFoundException;

public class RemoteRegistry
implements Registry {
    private static final String TEXT_PLAIN_MEDIA_TYPE = "text/plain";
    private String baseURI;
    private Log log = LogFactory.getLog(RemoteRegistry.class);
    private String authorizationString = null;
    private String username = null;
    private Abdera abdera = new Abdera();
    private static CachedResources cache = new CachedResources();

    public RemoteRegistry(URL registryURL) {
        this.baseURI = registryURL.toString();
        if (this.baseURI.endsWith("/")) {
            this.baseURI = this.baseURI.substring(0, this.baseURI.length() - 1);
        }
    }

    public RemoteRegistry(URL registryURL, String userName, String password) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        this.baseURI = registryURL.toString();
        if (this.baseURI.endsWith("/")) {
            this.baseURI = this.baseURI.substring(0, this.baseURI.length() - 1);
        }
        this.username = userName;
        if (userName != null && password != null) {
            this.authorizationString = userName + ":" + password;
            this.authorizationString = "Basic " + Base64.encode((byte[])this.authorizationString.getBytes());
        }
    }

    public RemoteRegistry(String registryURL, String userName, String password) throws MalformedURLException, org.wso2.carbon.registry.core.exceptions.RegistryException {
        this(new URL(registryURL), userName, password);
    }

    @Override
    public Resource newResource() throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        RemoteResourceImpl resource = new RemoteResourceImpl();
        resource.setAuthorUserName(this.username);
        return resource;
    }

    @Override
    public Collection newCollection() throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        CollectionImpl collection = new CollectionImpl();
        collection.setAuthorUserName(this.username);
        return collection;
    }

    @Override
    public Resource get(String path) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        ResourceImpl resource;
        String encodedPath;
        AbderaClient abderaClient = new AbderaClient(this.abdera);
        if (path.endsWith(";comments")) {
            encodedPath = RemoteRegistry.encodeURL(path);
            if (encodedPath.contains(";version:")) {
                int index = encodedPath.lastIndexOf(";version:");
                encodedPath = encodedPath.substring(0, index).replace(":", "%3A") + encodedPath.substring(index);
            } else {
                encodedPath = encodedPath.replace(":", "%3A");
            }
        } else {
            encodedPath = RemoteRegistry.encodeURL(path);
        }
        ClientResponse clientResponse = !cache.isResourceCached(path) ? abderaClient.get(this.baseURI + "/atom" + encodedPath, this.getAuthorization()) : abderaClient.get(this.baseURI + "/atom" + encodedPath, this.getAuthorizationForCaching(path));
        if (clientResponse.getType() == Response.ResponseType.CLIENT_ERROR || clientResponse.getType() == Response.ResponseType.SERVER_ERROR) {
            if (clientResponse.getStatus() == 404) {
                abderaClient.teardown();
                throw new ResourceNotFoundException(path);
            }
            abderaClient.teardown();
            throw new org.wso2.carbon.registry.core.exceptions.RegistryException(clientResponse.getStatusText());
        }
        if (clientResponse.getStatus() == 304) {
            abderaClient.teardown();
            this.log.debug((Object)"Cached resource returned since no modification has been done on the resource");
            return cache.getCachedResource(path);
        }
        String eTag = clientResponse.getHeader("ETag");
        Element introspection = clientResponse.getDocument().getRoot();
        if (introspection instanceof Feed) {
            Feed feed = (Feed)introspection;
            String state = feed.getSimpleExtension(new QName("http://wso2.org/registry", "state"));
            if (state != null && state.equals("Deleted")) {
                abderaClient.teardown();
                throw new ResourceNotFoundException(path);
            }
            resource = this.createResourceFromFeed(feed);
        } else {
            Entry entry = (Entry)introspection;
            resource = this.createResourceFromEntry(entry);
        }
        if (!cache.cacheResource(path, resource, eTag, 50000L)) {
            this.log.debug((Object)"Max Cache size exceeded the configured Cache size");
        }
        abderaClient.teardown();
        return resource;
    }

    @Override
    public Resource getMetaData(String path) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        return this.get(path);
    }

    public String importResource(String suggestedPath, String sourceURL, org.wso2.carbon.registry.api.Resource resource) throws RegistryException {
        return this.importResource(suggestedPath, sourceURL, (Resource)resource);
    }

    @Override
    public Collection get(String path, int start, int pageSize) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        AbderaClient abderaClient = new AbderaClient(this.abdera);
        ClientResponse clientResponse = abderaClient.get(this.baseURI + "/atom" + RemoteRegistry.encodeURL(path) + "?start=" + start + "&pageLen=" + pageSize, this.getAuthorization());
        if (clientResponse.getType() == Response.ResponseType.CLIENT_ERROR || clientResponse.getType() == Response.ResponseType.SERVER_ERROR) {
            if (clientResponse.getStatus() == 404) {
                abderaClient.teardown();
                throw new ResourceNotFoundException(path);
            }
            abderaClient.teardown();
            throw new org.wso2.carbon.registry.core.exceptions.RegistryException(clientResponse.getStatusText());
        }
        Element introspection = clientResponse.getDocument().getRoot();
        if (!(introspection instanceof Feed)) {
            abderaClient.teardown();
            throw new org.wso2.carbon.registry.core.exceptions.RegistryException("Got " + introspection.getQName() + " when expecting <feed>!");
        }
        Feed feed = (Feed)introspection;
        String state = feed.getSimpleExtension(new QName("http://wso2.org/registry", "state"));
        if (state != null && state.equals("Deleted")) {
            abderaClient.teardown();
            throw new ResourceNotFoundException(path);
        }
        CollectionImpl resource = this.createResourceFromFeed(feed);
        abderaClient.teardown();
        return resource;
    }

    private CollectionImpl createResourceFromFeed(Feed feed) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        String isComments;
        String childCount;
        String mediaType;
        Link pathLink;
        String lastUpdatedUser;
        CollectionImpl resource = new CollectionImpl();
        Properties properties = (Properties)feed.getExtension(PropertyExtensionFactory.PROPERTIES);
        RemoteRegistry.createPropertiesFromExtensionElement(properties, resource);
        if (feed.getAuthor() != null) {
            resource.setAuthorUserName(feed.getAuthor().getName());
        }
        resource.setLastModified(feed.getUpdated());
        String createdDate = feed.getSimpleExtension(new QName("http://wso2.org/registry", "createdTime"));
        if (createdDate != null) {
            try {
                resource.setCreatedTime(new AtomDate(createdDate).getDate());
            }
            catch (IllegalArgumentException e) {
                this.log.error((Object)"Error occured while trying to parse the created date", (Throwable)e);
            }
        }
        if ((lastUpdatedUser = feed.getSimpleExtension(APPConstants.QN_LAST_UPDATER)) != null) {
            resource.setLastUpdaterUserName(lastUpdatedUser);
        }
        String path = (pathLink = feed.getLink("path")) != null ? pathLink.getHref().toString() : feed.getTitle();
        path = URLDecoder.decode(path);
        resource.setPath(path);
        String snapshotID = feed.getSimpleExtension(APPConstants.QN_SNAPSHOT_ID);
        if (snapshotID != null) {
            resource.setMatchingSnapshotID(Long.parseLong(snapshotID));
        }
        if ((mediaType = feed.getSimpleExtension(new QName("http://wso2.org/registry", "mediaType"))) != null) {
            resource.setMediaType(mediaType);
        }
        resource.setDescription(feed.getSubtitle());
        String state = feed.getSimpleExtension(new QName("http://wso2.org/registry", "state"));
        if (state != null && "Deleted".equals(state)) {
            resource.setState(101);
        }
        if ((childCount = feed.getSimpleExtension(APPConstants.QN_CHILD_COUNT)) != null) {
            resource.setChildCount(Integer.parseInt(childCount));
        }
        if (feed.getId() != null) {
            resource.setUUID(feed.getId().toString().replace("urn:uuid:", ""));
        }
        if ((isComments = feed.getSimpleExtension(APPConstants.QN_COMMENTS)) != null) {
            resource.setContent(this.getCommentsFromFeed(feed));
        } else {
            List entries = feed.getEntries();
            if (entries != null) {
                String[] childNodes = new String[entries.size()];
                for (int i = 0; i < entries.size(); ++i) {
                    Entry entry = (Entry)entries.get(i);
                    Link childLink = Utils.getLinkWithRel(entry, "path");
                    childNodes[i] = URLDecoder.decode(childLink.getHref().toString());
                }
                resource.setContent(childNodes);
            }
        }
        return resource;
    }

    private ResourceImpl createResourceFromEntry(Entry entry) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        IRI srcIri;
        String snapshotID;
        String lastUpdatedUser;
        RemoteResourceImpl resource = new RemoteResourceImpl();
        Link pathLink = Utils.getLinkWithRel(entry, "path");
        String path = pathLink != null ? pathLink.getHref().toString() : entry.getTitle();
        path = URLDecoder.decode(path);
        resource.setPath(path);
        String mediaType = entry.getSimpleExtension(new QName("http://wso2.org/registry", "mediaType"));
        if (mediaType != null) {
            resource.setMediaType(mediaType);
        }
        if (entry.getId() != null) {
            resource.setUUID(entry.getId().toString().replace("urn:uuid:", ""));
        }
        Properties properties = (Properties)entry.getExtension(PropertyExtensionFactory.PROPERTIES);
        RemoteRegistry.createPropertiesFromExtensionElement(properties, resource);
        if (entry.getAuthor() != null) {
            resource.setAuthorUserName(entry.getAuthor().getName());
        }
        resource.setLastModified(entry.getUpdated());
        String createdDate = entry.getSimpleExtension(new QName("http://wso2.org/registry", "createdTime"));
        if (createdDate != null) {
            try {
                resource.setCreatedTime(new AtomDate(createdDate).getDate());
            }
            catch (IllegalArgumentException e) {
                this.log.error((Object)"Error occured while trying to parse the created date", (Throwable)e);
            }
        }
        if ((lastUpdatedUser = entry.getSimpleExtension(APPConstants.QN_LAST_UPDATER)) != null) {
            resource.setLastUpdaterUserName(lastUpdatedUser);
        }
        if ((snapshotID = entry.getSimpleExtension(APPConstants.QN_SNAPSHOT_ID)) != null) {
            resource.setMatchingSnapshotID(Long.parseLong(snapshotID));
        }
        resource.setDescription(entry.getSummary());
        Content content = entry.getContentElement();
        if (mediaType == null) {
            if (content.getContentType() == Content.Type.TEXT) {
                resource.setMediaType(TEXT_PLAIN_MEDIA_TYPE);
            } else if (content.getContentType() == Content.Type.MEDIA) {
                resource.setMediaType(content.getMimeType().toString());
            }
        }
        if ((srcIri = content.getSrc()) != null) {
            try {
                URL url = new URL(Utils.encodeRegistryPath(URLDecoder.decode(this.getFilteredTenantCountedContentURL(srcIri.toString()), "utf-8")) + (resource.getPermanentPath() != null ? ";version:" + snapshotID : ""));
                resource.setContentURL(url);
                if (this.authorizationString != null) {
                    resource.setAuthorizationString(this.authorizationString);
                }
                return resource;
            }
            catch (IOException e) {
                throw new org.wso2.carbon.registry.core.exceptions.RegistryException("unable to receive source. " + srcIri.toString());
            }
        }
        String content1 = entry.getContent();
        resource.setContent(content1);
        return resource;
    }

    @Override
    public boolean resourceExists(String path) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        AbderaClient abderaClient = new AbderaClient(this.abdera);
        ClientResponse response = abderaClient.head(this.baseURI + "/atom" + RemoteRegistry.encodeURL(path), this.getAuthorization());
        boolean exists = response.getType() == Response.ResponseType.SUCCESS;
        abderaClient.teardown();
        return exists;
    }

    public String put(String suggestedPath, org.wso2.carbon.registry.api.Resource resource) throws RegistryException {
        return this.put(suggestedPath, (Resource)resource);
    }

    @Override
    public String put(String suggestedPath, Resource resource) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        String location;
        Feed element;
        int idx = suggestedPath.lastIndexOf(47);
        String relativePath = suggestedPath.substring(idx + 1);
        if (Pattern.matches("\\p{Alnum}*[~!@#%^&*()\\+\\;<>\\[\\]{},/\\\\\"',]+\\p{Alnum}*", relativePath)) {
            throw new org.wso2.carbon.registry.core.exceptions.RegistryException("Invalid characters have been used in the resource name. " + relativePath + ". Special characters are ~!@#%^*()+{}[]|\\<>;\"',");
        }
        String parentPath = idx > 1 ? suggestedPath.substring(0, idx) : "/";
        boolean alreadyExists = false;
        AbderaClient abderaClient = new AbderaClient(this.abdera);
        Factory factory = this.abdera.getFactory();
        boolean isCollection = resource instanceof Collection;
        if (isCollection) {
            Feed feed = factory.newFeed();
            feed.setId(this.baseURI + "/atom" + RemoteRegistry.encodeURL(suggestedPath));
            feed.setTitle(suggestedPath);
            feed.setSubtitle(resource.getDescription());
            feed.addAuthor(this.username);
            feed.setUpdated(new Date());
            element = feed;
        } else {
            Entry entry = factory.newEntry();
            entry.setId(this.baseURI + "/atom" + RemoteRegistry.encodeURL(suggestedPath));
            entry.setTitle(suggestedPath);
            entry.setSummary(resource.getDescription());
            entry.addAuthor(this.username);
            entry.setUpdated(new Date());
            Object content = resource.getContent();
            if (content instanceof byte[]) {
                ByteArrayInputStream in = new ByteArrayInputStream((byte[])content);
                entry.setContent((InputStream)in);
            } else if (content instanceof InputStream) {
                entry.setContent((InputStream)content);
            } else {
                entry.setContent((String)content);
            }
            element = entry;
        }
        java.util.Properties properties = resource.getProperties();
        RemoteRegistry.addPropertyExtensionElement(properties, factory, (ExtensibleElement)element, PropertyExtensionFactory.PROPERTIES, PropertyExtensionFactory.PROPERTY);
        String mediaType = resource.getMediaType();
        if (mediaType != null && mediaType.length() > 0) {
            element.addSimpleExtension(new QName("http://wso2.org/registry", "mediaType"), mediaType);
        }
        if (resource.getUUID() != null) {
            element.addSimpleExtension(APPConstants.QN_UUID_TYPE, resource.getUUID());
        }
        element.addSimpleExtension(new QName("http://wso2.org/registry", "parentPath"), resource.getParentPath());
        if (((ResourceImpl)resource).isContentModified()) {
            element.addSimpleExtension(new QName("http://wso2.org/registry", "contentModified"), "true");
        }
        RequestOptions requestOptions = this.getAuthorization();
        requestOptions.setSlug(relativePath);
        requestOptions.setAcceptCharset("UTF-8");
        ClientResponse resp = !alreadyExists ? abderaClient.post(this.baseURI + "/atom" + RemoteRegistry.encodeURL(parentPath), (Base)element, requestOptions) : abderaClient.put(this.baseURI + "/atom" + RemoteRegistry.encodeURL(suggestedPath), (Base)element, requestOptions);
        if (resp.getStatus() == 401) {
            abderaClient.teardown();
            String msg = "User is not authorized to add the resource to " + suggestedPath;
            this.log.error((Object)msg);
            throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg);
        }
        if (resp.getType() != Response.ResponseType.SUCCESS) {
            String msg = "Add resource fail. Suggested Path: " + suggestedPath + ", Response Status: " + resp.getStatus() + ", Response Type: " + resp.getType();
            abderaClient.teardown();
            this.log.error((Object)msg);
            throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg);
        }
        abderaClient.teardown();
        if (resp.getLocation() != null && (location = resp.getLocation().toString()) != null) {
            if (location.startsWith(this.baseURI)) {
                return location.substring(this.baseURI.length() + "/atom".length()).replace("+", " ");
            }
            return location.replace("+", " ");
        }
        return suggestedPath;
    }

    public static void createPropertiesFromExtensionElement(Properties properties, Resource resource) {
        if (properties != null) {
            ((ResourceImpl)resource).setPropertiesModified(true);
            List propertyList = properties.getExtensions(PropertyExtensionFactory.PROPERTY);
            for (Object aPropertyList : propertyList) {
                Property property = (Property)((Object)aPropertyList);
                PropertyName pn = (PropertyName)property.getExtension(PropertyExtensionFactory.PROPERTY_NAME);
                List pv = property.getExtensions(PropertyExtensionFactory.PROPERTY_VALUE);
                String propertyName = pn.getText();
                for (PropertyValue valueElement : pv) {
                    resource.addProperty(propertyName, valueElement.getPropertyValue());
                }
            }
            if (propertyList.size() == 0) {
                resource.setProperties(null);
            }
        }
    }

    public static void addPropertyExtensionElement(java.util.Properties properties, Factory factory, ExtensibleElement entry, QName node1name, QName node2Name) {
        if (properties != null && properties.size() != 0) {
            Properties propertyElement = (Properties)factory.newExtensionElement(node1name);
            for (Object keyObj : properties.keySet()) {
                String key = (String)keyObj;
                Property property = (Property)factory.newExtensionElement(node2Name);
                PropertyName pn = (PropertyName)factory.newExtensionElement(PropertyExtensionFactory.PROPERTY_NAME);
                pn.setPropertyName(key);
                property.addName(pn);
                Object valueList = properties.get(key);
                if (!(valueList instanceof List)) continue;
                for (Object value : (List)valueList) {
                    if (value != null && !(value instanceof String)) continue;
                    PropertyValue pv = (PropertyValue)factory.newExtensionElement(PropertyExtensionFactory.PROPERTY_VALUE);
                    pv.setPropertyValue((String)value);
                    property.addValue(pv);
                }
                propertyElement.setProperty(property);
            }
            entry.addExtension((Element)propertyElement);
        }
    }

    @Override
    public String importResource(String suggestedPath, String sourceURL, Resource resource) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        int idx = suggestedPath.lastIndexOf(47);
        String relativePath = suggestedPath.substring(idx + 1);
        if (Pattern.matches("\\p{Alnum}*[~!@#%^&*()\\+=\\-;<>\\s\\[\\]{},/\\\\\"',]+\\p{Alnum}*", relativePath)) {
            throw new org.wso2.carbon.registry.core.exceptions.RegistryException("Invalid characters have been used in the resource name.");
        }
        AbderaClient abderaClient = new AbderaClient(this.abdera);
        Factory factory = this.abdera.getFactory();
        Entry entry = factory.newEntry();
        entry.setId(this.baseURI + "/atom" + RemoteRegistry.encodeURL(suggestedPath));
        entry.setTitle(suggestedPath);
        entry.setSummary(resource.getDescription());
        entry.addAuthor(this.username);
        entry.setUpdated(new Date());
        java.util.Properties properties = resource.getProperties();
        RemoteRegistry.addPropertyExtensionElement(properties, factory, (ExtensibleElement)entry, PropertyExtensionFactory.PROPERTIES, PropertyExtensionFactory.PROPERTY);
        String mediaType = resource.getMediaType();
        if (mediaType != null && mediaType.length() > 0) {
            entry.addSimpleExtension(new QName("http://wso2.org/registry", "mediaType"), mediaType);
        }
        entry.addSimpleExtension(new QName("http://wso2.org/registry", "parentPath"), resource.getParentPath());
        if (((ResourceImpl)resource).isContentModified()) {
            entry.addSimpleExtension(new QName("http://wso2.org/registry", "contentModified"), "true");
        }
        if (resource.getUUID() != null) {
            entry.addSimpleExtension(APPConstants.QN_UUID_TYPE, resource.getUUID());
        }
        RequestOptions opts = this.getAuthorization();
        opts.setSlug(suggestedPath);
        opts.setContentType(resource.getMediaType());
        ClientResponse response = abderaClient.post(this.baseURI + "/atom" + "?importURL=" + RemoteRegistry.encodeURL(sourceURL + ";" + "application/resource-import"), (Base)entry, opts);
        if (response.getType() == Response.ResponseType.SUCCESS) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("resource at " + sourceURL + " imported., Response Status: " + response.getStatus() + ", Response Type: " + response.getType()));
            }
            abderaClient.teardown();
            String location = response.getLocation().toString();
            if (location.startsWith(this.baseURI)) {
                return location.substring(this.baseURI.length() + "/atom".length()).replace("+", " ");
            }
            return location.replace("+", " ");
        }
        String msg = "failed to import resource at " + sourceURL + "., Response Status: " + response.getStatus() + ", Response Type: " + response.getType();
        abderaClient.teardown();
        this.log.error((Object)msg);
        throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg);
    }

    @Override
    public void delete(String path) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        AbderaClient abderaClient = new AbderaClient(this.abdera);
        ClientResponse resp = abderaClient.delete(this.baseURI + "/atom" + RemoteRegistry.encodeURL(path), this.getAuthorization());
        if (resp.getType() == Response.ResponseType.SUCCESS) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("resource at " + path + " deleted, Response Status: " + resp.getStatus() + ", Response Type: " + resp.getType()));
            }
        } else {
            String msg = "resource at " + path + " delete failed, Response Status: " + resp.getStatus() + ", Response Type: " + resp.getType();
            abderaClient.teardown();
            this.log.error((Object)msg);
            throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg);
        }
        abderaClient.teardown();
    }

    @Override
    public String rename(String currentPath, String newPath) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        AbderaClient abderaClient = new AbderaClient(this.abdera);
        ByteArrayInputStream is = new ByteArrayInputStream(newPath.getBytes());
        ClientResponse resp = abderaClient.post(this.baseURI + "/atom" + RemoteRegistry.encodeURL(currentPath + ";" + "rename"), (InputStream)is, this.getAuthorization().setContentType(TEXT_PLAIN_MEDIA_TYPE));
        if (resp.getType() == Response.ResponseType.SUCCESS) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("resource rename " + currentPath + " to " + newPath + "  succeeded" + this.getStatusAndType(resp)));
            }
        } else {
            String msg = "resource rename from " + currentPath + " to " + newPath + " failed" + this.getStatusAndType(resp);
            abderaClient.teardown();
            this.log.error((Object)msg);
            throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg);
        }
        abderaClient.teardown();
        return newPath;
    }

    private String getStatusAndType(ClientResponse resp) {
        return ", Response Status: " + resp.getStatus() + ", Response Type: " + resp.getType();
    }

    @Override
    public String move(String currentPath, String newPath) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        AbderaClient abderaClient = new AbderaClient(this.abdera);
        ByteArrayInputStream is = new ByteArrayInputStream(newPath.getBytes());
        ClientResponse resp = abderaClient.post(this.baseURI + "/atom" + RemoteRegistry.encodeURL(currentPath + ";" + "move"), (InputStream)is, this.getAuthorization().setContentType(TEXT_PLAIN_MEDIA_TYPE));
        if (resp.getType() == Response.ResponseType.SUCCESS) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("resource move  from " + currentPath + " to " + newPath + " succeeded" + this.getStatusAndType(resp)));
            }
        } else {
            String msg = "resource move from " + currentPath + " to " + newPath + " failed" + this.getStatusAndType(resp);
            abderaClient.teardown();
            this.log.error((Object)msg);
            throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg);
        }
        abderaClient.teardown();
        return newPath;
    }

    @Override
    public String copy(String sourcePath, String targetPath) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        AbderaClient abderaClient = new AbderaClient(this.abdera);
        ByteArrayInputStream is = new ByteArrayInputStream(targetPath.getBytes());
        ClientResponse resp = abderaClient.post(this.baseURI + "/atom" + RemoteRegistry.encodeURL(sourcePath + ";" + "copy"), (InputStream)is, this.getAuthorization().setContentType(TEXT_PLAIN_MEDIA_TYPE));
        if (resp.getType() == Response.ResponseType.SUCCESS) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("resource copy from " + sourcePath + " to " + targetPath + " succeeded" + this.getStatusAndType(resp)));
            }
        } else {
            String msg = "resource copy from " + sourcePath + " to " + targetPath + "  failed" + this.getStatusAndType(resp);
            abderaClient.teardown();
            this.log.error((Object)msg);
            throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg);
        }
        abderaClient.teardown();
        return targetPath;
    }

    @Override
    public void createVersion(String path) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        AbderaClient abderaClient = new AbderaClient(this.abdera);
        ByteArrayInputStream is = new ByteArrayInputStream("createVersion".getBytes());
        ClientResponse clientResponse = abderaClient.post(this.baseURI + "/atom" + RemoteRegistry.encodeURL(path + ";" + "checkpoint"), (InputStream)is, this.getAuthorization().setContentType(TEXT_PLAIN_MEDIA_TYPE));
        int status = clientResponse.getStatus();
        if (status < 200 || status > 299) {
            org.wso2.carbon.registry.core.exceptions.RegistryException e = status == 404 ? new ResourceNotFoundException(path) : new org.wso2.carbon.registry.core.exceptions.RegistryException("Response Status: " + clientResponse.getStatusText());
            abderaClient.teardown();
            throw e;
        }
        abderaClient.teardown();
    }

    @Override
    public String[] getVersions(String path) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        AbderaClient abderaClient = new AbderaClient(this.abdera);
        ClientResponse clientResponse = abderaClient.get(this.baseURI + "/atom" + RemoteRegistry.encodeURL(path + ";" + "versions"), this.getAuthorization());
        Document introspection = clientResponse.getDocument();
        Feed feed = (Feed)introspection.getRoot();
        List entries = feed.getEntries();
        if (entries != null) {
            String[] versions = new String[entries.size()];
            for (int i = 0; i < entries.size(); ++i) {
                Entry entry = (Entry)entries.get(i);
                versions[i] = Utils.getLinkWithRel(entry, "versionLink").getHref().toString();
            }
            abderaClient.teardown();
            return versions;
        }
        abderaClient.teardown();
        return new String[0];
    }

    @Override
    public void restoreVersion(String versionPath) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        AbderaClient abderaClient = new AbderaClient(this.abdera);
        Entry entry = this.abdera.getFactory().newEntry();
        ClientResponse resp = abderaClient.post(this.baseURI + "/atom" + RemoteRegistry.encodeURL(versionPath + ";" + "restore"), (Base)entry, this.getAuthorization());
        if (resp.getType() == Response.ResponseType.SUCCESS) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("resource restore to " + versionPath + " succeeded" + this.getStatusAndType(resp)));
            }
        } else {
            String msg = "resource restore " + versionPath + "  failed" + this.getStatusAndType(resp);
            abderaClient.teardown();
            this.log.error((Object)msg);
            throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg);
        }
        abderaClient.teardown();
    }

    @Override
    public void addAssociation(String sourcePath, String associationPaths, String associationType) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        AbderaClient abderaClient = new AbderaClient(this.abdera);
        Factory factory = this.abdera.getFactory();
        Element el = factory.newElement(APPConstants.QN_ASSOC);
        el.setAttributeValue("type", associationType);
        el.setText(associationPaths);
        ClientResponse resp = abderaClient.post(this.baseURI + "/atom" + RemoteRegistry.encodeURL(sourcePath + ";" + "associations"), (Base)el, this.getAuthorization());
        if (resp.getType() == Response.ResponseType.SUCCESS) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("associating " + sourcePath + " to " + associationPaths + " type " + associationType + " succeeded" + this.getStatusAndType(resp)));
            }
        } else {
            String msg = "associating " + sourcePath + " to " + associationPaths + " type " + associationType + "failed" + this.getStatusAndType(resp);
            abderaClient.teardown();
            this.log.error((Object)msg);
            throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg);
        }
        abderaClient.teardown();
    }

    @Override
    public void removeAssociation(String sourcePath, String associationPaths, String associationType) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        AbderaClient abderaClient = new AbderaClient(this.abdera);
        Factory factory = this.abdera.getFactory();
        Element el = factory.newElement(APPConstants.QN_ASSOC);
        el.setAttributeValue("type", associationType);
        el.setText(associationPaths);
        RequestOptions requestOptions = this.getAuthorization();
        requestOptions.setHeader("Destination", associationPaths);
        requestOptions.setHeader("AssociationType", associationType);
        ClientResponse resp = abderaClient.delete(this.baseURI + "/atom" + RemoteRegistry.encodeURL(sourcePath + ";" + "associations"), requestOptions);
        if (resp.getType() == Response.ResponseType.SUCCESS) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("remove association " + sourcePath + " to " + associationPaths + " type " + associationType + " succeeded" + this.getStatusAndType(resp)));
            }
        } else {
            String msg = "remove association " + sourcePath + " to " + associationPaths + " type " + associationType + "failed" + this.getStatusAndType(resp);
            this.log.error((Object)msg);
            abderaClient.teardown();
            throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg);
        }
        abderaClient.teardown();
    }

    @Override
    public Association[] getAllAssociations(String resourcePath) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        AbderaClient abderaClient = new AbderaClient(this.abdera);
        ClientResponse resp = abderaClient.get(this.baseURI + "/atom" + RemoteRegistry.encodeURL(resourcePath + ";" + "associations"), this.getAuthorization());
        if (resp.getType() == Response.ResponseType.SUCCESS) {
            Document introspection = resp.getDocument();
            Feed feed = (Feed)introspection.getRoot();
            Association[] associations = RemoteRegistry.getAssociationsFromFeed(feed);
            abderaClient.teardown();
            return associations;
        }
        String msg = "uanble to get all associations for path " + resourcePath + this.getStatusAndType(resp);
        this.log.error((Object)msg);
        abderaClient.teardown();
        throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg);
    }

    private static Association[] getAssociationsFromFeed(Feed feed) {
        List entries = feed.getEntries();
        Association[] associations = null;
        if (entries != null) {
            associations = new Association[entries.size()];
            for (int i = 0; i < entries.size(); ++i) {
                Entry entry = (Entry)entries.get(i);
                Association association = new Association();
                association.setSourcePath(entry.getTitle());
                association.setDestinationPath(entry.getContent());
                association.setAssociationType(entry.getSummary());
                associations[i] = association;
            }
        }
        return associations;
    }

    @Override
    public Association[] getAssociations(String resourcePath, String associationType) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        AbderaClient abderaClient = new AbderaClient(this.abdera);
        ClientResponse clientResponse = abderaClient.get(this.baseURI + "/atom" + RemoteRegistry.encodeURL(resourcePath + ";" + "associations" + ":" + associationType), this.getAuthorization());
        Document introspection = clientResponse.getDocument();
        Feed feed = (Feed)introspection.getRoot();
        List entries = feed.getEntries();
        Association[] associations = null;
        if (entries != null) {
            associations = new Association[entries.size()];
            for (int i = 0; i < entries.size(); ++i) {
                Entry entry = (Entry)entries.get(i);
                Association association = new Association();
                association.setSourcePath(entry.getTitle());
                association.setDestinationPath(entry.getContent());
                association.setAssociationType(entry.getSummary());
                associations[i] = association;
            }
        }
        abderaClient.teardown();
        return associations;
    }

    @Override
    public void applyTag(String resourcePath, String tag) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        AbderaClient abderaClient = new AbderaClient(this.abdera);
        Entry entry = this.abdera.getFactory().newEntry();
        entry.setContent(tag);
        ClientResponse resp = abderaClient.post(this.baseURI + "/atom" + RemoteRegistry.encodeURL(resourcePath + ";" + "tags"), (Base)entry, this.getAuthorization());
        if (resp.getType() == Response.ResponseType.SUCCESS) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Applying tag: " + tag + " for resourcePath + " + resourcePath + " succeeded." + this.getStatusAndType(resp)));
            }
        } else {
            String msg = "Applying tag: " + tag + " for resourcePath + " + resourcePath + " failed." + this.getStatusAndType(resp);
            abderaClient.teardown();
            this.log.error((Object)msg);
            throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg);
        }
        abderaClient.teardown();
    }

    @Override
    public TaggedResourcePath[] getResourcePathsWithTag(String tag) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        AbderaClient abderaClient = new AbderaClient(this.abdera);
        ClientResponse clientResponse = abderaClient.get(this.baseURI + "/tags/" + tag, this.getAuthorization());
        Document introspection = clientResponse.getDocument();
        Feed feed = (Feed)introspection.getRoot();
        List entries = feed.getEntries();
        TaggedResourcePath[] taggedResourcePaths = null;
        if (entries != null) {
            taggedResourcePaths = new TaggedResourcePath[entries.size()];
            for (int i = 0; i < entries.size(); ++i) {
                Entry entry = (Entry)entries.get(i);
                Properties properties = (Properties)entry.getExtension(PropertyExtensionFactory.TAGS);
                List propertyList = properties.getExtensions(PropertyExtensionFactory.TAG);
                HashMap<String, String> map = new HashMap<String, String>();
                for (Object aPropertyList : propertyList) {
                    Property property = (Property)((Object)aPropertyList);
                    PropertyName pn = (PropertyName)property.getExtension(PropertyExtensionFactory.PROPERTY_NAME);
                    PropertyValue pv = (PropertyValue)property.getExtension(PropertyExtensionFactory.PROPERTY_VALUE);
                    map.put(pn.getText(), pv.getText());
                }
                TaggedResourcePath tagPath = new TaggedResourcePath();
                tagPath.setResourcePath(entry.getTitle());
                tagPath.setTagCount(Long.parseLong(entry.getSimpleExtension(new QName("http://wso2.org/registry", "taggings"))));
                taggedResourcePaths[i] = tagPath;
                tagPath.setTagCounts(map);
            }
        }
        abderaClient.teardown();
        return taggedResourcePaths;
    }

    @Override
    public Tag[] getTags(String resourcePath) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        AbderaClient abderaClient = new AbderaClient(this.abdera);
        ClientResponse clientResponse = abderaClient.get(this.baseURI + "/atom" + RemoteRegistry.encodeURL(resourcePath + ";" + "tags"), this.getAuthorization());
        Document introspection = clientResponse.getDocument();
        Feed feed = (Feed)introspection.getRoot();
        List entries = feed.getEntries();
        Tag[] tags = null;
        if (entries != null) {
            tags = new Tag[entries.size()];
            for (int i = 0; i < entries.size(); ++i) {
                Entry entry = (Entry)entries.get(i);
                Tag tag = new Tag();
                tag.setTagCount(Long.parseLong(entry.getSimpleExtension(new QName("http://wso2.org/registry", "taggings"))));
                tag.setTagName(entry.getTitle());
                tags[i] = tag;
            }
        }
        abderaClient.teardown();
        return tags;
    }

    @Override
    public void removeTag(String path, String tag) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        String encodedTag;
        AbderaClient abderaClient = new AbderaClient(this.abdera);
        try {
            encodedTag = URLEncoder.encode(tag, "utf-8");
        }
        catch (Exception e) {
            this.log.error((Object)"An exception occurred while processing removeTag request", (Throwable)e);
            return;
        }
        ClientResponse resp = abderaClient.delete(this.baseURI + "/atom" + RemoteRegistry.encodeURL(path + ";") + "tag:" + encodedTag, this.getAuthorization());
        if (resp.getType() == Response.ResponseType.SUCCESS) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Removing tag: " + tag + " for resourcePath + " + path + " succeeded." + this.getStatusAndType(resp)));
            }
        } else {
            String msg = "Removing tag: " + tag + " for resourcePath + " + path + " failed." + this.getStatusAndType(resp);
            abderaClient.teardown();
            this.log.error((Object)msg);
            throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg);
        }
        abderaClient.teardown();
    }

    public String addComment(String resourcePath, org.wso2.carbon.registry.api.Comment comment) throws RegistryException {
        return this.addComment(resourcePath, (Comment)comment);
    }

    @Override
    public String addComment(String resourcePath, Comment comment) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        AbderaClient abderaClient = new AbderaClient(this.abdera);
        Entry entry = this.abdera.getFactory().newEntry();
        entry.setId("tag:commentID");
        entry.setTitle("Comment");
        entry.setUpdated(comment.getCreatedTime());
        entry.addAuthor(comment.getUser());
        entry.setContent(comment.getText());
        ClientResponse resp = abderaClient.post(this.baseURI + "/atom" + RemoteRegistry.encodeURL(resourcePath + ";" + "comments"), (Base)entry, this.getAuthorization());
        if (resp.getType() == Response.ResponseType.SUCCESS) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Adding comment for resourcePath + " + resourcePath + " succeeded." + this.getStatusAndType(resp)));
            }
            abderaClient.teardown();
            String location = resp.getLocation().toString();
            if (location.startsWith(this.baseURI)) {
                return location.substring(this.baseURI.length() + "/atom".length()).replace("+", " ");
            }
            return location.replace("+", " ");
        }
        String msg = "Adding comment for resourcePath + " + resourcePath + " failed." + this.getStatusAndType(resp);
        abderaClient.teardown();
        this.log.error((Object)msg);
        throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg);
    }

    @Override
    public void editComment(String commentPath, String text) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        AbderaClient abderaClient = new AbderaClient(this.abdera);
        Entry entry = this.abdera.getFactory().newEntry();
        entry.setContent(text);
        ClientResponse resp = abderaClient.put(this.baseURI + "/atom" + RemoteRegistry.encodeURL(commentPath), (Base)entry, this.getAuthorization());
        if (resp.getType() == Response.ResponseType.SUCCESS) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Editing comment for resourcePath + " + commentPath + " succeeded." + this.getStatusAndType(resp)));
            }
        } else {
            String msg = "Editing comment for resourcePath + " + commentPath + " failed." + this.getStatusAndType(resp);
            abderaClient.teardown();
            this.log.error((Object)msg);
            throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg);
        }
        abderaClient.teardown();
    }

    @Override
    public Comment[] getComments(String _resourcePath) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        AbderaClient abderaClient = new AbderaClient(this.abdera);
        String resourcePath = _resourcePath;
        if ((resourcePath = RemoteRegistry.encodeURL(resourcePath)).contains(";version:")) {
            int index = resourcePath.lastIndexOf(";version:");
            resourcePath = resourcePath.substring(0, index).replace(":", "%3A") + resourcePath.substring(index);
        } else {
            resourcePath = resourcePath.replace(":", "%3A");
        }
        ClientResponse clientResponse = abderaClient.get(this.baseURI + "/atom" + resourcePath + ";" + "comments", this.getAuthorization());
        Document introspection = clientResponse.getDocument();
        Element element = introspection.getRoot();
        Feed feed = (Feed)element;
        Comment[] comments = this.getCommentsFromFeed(feed);
        abderaClient.teardown();
        return comments;
    }

    private Comment[] getCommentsFromFeed(Feed feed) {
        List entries = feed.getEntries();
        Comment[] comments = null;
        if (entries != null) {
            comments = new Comment[entries.size()];
            for (int i = 0; i < entries.size(); ++i) {
                Link pathLink;
                Link resourceLink;
                Entry entry = (Entry)entries.get(i);
                Comment comment = new Comment();
                if (entry.getUpdated() != null) {
                    comment.setCreatedTime(entry.getUpdated());
                }
                if ((resourceLink = Utils.getLinkWithRel(entry, "resourcePath")) != null) {
                    comment.setResourcePath(URLDecoder.decode(resourceLink.getHref().toString()));
                }
                if ((pathLink = Utils.getLinkWithRel(entry, "path")) != null) {
                    String path = URLDecoder.decode(pathLink.getHref().toString());
                    comment.setPath(path);
                    comment.setCommentPath(path);
                }
                comment.setText(entry.getContent());
                comment.setUser(entry.getAuthor().getName());
                comments[i] = comment;
            }
        }
        return comments;
    }

    @Override
    public void rateResource(String resourcePath, int rating) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        AbderaClient abderaClient = new AbderaClient(this.abdera);
        ByteArrayInputStream is = new ByteArrayInputStream(Integer.toString(rating).getBytes());
        ClientResponse resp = abderaClient.post(this.baseURI + "/atom" + RemoteRegistry.encodeURL(resourcePath + ";" + "ratings"), (InputStream)is, this.getAuthorization().setContentType(TEXT_PLAIN_MEDIA_TYPE));
        if (resp.getType() == Response.ResponseType.SUCCESS) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("rating resource + " + resourcePath + " succeeded." + this.getStatusAndType(resp)));
            }
        } else {
            String msg = "rating resource + " + resourcePath + " failed." + this.getStatusAndType(resp);
            abderaClient.teardown();
            this.log.error((Object)msg);
            throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg);
        }
        abderaClient.teardown();
    }

    @Override
    public float getAverageRating(String resourcePath) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        AbderaClient abderaClient = new AbderaClient(this.abdera);
        ClientResponse clientResponse = abderaClient.get(this.baseURI + "/atom" + RemoteRegistry.encodeURL(resourcePath + ";" + "ratings"), this.getAuthorization());
        if (clientResponse.getStatus() != 200) {
            String msg = "Getting average rating failed. Path: " + resourcePath + ", Response Status: " + clientResponse.getStatus() + ", Response Type: " + clientResponse.getType();
            abderaClient.teardown();
            this.log.error((Object)msg);
            throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg);
        }
        Document introspection = clientResponse.getDocument();
        if (introspection.getRoot() instanceof Feed) {
            Feed feed = (Feed)introspection.getRoot();
            String floatValue = feed.getSimpleExtension(APPConstants.QN_AVERAGE_RATING);
            abderaClient.teardown();
            return Float.parseFloat(floatValue);
        }
        return 0.0f;
    }

    @Override
    public int getRating(String path, String userName) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        Feed feed;
        List entries;
        AbderaClient abderaClient = new AbderaClient(this.abdera);
        ClientResponse clientResponse = abderaClient.get(this.baseURI + "/atom" + RemoteRegistry.encodeURL(path + ";" + "ratings" + ":" + userName), this.getAuthorization());
        Document introspection = clientResponse.getDocument();
        if (introspection.getRoot() instanceof Feed && (entries = (feed = (Feed)introspection.getRoot()).getEntries()).size() == 1) {
            String intValue = ((Entry)entries.get(0)).getContent();
            abderaClient.teardown();
            return Integer.parseInt(intValue);
        }
        String msg = "Getting rating failed. Path: " + path;
        abderaClient.teardown();
        this.log.error((Object)msg);
        throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg);
    }

    @Override
    public Collection executeQuery(String path, Map parameters) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        AbderaClient abderaClient = new AbderaClient(this.abdera);
        RequestOptions requestOptions = this.getAuthorization();
        if (path == null) {
            path = "/";
        }
        ClientResponse resp = abderaClient.get(this.baseURI + "/atom" + RemoteRegistry.encodeURL(path + ";" + "query") + "?" + RemoteRegistry.buildQueryString(parameters), requestOptions);
        Document introspection = resp.getDocument();
        Feed feed = (Feed)introspection.getRoot();
        CollectionImpl c = this.createResourceFromFeed(feed);
        abderaClient.teardown();
        return c;
    }

    public static String buildQueryString(Map parameters) {
        StringBuffer buffer = new StringBuffer();
        boolean first = true;
        for (Object keyObj : parameters.keySet()) {
            String name = (String)keyObj;
            String value = (String)parameters.get(name);
            if (!first) {
                buffer.append("&");
            } else {
                first = false;
            }
            try {
                buffer.append(URLEncoder.encode(name, "utf-8"));
                buffer.append("=");
                buffer.append(URLEncoder.encode(value, "utf-8"));
            }
            catch (UnsupportedEncodingException e) {
                return "";
            }
        }
        return buffer.toString();
    }

    public static Map decodeQueryString(String _value) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        String value = _value;
        try {
            value = URLDecoder.decode(value, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
        for (String param : value.trim().split("&")) {
            if (param.trim().length() == 0) continue;
            param = param.trim();
            String paramKey = param.substring(0, param.indexOf(61));
            String paramValue = param.substring(param.indexOf(61) + 1);
            paramMap.put(paramKey, paramValue);
        }
        return paramMap;
    }

    @Override
    public LogEntry[] getLogs(String _resourcePath, int action, String userName, Date from, Date to, boolean recentFirst) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        String resourcePath = _resourcePath;
        if (resourcePath == null || "".equals(resourcePath)) {
            resourcePath = "/";
        }
        AbderaClient abderaClient = new AbderaClient(this.abdera);
        RequestOptions requestOptions = this.getAuthorization();
        requestOptions.addDateHeader("ToDate", to);
        requestOptions.addDateHeader("FromDate", from);
        requestOptions.addHeader("Action", "" + action);
        requestOptions.addHeader("Author", userName);
        ClientResponse resp = abderaClient.get(this.baseURI + "/atom" + RemoteRegistry.encodeURL(resourcePath + ";" + "logs"), requestOptions);
        Document introspection = resp.getDocument();
        Feed feed = (Feed)introspection.getRoot();
        List entries = feed.getEntries();
        LogEntry[] logs = null;
        if (entries != null) {
            logs = new LogEntry[entries.size()];
            for (int i = 0; i < entries.size(); ++i) {
                Entry entry = (Entry)entries.get(i);
                LogEntry logEntry = new LogEntry();
                logEntry.setDate(entry.getEdited());
                logEntry.setActionData(entry.getContent());
                logEntry.setUserName(entry.getAuthor().getName());
                logEntry.setAction(Integer.parseInt(entry.getSimpleExtension(new QName("http://wso2.org/registry", "action"))));
                String path = entry.getSimpleExtension(new QName("http://wso2.org/registry", "path"));
                logEntry.setResourcePath(path);
                logs[i] = logEntry;
            }
        }
        abderaClient.teardown();
        return logs;
    }

    @Override
    public LogEntryCollection getLogCollection(String resourcePath, int action, String userName, Date from, Date to, boolean recentFirst) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        throw new UnsupportedOperationException("Sorry we need to implement this method");
    }

    private RequestOptions getAuthorization() {
        RequestOptions requestOptions = new RequestOptions();
        requestOptions.setAuthorization(this.authorizationString);
        return requestOptions;
    }

    private RequestOptions getAuthorizationForCaching(String path) {
        RequestOptions requestOptions = new RequestOptions();
        requestOptions.setAuthorization(this.authorizationString);
        requestOptions.setHeader("if-none-match", cache.getETag(path));
        return requestOptions;
    }

    public static String encodeURL(String path) {
        String encodedRegistryPath = Utils.encodeRegistryPath(path);
        return encodedRegistryPath.replaceAll(" ", "+");
    }

    @Deprecated
    public void addUser(String userName, String password, String confirmPassword, String roleName, String friendlyName) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        throw new UnsupportedOperationException("This method is no longer supported.");
    }

    @Override
    public String[] getAvailableAspects() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void associateAspect(String resourcePath, String aspect) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        AbderaClient abderaClient = new AbderaClient(this.abdera);
        ByteArrayInputStream is = new ByteArrayInputStream(aspect.getBytes());
        ClientResponse resp = abderaClient.post(this.baseURI + "/atom" + RemoteRegistry.encodeURL(resourcePath + ";" + "aspects"), (InputStream)is, this.getAuthorization().setContentType(TEXT_PLAIN_MEDIA_TYPE));
        if (resp.getType() == Response.ResponseType.SUCCESS) {
            if (this.log.isDebugEnabled()) {
                String msg = "Resource associated to aspect " + this.getOnAppendedVal(aspect, resourcePath) + ".";
                this.log.debug((Object)msg);
            }
        } else {
            String msg = "Resource associated to aspect " + this.getOnAppendedVal(aspect, resourcePath) + ".";
            abderaClient.teardown();
            this.log.error((Object)msg);
            throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg);
        }
        abderaClient.teardown();
    }

    @Override
    public void invokeAspect(String resourcePath, String aspectName, String action) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        AbderaClient abderaClient = new AbderaClient(this.abdera);
        ByteArrayInputStream is = new ByteArrayInputStream("invoke".getBytes());
        ClientResponse resp = abderaClient.post(this.baseURI + "/atom" + RemoteRegistry.encodeURL(resourcePath + ";" + "aspect") + "(" + RemoteRegistry.encodeURL(aspectName) + ")" + action, (InputStream)is, this.getAuthorization().setContentType(TEXT_PLAIN_MEDIA_TYPE));
        if (resp.getType() == Response.ResponseType.SUCCESS) {
            if (this.log.isDebugEnabled()) {
                String msg = "Succeeded in invoking aspect " + this.getOnAppendedVal(aspectName, resourcePath) + " action " + action + ".";
                this.log.debug((Object)msg);
            }
        } else {
            String msg = "Couldn't invoke aspect " + this.getOnAppendedVal(aspectName, resourcePath) + " action " + action + ".";
            abderaClient.teardown();
            this.log.error((Object)msg);
            throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg);
        }
        abderaClient.teardown();
    }

    private String getOnAppendedVal(String aspect, String resourcePath) {
        return aspect + " on " + resourcePath;
    }

    @Override
    public void invokeAspect(String resourcePath, String aspectName, String action, Map<String, String> parameters) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        throw new UnsupportedOperationException("invokeAspect with parameters is not supported by Remote Registry");
    }

    @Override
    public boolean removeAspect(String aspect) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        throw new UnsupportedOperationException("removeAspect method is not supported by Remote Registry");
    }

    @Override
    public boolean addAspect(String name, Aspect aspect) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        throw new UnsupportedOperationException("removeAspect method is not supported by Remote Registry");
    }

    @Override
    public void beginTransaction() throws org.wso2.carbon.registry.core.exceptions.RegistryException {
    }

    @Override
    public void commitTransaction() throws org.wso2.carbon.registry.core.exceptions.RegistryException {
    }

    @Override
    public void rollbackTransaction() throws org.wso2.carbon.registry.core.exceptions.RegistryException {
    }

    @Override
    public String[] getAspectActions(String resourcePath, String aspectName) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        AbderaClient abderaClient = new AbderaClient(this.abdera);
        ClientResponse clientResponse = abderaClient.get(this.baseURI + "/atom" + RemoteRegistry.encodeURL(resourcePath + ";" + "aspect") + "(" + RemoteRegistry.encodeURL(aspectName) + ")", this.getAuthorization());
        Document introspection = clientResponse.getDocument();
        Feed feed = (Feed)introspection.getRoot();
        List entries = feed.getEntries();
        if (entries != null) {
            String[] aspectActions = new String[entries.size()];
            for (int i = 0; i < entries.size(); ++i) {
                Entry entry = (Entry)entries.get(i);
                aspectActions[i] = entry.getContent();
            }
            abderaClient.teardown();
            return aspectActions;
        }
        abderaClient.teardown();
        return new String[0];
    }

    @Override
    public RegistryContext getRegistryContext() {
        return RegistryContext.getBaseInstance();
    }

    @Override
    public Collection searchContent(String keywords) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void createLink(String path, String target) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void createLink(String path, String target, String subTargetPath) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeLink(String path) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void restore(String path, Reader reader) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        AbderaClient abderaClient = new AbderaClient(this.abdera);
        this.restore(path, reader, abderaClient);
    }

    @Override
    public void dump(String path, Writer writer) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        AbderaClient abderaClient = new AbderaClient(this.abdera);
        this.dump(path, abderaClient, writer);
    }

    public void restore(String path, Reader reader, int timeout) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        AbderaClient abderaClient = new AbderaClient(this.abdera);
        abderaClient.setSocketTimeout(timeout);
        this.restore(path, reader, abderaClient);
        abderaClient.teardown();
    }

    public void dump(String path, int timeout, Writer writer) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        AbderaClient abderaClient = new AbderaClient(this.abdera);
        abderaClient.setSocketTimeout(timeout);
        this.dump(path, abderaClient, writer);
        abderaClient.teardown();
    }

    private void restore(String path, Reader reader, AbderaClient abderaClient) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        ReaderInputStream is = new ReaderInputStream(reader, StandardCharsets.UTF_8);
        ClientResponse resp = abderaClient.post(this.baseURI + "/atom" + RemoteRegistry.encodeURL(path + ";" + "dump"), (InputStream)is, this.getAuthorization());
        if (resp.getType() == Response.ResponseType.SUCCESS) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("resource dump restored at " + path));
            }
        } else {
            String msg = "Restoring to " + path + " failed.";
            this.log.error((Object)msg);
            throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg);
        }
    }

    private void dump(String path, AbderaClient abderaClient, Writer writer) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        ClientResponse clientResponse = abderaClient.get(this.baseURI + "/atom" + RemoteRegistry.encodeURL(path + ";" + "dump"), this.getAuthorization());
        if (clientResponse.getType() == Response.ResponseType.SUCCESS) {
            Document introspection = clientResponse.getDocument();
            Element element = introspection.getRoot();
            if (element instanceof OMElement) {
                try {
                    ((OMElement)element).serialize(writer);
                }
                catch (XMLStreamException e) {
                    throw new org.wso2.carbon.registry.core.exceptions.RegistryException("Failed to serialize the xml", e);
                }
            }
        } else {
            String msg = "Failed to serialize the xml. Received Response: " + clientResponse.getStatusText();
            this.log.error((Object)msg);
            throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg);
        }
    }

    @Override
    public String getEventingServiceURL(String path) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setEventingServiceURL(String path, String eventingServiceURL) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeComment(String commentPath) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        AbderaClient abderaClient = new AbderaClient(this.abdera);
        String resourcePath = commentPath.substring(0, commentPath.indexOf(";comments:"));
        int commentId = Integer.parseInt(commentPath.substring(commentPath.indexOf(";comments:") + ";comments:".length()));
        ClientResponse resp = abderaClient.delete(this.baseURI + "/atom" + RemoteRegistry.encodeURL(resourcePath + ";") + "comment:" + commentId, this.getAuthorization());
        if (resp.getType() == Response.ResponseType.SUCCESS) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Removing comment: " + commentId + " for resourcePath + " + resourcePath + " succeeded." + this.getStatusAndType(resp)));
            }
        } else {
            String msg = "Removing comment: " + commentId + " for resourcePath + " + resourcePath + " succeeded." + this.getStatusAndType(resp);
            abderaClient.teardown();
            this.log.error((Object)msg);
            throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg);
        }
        abderaClient.teardown();
    }

    @Override
    public boolean removeVersionHistory(String path, long snapshotId) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        throw new UnsupportedOperationException("Operation not permitted");
    }

    private String getFilteredTenantCountedContentURL(String srcIri) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        String url;
        if (srcIri.startsWith(this.baseURI)) {
            return srcIri;
        }
        String protocol = "";
        try {
            if (this.baseURI.startsWith("https")) {
                protocol = "https";
            } else if (this.baseURI.startsWith("http")) {
                protocol = "http";
            }
            String hostDomain = protocol + "://" + new URL(srcIri).getHost() + ":" + new URL(srcIri).getPort();
            String srcUriReplace = hostDomain + "/registry/";
            url = srcIri.replace(srcUriReplace, this.baseURI + "/");
        }
        catch (MalformedURLException e) {
            throw new org.wso2.carbon.registry.core.exceptions.RegistryException("Malformed Host Url " + srcIri);
        }
        return url;
    }

    @Override
    public void dumpLite(String path, Writer writer) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        AbderaClient abderaClient = new AbderaClient(this.abdera);
        this.dumpLite(path, abderaClient, writer);
    }

    public void dumpLite(String path, int timeout, Writer writer) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        AbderaClient abderaClient = new AbderaClient(this.abdera);
        abderaClient.setSocketTimeout(timeout);
        this.dumpLite(path, abderaClient, writer);
        abderaClient.teardown();
    }

    private void dumpLite(String path, AbderaClient abderaClient, Writer writer) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        ClientResponse clientResponse = abderaClient.get(this.baseURI + "/atom" + RemoteRegistry.encodeURL(path + ";" + "dump"), this.getAuthorization());
        if (clientResponse.getType() == Response.ResponseType.SUCCESS) {
            Document introspection = clientResponse.getDocument();
            Element element = introspection.getRoot();
            if (element instanceof OMElement) {
                try {
                    ((OMElement)element).serialize(writer);
                }
                catch (XMLStreamException e) {
                    throw new org.wso2.carbon.registry.core.exceptions.RegistryException("Failed to serialize the xml", e);
                }
            }
        } else {
            String msg = "Failed to serialize the xml. Received Response: " + clientResponse.getStatusText();
            this.log.error((Object)msg);
            throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg);
        }
    }
}

