/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.handler.event.account.lock.util;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.email.mgt.exceptions.I18nEmailMgtException;
import org.wso2.carbon.identity.application.common.model.Property;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.event.IdentityEventException;
import org.wso2.carbon.identity.governance.IdentityGovernanceException;
import org.wso2.carbon.identity.governance.IdentityGovernanceService;
import org.wso2.carbon.identity.handler.event.account.lock.exception.AccountLockException;
import org.wso2.carbon.identity.handler.event.account.lock.exception.AccountLockRuntimeException;
import org.wso2.carbon.identity.handler.event.account.lock.internal.AccountServiceDataHolder;
import org.wso2.carbon.user.api.Claim;
import org.wso2.carbon.user.api.ClaimManager;
import org.wso2.carbon.user.api.UserRealm;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.api.UserStoreManager;
import org.wso2.carbon.user.core.service.RealmService;

public class AccountUtil {
    private static final Log log = LogFactory.getLog(AccountUtil.class);

    public static String getUserStoreDomainName(UserStoreManager userStoreManager) {
        String domainNameProperty = null;
        if (userStoreManager instanceof org.wso2.carbon.user.core.UserStoreManager && StringUtils.isBlank((String)(domainNameProperty = ((org.wso2.carbon.user.core.UserStoreManager)userStoreManager).getRealmConfiguration().getUserStoreProperty("DomainName")))) {
            domainNameProperty = IdentityUtil.getPrimaryDomainName();
        }
        return domainNameProperty;
    }

    public static String getTenantDomain(UserStoreManager userStoreManager) {
        try {
            return IdentityTenantUtil.getTenantDomain((int)userStoreManager.getTenantId());
        }
        catch (UserStoreException e) {
            throw AccountLockRuntimeException.error(e.getMessage(), e);
        }
    }

    public static String getConnectorConfig(String key, String tenantDomain) throws IdentityEventException {
        try {
            Property[] connectorConfigs;
            IdentityGovernanceService identityGovernanceService = AccountServiceDataHolder.getInstance().getIdentityGovernanceService();
            if (identityGovernanceService != null && (connectorConfigs = identityGovernanceService.getConfiguration(new String[]{key}, tenantDomain)) != null && connectorConfigs.length > 0) {
                return connectorConfigs[0].getValue();
            }
            return null;
        }
        catch (IdentityGovernanceException e) {
            throw new IdentityEventException("Error while getting connector configurations for property :" + key, (Throwable)e);
        }
    }

    public static boolean isAccountStateClaimExisting(String tenantDomain) throws AccountLockException {
        UserRealm userRealm = null;
        ClaimManager claimManager = null;
        RealmService realmService = AccountServiceDataHolder.getInstance().getRealmService();
        if (realmService != null) {
            try {
                int tenantId = realmService.getTenantManager().getTenantId(tenantDomain);
                userRealm = realmService.getTenantUserRealm(tenantId);
            }
            catch (UserStoreException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Error while retriving user realm in AccountUtil", (Throwable)e);
                }
                throw new AccountLockException("Error while retriving user realm in AccountUtil");
            }
        }
        if (userRealm != null) {
            try {
                claimManager = userRealm.getClaimManager();
            }
            catch (UserStoreException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Error while retriving claim manager in AccountUtil", (Throwable)e);
                }
                throw new AccountLockException("Error while retriving claim manager in AccountUtil");
            }
        }
        boolean isExist = false;
        try {
            Claim claim = claimManager.getClaim("http://wso2.org/claims/identity/accountState");
            if (claim != null) {
                isExist = true;
            }
        }
        catch (UserStoreException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Error while checking accountState claim  from ClaimManager in AccountUtil", (Throwable)e);
            }
            throw new AccountLockException("Error while checking accountState claim  from ClaimManager");
        }
        return isExist;
    }

    public static boolean isTemplateExists(String templateType, String tenantDomain) throws AccountLockException {
        try {
            return AccountServiceDataHolder.getInstance().getEmailTemplateManager().isEmailTemplateTypeExists(templateType, tenantDomain);
        }
        catch (I18nEmailMgtException e) {
            throw new AccountLockException("Error occurred while checking email template type: " + templateType + " existence in the tenantDomain: " + tenantDomain, e);
        }
    }
}

