/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.handler.event.account.lock.service;

import java.util.Map;
import org.apache.commons.lang.math.NumberUtils;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.handler.event.account.lock.exception.AccountLockServiceException;
import org.wso2.carbon.identity.handler.event.account.lock.internal.AccountServiceDataHolder;
import org.wso2.carbon.identity.handler.event.account.lock.service.AccountLockService;
import org.wso2.carbon.user.api.UserRealm;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.api.UserStoreManager;

public class AccountLockServiceImpl
implements AccountLockService {
    @Override
    public boolean isAccountLocked(String domainAwareUsername, String tenantDomain) throws AccountLockServiceException {
        long accountUnlockTime;
        UserStoreManager userStoreManager = this.getUserStoreManager(tenantDomain);
        boolean accountLocked = this.getAccountLockClaimValue(domainAwareUsername, userStoreManager);
        if (accountLocked && (accountUnlockTime = this.getAccountUnlockTimeClaimValue(domainAwareUsername, userStoreManager)) != 0L && System.currentTimeMillis() >= accountUnlockTime) {
            return false;
        }
        return accountLocked;
    }

    @Override
    public boolean isAccountLocked(String username, String tenantDomain, String userStoreDomain) throws AccountLockServiceException {
        return this.isAccountLocked(IdentityUtil.addDomainToName((String)username, (String)userStoreDomain), tenantDomain);
    }

    private boolean getAccountLockClaimValue(String username, UserStoreManager userStoreManager) throws AccountLockServiceException {
        String accountLockedClaimValue = this.getClaimValue(username, userStoreManager, "http://wso2.org/claims/identity/accountLocked");
        return Boolean.parseBoolean(accountLockedClaimValue);
    }

    private long getAccountUnlockTimeClaimValue(String username, UserStoreManager userStoreManager) throws AccountLockServiceException {
        long unlockTime = 0L;
        String accountUnlockTimeClaimValue = this.getClaimValue(username, userStoreManager, "http://wso2.org/claims/identity/unlockTime");
        if (NumberUtils.isNumber((String)accountUnlockTimeClaimValue)) {
            unlockTime = Long.parseLong(accountUnlockTimeClaimValue);
        }
        return unlockTime;
    }

    private String getClaimValue(String username, UserStoreManager userStoreManager, String claimURI) throws AccountLockServiceException {
        try {
            Map values = userStoreManager.getUserClaimValues(username, new String[]{claimURI}, "default");
            return (String)values.get(claimURI);
        }
        catch (UserStoreException e) {
            throw new AccountLockServiceException("Error occurred while retrieving claim: " + claimURI, e);
        }
    }

    private UserStoreManager getUserStoreManager(String tenantDomain) throws AccountLockServiceException {
        UserRealm userRealm;
        int tenantId;
        try {
            tenantId = AccountServiceDataHolder.getInstance().getRealmService().getTenantManager().getTenantId(tenantDomain);
        }
        catch (UserStoreException e) {
            throw new AccountLockServiceException("Could not retrieve tenant id from tenant domain: " + tenantDomain, e);
        }
        if (-1 == tenantId) {
            throw new AccountLockServiceException("Invalid tenant domain: " + tenantDomain);
        }
        try {
            userRealm = AccountServiceDataHolder.getInstance().getRealmService().getTenantUserRealm(tenantId);
        }
        catch (UserStoreException e) {
            throw new AccountLockServiceException("Could not retrieve user realm for tenant domain: " + tenantDomain, e);
        }
        try {
            return userRealm.getUserStoreManager();
        }
        catch (UserStoreException e) {
            throw new AccountLockServiceException("Could not retrieve user store for tenant domain: " + tenantDomain, e);
        }
    }
}

