/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.handler.event.account.lock.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.email.mgt.EmailTemplateManager;
import org.wso2.carbon.identity.event.handler.AbstractEventHandler;
import org.wso2.carbon.identity.event.services.IdentityEventService;
import org.wso2.carbon.identity.governance.IdentityGovernanceService;
import org.wso2.carbon.identity.handler.event.account.lock.AccountDisableHandler;
import org.wso2.carbon.identity.handler.event.account.lock.AccountLockHandler;
import org.wso2.carbon.identity.handler.event.account.lock.internal.AccountServiceDataHolder;
import org.wso2.carbon.identity.handler.event.account.lock.listener.AccountLockTenantMgtListener;
import org.wso2.carbon.identity.handler.event.account.lock.service.AccountLockService;
import org.wso2.carbon.identity.handler.event.account.lock.service.AccountLockServiceImpl;
import org.wso2.carbon.stratos.common.listeners.TenantMgtListener;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.user.core.service.RealmService;

@Component(name="handler.event.account.lock", immediate=true)
public class AccountServiceComponent {
    private static final Log log = LogFactory.getLog(AccountServiceComponent.class);

    @Activate
    protected void activate(ComponentContext context) {
        try {
            AccountServiceDataHolder.getInstance().setBundleContext(context.getBundleContext());
            AccountLockHandler accountLockHandler = new AccountLockHandler();
            context.getBundleContext().registerService(AbstractEventHandler.class.getName(), (Object)accountLockHandler, null);
            if (log.isDebugEnabled()) {
                log.debug((Object)"AccountLockHandler is registered");
            }
            AccountDisableHandler accountDisableHandler = new AccountDisableHandler();
            context.getBundleContext().registerService(AbstractEventHandler.class.getName(), (Object)accountDisableHandler, null);
            if (log.isDebugEnabled()) {
                log.debug((Object)"AccountDisableHandler is registered");
            }
            AccountLockServiceImpl accountLockService = new AccountLockServiceImpl();
            context.getBundleContext().registerService(AccountLockService.class.getName(), (Object)accountLockService, null);
            if (log.isDebugEnabled()) {
                log.debug((Object)"AccountLockService is registered");
            }
            AccountLockTenantMgtListener accountLockTenantMgtListener = new AccountLockTenantMgtListener();
            context.getBundleContext().registerService(TenantMgtListener.class, (Object)accountLockTenantMgtListener, null);
            if (log.isDebugEnabled()) {
                log.debug((Object)"AccountLockTenantMgtListener is registered");
            }
            try {
                UserStoreManager userStoreManager = AccountServiceDataHolder.getInstance().getRealmService().getBootstrapRealm().getUserStoreManager();
                if (!userStoreManager.isExistingRole("Internal/system")) {
                    userStoreManager.addRole("Internal/system", null, null, false);
                }
            }
            catch (UserStoreException e) {
                log.error((Object)String.format("Error while adding role: %s .", "Internal/system"), (Throwable)e);
            }
        }
        catch (Exception e) {
            log.error((Object)"Error while activating account lock handler bundle.", (Throwable)e);
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"AccountLock bundle is de-activated");
        }
    }

    protected void unsetIdentityGovernanceService(IdentityGovernanceService identityGovernanceService) {
        AccountServiceDataHolder.getInstance().setIdentityGovernanceService(null);
    }

    @Reference(name="IdentityGovernanceService", service=IdentityGovernanceService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetIdentityGovernanceService")
    protected void setIdentityGovernanceService(IdentityGovernanceService identityGovernanceService) {
        AccountServiceDataHolder.getInstance().setIdentityGovernanceService(identityGovernanceService);
    }

    protected void unsetIdentityEventService(IdentityEventService eventService) {
        AccountServiceDataHolder.getInstance().setIdentityEventService(null);
    }

    @Reference(name="EventMgtService", service=IdentityEventService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetIdentityEventService")
    protected void setIdentityEventService(IdentityEventService eventService) {
        AccountServiceDataHolder.getInstance().setIdentityEventService(eventService);
    }

    @Reference(name="RealmService", service=RealmService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRealmService")
    protected void setRealmService(RealmService realmService) {
        AccountServiceDataHolder.getInstance().setRealmService(realmService);
    }

    protected void unsetRealmService(RealmService realmService) {
        AccountServiceDataHolder.getInstance().setRealmService(null);
    }

    @Reference(name="emailTemplateManager.service", service=EmailTemplateManager.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetEmailTemplateManager")
    protected void setEmailTemplateManager(EmailTemplateManager emailTemplateManager) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Email Template Manager is registered in Account service.");
        }
        AccountServiceDataHolder.getInstance().setEmailTemplateManager(emailTemplateManager);
    }

    protected void unsetEmailTemplateManager(EmailTemplateManager emailTemplateManager) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Email Template Manager is unregistered in Account service.");
        }
        AccountServiceDataHolder.getInstance().setEmailTemplateManager(null);
    }
}

