/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.handler.event.account.lock;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;
import org.slf4j.MDC;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.identity.application.common.model.Property;
import org.wso2.carbon.identity.core.bean.context.MessageContext;
import org.wso2.carbon.identity.core.handler.InitConfig;
import org.wso2.carbon.identity.core.model.IdentityErrorMsgContext;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.event.IdentityEventException;
import org.wso2.carbon.identity.event.event.Event;
import org.wso2.carbon.identity.event.handler.AbstractEventHandler;
import org.wso2.carbon.identity.governance.IdentityGovernanceException;
import org.wso2.carbon.identity.governance.common.IdentityConnectorConfig;
import org.wso2.carbon.identity.handler.event.account.lock.exception.AccountLockException;
import org.wso2.carbon.identity.handler.event.account.lock.internal.AccountServiceDataHolder;
import org.wso2.carbon.identity.handler.event.account.lock.util.AccountUtil;
import org.wso2.carbon.user.api.UserStoreManager;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.util.UserCoreUtil;

public class AccountLockHandler
extends AbstractEventHandler
implements IdentityConnectorConfig {
    public static final Log AUDIT_LOG = LogFactory.getLog((String)"AUDIT_LOG");
    private static final Log log = LogFactory.getLog(AccountLockHandler.class);
    private static ThreadLocal<String> lockedState = new ThreadLocal();

    public String getName() {
        return "account.lock.handler";
    }

    public String getFriendlyName() {
        return "Account Lock";
    }

    public String getCategory() {
        return "Login Attempts Security";
    }

    public String getSubCategory() {
        return "DEFAULT";
    }

    public int getOrder() {
        return 0;
    }

    public void init(InitConfig initConfig) {
        super.init(initConfig);
        AccountServiceDataHolder.getInstance().getBundleContext().registerService(IdentityConnectorConfig.class.getName(), (Object)this, null);
    }

    public Map<String, String> getPropertyNameMapping() {
        HashMap<String, String> nameMapping = new HashMap<String, String>();
        nameMapping.put("account.lock.handler.enable", "Lock user accounts");
        nameMapping.put("account.lock.handler.On.Failure.Max.Attempts", "Maximum failed login attempts");
        nameMapping.put("account.lock.handler.Time", "Initial account lock duration");
        nameMapping.put("account.lock.handler.login.fail.timeout.ratio", "Account lock duration increment factor");
        nameMapping.put("account.lock.handler.notification.manageInternally", "Manage notification sending internally");
        return nameMapping;
    }

    public Map<String, String> getPropertyDescriptionMapping() {
        HashMap<String, String> descriptionMapping = new HashMap<String, String>();
        descriptionMapping.put("account.lock.handler.enable", "Lock user accounts on failed login attempts");
        descriptionMapping.put("account.lock.handler.On.Failure.Max.Attempts", "Number of failed login attempts allowed until account lock.");
        descriptionMapping.put("account.lock.handler.Time", "Initial account lock time period in minutes. Account will be automatically unlocked after this time period.");
        descriptionMapping.put("account.lock.handler.login.fail.timeout.ratio", "Account lock duration will be increased by this factor. Ex: Initial duration: 5m; Increment factor: 2; Next lock duration: 5 x 2 = 10m");
        descriptionMapping.put("account.lock.handler.notification.manageInternally", "Disable if the client application handles notification sending");
        return descriptionMapping;
    }

    public int getPriority(MessageContext messageContext) {
        return 100;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(Event event) throws IdentityEventException {
        boolean userExists;
        Map eventProperties = event.getEventProperties();
        String userName = (String)eventProperties.get("user-name");
        org.wso2.carbon.user.core.UserStoreManager userStoreManager = (org.wso2.carbon.user.core.UserStoreManager)eventProperties.get("userStoreManager");
        String userStoreDomainName = AccountUtil.getUserStoreDomainName((UserStoreManager)userStoreManager);
        String tenantDomain = (String)eventProperties.get("tenant-domain");
        Property[] identityProperties = null;
        Boolean accountLockedEnabled = false;
        String accountLockTime = "0";
        int maximumFailedAttempts = 0;
        double unlockTimeRatio = 1.0;
        String adminPasswordResetAccountLockNotificationProperty = IdentityUtil.getProperty((String)"Recovery.AdminPasswordReset.AccountLockNotification");
        boolean adminForcePasswordResetLockNotificationEnabled = Boolean.parseBoolean(adminPasswordResetAccountLockNotificationProperty);
        String adminPasswordResetAccountUnlockNotificationProperty = IdentityUtil.getProperty((String)"Recovery.AdminPasswordReset.AccountUnlockNotification");
        boolean adminForcePasswordResetUnlockNotificationEnabled = Boolean.parseBoolean(adminPasswordResetAccountUnlockNotificationProperty);
        try {
            identityProperties = AccountServiceDataHolder.getInstance().getIdentityGovernanceService().getConfiguration(this.getPropertyNames(), tenantDomain);
        }
        catch (IdentityGovernanceException e) {
            throw new IdentityEventException("Error while retrieving Account Locking Handler properties.", (Throwable)e);
        }
        for (Property identityProperty : identityProperties) {
            String value;
            if ("account.lock.handler.enable".equals(identityProperty.getName())) {
                accountLockedEnabled = Boolean.parseBoolean(identityProperty.getValue());
                continue;
            }
            if ("account.lock.handler.On.Failure.Max.Attempts".equals(identityProperty.getName())) {
                maximumFailedAttempts = Integer.parseInt(identityProperty.getValue());
                continue;
            }
            if ("account.lock.handler.Time".equals(identityProperty.getName())) {
                accountLockTime = identityProperty.getValue();
                continue;
            }
            if (!"account.lock.handler.login.fail.timeout.ratio".equals(identityProperty.getName()) || !NumberUtils.isNumber((String)(value = identityProperty.getValue())) || Integer.parseInt(value) <= 0) continue;
            unlockTimeRatio = Integer.parseInt(value);
        }
        if (!accountLockedEnabled.booleanValue()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Account lock handler is disabled in tenant: " + tenantDomain));
            }
            return;
        }
        String usernameWithDomain = UserCoreUtil.addDomainToName((String)userName, (String)userStoreDomainName);
        try {
            userExists = userStoreManager.isExistingUser(usernameWithDomain);
        }
        catch (UserStoreException e) {
            throw new IdentityEventException("Error in accessing user store", (Throwable)e);
        }
        if (!userExists) {
            return;
        }
        if ("PRE_AUTHENTICATION".equals(event.getEventName())) {
            this.handlePreAuthentication(event, userName, userStoreManager, userStoreDomainName, tenantDomain, identityProperties, maximumFailedAttempts, accountLockTime, unlockTimeRatio);
        } else if ("POST_AUTHENTICATION".equals(event.getEventName())) {
            this.handlePostAuthentication(event, userName, userStoreManager, userStoreDomainName, tenantDomain, identityProperties, maximumFailedAttempts, accountLockTime, unlockTimeRatio);
        } else if ("PRE_SET_USER_CLAIMS".equals(event.getEventName())) {
            this.handlePreSetUserClaimValues(event, userName, userStoreManager, userStoreDomainName, tenantDomain, identityProperties, maximumFailedAttempts, accountLockTime, unlockTimeRatio);
        } else if ("POST_SET_USER_CLAIMS".equals(event.getEventName())) {
            PrivilegedCarbonContext.startTenantFlow();
            try {
                PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain(tenantDomain, true);
                this.handlePostSetUserClaimValues(event, userName, userStoreManager, userStoreDomainName, tenantDomain, identityProperties, maximumFailedAttempts, accountLockTime, unlockTimeRatio, adminForcePasswordResetLockNotificationEnabled, adminForcePasswordResetUnlockNotificationEnabled);
            }
            finally {
                PrivilegedCarbonContext.endTenantFlow();
            }
        }
    }

    protected boolean handlePreAuthentication(Event event, String userName, org.wso2.carbon.user.core.UserStoreManager userStoreManager, String userStoreDomainName, String tenantDomain, Property[] identityProperties, int maximumFailedAttempts, String accountLockTime, double unlockTimeRatio) throws AccountLockException {
        if (this.isAuthPolicyAccountExistCheck() && !this.isUserExistsInDomain(userStoreManager, userName)) {
            IdentityErrorMsgContext customErrorMessageContext = new IdentityErrorMsgContext("17001");
            IdentityUtil.setIdentityErrorMsg((IdentityErrorMsgContext)customErrorMessageContext);
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean handlePostAuthentication(Event event, String userName, org.wso2.carbon.user.core.UserStoreManager userStoreManager, String userStoreDomainName, String tenantDomain, Property[] identityProperties, int maximumFailedAttempts, String accountLockTime, double unlockTimeRatio) throws AccountLockException {
        IdentityErrorMsgContext customErrorMessageContext;
        long unlockTime = this.getUnlockTime(userName, userStoreManager);
        if (this.isAccountLock(userName, userStoreManager)) {
            if (this.isAccountLockByPassForUser(userStoreManager, userName)) {
                if (!log.isDebugEnabled()) return true;
                String bypassMsg = String.format("Account locking is bypassed as lock bypass role: %s is assigned to the user %s", "Internal/system", userName);
                log.debug((Object)bypassMsg);
                return true;
            }
            if (System.currentTimeMillis() < unlockTime || unlockTime == 0L) {
                String message = StringUtils.isNotBlank((String)userStoreDomainName) ? "Account is locked for user " + userName + " in user store " + userStoreDomainName + " in tenant " + tenantDomain + ". Cannot login until the account is unlocked." : "Account is locked for user " + userName + " in tenant " + tenantDomain + ". Cannot login until the account is unlocked.";
                if (log.isDebugEnabled()) {
                    log.debug((Object)message);
                }
                IdentityErrorMsgContext customErrorMessageContext2 = new IdentityErrorMsgContext("17003");
                IdentityUtil.setIdentityErrorMsg((IdentityErrorMsgContext)customErrorMessageContext2);
                throw new AccountLockException("17003", message);
            }
        }
        Map claimValues = null;
        int currentFailedAttempts = 0;
        int currentFailedLoginLockouts = 0;
        try {
            String currentFailedLoginLockoutCount;
            claimValues = userStoreManager.getUserClaimValues(userName, new String[]{"http://wso2.org/claims/identity/failedLoginLockoutCount", "http://wso2.org/claims/identity/failedLoginAttempts", "http://wso2.org/claims/identity/accountLocked"}, "default");
            String currentFailedAttemptCount = (String)claimValues.get("http://wso2.org/claims/identity/failedLoginAttempts");
            if (StringUtils.isNotBlank((String)currentFailedAttemptCount)) {
                currentFailedAttempts = Integer.parseInt(currentFailedAttemptCount);
            }
            if (StringUtils.isNotBlank((String)(currentFailedLoginLockoutCount = (String)claimValues.get("http://wso2.org/claims/identity/failedLoginLockoutCount")))) {
                currentFailedLoginLockouts = Integer.parseInt(currentFailedLoginLockoutCount);
            }
        }
        catch (UserStoreException e) {
            throw new AccountLockException("Error occurred while retrieving http://wso2.org/claims/identity/unlockTime , http://wso2.org/claims/identity/failedLoginAttempts and http://wso2.org/claims/identity/failedLoginLockoutCount", e);
        }
        HashMap<String, String> newClaims = new HashMap<String, String>();
        if (((Boolean)event.getEventProperties().get("OPERATION_STATUS")).booleanValue()) {
            String accountLockClaim = (String)claimValues.get("http://wso2.org/claims/identity/accountLocked");
            if (!Boolean.parseBoolean(accountLockClaim) && currentFailedAttempts == 0 && currentFailedLoginLockouts == 0 && unlockTime == 0L) {
                return true;
            }
            newClaims.put("http://wso2.org/claims/identity/failedLoginAttemptsBeforeSuccess", String.valueOf(currentFailedAttempts + currentFailedLoginLockouts * maximumFailedAttempts));
            if (this.isUserUnlockable(userName, userStoreManager, currentFailedAttempts, unlockTime, accountLockClaim)) {
                newClaims.put("http://wso2.org/claims/identity/failedLoginAttempts", "0");
                newClaims.put("http://wso2.org/claims/identity/unlockTime", "0");
                newClaims.put("http://wso2.org/claims/identity/accountLocked", Boolean.FALSE.toString());
                newClaims.put("http://wso2.org/claims/identity/failedLoginLockoutCount", "0");
                ((Map)IdentityUtil.threadLocalProperties.get()).put("AdminInitiated", false);
            }
            try {
                userStoreManager.setUserClaimValues(userName, newClaims, null);
                if (!log.isDebugEnabled()) return true;
                log.debug((Object)String.format("User %s is unlocked after exceeding the account locked time or account lock bypassing is enabled", userName));
                return true;
            }
            catch (UserStoreException e) {
                throw new AccountLockException("Error occurred while storing http://wso2.org/claims/identity/failedLoginAttempts, http://wso2.org/claims/identity/unlockTime, http://wso2.org/claims/identity/failedLoginLockoutCount and http://wso2.org/claims/identity/accountLocked", e);
            }
        }
        newClaims.put("http://wso2.org/claims/identity/failedLoginAttempts", ++currentFailedAttempts + "");
        newClaims.put("http://wso2.org/claims/identity/failedLoginAttemptsBeforeSuccess", "0");
        if (this.isAccountLockByPassForUser(userStoreManager, userName)) {
            customErrorMessageContext = new IdentityErrorMsgContext("17002", currentFailedAttempts, maximumFailedAttempts);
            IdentityUtil.setIdentityErrorMsg((IdentityErrorMsgContext)customErrorMessageContext);
            if (!log.isDebugEnabled()) return true;
            String msg = String.format("Login attempt failed. Bypassing account locking for user %s", userName);
            log.debug((Object)msg);
            return true;
        }
        if (currentFailedAttempts >= maximumFailedAttempts) {
            long unlockTimePropertyValue;
            newClaims.put("http://wso2.org/claims/identity/accountLocked", "true");
            if (NumberUtils.isNumber((String)accountLockTime) && (unlockTimePropertyValue = (long)Integer.parseInt(accountLockTime)) != 0L) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Set account unlock time for user:" + userName + " of tenant domain: " + tenantDomain + " userstore domain: " + userStoreDomainName + " adding account unlock time out: " + unlockTimePropertyValue + ", account lock timeout increment factor: " + unlockTimeRatio + " raised to the power of failed login attempt cycles: " + currentFailedLoginLockouts));
                }
                unlockTimePropertyValue = (long)((double)(unlockTimePropertyValue * 1000L * 60L) * Math.pow(unlockTimeRatio, currentFailedLoginLockouts));
                unlockTime = System.currentTimeMillis() + unlockTimePropertyValue;
                newClaims.put("http://wso2.org/claims/identity/unlockTime", unlockTime + "");
            }
            newClaims.put("http://wso2.org/claims/identity/failedLoginLockoutCount", ++currentFailedLoginLockouts + "");
            newClaims.put("http://wso2.org/claims/identity/failedLoginAttempts", "0");
            customErrorMessageContext = new IdentityErrorMsgContext("17003", currentFailedAttempts, maximumFailedAttempts);
            IdentityUtil.setIdentityErrorMsg((IdentityErrorMsgContext)customErrorMessageContext);
            ((Map)IdentityUtil.threadLocalProperties.get()).put("UserAccountState", "17003");
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("User %s is locked since he/she exceeded the maximum allowed failed attempts", userName));
            }
            ((Map)IdentityUtil.threadLocalProperties.get()).put("AdminInitiated", false);
        } else {
            customErrorMessageContext = new IdentityErrorMsgContext("17002", currentFailedAttempts, maximumFailedAttempts);
            IdentityUtil.setIdentityErrorMsg((IdentityErrorMsgContext)customErrorMessageContext);
        }
        try {
            userStoreManager.setUserClaimValues(userName, newClaims, null);
            return true;
        }
        catch (UserStoreException e) {
            throw new AccountLockException("Error occurred while locking user account", e);
        }
        catch (NumberFormatException e) {
            throw new AccountLockException("Error occurred while parsing config values", e);
        }
    }

    private boolean isUserUnlockable(String userName, org.wso2.carbon.user.core.UserStoreManager userStoreManager, int currentFailedAttempts, long unlockTime, String accountLockClaim) throws AccountLockException {
        return unlockTime != 0L && System.currentTimeMillis() >= unlockTime || currentFailedAttempts > 0 || Boolean.parseBoolean(accountLockClaim) && this.isAccountLockByPassForUser(userStoreManager, userName);
    }

    protected boolean handlePreSetUserClaimValues(Event event, String userName, org.wso2.carbon.user.core.UserStoreManager userStoreManager, String userStoreDomainName, String tenantDomain, Property[] identityProperties, int maximumFailedAttempts, String accountLockTime, double unlockTimeRatio) throws AccountLockException {
        Boolean existingAccountLockedValue;
        if (lockedState.get() != null) {
            return true;
        }
        try {
            Map claimValues = userStoreManager.getUserClaimValues(userName, new String[]{"http://wso2.org/claims/identity/accountLocked"}, "default");
            existingAccountLockedValue = Boolean.valueOf((String)claimValues.get("http://wso2.org/claims/identity/accountLocked"));
        }
        catch (UserStoreException e) {
            throw new AccountLockException("Error occurred while retrieving http://wso2.org/claims/identity/accountLocked claim value", e);
        }
        String newStateString = (String)((Map)event.getEventProperties().get("USER_CLAIMS")).get("http://wso2.org/claims/identity/accountLocked");
        if (StringUtils.isNotBlank((String)newStateString)) {
            Boolean newAccountLockedValue = Boolean.parseBoolean((String)((Map)event.getEventProperties().get("USER_CLAIMS")).get("http://wso2.org/claims/identity/accountLocked"));
            if (existingAccountLockedValue != newAccountLockedValue) {
                if (existingAccountLockedValue.booleanValue()) {
                    lockedState.set(lockedStates.UNLOCKED_MODIFIED.toString());
                } else {
                    lockedState.set(lockedStates.LOCKED_MODIFIED.toString());
                    ((Map)IdentityUtil.threadLocalProperties.get()).put("UserAccountState", "17003");
                }
            } else if (existingAccountLockedValue.booleanValue()) {
                lockedState.set(lockedStates.LOCKED_UNMODIFIED.toString());
            } else {
                lockedState.set(lockedStates.UNLOCKED_UNMODIFIED.toString());
            }
        } else if (existingAccountLockedValue.booleanValue()) {
            lockedState.set(lockedStates.LOCKED_UNMODIFIED.toString());
        } else {
            lockedState.set(lockedStates.UNLOCKED_UNMODIFIED.toString());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean handlePostSetUserClaimValues(Event event, String userName, org.wso2.carbon.user.core.UserStoreManager userStoreManager, String userStoreDomainName, String tenantDomain, Property[] identityProperties, int maximumFailedAttempts, String accountLockTime, double unlockTimeRatio, boolean adminForcedPasswordResetLockNotificationEnabled, boolean adminForcedPasswordResetUnlockNotificationEnabled) throws AccountLockException {
        String newAccountState = null;
        try {
            String existingAccountStateClaimValue;
            boolean notificationInternallyManage;
            block30: {
                notificationInternallyManage = true;
                existingAccountStateClaimValue = this.getAccountState(userStoreManager, tenantDomain, userName);
                try {
                    notificationInternallyManage = Boolean.parseBoolean(AccountUtil.getConnectorConfig("account.lock.handler.notification.manageInternally", tenantDomain));
                }
                catch (IdentityEventException e) {
                    log.warn((Object)"Error while reading Notification internally manage property in account lock handler");
                    if (!log.isDebugEnabled()) break block30;
                    log.debug((Object)"Error while reading Notification internally manage property in account lock handler", (Throwable)e);
                }
            }
            boolean isAdminInitiated = true;
            if (((Map)IdentityUtil.threadLocalProperties.get()).get("AdminInitiated") != null) {
                isAdminInitiated = (Boolean)((Map)IdentityUtil.threadLocalProperties.get()).get("AdminInitiated");
            }
            if (lockedStates.UNLOCKED_MODIFIED.toString().equals(lockedState.get())) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("User %s is unlocked", userName));
                }
                String emailTemplateTypeAccUnlocked = "accountunlock";
                if (notificationInternallyManage) {
                    if (isAdminInitiated) {
                        if (AccountUtil.isTemplateExists("accountunlockadmin", tenantDomain)) {
                            emailTemplateTypeAccUnlocked = "accountunlockadmin";
                        }
                    } else if (AccountUtil.isTemplateExists("accountunlocktimebased", tenantDomain)) {
                        emailTemplateTypeAccUnlocked = "accountunlocktimebased";
                    }
                    boolean isPendingSelfRegistration = "PENDING_SR".equals(existingAccountStateClaimValue);
                    if ("PENDING_FUPR".equals(existingAccountStateClaimValue)) {
                        if (adminForcedPasswordResetUnlockNotificationEnabled) {
                            this.triggerNotification(event, userName, userStoreManager, userStoreDomainName, tenantDomain, identityProperties, emailTemplateTypeAccUnlocked);
                        }
                    } else if (!isPendingSelfRegistration) {
                        this.triggerNotification(event, userName, userStoreManager, userStoreDomainName, tenantDomain, identityProperties, emailTemplateTypeAccUnlocked);
                    }
                    newAccountState = this.buildAccountState("accountunlock", tenantDomain, userStoreManager, userName);
                    this.auditAccountLock("Account Unlock", userName, userStoreDomainName, isAdminInitiated, null, "Success");
                }
            } else if (lockedStates.LOCKED_MODIFIED.toString().equals(lockedState.get())) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("User %s is locked", userName));
                }
                String emailTemplateTypeAccLocked = "accountlock";
                if (notificationInternallyManage) {
                    if (isAdminInitiated) {
                        if (AccountUtil.isTemplateExists("accountlockadmin", tenantDomain)) {
                            emailTemplateTypeAccLocked = "accountlockadmin";
                        }
                    } else if (AccountUtil.isTemplateExists("accountlockfailedattempt", tenantDomain)) {
                        emailTemplateTypeAccLocked = "accountlockfailedattempt";
                    }
                    if ("PENDING_FUPR".equals(existingAccountStateClaimValue)) {
                        if (adminForcedPasswordResetLockNotificationEnabled) {
                            this.triggerNotification(event, userName, userStoreManager, userStoreDomainName, tenantDomain, identityProperties, emailTemplateTypeAccLocked);
                        }
                    } else if (!"PENDING_SR".equals(existingAccountStateClaimValue) && !"PENDING_EV".equals(existingAccountStateClaimValue)) {
                        this.triggerNotification(event, userName, userStoreManager, userStoreDomainName, tenantDomain, identityProperties, emailTemplateTypeAccLocked);
                        newAccountState = this.buildAccountState("accountlock", tenantDomain, userStoreManager, userName);
                    }
                }
                this.auditAccountLock("Account Lock", userName, userStoreDomainName, isAdminInitiated, null, "Success");
            }
        }
        finally {
            lockedState.remove();
            ((Map)IdentityUtil.threadLocalProperties.get()).remove("AdminInitiated");
        }
        if (StringUtils.isNotEmpty(newAccountState)) {
            this.setUserClaim("http://wso2.org/claims/identity/accountState", newAccountState, userStoreManager, userName);
        }
        return true;
    }

    public String[] getPropertyNames() {
        ArrayList<String> properties = new ArrayList<String>();
        properties.add("account.lock.handler.enable");
        properties.add("account.lock.handler.On.Failure.Max.Attempts");
        properties.add("account.lock.handler.Time");
        properties.add("account.lock.handler.login.fail.timeout.ratio");
        properties.add("account.lock.handler.notification.manageInternally");
        return properties.toArray(new String[properties.size()]);
    }

    public Properties getDefaultPropertyValues(String tenantDomain) throws IdentityGovernanceException {
        return this.configs.getModuleProperties();
    }

    public Map<String, String> getDefaultPropertyValues(String[] propertyNames, String tenantDomain) throws IdentityGovernanceException {
        return null;
    }

    protected void triggerNotification(Event event, String userName, org.wso2.carbon.user.core.UserStoreManager userStoreManager, String userStoreDomainName, String tenantDomain, Property[] identityProperties, String notificationEvent) throws AccountLockException {
        block2: {
            String eventName = "TRIGGER_NOTIFICATION";
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("user-name", userName);
            properties.put("userstore-domain", userStoreDomainName);
            properties.put("tenant-domain", tenantDomain);
            properties.put("TEMPLATE_TYPE", notificationEvent);
            Event identityMgtEvent = new Event(eventName, properties);
            try {
                AccountServiceDataHolder.getInstance().getIdentityEventService().handleEvent(identityMgtEvent);
            }
            catch (Exception e) {
                String errorMsg = "Error occurred while calling triggerNotification, detail : " + e.getMessage();
                log.warn((Object)errorMsg);
                if (!log.isDebugEnabled()) break block2;
                log.debug((Object)errorMsg, (Throwable)e);
            }
        }
    }

    protected long getUnlockTime(String userName, org.wso2.carbon.user.core.UserStoreManager userStoreManager) throws AccountLockException {
        long unlockTime = 0L;
        try {
            Map values = userStoreManager.getUserClaimValues(userName, new String[]{"http://wso2.org/claims/identity/unlockTime"}, "default");
            String userClaimValue = (String)values.get("http://wso2.org/claims/identity/unlockTime");
            if (NumberUtils.isNumber((String)userClaimValue)) {
                unlockTime = Long.parseLong(userClaimValue);
            }
        }
        catch (UserStoreException e) {
            throw new AccountLockException("Error occurred while retrieving http://wso2.org/claims/identity/unlockTime claim value", e);
        }
        return unlockTime;
    }

    protected boolean isAccountLock(String userName, org.wso2.carbon.user.core.UserStoreManager userStoreManager) throws AccountLockException {
        String accountLockedClaim;
        try {
            Map values = userStoreManager.getUserClaimValues(userName, new String[]{"http://wso2.org/claims/identity/accountLocked"}, "default");
            accountLockedClaim = (String)values.get("http://wso2.org/claims/identity/accountLocked");
        }
        catch (UserStoreException e) {
            throw new AccountLockException("Error occurred while retrieving http://wso2.org/claims/identity/accountLocked claim value", e);
        }
        return Boolean.parseBoolean(accountLockedClaim);
    }

    private boolean isUserExistsInDomain(org.wso2.carbon.user.core.UserStoreManager userStoreManager, String userName) throws AccountLockException {
        boolean isExists = false;
        try {
            if (userStoreManager.isExistingUser(userName)) {
                isExists = true;
            }
        }
        catch (UserStoreException e) {
            throw new AccountLockException("Error occurred while check user existence: " + userName, e);
        }
        return isExists;
    }

    private boolean isAuthPolicyAccountExistCheck() {
        return Boolean.parseBoolean(IdentityUtil.getProperty((String)"AuthenticationPolicy.CheckAccountExist"));
    }

    private boolean isAccountLockByPassForUser(org.wso2.carbon.user.core.UserStoreManager userStoreManager, String userName) throws AccountLockException {
        try {
            Object[] roleList = userStoreManager.getRoleListOfUser(userName);
            if (!ArrayUtils.isEmpty((Object[])roleList)) {
                return ArrayUtils.contains((Object[])roleList, (Object)"Internal/system");
            }
        }
        catch (UserStoreException e) {
            throw new AccountLockException("Error occurred while listing user role: " + userName, e);
        }
        return false;
    }

    private String buildAccountState(String state, String tenantDomain, org.wso2.carbon.user.core.UserStoreManager userStoreManager, String userName) throws AccountLockException {
        boolean isAccountStateClaimExist = AccountUtil.isAccountStateClaimExisting(tenantDomain);
        String newAccountstate = null;
        if (isAccountStateClaimExist) {
            if (this.isAccountDisabled(userStoreManager, userName)) {
                newAccountstate = "DISABLED";
            } else if (state.equals("accountunlock")) {
                newAccountstate = "UNLOCKED";
            } else if (state.equals("accountlock")) {
                newAccountstate = "LOCKED";
            }
        }
        return newAccountstate;
    }

    private String getAccountState(org.wso2.carbon.user.core.UserStoreManager userStoreManager, String tenantDomain, String userName) throws AccountLockException {
        String accountStateClaimValue = null;
        try {
            boolean isAccountStateClaimExist = AccountUtil.isAccountStateClaimExisting(tenantDomain);
            if (isAccountStateClaimExist) {
                Map claimValues = userStoreManager.getUserClaimValues(userName, new String[]{"http://wso2.org/claims/identity/accountState"}, "default");
                accountStateClaimValue = (String)claimValues.get("http://wso2.org/claims/identity/accountState");
            }
        }
        catch (UserStoreException e) {
            throw new AccountLockException("Error occurred while retrieving account state claim value", e);
        }
        return accountStateClaimValue;
    }

    private boolean isAccountDisabled(org.wso2.carbon.user.core.UserStoreManager userStoreManager, String userName) throws AccountLockException {
        boolean accountDisabled = false;
        try {
            Map claimValues = userStoreManager.getUserClaimValues(userName, new String[]{"http://wso2.org/claims/identity/accountDisabled"}, "default");
            accountDisabled = Boolean.parseBoolean((String)claimValues.get("http://wso2.org/claims/identity/accountDisabled"));
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            throw new AccountLockException("Error occurred while retrieving http://wso2.org/claims/identity/accountDisabled claim value", e);
        }
        return accountDisabled;
    }

    private void setUserClaim(String claimName, String claimValue, org.wso2.carbon.user.core.UserStoreManager userStoreManager, String username) throws AccountLockException {
        HashMap<String, String> userClaims = new HashMap<String, String>();
        userClaims.put(claimName, claimValue);
        try {
            userStoreManager.setUserClaimValues(username, userClaims, null);
        }
        catch (UserStoreException e) {
            throw new AccountLockException("Error while setting user claim value :" + username, e);
        }
    }

    private static void createAuditMessage(String action, String target, JSONObject dataObject, String result) {
        String loggedInUser = PrivilegedCarbonContext.getThreadLocalCarbonContext().getUsername();
        if (StringUtils.isBlank((String)loggedInUser)) {
            loggedInUser = "wso2.system.user";
        }
        String tenantDomain = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        loggedInUser = UserCoreUtil.addTenantDomainToEntry((String)loggedInUser, (String)tenantDomain);
        AUDIT_LOG.info((Object)String.format("Initiator : %s | Action : %s | Target : %s | Data : %s | Result : %s ", loggedInUser, action, target, dataObject, result));
    }

    private void auditAccountLock(String action, String target, String userStoreDomainName, boolean isAdminInitiated, String errorMsg, String result) {
        JSONObject dataObject = new JSONObject();
        dataObject.put("RemoteAddress", (Object)MDC.get((String)"remoteAddress"));
        dataObject.put("User Agent", (Object)MDC.get((String)"User-Agent"));
        dataObject.put("ServiceProviderName", (Object)MDC.get((String)"serviceProvider"));
        dataObject.put("AdminInitiated", isAdminInitiated);
        dataObject.put("UserStoreDomain", (Object)userStoreDomainName);
        if ("Failed".equals(result)) {
            dataObject.put("Error Message", (Object)errorMsg);
        }
        AccountLockHandler.createAuditMessage(action, target, dataObject, result);
    }

    private static enum lockedStates {
        LOCKED_MODIFIED,
        UNLOCKED_MODIFIED,
        LOCKED_UNMODIFIED,
        UNLOCKED_UNMODIFIED;

    }
}

