/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.handler.event.account.lock;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.core.bean.context.MessageContext;
import org.wso2.carbon.identity.core.handler.InitConfig;
import org.wso2.carbon.identity.core.model.IdentityErrorMsgContext;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.event.IdentityEventException;
import org.wso2.carbon.identity.event.event.Event;
import org.wso2.carbon.identity.event.handler.AbstractEventHandler;
import org.wso2.carbon.identity.governance.IdentityGovernanceException;
import org.wso2.carbon.identity.governance.common.IdentityConnectorConfig;
import org.wso2.carbon.identity.handler.event.account.lock.exception.AccountLockException;
import org.wso2.carbon.identity.handler.event.account.lock.internal.AccountServiceDataHolder;
import org.wso2.carbon.identity.handler.event.account.lock.util.AccountUtil;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.api.UserStoreManager;
import org.wso2.carbon.user.core.util.UserCoreUtil;

public class AccountDisableHandler
extends AbstractEventHandler
implements IdentityConnectorConfig {
    private static final Log log = LogFactory.getLog(AccountDisableHandler.class);
    private static final ThreadLocal<String> disabledState = new ThreadLocal();

    public String getName() {
        return "account.disable.handler";
    }

    public String getFriendlyName() {
        return "Account Disable";
    }

    public String getCategory() {
        return "Account Management";
    }

    public String getSubCategory() {
        return "DEFAULT";
    }

    public int getOrder() {
        return 0;
    }

    public void init(InitConfig initConfig) {
        super.init(initConfig);
        AccountServiceDataHolder.getInstance().getBundleContext().registerService(IdentityConnectorConfig.class.getName(), (Object)this, null);
    }

    public Map<String, String> getPropertyNameMapping() {
        HashMap<String, String> nameMapping = new HashMap<String, String>();
        nameMapping.put("account.disable.handler.enable", "Enable account disabling");
        nameMapping.put("account.disable.handler.notification.manageInternally", "Manage notification sending internally");
        return nameMapping;
    }

    public Map<String, String> getPropertyDescriptionMapping() {
        HashMap<String, String> descriptionMapping = new HashMap<String, String>();
        descriptionMapping.put("account.disable.handler.enable", "Allow an administrative user to disable user accounts");
        descriptionMapping.put("account.disable.handler.notification.manageInternally", "Disable, if the client application handles notification sending");
        return descriptionMapping;
    }

    public String[] getPropertyNames() {
        ArrayList<String> properties = new ArrayList<String>();
        properties.add("account.disable.handler.enable");
        properties.add("account.disable.handler.notification.manageInternally");
        return properties.toArray(new String[0]);
    }

    public Properties getDefaultPropertyValues(String s) throws IdentityGovernanceException {
        return this.configs.getModuleProperties();
    }

    public Map<String, String> getDefaultPropertyValues(String[] strings, String s) throws IdentityGovernanceException {
        return null;
    }

    public void handleEvent(Event event) throws IdentityEventException {
        boolean userExists;
        Map eventProperties = event.getEventProperties();
        String userName = (String)eventProperties.get("user-name");
        UserStoreManager userStoreManager = (UserStoreManager)eventProperties.get("userStoreManager");
        String userStoreDomainName = AccountUtil.getUserStoreDomainName(userStoreManager);
        String tenantDomain = (String)eventProperties.get("tenant-domain");
        String usernameWithDomain = UserCoreUtil.addDomainToName((String)userName, (String)userStoreDomainName);
        boolean isAccountDisabledEnabled = Boolean.parseBoolean(AccountUtil.getConnectorConfig("account.disable.handler.enable", tenantDomain));
        if (!isAccountDisabledEnabled) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Account disable feature is disabled for tenant :" + tenantDomain));
            }
            return;
        }
        try {
            userExists = userStoreManager.isExistingUser(usernameWithDomain);
        }
        catch (UserStoreException e) {
            throw new IdentityEventException("Error in accessing user store", (Throwable)e);
        }
        if (!userExists) {
            return;
        }
        if ("PRE_AUTHENTICATION".equals(event.getEventName())) {
            this.handlePreAuthentication(event, userName, userStoreManager, userStoreDomainName, tenantDomain);
        } else if ("PRE_SET_USER_CLAIMS".equals(event.getEventName())) {
            this.handlePreSetUserClaimValues(event, userName, userStoreManager, userStoreDomainName, tenantDomain);
        } else if ("POST_SET_USER_CLAIMS".equals(event.getEventName())) {
            this.handlePostSetUserClaimValues(event, userName, userStoreManager, userStoreDomainName, tenantDomain);
        }
    }

    protected boolean handlePreAuthentication(Event event, String userName, UserStoreManager userStoreManager, String userStoreDomainName, String tenantDomain) throws AccountLockException {
        String accountDisabledClaim;
        try {
            Map claimValues = userStoreManager.getUserClaimValues(userName, new String[]{"http://wso2.org/claims/identity/accountDisabled"}, "default");
            accountDisabledClaim = (String)claimValues.get("http://wso2.org/claims/identity/accountDisabled");
        }
        catch (UserStoreException e) {
            throw new AccountLockException("Error occurred while retrieving http://wso2.org/claims/identity/accountDisabled claim value", e);
        }
        if (Boolean.parseBoolean(accountDisabledClaim)) {
            String message = StringUtils.isNotBlank((String)userStoreDomainName) ? "Account is disabled for user " + userName + " in user store " + userStoreDomainName + " in tenant " + tenantDomain + ". Cannot login until the account is enabled." : "Account is disabled for user " + userName + " in tenant " + tenantDomain + ". Cannot login until the account is enabled.";
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Authentication failed for user %s as the account is disabled", userName));
            }
            IdentityErrorMsgContext customErrorMessageContext = new IdentityErrorMsgContext("17004");
            IdentityUtil.setIdentityErrorMsg((IdentityErrorMsgContext)customErrorMessageContext);
            throw new AccountLockException("17004", message);
        }
        return true;
    }

    protected boolean handlePreSetUserClaimValues(Event event, String userName, UserStoreManager userStoreManager, String userStoreDomainName, String tenantDomain) throws AccountLockException {
        boolean existingAccountDisabledValue;
        if (disabledState.get() != null) {
            return true;
        }
        try {
            Map claimValues = userStoreManager.getUserClaimValues(userName, new String[]{"http://wso2.org/claims/identity/accountDisabled"}, "default");
            existingAccountDisabledValue = Boolean.parseBoolean((String)claimValues.get("http://wso2.org/claims/identity/accountDisabled"));
        }
        catch (UserStoreException e) {
            throw new AccountLockException("Error occurred while retrieving http://wso2.org/claims/identity/accountDisabled claim value", e);
        }
        String newAccountDisableString = (String)((Map)event.getEventProperties().get("USER_CLAIMS")).get("http://wso2.org/claims/identity/accountDisabled");
        if (StringUtils.isNotBlank((String)newAccountDisableString)) {
            boolean newAccountDisabledValue = Boolean.parseBoolean((String)((Map)event.getEventProperties().get("USER_CLAIMS")).get("http://wso2.org/claims/identity/accountDisabled"));
            if (existingAccountDisabledValue != newAccountDisabledValue) {
                if (existingAccountDisabledValue) {
                    disabledState.set(disabledStates.ENABLED_MODIFIED.toString());
                } else {
                    disabledState.set(disabledStates.DISABLED_MODIFIED.toString());
                    IdentityErrorMsgContext customErrorMessageContext = new IdentityErrorMsgContext(" User account is disabled");
                    IdentityUtil.setIdentityErrorMsg((IdentityErrorMsgContext)customErrorMessageContext);
                    ((Map)IdentityUtil.threadLocalProperties.get()).put("UserAccountState", "17004");
                }
            } else if (existingAccountDisabledValue) {
                disabledState.set(disabledStates.DISABLED_UNMODIFIED.toString());
            } else {
                disabledState.set(disabledStates.ENABLED_UNMODIFIED.toString());
            }
        } else if (existingAccountDisabledValue) {
            disabledState.set(disabledStates.DISABLED_UNMODIFIED.toString());
        } else {
            disabledState.set(disabledStates.ENABLED_UNMODIFIED.toString());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean handlePostSetUserClaimValues(Event event, String userName, UserStoreManager userStoreManager, String userStoreDomainName, String tenantDomain) throws AccountLockException {
        String newAccountState = null;
        try {
            boolean notificationInternallyManage;
            block13: {
                notificationInternallyManage = true;
                try {
                    notificationInternallyManage = Boolean.parseBoolean(AccountUtil.getConnectorConfig("account.disable.handler.notification.manageInternally", tenantDomain));
                }
                catch (IdentityEventException e) {
                    log.warn((Object)"Error while reading Notification internally manage property in account lock handler");
                    if (!log.isDebugEnabled()) break block13;
                    log.debug((Object)"Error while reading Notification internally manage property in account lock handler", (Throwable)e);
                }
            }
            if (disabledStates.ENABLED_MODIFIED.toString().equals(disabledState.get())) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("User %s is enabled", userName));
                }
                if (notificationInternallyManage) {
                    this.triggerNotification(event, userName, userStoreManager, userStoreDomainName, tenantDomain, "accountenable");
                    newAccountState = this.buildAccountState("accountenable", userStoreManager, tenantDomain, userName);
                }
            } else if (disabledStates.DISABLED_MODIFIED.toString().equals(disabledState.get())) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("User %s is disabled", userName));
                }
                if (notificationInternallyManage) {
                    this.triggerNotification(event, userName, userStoreManager, userStoreDomainName, tenantDomain, "accountdisable");
                    newAccountState = this.buildAccountState("accountdisable", userStoreManager, tenantDomain, userName);
                }
            }
        }
        finally {
            disabledState.remove();
        }
        if (StringUtils.isNotEmpty(newAccountState)) {
            this.setUserClaim("http://wso2.org/claims/identity/accountState", newAccountState, userStoreManager, userName);
        }
        return true;
    }

    protected void triggerNotification(Event event, String userName, UserStoreManager userStoreManager, String userStoreDomainName, String tenantDomain, String notificationEvent) throws AccountLockException {
        block2: {
            String eventName = "TRIGGER_NOTIFICATION";
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("user-name", userName);
            properties.put("userstore-domain", userStoreDomainName);
            properties.put("tenant-domain", tenantDomain);
            properties.put("TEMPLATE_TYPE", notificationEvent);
            Event identityMgtEvent = new Event(eventName, properties);
            try {
                AccountServiceDataHolder.getInstance().getIdentityEventService().handleEvent(identityMgtEvent);
            }
            catch (Exception e) {
                String errorMsg = "Error occurred while calling triggerNotification, detail : " + e.getMessage();
                log.warn((Object)errorMsg);
                if (!log.isDebugEnabled()) break block2;
                log.debug((Object)errorMsg, (Throwable)e);
            }
        }
    }

    private String buildAccountState(String state, UserStoreManager userStoreManager, String tenantDomain, String userName) {
        String accountState;
        block6: {
            accountState = null;
            try {
                boolean isAccountStateClaimExist = AccountUtil.isAccountStateClaimExisting(tenantDomain);
                if (isAccountStateClaimExist) {
                    boolean accountLocked = this.isAccountLocked(userStoreManager, userName);
                    if (state.equals("accountdisable")) {
                        accountState = "DISABLED";
                    } else if (state.equals("accountenable")) {
                        accountState = !accountLocked ? "UNLOCKED" : "LOCKED";
                    }
                }
            }
            catch (AccountLockException e) {
                log.warn((Object)"Error while setting account state claim as locked in account lock handler");
                if (!log.isDebugEnabled()) break block6;
                log.debug((Object)"Error while setting account state claim as locked in account lock handler", (Throwable)((Object)e));
            }
        }
        return accountState;
    }

    private boolean isAccountLocked(UserStoreManager userStoreManager, String userName) throws AccountLockException {
        boolean accountLocked = false;
        try {
            Map claimValues = userStoreManager.getUserClaimValues(userName, new String[]{"http://wso2.org/claims/identity/accountLocked"}, "default");
            accountLocked = Boolean.parseBoolean((String)claimValues.get("http://wso2.org/claims/identity/accountLocked"));
        }
        catch (UserStoreException e) {
            throw new AccountLockException("Error occurred while retrieving http://wso2.org/claims/identity/accountLocked claim value", e);
        }
        return accountLocked;
    }

    private void setUserClaim(String claimName, String claimValue, UserStoreManager userStoreManager, String username) throws AccountLockException {
        HashMap<String, String> userClaims = new HashMap<String, String>();
        userClaims.put(claimName, claimValue);
        try {
            userStoreManager.setUserClaimValues(username, userClaims, null);
        }
        catch (UserStoreException e) {
            throw new AccountLockException("Error while setting user claim value :" + username, e);
        }
    }

    public int getPriority(MessageContext messageContext) {
        int priority = super.getPriority(messageContext);
        if (priority == -1) {
            priority = 101;
        }
        return priority;
    }

    private static enum disabledStates {
        DISABLED_UNMODIFIED,
        DISABLED_MODIFIED,
        ENABLED_UNMODIFIED,
        ENABLED_MODIFIED;

    }
}

