/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.captcha.mgt.util;

import com.google.code.kaptcha.Producer;
import com.google.code.kaptcha.util.Config;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.Date;
import java.util.Properties;
import java.util.UUID;
import javax.imageio.ImageIO;
import org.apache.axis2.AxisFault;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.captcha.mgt.beans.CaptchaInfoBean;
import org.wso2.carbon.captcha.mgt.internal.CaptchaMgtServiceComponent;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.registry.core.CollectionImpl;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourceImpl;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.user.core.AuthorizationManager;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.utils.CarbonUtils;

public class CaptchaUtil {
    private static final Log log = LogFactory.getLog(CaptchaUtil.class);

    public static void cleanOldCaptchas() throws Exception {
        new Thread(){

            @Override
            public void run() {
                PrivilegedCarbonContext context = PrivilegedCarbonContext.getThreadLocalCarbonContext();
                context.setTenantDomain("carbon.super");
                context.setTenantId(-1234);
                try {
                    String[] childPaths;
                    UserRegistry superTenantRegistry = CaptchaMgtServiceComponent.getConfigSystemRegistry(-1234);
                    if (!superTenantRegistry.resourceExists("/repository/components/org.wso2.carbon.captcha-details")) {
                        return;
                    }
                    CollectionImpl c = (CollectionImpl)superTenantRegistry.get("/repository/components/org.wso2.carbon.captcha-details");
                    for (String childPath : childPaths = c.getChildren()) {
                        Resource resource = superTenantRegistry.get(childPath);
                        long createdTime = resource.getCreatedTime().getTime();
                        long currentTime = new Date().getTime();
                        if (currentTime < createdTime + 1200000L) continue;
                        String imagePath = resource.getProperty("captcha-path");
                        superTenantRegistry.delete(imagePath);
                        superTenantRegistry.delete(childPath);
                    }
                }
                catch (RegistryException e) {
                    String msg = "Error in cleaning old captchas.";
                    log.error((Object)msg, (Throwable)e);
                }
            }
        }.start();
    }

    public static void cleanCaptcha(String secretKey) throws Exception {
        String recordPath = "/repository/components/org.wso2.carbon.captcha-details/" + secretKey;
        UserRegistry superTenantRegistry = CaptchaMgtServiceComponent.getConfigSystemRegistry(-1234);
        Resource resource = superTenantRegistry.get(recordPath);
        String imagePath = resource.getProperty("captcha-path");
        superTenantRegistry.delete(imagePath);
        superTenantRegistry.delete(recordPath);
        CaptchaUtil.cleanOldCaptchas();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CaptchaInfoBean generateCaptchaImage() throws Exception {
        String randomSecretKey = UUID.randomUUID().toString();
        String imagePath = "/repository/components/org.wso2.carbon.captcha-images/" + randomSecretKey + ".jpg";
        Config config = new Config(new Properties());
        Producer captchaProducer = config.getProducerImpl();
        String captchaText = captchaProducer.createText();
        BufferedImage image = captchaProducer.createImage(captchaText);
        File tempFile = File.createTempFile("temp-", ".jpg");
        try {
            ImageIO.write((RenderedImage)image, "jpg", tempFile);
            byte[] imageBytes = CarbonUtils.getBytesFromFile((File)tempFile);
            UserRegistry superTenantRegistry = CaptchaMgtServiceComponent.getConfigSystemRegistry(-1234);
            Resource imageResource = superTenantRegistry.newResource();
            imageResource.setContent((Object)imageBytes);
            superTenantRegistry.put(imagePath, imageResource);
            CaptchaInfoBean captchaInfoBean = new CaptchaInfoBean();
            captchaInfoBean.setSecretKey(randomSecretKey);
            captchaInfoBean.setImagePath("registry/resource/_system/config" + imagePath);
            Resource recordResource = superTenantRegistry.newResource();
            ((ResourceImpl)recordResource).setVersionableChange(false);
            recordResource.setProperty("captcha-text", captchaText);
            recordResource.setProperty("captcha-path", imagePath);
            superTenantRegistry.put("/repository/components/org.wso2.carbon.captcha-details/" + randomSecretKey, recordResource);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Successfully generated the captcha image.");
            }
            CaptchaInfoBean captchaInfoBean2 = captchaInfoBean;
            return captchaInfoBean2;
        }
        finally {
            if (!tempFile.delete()) {
                log.warn((Object)("Could not delete " + tempFile.getAbsolutePath()));
            }
        }
    }

    public static void validateCaptcha(CaptchaInfoBean captchaInfoBean) throws Exception {
        String userAnswer = captchaInfoBean.getUserAnswer();
        if (userAnswer.equals("")) {
            String msg = "Captcha validation failed. User has not answered to captcha text.";
            log.error((Object)msg);
            throw new Exception(msg);
        }
        String secretKey = captchaInfoBean.getSecretKey();
        String recordPath = "/repository/components/org.wso2.carbon.captcha-details/" + secretKey;
        UserRegistry superTenantRegistry = CaptchaMgtServiceComponent.getConfigSystemRegistry(-1234);
        if (!superTenantRegistry.resourceExists(recordPath)) {
            String msg = "The captcha details are not available.";
            log.error((Object)msg);
            throw new Exception(msg);
        }
        Resource resource = superTenantRegistry.get(recordPath);
        String captchaText = resource.getProperty("captcha-text");
        if (captchaText == null) {
            String msg = "The captcha details are not available.";
            log.error((Object)msg);
            throw new Exception(msg);
        }
        if (!captchaText.equals(userAnswer)) {
            String msg = "Captcha validation failed. The user's answer doesn't match the captcha text.";
            log.error((Object)msg);
            throw new Exception(msg);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Successfully validated the captcha.");
        }
    }

    public static void processCaptchaInfoBean(CaptchaInfoBean captchaInfoBean) throws Exception {
        try {
            CaptchaUtil.validateCaptcha(captchaInfoBean);
        }
        catch (Exception e) {
            String msg = "Captcha validation failed.";
            log.error((Object)msg, (Throwable)e);
            throw new AxisFault(msg);
        }
        finally {
            try {
                CaptchaUtil.cleanCaptcha(captchaInfoBean.getSecretKey());
            }
            catch (Exception e) {
                String msg = "Error in cleaning captcha. ";
                log.error((Object)msg, (Throwable)e);
            }
        }
    }

    public static void setAnonAccessToCaptchaImages() throws Exception {
        UserRegistry systemTenantRegistry = CaptchaMgtServiceComponent.getConfigSystemRegistry(-1234);
        CaptchaUtil.setAnonAuthorization("/_system/config/repository/components/org.wso2.carbon.captcha-images", systemTenantRegistry.getUserRealm());
    }

    public static void setAnonAuthorization(String path, UserRealm userRealm) throws RegistryException {
        if (userRealm == null) {
            return;
        }
        try {
            AuthorizationManager accessControlAdmin = userRealm.getAuthorizationManager();
            String everyoneRole = "system/wso2.anonymous.role";
            accessControlAdmin.authorizeRole(everyoneRole, path, "http://www.wso2.org/projects/registry/actions/get");
            accessControlAdmin.denyRole(everyoneRole, path, "http://www.wso2.org/projects/registry/actions/add");
            accessControlAdmin.denyRole(everyoneRole, path, "http://www.wso2.org/projects/registry/actions/delete");
            accessControlAdmin.denyRole(everyoneRole, path, "authorize");
        }
        catch (UserStoreException e) {
            String msg = "Could not set authorizations for the " + path + ".";
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg);
        }
    }
}

