/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.captcha.mgt.internal;

import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.captcha.mgt.util.CaptchaUtil;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.utils.ConfigurationContextService;

@Component(name="org.wso2.carbon.captcha.mgt.internal.CaptchaMgtServiceComponent", immediate=true)
public class CaptchaMgtServiceComponent {
    private static Log log = LogFactory.getLog(CaptchaMgtServiceComponent.class);
    private static ConfigurationContextService configurationContextService;
    private static RegistryService registryService;

    public static ConfigurationContext getConfigurationContext() {
        if (configurationContextService.getServerConfigContext() == null) {
            return null;
        }
        return configurationContextService.getServerConfigContext();
    }

    public static UserRegistry getConfigSystemRegistry(int tenantId) throws RegistryException {
        return registryService.getConfigSystemRegistry(tenantId);
    }

    @Activate
    protected void activate(ComponentContext context) {
        try {
            CaptchaUtil.setAnonAccessToCaptchaImages();
            if (log.isDebugEnabled()) {
                log.debug((Object)"*************Captcha Management component is activated.**************");
            }
        }
        catch (Exception e) {
            log.error((Object)"******* Captcha Management Component failed activating ****", (Throwable)e);
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        log.debug((Object)"******* Captcha Management bundle is deactivated ******* ");
    }

    @Reference(name="configuration.context.service", service=ConfigurationContextService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetConfigurationContextService")
    protected void setConfigurationContextService(ConfigurationContextService configurationContextService) {
        log.debug((Object)"Receiving ConfigurationContext Service");
        CaptchaMgtServiceComponent.configurationContextService = configurationContextService;
    }

    protected void unsetConfigurationContextService(ConfigurationContextService configurationContextService) {
        log.debug((Object)"Unsetting ConfigurationContext Service");
        CaptchaMgtServiceComponent.configurationContextService = null;
    }

    @Reference(name="registry.service", service=RegistryService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRegistryService")
    protected void setRegistryService(RegistryService registryService) {
        CaptchaMgtServiceComponent.registryService = registryService;
    }

    protected void unsetRegistryService(RegistryService registryService) {
        CaptchaMgtServiceComponent.registryService = null;
    }
}

