/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.mgt.recorder;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.user.mgt.recorder.RecorderException;
import org.wso2.carbon.user.mgt.recorder.UserDeletionEventRecorder;

public class DefaultUserDeletionEventRecorder
implements UserDeletionEventRecorder {
    private static final Log log = LogFactory.getLog(DefaultUserDeletionEventRecorder.class);
    private static final Log DELETE_EVENT_LOGGER = LogFactory.getLog((String)"DELETE_EVENT_LOGGER");
    private static final String PATH_PROPERTY_NAME = "path";
    private static final String COMMA = ",";

    @Override
    public void recordUserDeleteEvent(String username, String domainName, String tenantDomain, int tenantId, Date timeStamp, Map<String, String> properties) throws RecorderException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(username).append(COMMA).append(domainName).append(COMMA).append(tenantDomain).append(COMMA).append(tenantId).append(COMMA).append(timeStamp.toString()).append(COMMA);
        for (Map.Entry<String, String> values : properties.entrySet()) {
            if (values.getKey().equals(PATH_PROPERTY_NAME)) continue;
            stringBuilder.append(values.getValue()).append(COMMA);
        }
        String path = properties.get(PATH_PROPERTY_NAME);
        if (StringUtils.isNotEmpty((String)path)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("CSV file path is set to: " + path));
            }
            path = IdentityUtil.fillURLPlaceholders((String)path);
            if (log.isDebugEnabled()) {
                log.debug((Object)("CSV path after resolving the carbon placeholders: " + path));
            }
            this.writeToCustomFile(path, stringBuilder.toString());
        } else {
            DELETE_EVENT_LOGGER.info((Object)stringBuilder.toString());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Following line was successfully written to file: " + stringBuilder.toString()));
        }
    }

    private void writeToCustomFile(String path, String content) throws RecorderException {
        try (OutputStream outputStream = Files.newOutputStream(Paths.get(path, new String[0]), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.APPEND);){
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream));
            bufferedWriter.write(content);
            bufferedWriter.newLine();
            bufferedWriter.flush();
        }
        catch (IOException e) {
            throw new RecorderException("Error while writing content to the file.", e);
        }
    }
}

