/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.mgt.permission;

import org.apache.commons.lang.ArrayUtils;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.core.util.AdminServicesUtil;
import org.wso2.carbon.user.api.Permission;
import org.wso2.carbon.user.core.AuthorizationManager;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.user.core.common.AbstractUserOperationEventListener;
import org.wso2.carbon.user.core.constants.UserCoreErrorConstants;
import org.wso2.carbon.user.core.listener.UserManagementErrorEventListener;
import org.wso2.carbon.user.core.listener.UserOperationEventListener;
import org.wso2.carbon.user.core.util.UserCoreUtil;
import org.wso2.carbon.user.mgt.common.UserAdminException;
import org.wso2.carbon.user.mgt.internal.UserMgtDSComponent;

public class ManagementPermissionUtil {
    private ManagementPermissionUtil() {
    }

    public static void updateRoleUIPermission(String roleName, String[] rawPermissions) throws UserAdminException {
        Permission[] permissions = null;
        UserStoreManager userStoreManager = null;
        try {
            String[] optimizedList = UserCoreUtil.optimizePermissions((String[])rawPermissions);
            UserRealm realm = AdminServicesUtil.getUserRealm();
            AuthorizationManager authMan = realm.getAuthorizationManager();
            authMan.clearRoleActionOnAllResources(roleName, "ui.execute");
            permissions = new Permission[optimizedList.length];
            for (int i = 0; i < optimizedList.length; ++i) {
                authMan.authorizeRole(roleName, optimizedList[i], "ui.execute");
                permissions[i] = new Permission(optimizedList[i], "ui.execute");
            }
            userStoreManager = realm.getUserStoreManager();
            ManagementPermissionUtil.handlePostUpdatePermissionsOfRole(roleName, permissions, userStoreManager);
        }
        catch (UserStoreException e) {
            ManagementPermissionUtil.handleOnUpdatePermissionsOfRoleFailure(e.getMessage(), roleName, permissions, userStoreManager);
            throw new UserAdminException(e.getMessage(), e);
        }
        catch (CarbonException e) {
            ManagementPermissionUtil.handleOnUpdatePermissionsOfRoleFailure(e.getMessage(), roleName, null, null);
            throw new UserAdminException(e.getMessage(), e);
        }
    }

    public static Permission[] getRoleUIPermissions(String roleName, String[] rawPermissions) throws UserAdminException {
        if (ArrayUtils.isEmpty((Object[])rawPermissions)) {
            return new Permission[0];
        }
        String[] optimizedList = UserCoreUtil.optimizePermissions((String[])rawPermissions);
        Permission[] permissions = new Permission[optimizedList.length];
        int i = 0;
        for (String path : optimizedList) {
            permissions[i++] = new Permission(path, "ui.execute");
        }
        return permissions;
    }

    public static void handleOnUpdatePermissionsOfRoleFailure(String errorMessage, String roleName, Permission[] permissions, UserStoreManager userStoreManager) throws UserAdminException {
        try {
            for (UserManagementErrorEventListener listener : UserMgtDSComponent.getUserManagementErrorEventListeners()) {
                if (!listener.isEnable() || listener.onUpdatePermissionsOfRoleFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_UPDATING_PERMISSIONS_OF_ROLE.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_UPDATING_PERMISSIONS_OF_ROLE.getMessage(), errorMessage), roleName, permissions, userStoreManager)) continue;
                return;
            }
        }
        catch (UserStoreException ex) {
            throw new UserAdminException("Exception while executing error listeners after a failure while updating permissions of role " + roleName, ex);
        }
    }

    public static void handlePostUpdatePermissionsOfRole(String roleName, Permission[] permissions, UserStoreManager userStoreManager) throws UserStoreException {
        for (UserOperationEventListener userOperationEventListener : UserMgtDSComponent.getUserOperationEventListeners()) {
            if (!(userOperationEventListener instanceof AbstractUserOperationEventListener) || ((AbstractUserOperationEventListener)userOperationEventListener).doPostUpdatePermissionsOfRole(roleName, permissions, userStoreManager)) continue;
            return;
        }
    }
}

