/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.mgt.listeners;

import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.json.JSONArray;
import org.json.JSONObject;
import org.wso2.carbon.CarbonConstants;
import org.wso2.carbon.identity.core.AbstractIdentityUserMgtFailureEventListener;
import org.wso2.carbon.user.api.Permission;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.user.mgt.listeners.utils.ListenerUtils;

public class UserMgtFailureAuditLogger
extends AbstractIdentityUserMgtFailureEventListener {
    private static final Log audit = CarbonConstants.AUDIT_LOG;

    public boolean onAuthenticateFailure(String errorCode, String errorMessage, String userName, Object credential, UserStoreManager userStoreManager) {
        audit.warn((Object)this.createAuditMessage("Authentication", ListenerUtils.getEntityWithUserStoreDomain(userName, userStoreManager), null, errorCode, errorMessage));
        return true;
    }

    public boolean onAddUserFailure(String errorCode, String errorMessage, String userName, Object credential, String[] roleList, Map<String, String> claims, String profile, UserStoreManager userStoreManager) {
        JSONObject dataObject = new JSONObject();
        if (ArrayUtils.isNotEmpty((Object[])roleList)) {
            dataObject.put("Roles", (Object)new JSONArray((Object)roleList));
        }
        dataObject.put("Claims", (Object)new JSONObject(claims));
        dataObject.put("Profile", (Object)profile);
        audit.warn((Object)this.createAuditMessage("Add-User", ListenerUtils.getEntityWithUserStoreDomain(userName, userStoreManager), profile, errorCode, errorMessage));
        return true;
    }

    public boolean onUpdateCredentialFailure(String errorCode, String errorMessage, String userName, Object newCredential, Object oldCredential, UserStoreManager userStoreManager) {
        audit.warn((Object)this.createAuditMessage("Change-Password-by-User", ListenerUtils.getEntityWithUserStoreDomain(userName, userStoreManager), null, errorCode, errorMessage));
        return true;
    }

    public boolean onUpdateCredentialByAdminFailure(String errorCode, String errorMessage, String userName, Object newCredential, UserStoreManager userStoreManager) {
        audit.warn((Object)this.createAuditMessage("Change-Password-by-Administrator", ListenerUtils.getEntityWithUserStoreDomain(userName, userStoreManager), null, errorCode, errorMessage));
        return true;
    }

    public boolean onDeleteUserFailure(String errorCode, String errorMessage, String userName, UserStoreManager userStoreManager) {
        audit.warn((Object)this.createAuditMessage("Delete-User", ListenerUtils.getEntityWithUserStoreDomain(userName, userStoreManager), null, errorCode, errorMessage));
        return true;
    }

    public boolean onSetUserClaimValueFailure(String errorCode, String errorMessage, String userName, String claimURI, String claimValue, String profileName, UserStoreManager userStoreManager) {
        JSONObject dataObject = new JSONObject();
        dataObject.put("Claim", (Object)claimURI);
        dataObject.put("Claim Value", (Object)claimValue);
        audit.warn((Object)this.createAuditMessage("Set-User-Claim-Value", ListenerUtils.getEntityWithUserStoreDomain(userName, userStoreManager), dataObject, errorCode, errorMessage));
        return true;
    }

    public boolean onSetUserClaimValuesFailure(String errorCode, String errorMessage, String userName, Map<String, String> claims, String profileName, UserStoreManager userStoreManager) {
        audit.warn((Object)this.createAuditMessage("Set-User-Claim-Values", ListenerUtils.getEntityWithUserStoreDomain(userName, userStoreManager), new JSONObject(claims), errorCode, errorMessage));
        return true;
    }

    public boolean onDeleteUserClaimValuesFailure(String errorCode, String errorMessage, String userName, String[] claims, String profileName, UserStoreManager userStoreManager) {
        JSONArray data = new JSONArray();
        if (ArrayUtils.isNotEmpty((Object[])claims)) {
            data = new JSONArray((Object)claims);
        }
        audit.warn((Object)this.createAuditMessage("Delete-User-Claim-Values", ListenerUtils.getEntityWithUserStoreDomain(userName, userStoreManager), data, errorCode, errorMessage));
        return true;
    }

    public boolean onDeleteUserClaimValueFailure(String errorCode, String errorMessage, String userName, String claimURI, String profileName, UserStoreManager userStoreManager) {
        JSONObject dataObject = new JSONObject();
        dataObject.put("Claim", (Object)claimURI);
        dataObject.put("Profile", (Object)profileName);
        audit.warn((Object)this.createAuditMessage("Delete-User-Claim-Value", ListenerUtils.getEntityWithUserStoreDomain(userName, userStoreManager), dataObject, errorCode, errorMessage));
        return true;
    }

    public boolean onAddRoleFailure(String errorCode, String errorMessage, String roleName, String[] userList, Permission[] permissions, UserStoreManager userStoreManager) {
        JSONObject dataObject = new JSONObject();
        if (ArrayUtils.isNotEmpty((Object[])userList)) {
            dataObject.put("Users", (Object)new JSONArray((Object)userList));
        }
        if (ArrayUtils.isNotEmpty((Object[])permissions)) {
            JSONArray permissionsArray = new JSONArray((Object)permissions);
            dataObject.put("Permissions", (Object)permissionsArray);
        }
        audit.warn((Object)this.createAuditMessage("Add-Role", ListenerUtils.getEntityWithUserStoreDomain(roleName, userStoreManager), dataObject, errorCode, errorMessage));
        return true;
    }

    public boolean onDeleteRoleFailure(String errorCode, String errorMessage, String roleName, UserStoreManager userStoreManager) {
        audit.warn((Object)this.createAuditMessage("Delete-Role", ListenerUtils.getEntityWithUserStoreDomain(roleName, userStoreManager), null, errorCode, errorMessage));
        return true;
    }

    public boolean onUpdateRoleNameFailure(String errorCode, String errorMessage, String roleName, String newRoleName, UserStoreManager userStoreManager) {
        audit.warn((Object)this.createAuditMessage("Update-Role-Name", ListenerUtils.getEntityWithUserStoreDomain(roleName, userStoreManager), newRoleName, errorCode, errorMessage));
        return true;
    }

    public boolean onUpdateUserListOfRoleFailure(String errorCode, String errorMessage, String roleName, String[] deletedUsers, String[] newUsers, UserStoreManager userStoreManager) {
        JSONObject dataObject = new JSONObject();
        if (ArrayUtils.isNotEmpty((Object[])deletedUsers)) {
            dataObject.put("Deleted Users", (Object)new JSONArray((Object)deletedUsers));
        }
        if (ArrayUtils.isNotEmpty((Object[])newUsers)) {
            dataObject.put("New Users", (Object)new JSONArray((Object)newUsers));
        }
        audit.warn((Object)this.createAuditMessage("Update-Users-of-Role", ListenerUtils.getEntityWithUserStoreDomain(roleName, userStoreManager), dataObject, errorCode, errorMessage));
        return true;
    }

    public boolean onUpdateRoleListOfUserFailure(String errorCode, String errorMessage, String userName, String[] deletedRoles, String[] newRoles, UserStoreManager userStoreManager) {
        JSONObject dataObject = new JSONObject();
        if (ArrayUtils.isNotEmpty((Object[])deletedRoles)) {
            dataObject.put("Deleted Roles", (Object)new JSONArray((Object)deletedRoles));
        }
        if (ArrayUtils.isNotEmpty((Object[])newRoles)) {
            dataObject.put("New Roles", (Object)new JSONArray((Object)newRoles));
        }
        audit.warn((Object)this.createAuditMessage("Update-Roles-of-User", ListenerUtils.getEntityWithUserStoreDomain(userName, userStoreManager), dataObject, errorCode, errorMessage));
        return true;
    }

    public boolean onGetUserClaimValueFailure(String errorCode, String errorMessage, String userName, String claim, String profileName, UserStoreManager userStoreManager) {
        JSONObject dataObject = new JSONObject();
        dataObject.put("Profile", (Object)profileName);
        dataObject.put("Claim", (Object)claim);
        audit.info((Object)this.createAuditMessage("Get-User-Claim-Value", ListenerUtils.getEntityWithUserStoreDomain(userName, userStoreManager), dataObject, errorCode, errorMessage));
        return true;
    }

    public boolean onGetUserClaimValuesFailure(String errorCode, String errorMessage, String userName, String[] claims, String profile, UserStoreManager userStoreManager) {
        JSONObject dataObject = new JSONObject();
        dataObject.put("Profile", (Object)profile);
        if (ArrayUtils.isNotEmpty((Object[])claims)) {
            dataObject.put("Claims", (Object)new JSONArray((Object)claims));
        }
        audit.info((Object)this.createAuditMessage("Get-User-Claim-Values", ListenerUtils.getEntityWithUserStoreDomain(userName, userStoreManager), dataObject, errorCode, errorMessage));
        return true;
    }

    public boolean onGetUserListFailure(String errorCode, String errorMessage, String claim, String claimValue, String profileName, UserStoreManager userStoreManager) {
        JSONObject dataObject = new JSONObject();
        dataObject.put("Claim", (Object)claim);
        dataObject.put("Claim Value", (Object)claimValue);
        dataObject.put("Profile", (Object)profileName);
        audit.info((Object)this.createAuditMessage("Get-User-List", null, dataObject, errorCode, errorMessage));
        return true;
    }

    public boolean onUpdatePermissionsOfRoleFailure(String errorCode, String errorMessage, String roleName, Permission[] permissions, UserStoreManager userStoreManager) {
        JSONObject dataObject = new JSONObject();
        if (ArrayUtils.isNotEmpty((Object[])permissions)) {
            JSONArray permissionsArray = new JSONArray((Object)permissions);
            dataObject.put("Permissions", (Object)permissionsArray);
        }
        audit.warn((Object)this.createAuditMessage("Update-Permissions-of-Role", ListenerUtils.getEntityWithUserStoreDomain(roleName, userStoreManager), dataObject, errorCode, errorMessage));
        return true;
    }

    private String createAuditMessage(String action, String target, Object data, String errorCode, String errorMessage) {
        String errorCodeField = "Error Code";
        String errorMessageField = "Error Message";
        JSONObject error = new JSONObject();
        error.put(errorCodeField, (Object)errorCode);
        error.put(errorMessageField, (Object)errorMessage);
        String auditMessage = "Initiator=%s Action=%s Target=%s Data=%s Outcome=Failure Error=%s";
        return String.format(auditMessage, ListenerUtils.getUser(), action, target, data, error);
    }
}

