/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.mgt.listeners;

import java.util.Arrays;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.wso2.carbon.CarbonConstants;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.identity.core.AbstractIdentityUserOperationEventListener;
import org.wso2.carbon.user.api.Permission;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.UserStoreManager;

public class UserMgtAuditLogger
extends AbstractIdentityUserOperationEventListener {
    private static final Log audit = CarbonConstants.AUDIT_LOG;
    private static final String SUCCESS = "Success";
    private static String AUDIT_MESSAGE = "Initiator : %s | Action : %s | Target : %s | Data : { %s } | Result : %s ";

    public int getExecutionOrderId() {
        int orderId = this.getOrderId();
        if (orderId != -1) {
            return orderId;
        }
        return 8;
    }

    public boolean doPostAddUser(String userName, Object credential, String[] roleList, Map<String, String> claims, String profile, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        StringBuilder builder = new StringBuilder();
        if (roleList != null) {
            for (int i = 0; i < roleList.length; ++i) {
                builder.append(roleList[i] + ",");
            }
        }
        audit.info((Object)String.format(AUDIT_MESSAGE, this.getUser(), "Add User", userName, "Roles :" + builder.toString(), SUCCESS));
        return true;
    }

    public boolean doPostDeleteUser(String userName, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        audit.info((Object)String.format(AUDIT_MESSAGE, this.getUser(), "Delete User", userName, "", SUCCESS));
        return true;
    }

    public boolean doPostUpdateCredential(String userName, Object credential, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        audit.info((Object)String.format(AUDIT_MESSAGE, this.getUser(), "Change Password by User", userName, "", SUCCESS));
        return true;
    }

    public boolean doPreUpdateCredentialByAdmin(String userName, Object newCredential, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        audit.info((Object)String.format(AUDIT_MESSAGE, this.getUser(), "Change Password by Administrator", userName, "", SUCCESS));
        return true;
    }

    public boolean doPostDeleteRole(String roleName, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        audit.info((Object)String.format(AUDIT_MESSAGE, this.getUser(), "Delete Role", roleName, "", SUCCESS));
        return true;
    }

    public boolean doPostAddRole(String roleName, String[] userList, Permission[] permissions, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        StringBuilder stringBuilder = new StringBuilder();
        String format = "ResourceID : %s Action : %s\n";
        for (Permission permission : permissions) {
            stringBuilder.append(String.format(format, permission.getResourceId(), permission.getAction()));
        }
        String permissionsString = stringBuilder.toString();
        stringBuilder.setLength(0);
        format = "%s\n";
        for (String string : userList) {
            stringBuilder.append(String.format(format, string));
        }
        String usersString = stringBuilder.toString();
        format = "\nUsers :\n%sPermissions :\n%s";
        String string = String.format(format, usersString, permissionsString);
        audit.info((Object)String.format(AUDIT_MESSAGE, this.getUser(), "Add Role", roleName, string, SUCCESS));
        return true;
    }

    public boolean doPostUpdateRoleName(String roleName, String newRoleName, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        audit.info((Object)String.format(AUDIT_MESSAGE, this.getUser(), "Update Role Name", roleName, "Old : " + roleName + " New : " + newRoleName, SUCCESS));
        return true;
    }

    public boolean doPostUpdateUserListOfRole(String roleName, String[] deletedUsers, String[] newUsers, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        audit.info((Object)String.format(AUDIT_MESSAGE, this.getUser(), "Update Users of Role", roleName, "UsersAdded : " + Arrays.toString(newUsers) + ", UsersRemoved : " + Arrays.toString(deletedUsers), SUCCESS));
        return true;
    }

    public boolean doPostUpdateRoleListOfUser(String userName, String[] deletedRoles, String[] newRoles, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        audit.info((Object)String.format(AUDIT_MESSAGE, this.getUser(), "Update Roles of User", userName, "RolesAdded : " + Arrays.toString(newRoles) + ", RolesRemoved : " + Arrays.toString(deletedRoles), SUCCESS));
        return true;
    }

    private String getUser() {
        String user = CarbonContext.getThreadLocalCarbonContext().getUsername();
        user = user != null ? user + "@" + CarbonContext.getThreadLocalCarbonContext().getTenantDomain() : "wso2.system.user";
        return user;
    }
}

